

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/LM_Create_HyperScaleMonitoringPolicy.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- LM_Create_HyperScaleMonitoringPolicy.script 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ---------------------------------------------------------------------- 

-- 

--           Copyright (c) 2011  CommVault Systems, Inc. 

--                  All rights reserved. 

-- 

-- 

--        This is unpublished proprietary source code of CommVault 

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

EXEC LM_HyperScaleMonitoring

--Disabling hyperscale policy changes

DECLARE @policyName NVARCHAR(MAX) = 'Hyperscale OS Log'

DECLARE @policyId INT 

DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

SET @policyId =  ISNULL((SELECT TOP 1 monitorPolicyId FROM APP_MonitoringPolicy WITH(NOLOCK)

                                    WHERE MonitorPolicyName = @policyName AND status <> 3

                                    ORDER BY monitorPolicyId DESC),0)

IF @policyId <> 0

BEGIN

	DECLARE @policyDisableGuid uniqueidentifier = '92FEC3AF-10A5-4EFE-98CC-27BE9AFECA79'

	DECLARE @policyDisableOccured INT = 0

	SELECT @policyDisableOccured = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @policyDisableGuid

	DECLARE @policyStatus INT = (SELECT TOP 1 status FROM APP_MonitoringPolicy WITH(NOLOCK) WHERE monitorPolicyId = @policyId)

	IF @policyStatus = 0 AND @policyDisableOccured = 0

	BEGIN

		-- Policy enabled and disable dint occur

		UPDATE APP_MonitoringPolicy

		SET status = 1

		WHERE monitorPolicyId = @policyId

		DECLARE @clientTbl TABLE(clientId INT)
		INSERT INTO @clientTbl


		SELECT clientId

		FROM APP_MonitorAssocEntity

		WHERE monitorPolicyId = @policyId AND clientId <> 0
		INSERT INTO @clientTbl


		SELECT CGTbl.clientId

		FROM APP_ClientGroupAssoc CGTbl

		INNER JOIN APP_MonitorAssocEntity mpAssoc ON mpAssoc.clientGroupId = CGTbl.clientGroupId

		WHERE mpAssoc.monitorPolicyId = @policyId AND mpAssoc.clientGroupId <> 0
		INSERT INTO APP_WorkQueueRequest (clientId, remoteClient,workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)


		SELECT hyperScaleTbl.clientId, -1, 8/*WORK_TOKEN_LOGMONITORING*/,'<TMMsg_MonitoringPolicyChangeReq clientId="'+ CONVERT(NVARCHAR(MAX),hyperScaleTbl.clientId) + '" monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@policyId) + '" operationType="0"/>',@nowTime,@nowTime,0,0

		FROM @clientTbl hyperScaleTbl

		INNER JOIN APP_Client clientTbl WITH(NOLOCK)

		ON hyperScaleTbl.clientId = clientTbl.id
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@policyDisableGuid, 'LM_HyperScaleMonitoring_DisableChange', 'Disabling default monitoring policy for hyperscale', @nowTime, 16, 0 , (16 + 2))

	END

END

--Disabling hyperscale policy changes end

SET NOCOUNT OFF
