

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMVSAIndexingV2MappingUpgrade.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- JMJobDataLink.script

-- 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ---------------------------------------------------------------------- 

-- 

--           Copyright (c) 2011  CommVault Systems, Inc. 

--                  All rights reserved. 

-- 

-- 

--        This is unpublished proprietary source code of CommVault 

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

DECLARE @guid uniqueidentifier = 'E073BA12-9EFD-4094-9084-4B4B3E60511F'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())    

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

BEGIN TRY

	BEGIN TRAN

	IF @globalParamPlanUpdateExec = 0

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#DataLinkTemp') IS NOT NULL DROP TABLE #DataLinkTemp

		CREATE TABLE #DataLinkTemp

		(

			 commCellId      integer,

			 parentJobId     integer,

			 childJobId      integer,

			 parentAppid     integer,

			 childAppid      integer,

			 linkType        integer,

			 childJobStatus      integer,

			 primary key (commCellId,parentJobId, childJobId),

		);
		create index TempJMJobDataLink_idx2 on #DataLinkTemp (parentJobId, commCellId)

		create index TempJMJobDataLink_idx3 on #DataLinkTemp (childJobId,commCellId)


		-- get the parent child relation from the JMBkpStats table
		INSERT INTO #DataLinkTemp(commCellId,parentJobId,childJobId,parentAppid,childAppid,linkType,childJobStatus)


SELECT commCellId,jobIdActedOn,jobid,0,appid,7,status

FROM JMBkpStats WITH(NOLOCK) WHERE (bkpAttributesEx & 0x4000000) = 0x4000000 AND jobIdActedOn <> 0

		AND opType = 4 -- BACKUP

		--update the parent appid column

		UPDATE dataLinkTemp

		SET dataLinkTemp.parentAppid = jmstats.appId

		FROM #DataLinkTemp dataLinkTemp INNER JOIN JMBkpStats jmstats WITH(NOLOCK) ON jmstats.jobid = dataLinkTemp.parentJobId AND jmstats.commCellId = dataLinkTemp.commCellId

		-- insert  the data link table
		INSERT INTO JMJobDataLink(commCellId,parentJobId,childJobId,parentAppid,childAppid,linkType,childJobStatus)


		SELECT commCellId,parentJobId,childJobId,parentAppid,childAppid,linkType,childJobStatus FROM #DataLinkTemp

		WHERE parentAppid > 0 -- Insert only if parent job was found in JMBkpStats join above.

		--Update the jobIdActedOn column to 0

		UPDATE jmstats

		SET jmstats.jobIdActedOn = 0

		FROM #DataLinkTemp dataLinkTemp INNER JOIN JMBkpStats jmstats ON jmstats.jobid = dataLinkTemp.childJobId AND jmstats.commCellId = dataLinkTemp.commCellId AND jmstats.appId = dataLinkTemp.childAppid

		DROP TABLE #DataLinkTemp
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'JMMoveParentChildVSARelation', 'Move parent-child relation for Indexing V2', @curUtcDateTime, 16, 0 , (16 + 2))

	END

	COMMIT TRAN

END TRY

BEGIN CATCH

	ROLLBACK TRAN

	RAISERROR('Failed to move parent-child mapping for VSA Indexing V2 jobs.',16,1)

END CATCH

