

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMJobSnapDeferredCatalogStats.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/******************************************************************************/

/*  Copyright (c) CommVault Systems                                           */

/*  All Rights Reserved                                                       */

/*                                                                            */

/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */

/*  The copyright notice above does not evidence any                          */

/*  actual or intended publication of such source code.                       */

/*                                                                            */

/*  File name   :   JMJobSnapDeferredCatalogStats.script                      */

/*                                                                            */

/*  Description :   Script to move the jobs processed for deferred catalog to */

/*					new V11 table   										  */

/*                                                                            */

/*  Author      :   Praveen Krishnan                                          */

/*                                                                            */

/******************************************************************************/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/JMJobSnapDeferredCatalogStats.script,v $ $Id: JMJobSnapDeferredCatalogStats.script,v 1.2.34.1 2017/02/10 22:33:12 sjohnson Exp $";

IF EXISTS(SELECT 1 FROM JMJobSnapShotStats WHERE flags & 1 = 1)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#tempJMJobSnapShotStats') IS NOT NULL

		DROP TABLE #tempJMJobSnapShotStats

	CREATE TABLE #tempJMJobSnapShotStats(jobId integer, commcellId integer, primary key(jobId, commcellId))

WHILE EXISTS(SELECT 1 FROM JMJobSnapShotStats WHERE flags & 1 = 1)

	BEGIN		

		BEGIN TRY

			BEGIN TRAN MOVEROWS
			INSERT INTO #tempJMJobSnapShotStats


			SELECT top 50000 jobId, commcellId

FROM JMJobSnapShotStats WHERE flags & 1 = 1
			INSERT INTO JMJobSnapDeferredCatalogStats


			SELECT JSS.jobId, JSS.commcellId, JSS.materializationStatus, JSS.disabled, JSS.materializationJobId, JSS.appId, JSS.archGrpId, JSS.unPickReason, 0 --flags

			FROM JMJobSnapShotStats JSS INNER JOIN #tempJMJobSnapShotStats tJSS ON JSS.jobId = tJSS.jobId AND JSS.commcellId = tJSS.commcellId					

			DELETE JMJobSnapShotStats

			FROM JMJobSnapShotStats JSS INNER JOIN #tempJMJobSnapShotStats tJSS ON JSS.jobId = tJSS.jobId AND JSS.commcellId = tJSS.commcellId

			COMMIT TRAN MOVEROWS

		END TRY

		BEGIN CATCH

			IF @@TRANCOUNT > 0

				ROLLBACK TRAN MOVEROWS					

			IF OBJECT_ID('tempdb.dbo.#tempJMJobSnapShotStats') IS NOT NULL

				DROP TABLE #tempJMJobSnapShotStats			

			DECLARE @errStr nvarchar(max)			

			SET @errStr = N'Failed to move rows of jobs processed for deferred catalog. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')		

			RAISERROR(@errStr, 16, 1)

			BREAK

		END CATCH

		TRUNCATE TABLE #tempJMJobSnapShotStats

	END

	IF OBJECT_ID('tempdb.dbo.#tempJMJobSnapShotStats') IS NOT NULL

		DROP TABLE #tempJMJobSnapShotStats

END

