

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMJobOptions.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                              

--           Copyright (c) 1998  CommVault Systems, Inc.                  

--                   All rights reserved.                                    

--                                                                              

--                                                                           

--       This is unpublished proprietary source code of CommVault  

--       Systems, Inc. The copyright notice above does not evidence 

--       any actual or intended publication of such source code. 

--

--      Revisions  Author   Description

--      ---------  -------  ----------------------------------------------------------------------------------

--		Initial	   Jawahar	Fixing 'Size on media' Job option for Snap Backups after Backup Copy ran for them.

-- ---------------------------------------------------------------------------------------------------------*/

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '355259D5-0B84-4BE6-BAD6-04B7CCC3A01F')

BEGIN 

	UPDATE JMJobOptions SET attributeValueInt = 

		(

			SELECT CASE WHEN ISNULL(SUM(sizeOnMedia),0) > 0 

				THEN  SUM(sizeOnMedia)

				ELSE JBS.totalBackupSize

			END

			FROM JMJobDataStats J

			INNER JOIN archGroup AG ON AG.id = J.archGrpId 

			WHERE j.jobId  = JBS.jobIdActedOn AND j.commCellId = JBS.commCellId AND j.archGrpCopyId = AG.defaultCopy

		)  

FROM JMJobOptions JJO INNER JOIN JMBkpStats JBS ON JJO.jobId = JBS.jobIdActedOn WHERE JJO.attributeId = 73 AND JJO.attributeValueInt = 0

EXIT_SCRIPT:
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('355259D5-0B84-4BE6-BAD6-04B7CCC3A01F', 'JMJobOptionsFixSnapBackupSizeOnMedia', 'Script to fix sizeOnMedia for Snap Backup jobs which need to updated after Backup Copy ran', @nowTime, 16, 0, 16+1)

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '355259D5-0B84-4BE6-BAD6-04B7CCC3A02F')

BEGIN 
	INSERT INTO JMJobOptions


SELECT jobId, commCellId, 76 AS attributeId, 'Job Running Threshold Time' AS attributeName, xmlVal.value('(/JobManager_ForeCastInfo/@thresholdForAnomalousRunTime)[1]', 'BIGINT'), N''

	  FROM

		(

			SELECT FORECASTXML.jobId AS jobId, FORECASTXML.commCellId AS commCellId,  

			CAST(CAST(FORECASTXML.attributeValue AS VARCHAR(MAX)) AS XML) AS xmlVal, 

			THRESHOLD.attributeValueInt AS threshold

			FROM JMJobOptions FORECASTXML

LEFT OUTER JOIN JMJobOptions THRESHOLD ON FORECASTXML.jobId = THRESHOLD.jobId AND THRESHOLD.attributeId = 76

WHERE FORECASTXML.attributeId = 67

		)THRESHOLD

		WHERE threshold IS NULL AND xmlVal.value('(/JobManager_ForeCastInfo/@thresholdForAnomalousRunTime)[1]', 'BIGINT') IS NOT NULL

	UNION ALL

SELECT jobId, commCellId, 77 AS attributeId, 'Forecasted Job Running Time' AS attributeName, xmlVal.value('(/JobManager_ForeCastInfo/@foreCastedRunTime)[1]', 'BIGINT'), N''

	  FROM

		(

			SELECT FORECASTXML.jobId AS jobId, FORECASTXML.commCellId AS commCellId,  

			CAST(CAST(FORECASTXML.attributeValue AS VARCHAR(MAX)) AS XML) AS xmlVal, 

			FORECAST.attributeValueInt AS forecast

			FROM JMJobOptions FORECASTXML

LEFT OUTER JOIN JMJobOptions FORECAST ON FORECASTXML.jobId = FORECAST.jobId AND FORECAST.attributeId = 77

WHERE FORECASTXML.attributeId = 67

		) FORECAST

	WHERE forecast IS NULL AND xmlVal.value('(/JobManager_ForeCastInfo/@foreCastedRunTime)[1]', 'BIGINT') IS NOT NULL
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('355259D5-0B84-4BE6-BAD6-04B7CCC3A02F', 'JMJobOptionsInsertJobRuntimeThresholdAndForecastTime', 'Script to insert Job runtime threshold and forecast time from XML', @nowTime, 16, 0, 16+1)

END

DECLARE @ForecastGuid    VARCHAR(40) = '7F0556B2-F601-495B-9D29-7DFDD838ABCD'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @ForecastGuid)

BEGIN

    	IF EXISTS (SELECT 1 FROM APP_CommCell WHERE id = 2)

    	BEGIN

		IF EXISTS (SELECT jobId FROM JMJobOptions WHERE attributeId = 67 GROUP BY jobId HAVING COUNT(1) > 1)

		BEGIN

			WITH REDUNDANT AS (

			SELECT id, ROW_NUMBER() OVER(PARTITION BY jobId, attributeId ORDER BY id DESC) AS RN

FROM JMJobOptions WHERE attributeId IN (67, 76, 77))

	 		DELETE JO FROM JMJobOptions JO

			INNER JOIN REDUNDANT

				ON JO.id = REDUNDANT.id

			WHERE REDUNDANT.RN > 1

		END

    	END
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@ForecastGuid, 'Execute JMJobOptionsRemoveRedundantForecastInfo SP', 'Table script to execute JMJobOptions SP to remove redundant forecast Info from JMJobOptions table', @nowTime,  16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '689E7F3B-0819-4A0E-9380-4B8CCA23AABC')

BEGIN 

	IF OBJECT_ID('tempDb.dbo.#jobsToInsert') IS NOT NULL DROP TABLE #jobsToInsert

	CREATE TABLE #jobsToInsert(jobId INT, commcellId INT, sizeOnMedia BIGINT)

	IF OBJECT_ID('tempDb.dbo.#jobsToInsert_vsa') IS NOT NULL DROP TABLE #jobsToInsert_vsa

	CREATE TABLE #jobsToInsert_vsa(jobId INT, commcellId INT,sizeOnMedia BIGINT)
	INSERT INTO #jobsToInsert


	SELECT JBS.jobId, JBS.commCellId, SUM(sizeOnMedia)

			FROM JMBkpStats JBS	

LEFT OUTER JOIN JMJobOptions JO ON JBS.jobId = JO.jobId AND JO.attributeId = 73 AND JO.commCellId = JBS.commCellId

			LEFT OUTER JOIN JMJobDataStats J ON J.jobId = (CASE WHEN JBS.opType = 60 then JBS.jobIdActedOn else JBS.jobId END) AND J.commCellId = JBS.commCellId 

			INNER JOIN archGroup AG ON AG.id = J.archGrpId AND J.archGrpCopyId = AG.defaultCopy

		GROUP BY JBS.jobId, JBS.commCellId

		HAVING MIN(JO.attributeId) IS NULL
	INSERT INTO #jobsToInsert


	SELECT JBS.jobId, JBS.commCellId,  MIN(JBS.totalBackupSize)

			FROM JMBkpStats JBS	

LEFT OUTER JOIN JMJobOptions JO ON JBS.jobId = JO.jobId AND JO.attributeId = 73 AND JO.commCellId = JBS.commCellId

			LEFT OUTER JOIN JMJobDataStats J ON J.jobId = (CASE WHEN JBS.opType = 60 then JBS.jobIdActedOn else JBS.jobId END) AND J.commCellId = JBS.commCellId 

			LEFT OUTER JOIN archGroup AG ON AG.id = J.archGrpId AND J.archGrpCopyId = AG.defaultCopy

		GROUP BY JBS.jobId, JBS.commCellId

		HAVING MIN(JO.attributeId) IS NULL AND MIN(AG.ID) IS NULL
	INSERT INTO #jobsToInsert_vsa


	SELECT  JBS.jobId, JBS.commCellId, ISNULL(SUM(sizeOnMedia), 0)

	FROM JMBkpStats JBS

LEFT OUTER JOIN JMJobOptions JO ON JBS.jobId = JO.jobId AND JO.attributeId = 73 AND JO.commCellId = JBS.commCellId

INNER JOIN JMJobDataStats J ON J.jobId = JBS.jobId AND J.commCellId = JBS.commCellId AND JBS.appType = 106 AND (JBS.bkpattributesEx & 0x40000000 = 0x40000000)

		INNER JOIN archGroup AG on AG.id = J.archGrpId AND J.archGrpCopyId = AG.defaultCopy

		INNER JOIN JMJobDataLink jobMapping ON J.jobId = jobMapping.childJobId AND jobMapping.parentJobId = (case when  JBS.optype = 60 then JBS.jobIdActedOn else JBS.jobId end)

AND jobMapping.linkType = 7 AND jobMapping.commCellId = J.commCellId

	GROUP BY JBS.jobId, JBS.commCellId

	HAVING MIN(JO.attributeId) IS NULL
	INSERT INTO JMJobOptions


SELECT J.jobId, J.commcellId, 73, 'Size on Media', (J.sizeOnMedia + ISNULL(J2.sizeOnMedia,0)), ''

	FROM #jobsToInsert J

		LEFT OUTER JOIN #jobsToInsert_vsa J2 ON J.jobId = J2.jobId AND J.commcellId = J2.commcellId

	IF OBJECT_ID('tempDb.dbo.#jobsToInsert') IS NOT NULL DROP TABLE #jobsToInsert

	IF OBJECT_ID('tempDb.dbo.#jobsToInsert_vsa') IS NOT NULL DROP TABLE #jobsToInsert_vsa
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('689E7F3B-0819-4A0E-9380-4B8CCA23AABC', 'JMJobOptionsInsertSizeOnMedia', 'Script to insert size on media field computed from JMJobDataStats', @nowTime, 16, 0, 16+1)

END

SET NOCOUNT OFF

