

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMJobDataStats.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                              

--           Copyright (c) 1998  CommVault Systems, Inc.                  

--                   All rights reserved.                                    

--                                                                              

--                                                                           

--       This is unpublished proprietary source code of CommVault  

--       Systems, Inc. The copyright notice above does not evidence 

--       any actual or intended publication of such source code. 

--

--      Revisions  Author   Description

--      ---------  -------  ---------------------------------------------

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/JMJobDataStats.script,v $ $Id: JMJobDataStats.script,v 1.1.2.1 2019/10/11 22:42:06 chandru Exp $";

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

GO

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = 'BECDF4E1-2481-4626-95B5-C9F6898506D3')

BEGIN 

	IF OBJECT_ID('tempdb.dbo.#tempJobDataStatus') IS NOT NULL DROP TABLE #tempJobDataStatus

	CREATE TABLE #tempJobDataStatus (jobId INT, commCellId INT, archGrpCopyId INT, dataType INT,

				archCheckStatus INT, archCheckEndTime INT, newCheckStatus INT, failedOR INT, checkedOR INT, checkedAND INT, chunkUpdated INT PRIMARY KEY(jobId, commCellId, archGrpCopyId, dataType))
	INSERT INTO #tempJobDataStatus


	SELECT	AF.JobId, AF.CommCellId, AFC.archCopyId, AF.fileType, 0, 0, 5, 0, 0, 0, 1

	FROM	JMJobDataStats JDS WITH (READUNCOMMITTED) 

			INNER JOIN archFile AF WITH (READUNCOMMITTED) ON JDS.JobId = AF.JobID AND JDS.CommCellId = AF.CommCellId AND JDS.dataType = AF.FileType

			INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellId = AFC.CommCellID AND JDS.archGrpCopyId = AFC.archCopyId

	WHERE	AF.isValid = 1

			AND JDS.Status = 100

			AND JDS.archCheckStatus = 0

AND (AF.flags & 2) = 0

	GROUP BY AF.JobId, AFC.archCopyId, AF.fileType, AF.CommCellId

	HAVING	MIN(AFC.isValid) = 1

			AND MAX(AFC.lastChunkNumber) = 0

	DELETE FROM  ST

	FROM	#tempJobDataStatus ST 

			LEFT OUTER JOIN	(SELECT	JDS.JobId, JDS.CommCellId, JDS.archGrpCopyId

							FROM	JMJobDataStats JDS, #tempJobDataStatus T

							WHERE	JDS.JobId = T.JobId

									AND JDS.CommCellId = T.CommCellId

									AND JDS.archGrpCopyId = T.archGrpCopyId

									AND JDS.dataType != T.dataType

							GROUP BY JDS.JobId, JDS.CommCellId, JDS.archGrpCopyId

							HAVING MAX(JDS.archCheckStatus) > 0) JC

						ON	ST.JobId = JC.JobId

								AND ST.CommCellId = JC.CommCellId

								AND ST.archGrpCopyId = JC.archGrpCopyId

	WHERE	JC.JobId IS NULL

	UPDATE	JDS

	SET		archCheckStatus = 5, archCheckEndTime = @nowTime, modifiedTime = @nowTime

	FROM	JMJobDataStats JDS, #tempJobDataStatus T

	WHERE	JDS.JobId = T.JobId

			AND JDS.CommCellId = T.CommCellId

			AND JDS.archGrpCopyId = T.archGrpCopyId

			AND JDS.dataType = T.dataType
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('BECDF4E1-2481-4626-95B5-C9F6898506D3', 'UpdateDVStatusForVSAParentJob', 'Script to fix set archCheckStatus on JMJobDataStats for VSA Parent Job', @nowTime, 16, 0, 16+1)

	IF OBJECT_ID('tempdb.dbo.#tempJobDataStatus') IS NOT NULL DROP TABLE #tempJobDataStatus

END

