

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMJobDataLink.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- JMJobDataLink.script

-- 

-- ALLOW_COMMENTS_BELOW_HERE:

-- ---------------------------------------------------------------------- 

-- 

--           Copyright (c) 2011  CommVault Systems, Inc. 

--                  All rights reserved. 

-- 

-- 

--        This is unpublished proprietary source code of CommVault 

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

DECLARE @guid uniqueidentifier = '025BA733-B3C7-424B-8026-FC72F3F4F487'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())    

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF @globalParamPlanUpdateExec = 0

BEGIN

	/*

		If there is a storage policy change between Cycles then there could be a case where Full of the cycle is aged and Incremental is not aged because of invalid linking.

		And when below update query is execute, it might fail to find the Full/SynthFull for that Cycle causing the query to fail with NULL constraint error.

		Hence added the new Delete statement that would cleanup such entries from JMJobDataLink table. 

	*/

	DELETE dataLink 

	FROM JMBkpStats jmStats INNER JOIN JMJobDataLink dataLink

		ON dataLink.linkType = 6 AND jmStats.appType = 106 AND jmStats.jobId = dataLink.childJobId AND jmStats.commCellId = dataLink.commCellId

		WHERE NOT EXISTS (SELECT TOP 1 jobid FROM JMBkpStats bkpStats 

							WHERE status IN (1,3,14) AND bkpLevel IN(1,64,128) 

								AND bkpStats.appId = jmStats.appId AND bkpStats.fullCycleNum = jmStats.fullCycleNum 

									ORDER BY servEndDate DESC )

	UPDATE dataLink

	SET parentJobId = (SELECT TOP 1 jobid FROM JMBkpStats bkpStats 

							WHERE status IN (1,3,14) AND bkpLevel IN(1,64,128) 

								AND bkpStats.appId = jmStats.appId AND bkpStats.fullCycleNum = jmStats.fullCycleNum 

									ORDER BY servEndDate DESC )

	FROM JMBkpStats jmStats INNER JOIN JMJobDataLink dataLink

		ON dataLink.linkType = 6 AND jmStats.appType = 106 AND jmStats.jobId = dataLink.childJobId AND jmStats.commCellId = dataLink.commCellId

	DELETE JMJobDataStats

	FROM JMJobDataStats jds , archGroupCOpy agc, APP_Application aa 

                        WHERE archGrpCopyId = agc.id AND archGrpId <> archGroupId

                                    AND aa.id = jds.appId AND aa.appTypeId = 106
	 INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'JMFixJobDataLinkEntriesDataAging', 'Fix JMJobDataLink Entries of Type 6', @curUtcDateTime, 16, 0 , (16 + 2))

END

