

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMFailureReasonMsg.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                              

--           Copyright (c) 1998  CommVault Systems, Inc.                  

--                   All rights reserved.                                    

--                                                                              

--                                                                           

--       This is unpublished proprietary source code of CommVault  

--       Systems, Inc. The copyright notice above does not evidence 

--       any actual or intended publication of such source code. 

--

--      Revisions  Author   Description

--      ---------  -------  ---------------------------------------------

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/JMFailureReasonMsg.script,v $ $Id: JMFailureReasonMsg.script,v 1.1.2.1 2020/09/01 16:13:10 gstoops Exp $";

SET NOCOUNT ON

DECLARE @scriptExecuted INT = 0

DECLARE @uniqueScriptID uniqueidentifier = 'BB890CFD-17CC-4742-B35A-21833E6260A3'

SELECT @scriptExecuted = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @scriptExecuted = 0

BEGIN

    DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

    IF OBJECT_ID('tempdb.dbo.#FailureReasonMsgsWithNoTime') IS NOT NULL DROP TABLE #FailureReasonMsgsWithNoTime

    CREATE TABLE #FailureReasonMsgsWithNoTime

    (

        id INT

    )

    CREATE CLUSTERED INDEX FailureReasonMsgsWithNoTime_id_idx ON #FailureReasonMsgsWithNoTime(id)
    INSERT INTO #FailureReasonMsgsWithNoTime


    SELECT FRM.id

    FROM JMFailureReasonMsg FRM

    WHERE failureReasonTime = 0

    -- Update failureReasonTime to nowTime

    UPDATE FRM

    SET failureReasonTime = @nowTime

    FROM JMFailureReasonMsg FRM WITH (NOLOCK)

    JOIN #FailureReasonMsgsWithNoTime WNT ON FRM.Id = WNT.id

    IF OBJECT_ID('tempdb.dbo.#FailureReasonMsgsWithNoTime') IS NOT NULL DROP TABLE #FailureReasonMsgsWithNoTime
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'JMFailureReasonMsgsWithNoTimeStamp', 'Script to update failureReasonTime to run time so that records can be pruned.', @nowTime, 16, 0, 16+1)

END

SET NOCOUNT OFF

