

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMFailureReasonLocaleMsgCache.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                              

--           Copyright (c) 1998  CommVault Systems, Inc.                  

--                   All rights reserved.                                    

--                                                                              

--                                                                           

--       This is unpublished proprietary source code of CommVault  

--       Systems, Inc. The copyright notice above does not evidence 

--       any actual or intended publication of such source code. 

--

--      Revisions  Author   Description

--      ---------  -------  ---------------------------------------------

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/JMFailureReasonLocaleMsgCache.script,v $ $Id: JMFailureReasonLocaleMsgCache.script,v 1.1.2.1 2018/09/29 21:27:48 gpattabiraman Exp $";

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '23B4D0E6-E74B-49FC-AB7A-29BF704F20C7')

BEGIN 

	DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

	DECLARE @lastThreeMonths INT = @nowTime - 7776000

	IF OBJECT_ID('tempdb.dbo.#JobsWithJPR') IS NOT NULL DROP TABLE #JobsWithJPR

	CREATE TABLE #JobsWithJPR

	(jobId INT, commcellId INT, failureReason VARCHAR(256))
	INSERT INTO #JobsWithJPR


	SELECT JM.jobid, JM.commCellId, JM.failureReason

	FROM JMAdminJobStatsTable JM

	INNER JOIN JMFailureReasonMsg JF ON JM.jobId = JF.jobId AND JM.commCellId = JF.commCellId

	WHERE failureReason IS NOT NULL AND failureReason <> ''

	AND servEnd >= @lastThreeMonths

	UNION 

	SELECT JM.jobid, JM.commCellId, JM.failureReason

	FROM JMBkpStats JM

	INNER JOIN JMFailureReasonMsg JF ON JM.jobId = JF.jobId AND JM.commCellId = JF.commCellId

	WHERE failureReason IS NOT NULL AND failureReason <> ''

	AND servEndDate >= @lastThreeMonths

	UNION 

	SELECT JM.jobid, JM.commCellId, JM.failureReason

	FROM JMRestoreStats JM

	INNER JOIN JMFailureReasonMsg JF ON JM.jobId = JF.jobId AND JM.commCellId = JF.commCellId

	WHERE failureReason IS NOT NULL AND failureReason <> ''

	AND servEndTime > @lastThreeMonths

	-- Delete all JPRs first

	DELETE C

	FROM JMFailureReasonLocaleMsgCache C

	INNER JOIN #JobsWithJPR J ON C.jobId = J.jobId AND C.commCellId = J.commCellId
	INSERT INTO JMFailureReasonLocaleMsgCache


	SELECT jobId, commcellId, failureReason, 0 /*English locale*/, dbo.JMGetLocalizedMessageFunc(0, failureReason) FR

	FROM #JobsWithJPR

	IF OBJECT_ID('tempdb.dbo.#JobsWithJPR') IS NOT NULL DROP TABLE #JobsWithJPR

EXIT_SCRIPT:
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('23B4D0E6-E74B-49FC-AB7A-29BF704F20C7', 'JMBuildJPRCache', 'Script to populate cache for JPR strings.', @nowTime, 16, 0, 16+1)

END

