

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMBkpStats.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                              

--           Copyright (c) 1998  CommVault Systems, Inc.                  

--                   All rights reserved.                                    

--                                                                              

--                                                                           

--       This is unpublished proprietary source code of CommVault  

--       Systems, Inc. The copyright notice above does not evidence 

--       any actual or intended publication of such source code. 

--

--      Revisions  Author   Description

--      ---------  -------  ---------------------------------------------

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/JMBkpStats.script,v $ $Id: JMBkpStats.script,v 1.1.2.9 2019/09/20 16:01:30 gpattabiraman Exp $";

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

GO

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '18391673-2ADB-49FB-B175-0FF8D7FA1243')

BEGIN 

	IF OBJECT_ID('tempdb.dbo.#tmpJobsToFix') IS NOT NULL DROP TABLE #tmpJobsToFix

	CREATE TABLE #tmpJobsToFix(jobId INT, commCellId INT)

	IF OBJECT_ID('tempdb.dbo.#tmpJobCopy') IS NOT NULL DROP TABLE #tmpJobCopy

	CREATE TABLE #tmpJobCopy(jobId INT, commCellId INT, copyId INT)

	IF OBJECT_ID('tempdb.dbo.#tmpJobInfo') IS NOT NULL DROP TABLE #tmpJobInfo

	CREATE TABLE #tmpJobInfo (jobId INT, commCellId INT, afPhysicalSize BIGINT)

	/*

	*/
	INSERT INTO #tmpJobsToFix(jobId, commCellId)


SELECT jobId, CommcellId FROM JMBkpStats WITH (READUNCOMMITTED) WHERE (bkpattributesEx & 0x800000) > 0 AND (bkpAttributes & 0x200000000) = 0 AND status IN (1,3,14)

	AND jobid = jobidactedon

	IF @@ROWCOUNT = 0

		GOTO EXIT_SCRIPT

	;WITH CopyPicker (jobId, commCellId, archGrpCopyId, rn)

	AS

	(

	SELECT J.jobId, J.commCellId, archGrpCopyId, row_number() over (partition by J.jobId, J.commCellId ORDER BY J.archGrpCopyId) as rn

		FROM JMJobDataStats J, #tmpJobsToFix S, ArchGroupCopy AGC

		WHERE J.jobId = S.jobId

		AND J.commCellId = S.commCellId

		AND AGC.id = J.archGrpCopyId

		AND AGC.isSnapCopy = 0

		GROUP BY J.jobId, J.commCellId, archGrpCopyId

		HAVING MIN(J.status) = 100 AND MAX(J.status) = 100

	)	
	INSERT INTO #tmpJobCopy(jobId, commCellId, copyId)


	SELECT jobId, commCellId, archGrpCopyId

	FROM CopyPicker

	WHERE rn = 1	
	INSERT INTO #tmpJobInfo(jobId, commCellId, afPhysicalSize) 


	SELECT	J.JobID, J.commCellId, SUM(AFC.physicalSize)

	FROM	JMBkpStats J, archFile AF, archFileCopy AFC, #tmpJobCopy T

	WHERE	J.JobId = T.jobId

	AND J.commCellId = T.commCellId

	AND J.JobID = AF.JobID

	AND J.commCellId = AF.commCellId

	AND AF.id = AFC.archFileId

	AND AF.commCellId = AFC.commCellId

	AND AFC.archCopyId = T.copyId

	AND AF.isValid = 1

	GROUP BY J.JobID, J.commCellId	

	UPDATE J

	SET totalBackupSize = T.afPhysicalSize

	FROM JMBkpStats J, #tmpJobInfo T

	WHERE J.jobId = T.jobId

	AND J.commCellId = T.commCellId	

EXIT_SCRIPT:
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('18391673-2ADB-49FB-B175-0FF8D7FA1243', 'JMBkpStatsFixBlockLevelBackupSize', 'Script to fix block level jobs which were run with an issue that caused job totalbackupsize not to be updated with backup copy archive file sizes', @nowTime, 16, 0, 16+1)

	IF OBJECT_ID('tempdb.dbo.#tmpJobsToFix') IS NOT NULL DROP TABLE #tmpJobsToFix	

	IF OBJECT_ID('tempdb.dbo.#tmpJobCopy') IS NOT NULL DROP TABLE #tmpJobCopy

	IF OBJECT_ID('tempdb.dbo.#tmpJobInfo') IS NOT NULL DROP TABLE #tmpJobInfo

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = 'E894D65A-FE66-4C23-92DD-D90D27DDC8EE')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#laptopClients') IS NOT NULL DROP TABLE #laptopClients

	CREATE TABLE #laptopClients(clientId INT, PRIMARY KEY(clientId))

	IF OBJECT_ID('tempdb.dbo.#laptopAppIds') IS NOT NULL DROP TABLE #laptopAppIds

	CREATE TABLE #laptopAppIds(appId INT, PRIMARY KEY(appId))
	INSERT INTO #laptopClients


	SELECT id

	FROM APP_Client

	WHERE status & 0x1000 = 0x1000 -- laptops
	INSERT INTO #laptopAppIds


	SELECT APP.id

	FROM APP_Application APP

	JOIN #laptopClients L ON APP.clientId = L.clientId

	UPDATE JM

	SET bkpAttributesEx = bkpAttributesEx | 0x40000000000000 -- JMBKP_EX_LAPTOP_JOB

	FROM JMBkpStats JM

	JOIN #laptopAppIds L ON JM.appId = L.appId

	UPDATE JM

	set rstattributes = rstattributes | 0x100000 -- JMRST_LAPTOP_JOB

	FROM JMRestoreStats JM

	JOIN #laptopClients L ON L.clientId = JM.srcClientId

	IF OBJECT_ID('tempdb.dbo.#laptopClients') IS NOT NULL DROP TABLE #laptopClients

	IF OBJECT_ID('tempdb.dbo.#laptopAppIds') IS NOT NULL DROP TABLE #laptopAppIds
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('E894D65A-FE66-4C23-92DD-D90D27DDC8EE', 'SetLaptopAttributes', 'Script to set the laptop job attribute for backupa and restore jobs.', @nowTime, 16, 0, 16+1)

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '8530DEFC-1849-4A3F-AF2B-7E120834FADA')

BEGIN 

	DECLARE @appAwareFullAttribute BIGINT = (CAST(0x10000000000000 AS BIGINT) | CAST (0x20000000000000 AS BIGINT)) -- JMBKP_EX_APPAWARE_CHILD_JOB | JMBKP_EX_FULL_JOB_IN_CYCLE

	UPDATE JM

	SET bkpAttributesEx = bkpAttributesEx | @appAwareFullAttribute

	FROM JMBkpStats JM

	INNER JOIN JMVSAAppJobLink VAPP ON JM.jobId = VAPP.childJobId AND JM.commCellId = VAPP.commCellId

	WHERE JM.bkpLevel = 1 -- Full AppAware child jobs.
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('8530DEFC-1849-4A3F-AF2B-7E120834FADA', 'SetAppAwareFullAttributes2', 'Script to set the new full job attribute for appaware child jobs.', @nowTime, 16, 0, 16+1)

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = 'A930B937-6011-41DB-8494-9B52EF09088F')

BEGIN 

	IF OBJECT_ID('tempdb.dbo.#tmpVSAJobsToFix') IS NOT NULL DROP TABLE #tmpVSAJobsToFix

	CREATE TABLE #tmpVSAJobsToFix(jobId INT, commcellId INT, appId INT, PRIMARY KEY (jobId, commcellId))

	-- Get All VSA jobs for V2 parent subclients that have successful jobs but no full cycle number property
	INSERT INTO #tmpVSAJobsToFix(jobId, commCellId, appId)


	SELECT JM.jobId, JM.commCellId, JM.appId

	FROM JMBkpStats JM WITH (NOLOCK)

	JOIN APP_Application APP WITH (NOLOCK) ON JM.appId = APP.id

	LEFT JOIN APP_SubClientProp SP (NOLOCK) ON SP.componentNameId = JM.appId AND SP.attrName = 'sys:full cycle num' AND SP.modified = 0 AND SP.cs_attrName = CHECKSUM(N'sys:full cycle num')

	WHERE JM.opType = 4 /*BACKUP*/ AND JM.appType = 106 /*VIRTUAL_SERVER_IDA*/ AND JM.status IN (1, 3, 14)/*JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/ 

	AND JM.bkpAttributesEx & 0x40000000 = 0x40000000 /*JMBKP_EX_PSEUDO_PARENT_JOB*/ 

	AND fullCycleNum = 0  -- No full cycle number in JM tables

	AND SP.id IS NULL -- No full cycle number is subclient property

	IF @@ROWCOUNT = 0

		GOTO EXIT_VSAV2CYCLEFIX

	UPDATE JM

	SET fullCycleNum = 1

	FROM #tmpVSAJobsToFix TJ

	JOIN JMBkpStats JM ON TJ.jobId = JM.jobId AND TJ.commcellId = JM.commCellId
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)


	SELECT DISTINCT appId, 'sys:full cycle num', 10, '1', @nowTime, 0

	FROM #tmpVSAJobsToFix	

EXIT_VSAV2CYCLEFIX:
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('A930B937-6011-41DB-8494-9B52EF09088F', 'JMFixCycleForVSAV2Jobs', 'Script to fix cycle number for VSA V2 jobs', @nowTime, 16, 0, 16+1)

	IF OBJECT_ID('tempdb.dbo.#tmpVSAJobsToFix') IS NOT NULL DROP TABLE #tmpVSAJobsToFix	

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '6F00B5AA-5885-4000-A4DA-1EC1AAAFC2CC')

BEGIN 

	-- Remove skip catalog flag for all VSA jobs as it is not applicable.

	DECLARE @skipCataLogFlag BIGINT = 0x200000000000000 --JMBKP_SKIP_CATALOG_PHASE_SNAP_BKUP

	UPDATE JM 

	SET bkpattributes = bkpattributes & ~ @skipCataLogFlag

	FROM JMBkpStats JM

	WHERE JM.appType = 106 -- VIRTUAL_SERVER_IDA

	AND JM.bkpattributes & @skipCataLogFlag = @skipCataLogFlag
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('6F00B5AA-5885-4000-A4DA-1EC1AAAFC2CC', 'JMRemoveSkipCatalogForVSAJobs', 'Script to remove skip catalog flag for VSA jobs', @nowTime, 16, 0, 16+1)

END

