

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/JMAdminJobAttemptStatsTable.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/JMAdminJobAttemptStatsTable.script,v $ $Id: JMAdminJobAttemptStatsTable.script,v 1.1.2.12 2018/08/23 10:23:10 bzhu Exp $";

declare @guid uniqueidentifier = '3EFE072A-2A4A-4136-865C-10B147CFCD22'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	UPDATE JMAdminJobAttemptStatsTable 

	SET phaseNum = phaseNum + 1 

	FROM JMAdminJobStatsTable, JMAdminJobAttemptStatsTable 

	WHERE

    JMAdminJobStatsTable.jobId = JMAdminJobAttemptStatsTable.jobId AND

    JMAdminJobStatsTable.commCellId = JMAdminJobAttemptStatsTable.commCellId AND      

    JMAdminJobStatsTable.opType = 31 AND

    JMAdminJobAttemptStatsTable.phaseNum = 3  
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateAlertTemplateForAuxCopy', 'Update alert template', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET @guid = '11C58E69-8FE1-46BA-BDEE-9CD58D4B86A2'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	UPDATE adminAttempt

	SET adminAttempt.phaseNum = adminAttempt.phaseNum +1

	FROM JMAdminJobStatsTable adminStats INNER JOIN JMAdminJobAttemptStatsTable adminAttempt

	ON adminStats.jobId = adminAttempt.jobId AND adminStats.commCellId = adminAttempt.commCellId 

	AND adminStats.opType = 53 AND adminAttempt.phaseNum = 1--OFFLINECONTENTINDEX
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateDataAnalyticsPhase', 'Update data analytics jobs phase number', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET @guid = '7F1F1C66-E47B-49A3-A81E-0FD1E22D8219'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	UPDATE adminAttempt

	SET adminAttempt.phaseNum = adminAttempt.phaseNum +1

	FROM JMAdminJobStatsTable adminStats INNER JOIN JMAdminJobAttemptStatsTable adminAttempt

	ON adminStats.jobId = adminAttempt.jobId AND adminStats.commCellId = adminAttempt.commCellId 

	AND adminStats.opType = 53 AND adminAttempt.phaseNum >= 1 --OFFLINECONTENTINDEX
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateDataAnalyticsPhase', 'Update data analytics jobs phase number', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET @guid = '8728B2B8-C37B-4FD2-B22C-E029CD3C8508'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	UPDATE adminAttempt

	SET adminAttempt.phaseNum = adminAttempt.phaseNum +1

	FROM JMAdminJobStatsTable adminStats INNER JOIN JMAdminJobAttemptStatsTable adminAttempt

	ON adminStats.jobId = adminAttempt.jobId AND adminStats.commCellId = adminAttempt.commCellId 

	AND adminStats.opType = 113 AND adminAttempt.phaseNum = 1--SUBCLIENTCONTENTINDEX
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateSubClientDataAnalyticsPhase', 'Update data analytics jobs phase number', @curUtcDateTime, 16, 0 , (16 + 2))

END

--Added content push phase at Number 2, Hence increment phase number 2 to 3.

SET @guid = '8A1BC3CE-2F0B-4EC7-B2FC-5B1F7A88A16B'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	UPDATE adminAttempt

	SET adminAttempt.phaseNum = adminAttempt.phaseNum +1

	FROM JMAdminJobStatsTable adminStats INNER JOIN JMAdminJobAttemptStatsTable adminAttempt

	ON adminStats.jobId = adminAttempt.jobId AND adminStats.commCellId = adminAttempt.commCellId 

	AND adminStats.opType IN (53,113) AND adminAttempt.phaseNum = 2--SUBCLIENTCONTENTINDEX && OFFLINECONTENTINDEX

	--Update the phase number in running info tables.

	UPDATE adminAttemptInfo

	SET adminAttemptInfo.phaseNum = adminAttemptInfo.phaseNum +2

	FROM JMJobInfo jobInfo INNER JOIN JMAdminJobAttemptInfoTable adminAttemptInfo

	ON jobInfo.jobId = adminAttemptInfo.jobId AND jobInfo.commCellId = adminAttemptInfo.commCellId 

	AND jobInfo.opType IN (53,113) AND adminAttemptInfo.phaseNum = 1--SUBCLIENTCONTENTINDEX && OFFLINECONTENTINDEX

	--Update the current phase column in JMJobInfo

	UPDATE JMJobInfo

	SET currentPhase = currentPhase + 2

	WHERE opType IN (53,113) AND currentPhase = 1
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'PhaseUpdateGDPRChanges', 'Update data analytics jobs phase number for GDPR', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET @guid = '7F8E7567-2912-4414-883D-852E0FE184B7'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	--Increment current phase column if this is backup copy in same job

	UPDATE jobInfo

	SET jobInfo.currentPhase = jobInfo.currentPhase + 1

	FROM JMJobInfo jobInfo INNER JOIN JMBkpJobInfo bkpInfo

		ON jobInfo.jobId = bkpInfo.jobId AND jobInfo.commCellId = bkpInfo.commcellId AND (bkpInfo.bkpAttributesEx & 0x800000) = 0x800000 -- JMBKP_EX_SNAPTOTAPE_IN_SAME_JOB

	WHERE jobInfo.currentPhase > 14  --Phase number is in Backup copy phases

	--Increment attempt info if this is backup copy in same job

	UPDATE bkpAtmInfo

	SET bkpAtmInfo.phaseNum = bkpAtmInfo.phaseNum + 1

	FROM JMJobInfo jobInfo INNER JOIN JMBkpJobInfo bkpInfo

		ON jobInfo.jobId = bkpInfo.jobId AND jobInfo.commCellId = bkpInfo.commcellId AND (bkpInfo.bkpAttributesEx & 0x800000) = 0x800000 --JMBKP_EX_SNAPTOTAPE_IN_SAME_JOB

		INNER JOIN JMBkpAttemptInfo bkpAtmInfo ON jobInfo.jobId = bkpAtmInfo.jobId AND jobInfo.commCellId = bkpAtmInfo.commcellId

	WHERE jobInfo.currentPhase > 14 AND bkpAtmInfo.phaseNum > 14 --Phase number is in Backup copy phases

	--Increment bkp attempts if this is backup copy in same job

	UPDATE bkpAttmStats

	SET bkpAttmStats.phase = bkpAttmStats.phase + 1

	FROM JMBkpStats bkpStats INNER JOIN JMBkpAtmptStats bkpAttmStats

	ON bkpStats.jobId = bkpAttmStats.jobId AND bkpStats.commCellId = bkpAttmStats.commcellId AND (bkpStats.bkpAttributesEx & 0x800000) = 0x800000 --JMBKP_EX_SNAPTOTAPE_IN_SAME_JOB

	WHERE bkpAttmStats.phase > 14
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'PostOperationPhaseForSnap', 'Update snap backup phase numbers', @curUtcDateTime, 16, 0 , (16 + 2))

END

-- add prescan phase = 1, so increase phase number 

SET @guid = 'A4F04972-FBB9-4ACE-B5DC-D7288B9B4400'

SET @globalParamPlanUpdateExec = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, execute below query

BEGIN

	UPDATE adminAttempt

	SET adminAttempt.phaseNum = adminAttempt.phaseNum +1

	FROM JMAdminJobStatsTable adminStats INNER JOIN JMAdminJobAttemptStatsTable adminAttempt

	ON adminStats.jobId = adminAttempt.jobId AND adminStats.commCellId = adminAttempt.commCellId 

	AND adminStats.opType = 113 AND adminAttempt.phaseNum >= 1 -- SUBCLIENTCONTENTINDEX

	--Update the phase number in running info tables.

	UPDATE adminAttemptInfo

	SET adminAttemptInfo.phaseNum = adminAttemptInfo.phaseNum + 1

	FROM JMJobInfo jobInfo INNER JOIN JMAdminJobAttemptInfoTable adminAttemptInfo

	ON jobInfo.jobId = adminAttemptInfo.jobId AND jobInfo.commCellId = adminAttemptInfo.commCellId 

	AND jobInfo.opType = 113 AND adminAttemptInfo.phaseNum >= 1 --SUBCLIENTCONTENTINDEX

	--Update the current phase column in JMJobInfo

	UPDATE JMJobInfo

	SET currentPhase = currentPhase + 1

	WHERE opType = 113 AND currentPhase >= 1 --SUBCLIENTCONTENTINDEX
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateContentIndexingPhase', 'Update content indexing jobs phase number', @curUtcDateTime, 16, 0 , (16 + 2))

END

SET  NOCOUNT OFF

