

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/InfiniStore.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @l_nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '46E8778A-A7CD-461A-AA43-2111DF1CAD10')

BEGIN

	--

	-- Set Active and Default flag for all active DDBs

	--

	UPDATE 	C2S

SET		flags = (C2S.flags | 4 | 2)

	FROM	archCopySIDBStore C2S, archGroupCopy AGC

	WHERE	C2S.copyId = AGC.id AND C2S.SIDBStoreId = AGC.SIDBStoreId

	--

	-- Set Default flag for all active DDBs

	--

	UPDATE 	S

SET		ExtendedFlags = (S.ExtendedFlags | 2)

	FROM	IdxSIDBStore S, archGroupCopy AGC

	WHERE	S.SIDBStoreId = AGC.SIDBStoreId

	--

	-- Add association for dependent Copy to GDSP

	--
	INSERT INTO archCopyToGlobalPolicy (copyId, globalPolicyId, flags)


	SELECT 	DC.id, GC.archGroupId, 0

	FROM	archGroupCopy DC WITH(READUNCOMMITTED),

			archGroupCopy GC  WITH(READUNCOMMITTED)

	WHERE	DC.SIDBStoreId = GC.SIDBStoreId

AND (DC.dedupeFlags & 134217728) > 0

AND (GC.dedupeFlags & 268435456) > 0

	--

	-- Populate Subclient to DDB mapping 

	--
	INSERT INTO archSubclientCopyDDBMap (AppId, CopyId, SIDBStoreId)


	-- Associated StoragePolicy

	SELECT	SC.id, AGC.id, AGC.SIDBStoreId

	FROM	App_Application SC WITH(READUNCOMMITTED),

			archGroupCopy AGC WITH(READUNCOMMITTED)

	WHERE	(SC.dataArchGrpId = AGC.archGroupId OR SC.logArchGrpId = AGC.archGroupId)

			AND AGC.SIDBStoreId > 0

	UNION

	--Incremental StoragePolicy

	SELECT	SC.Id, AGC.Id, AGC.SIDBStoreId

	FROM	App_Application SC WITH(READUNCOMMITTED),

			archGroup AG WITH(READUNCOMMITTED),

			archGroupCopy AGC WITH(READUNCOMMITTED)

	WHERE	(SC.dataArchGrpId = AG.id OR SC.logArchGrpId = AG.id)

			AND AG.incrSP > 1

			AND AG.incrSP = AGC.archGroupId

			AND AGC.SIDBStoreId > 0	
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('46E8778A-A7CD-461A-AA43-2111DF1CAD10', 'InfiniStoreScript', 'Upgrade script for InfiniStore changes', @l_nowTime, 16, 0, 16 + 1)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'F911A418-3D58-46AA-B712-CBD36F8A89CA')

BEGIN
	INSERT INTO archSubclientCopyDDBMap


	SELECT T.AppId, T.CopyId, T.SIDBStoreId

	FROM

	(

		SELECT 	SC.id AppId, AGC.id CopyId, S.SIDBStoreId, 

				ROW_NUMBER() 

				OVER

				(	

					PARTITION BY SC.id, AGC.id

					ORDER BY

						--Matching DDB by AppType first

						(CASE WHEN EXISTS(SELECT 1 FROM APP_AppTypeGroupAssoc ATG WITH (NOLOCK) WHERE ATG.appTypeId = SC.appTypeId

												AND ATG.typeOfGroup = 0 /*TYPEOFGROUP_APPTYPES*/ AND S.AppTypeGroupId = ATG.appGroupId) 

							THEN 0 ELSE 1 END),

						--Default DDB

						(CASE WHEN (ACS.flags & 2 /*IDX_COPY_DDB_DEFAULT*/) > 0 THEN 0 ELSE 1 END),

						S.SIDBStoreId		

				) AS RowNum

		FROM 	

			(

				SELECT  I.id, I.dataArchGrpID, I.logArchGrpID, I.appTypeId, CN.releaseId, ISNULL(MAX(SIP.HighestSP),0) SP

				FROM   	APP_Application I

						INNER JOIN APP_Client CN WITH(READUNCOMMITTED) ON I.clientId = CN.id 

						LEFT JOIN simInstalledPackages SIP WITH(READUNCOMMITTED) ON CN.id = SIP.ClientId                                       

				GROUP BY I.id, I.dataArchGrpID, I.logArchGrpID, I.appTypeId, CN.releaseId

			) AS SC

			INNER JOIN archGroup AG WITH (NOLOCK) ON  AG.Id IN (SC.dataArchGrpID, SC.logArchGrpID) AND AG.id > 0

			INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.archGroupId in (AG.id, AG.incrSp)

			INNER JOIN archCopySIDBStore ACS WITH (NOLOCK) ON ACS.CopyId = AGC.id

			INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON ACS.SIDBStoreId = S.SIDBStoreId

			LEFT JOIN archSubclientCopyDDBMap ASCM ON ASCM.copyId = AGC.id AND ASCM.appId = SC.id

			WHERE 	(

						(SC.releaseId > 16 OR (SC.releaseId = 16 AND SC.SP > 13))

						OR

						((SC.releaseId < 16 OR (SC.releaseId = 16 AND SC.SP < 14)) AND (ACS.flags & 2 /*IDX_COPY_DDB_DEFAULT*/) > 0)

					)

					AND ACS.flags & (1|4) = 4 -- IDX_COPY_DDB_FULL | IDX_COPY_DDB_ACTIVE

					AND AGC.id > 0 AND ASCM.appId IS NULL

	) AS T

	WHERE T.RowNum = 1
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('F911A418-3D58-46AA-B712-CBD36F8A89CA', 'CreateInfinitStoreMapForPseudoClient', 'Upgrade script for Creating missing archSubclientCopyDDBMap entries', @l_nowTime, 16, 0, 16 + 1)

END

--

-- Add new events to the "Deduplication Database Threshold" alert

--

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'CA81E2F9-A102-407D-9806-944724E1955A')

BEGIN

	DECLARE @alertId INT 

	DECLARE @criteriaId INT 

	DECLARE @criteriaXML xml

	SELECT 	TOP 1 @alertId = R.id, @criteriaId = C.criteriaId, @criteriaXML = cast(cast(C.criteriaXML as varchar(max)) as xml)

	FROM	NTSimpanaEventCriteria C, NTnotificationRule R

	WHERE	C.notifRuleId = R.id

			AND R.notificationName =  'Deduplication Database Threshold'

			AND R.alertTypeId = 58 

	IF @@ROWCOUNT > 0 AND @criteriaXML IS NOT NULL

	BEGIN

		SET	@criteriaXML.modify('replace value of (/LogMonitoring_ConditionsList/conditions)[1]/@value1 with ''32:524|32:530''')

		SET	@criteriaXML.modify('replace value of (/LogMonitoring_ConditionsList)[1]/@criteriaName with ''(Event Code equals to 32:524|32:530)''')

		UPDATE 	NTSimpanaEventCriteria

		SET		criteriaXML = cast(@criteriaXML as nvarchar(max))

		WHERE	criteriaId = @criteriaId

		--Enable alert

		UPDATE 	NTnotificationRule

		SET		status = 2048 /*NT_STATUS_DEFAULT_ALERT*/

		WHERE	id = @alertId	

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('CA81E2F9-A102-407D-9806-944724E1955A', 'EnableAddNewEventsDedupeThresholdAlert', 'Upgrade script for adding new events to dedupe threshold alert', @l_nowTime, 16, 0, 16 + 1)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '36CF2EC2-ABC4-4AD3-BC3D-AFF75051F906')

BEGIN

	UPDATE archGroup

SET flags |= 32, SIBlockSizeKB = case when SIBlockSizeKB > 0 then SIBlockSizeKB else 128 end

WHERE (flags & 32 = 0 OR SIBlockSizeKB = 0)

AND EXISTS(SELECT 1 FROM archGroupCopy AGC WITH(READUNCOMMITTED) WHERE AGC.archGroupId = archGroup.id AND AGC.dedupeFlags & 262144 > 0)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('36CF2EC2-ABC4-4AD3-BC3D-AFF75051F906', 'SetBlockLevelDedupeFlagOnHyperscaleGDSP', 'Upgrade script for setting block level dedupe flag on the Hyperscale GDSP', @l_nowTime, 16, 0, 16 + 1)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '48C55B1F-151C-4074-967C-8B6BFDA96D60')

BEGIN

	DECLARE @lt_Copy TABLE (CopyId INT, CommCellId INT)
	INSERT 	INTO @lt_Copy


	SELECT 	DISTINCT ISNULL(GP.defaultCopy, AGC.id), P.intVal

	FROM 	MMEntityProp P WITH(READUNCOMMITTED)

			INNER JOIN archGroupCopy AGC WITH(READUNCOMMITTED) 

ON P.CommCellId = 2

			AND P.EntityId = AGC.id 

			AND P.propertyName = 'AuxCopyCommCellID' 

AND P.EntityType = 2

LEFT OUTER JOIN archCopyToGlobalPolicy CGP WITH(READUNCOMMITTED) ON AGC.id = CGP.copyId AND AGC.dedupeFlags & 134217728 > 0

			LEFT OUTER JOIN archGroup GP WITH(READUNCOMMITTED) ON CGP.globalPolicyId = GP.id

WHERE  	P.intVal > 2

	IF @@ROWCOUNT > 0

	BEGIN
		INSERT INTO IdxSIDBGroup


		SELECT 	CopyId, CommCellId

		FROM	@lt_Copy

		UPDATE	S

		SET		SIDBGroupId = SG.SIDBGroupId

		FROM	@lt_Copy C,

				IdxSIDBGroup SG WITH(READUNCOMMITTED), 

				archCopySIDBStore CS WITH(READUNCOMMITTED), 

				IdxSIDBStore S				

		WHERE	C.copyId = SG.copyId

				AND C.copyId = CS.copyId

				AND CS.SIDBStoreId = S.SIDBStoreId

	END

	DELETE 	MMEntityProp

	WHERE	propertyName = 'AuxCopyCommCellID'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('48C55B1F-151C-4074-967C-8B6BFDA96D60', 'SetDDBCommCellIdGroup', 'Upgrade script for moving DDBs using for migrated data to respective CommCellId group', @l_nowTime, 16, 0, 16 + 1)

END

