

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/IndexDefragExclusionList.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/IndexDefragExclusionList.script,v $ $Id: IndexDefragExclusionList.script,v 1.1.2.1 2020/03/12 01:33:18 abilbrey Exp $";
-- TABLENAME IndexDefragExclusionList

print '... inserting Table: IndexDefragExclusionList'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME IndexDefragExclusionList

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @staticTableIdxExclList TABLE (

	tableName	SYSNAME PRIMARY KEY,

	exclSizeMB	BIGINT

)

-- Insert static tables to check to see if size is exceeded and add to the Index Defrag Exclusion List by default
INSERT INTO @staticTableIdxExclList (tableName, exclSizeMB)


	VALUES 

		('archFileSIDBKeys', 20480)		-- 20GB exceeded exclude from all index defrag operations

DECLARE @excludeTables TABLE (

	tableName	SYSNAME PRIMARY KEY,

	totalMB		BIGINT,

	exclSizeMB	BIGINT 

)

DECLARE @rCnt INT = 0
INSERT INTO @excludeTables (tableName, totalMB, exclSizeMB)


	SELECT

		t.Name AS TableName,

		CAST((SUM(a.total_pages) / 128.00) AS BIGINT) AS TotalMB,

		e.exclSizeMB

	FROM @staticTableIdxExclList e

		INNER JOIN sys.tables t ON

			t.Name = e.tableName

		INNER JOIN sys.indexes i ON 

			t.OBJECT_ID = i.object_id

		INNER JOIN sys.partitions p ON 

			i.object_id = p.OBJECT_ID 

			AND i.index_id = p.index_id

		INNER JOIN sys.allocation_units a ON 

			p.partition_id = a.container_id

	GROUP BY 

		t.Name,

		e.exclSizeMB

	HAVING

		CAST((SUM(a.total_pages) / 128.00) AS BIGINT) >= e.exclSizeMB

SET @rCnt = @@ROWCOUNT

DECLARE @exclXML NVARCHAR(MAX)		-- yes nvarchar wanted for XML document

IF (@rCnt > 0)

BEGIN

	-- Tables found that need to be excluded, create exclustion XML document

	SET @exclXML = (

		SELECT

			 tableName '@name'

		FROM @excludeTables

		FOR XML PATH('Table'), ROOT('DbMaintenanceExcludeIdxDefrag')

	)

	DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())

	UPDATE p

		SET value = @exclXML,

			created = @now

	FROM GXGlobalParam p

	WHERE

		p.name = N'DbMaintenanceExcludeIdxDefrag'

	SET @rCnt = @@ROWCOUNT

	IF (@rCnt = 0)

	BEGIN

		-- Add row
		INSERT INTO GXGlobalParam (name, value, created, modified)


			VALUES (N'DbMaintenanceExcludeIdxDefrag', @exclXML, @now, 0)

	END

	-- Generate a report to log to the database upgrade log file

	SET @exclXML = (

		SELECT

			 tableName '@name',

			 totalMB '@totalMB',

			 exclSizeMB '@exceededSizeMB'

		FROM @excludeTables

		FOR XML PATH('Table'), ROOT('DbMaintenanceExcludeIdxDefrag')

	)

	PRINT N'IndexDefragExclusion: Created exclusion list [' + @exclXML + N']'

END

