

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/IdxSIDBSubStore.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/IdxSIDBSubStore.script,v $ $Id: IdxSIDBSubStore.script,v 1.3.42.6 2019/09/26 06:43:34 kbora Exp $";
-- TABLENAME IdxSIDBSubStore

print '... inserting Table: IdxSIDBSubStore'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME IdxSIDBSubStore

-- Move the insert part back into IdxSIDBSubStore table as IdxSIDBRecoveryHistory needed the rows in SubStore table while upgrading the schema.

UPDATE IdxSIDBStore 

SET IdxCacheId = 0, IdxAccessPathId = 0, ClientId = 0 

WHERE SIDBStoreId > 0

--Delete the dangling entries in SubStore table before adding constraint. This is done for matador case where 9.0 stores have substore entries

--and deletion of stores may leave the substore entries behind.

DELETE FROM IdxSIDBSubStore WHERE SIDBStoreId NOT IN (SELECT I.SIDBStoreId FROM IdxSIDBStore I WHERE SIDBStoreId > 0)

IF (EXISTS (SELECT 1 

			FROM MMEntityProp P, IdxSIDBSubStore S 

			WHERE S.SIDBStoreId = P.EntityID 

				AND S.CommCellId = P.CommCellId 

				AND P.EntityType = 3 

				AND P.propertyName IN ('DDBLastBackupJobId', 'DDBLastBackupJobCommCellGUID', 'DDBPath')

	))

BEGIN

	--Move the DDB Backup info from MMEntityProp to IDXSIDBSubStore table

	UPDATE IdxSIDBSubStore 

	SET LastSnapJobId = ISNULL(MMEntityProp.longlongVal, 0) 

	FROM MMEntityProp 

	WHERE IdxSIDBSubStore.SIDBStoreId = MMEntityProp.EntityID 

	AND IdxSIDBSubStore.CommCellId = MMEntityProp.CommCellId 

	AND MMEntityProp.EntityType = 3 

	AND MMEntityProp.propertyName = 'DDBLastBackupJobId'

	UPDATE IdxSIDBSubStore 

	SET DDBBackupCSGUID = ISNULL(MMEntityProp.stringVal, '') 

	FROM MMEntityProp 

	WHERE IdxSIDBSubStore.SIDBStoreId = MMEntityProp.EntityID 

	AND IdxSIDBSubStore.CommCellId = MMEntityProp.CommCellId 

	AND MMEntityProp.EntityType = 3 

	AND MMEntityProp.propertyName = 'DDBLastBackupJobCommCellGUID'

	UPDATE IdxSIDBSubStore 

	SET SIDBSnapPath = ISNULL(MMEntityProp.stringVal, '') 

	FROM MMEntityProp 

	WHERE IdxSIDBSubStore.SIDBStoreId = MMEntityProp.EntityID 

	AND IdxSIDBSubStore.CommCellId = MMEntityProp.CommCellId 

	AND MMEntityProp.EntityType = 3 

	AND MMEntityProp.propertyName = 'DDBPath'

	-- Remove the DDB Backup info from MMEntityProp 

	DELETE FROM MMEntityProp 

	FROM MMEntityProp P, IdxSIDBSubStore S 

	WHERE S.SIDBStoreId = P.EntityID 

	AND S.CommCellId = P.CommCellId 

	AND P.EntityType = 3 

	AND P.propertyName IN ('DDBLastBackupJobId', 'DDBLastBackupJobCommCellGUID', 'DDBPath')

END

UPDATE IdxSIDBSubStore

SET flags = flags | 8192

WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM IdxSIDBStore WHERE (flags & 8192) > 0)

AND Version = 4

UPDATE SUB

SET MaxNumOfAFsInSecFile = I.MaxNumOfAFsInSecFile

FROM IdxSIDBSubStore SUB, IdxSIDBStore I WITH (READUNCOMMITTED)

WHERE SUB.SIDBStoreId = I.SIDBStoreId

AND SUB.MaxNumOfAFsInSecFile = 0

UPDATE IdxSIDBSubStore 

SET ClientId = 1 

WHERE ClientId = 0 AND SIDBStoreId > 0

-- Above we check if the SubStore has the value set instead of store having value 0.

-- Below we commented out resetting so that any DDB MA which is not upgraded will continue to work.

--UPDATE I

--SET MaxNumOfAFsInSecFile = 0

--FROM IdxSIDBStore I

--WHERE I.MaxNumOfAFsInSecFile > 0

