

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/IdxSIDBRecoveryHistory.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/IdxSIDBRecoveryHistory.script,v $ $Id: IdxSIDBRecoveryHistory.script,v 1.2.42.3 2020/10/28 23:43:06 chandru Exp $";
-- TABLENAME IdxSIDBRecoveryHistory

print '... inserting Table: IdxSIDBRecoveryHistory'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME IdxSIDBRecoveryHistory

BEGIN TRY

	BEGIN TRAN

	IF NOT EXISTS(SELECT 1 FROM    GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '0731B214-9A86-444E-AB70-984DC09916C5')

	BEGIN

		DECLARE @tblLib TABLE (LibId INT, sizeOnLibGB BIGINT)

		DECLARE @l_DefragJobStores	table (SIDBStoreId INT, lastFullReconJobId INT)

		DECLARE @l_currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())

		DECLARE @tblMP TABLE (MountPathId INT, MediaSideId BIGINT)
		INSERT INTO @tblMP


		SELECT DISTINCT CLOUD_MP.MountPathId, CLOUD_MP.MediaSideId

		FROM MMSDSStoragePool SDS WITH (READUNCOMMITTED)

			   INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON SDS.LibraryId = MP.LibraryId

			   INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId

			   INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEVC.DeviceId

			   INNER JOIN MMDeviceController DEVCLOUD WITH (READUNCOMMITTED) ON DEVC.ClientId = DEVCLOUD.ClientId

			   INNER JOIN MMDevice CLOUD_DEV WITH (READUNCOMMITTED) ON DEVCLOUD.DeviceId = CLOUD_DEV.DeviceId

			   INNER JOIN MMMountPathToStorageDevice CLOUD_MPSD WITH (READUNCOMMITTED) ON CLOUD_DEV.DeviceId = CLOUD_MPSD.DeviceId

			   INNER JOIN MMMountPath CLOUD_MP WITH (READUNCOMMITTED) ON CLOUD_MPSD.MountPathId = CLOUD_MP.MountPathId 

		WHERE DEVCLOUD.DeviceId <> MPSD.DeviceId

		AND CLOUD_DEV.DeviceTypeId >=  2 -- TYPE_SAN_MAGNETIC_REMOTE_HOST_START 2

		AND CLOUD_DEV.DeviceTypeId <=  1000 -- TYPE_SAN_MAGNETIC_REMOTE_HOST_END   1000

		AND CLOUD_MP.Attribute & 32 > 0 --MNTPTH_ATTRIB_ENABLE_CLOUD_PRUNING  

AND CLOUD_DEV.DeviceTypeId NOT IN (22, 28)

		-- Skip archive libraries

		IF OBJECT_ID('tempdb.dbo.#tmpArchNumDevType') is not null DROP TABLE #tmpArchNumDevType

		CREATE TABLE #tmpArchNumDevType(

			DeviceId        INTEGER,

			ArchiveNumber    INTEGER,

			DeviceTypeId    INTEGER,

			MountPathId        INTEGER

		)
		INSERT INTO #tmpArchNumDevType


		SELECT MDC.DeviceId,

			CASE WHEN MDC.UserName LIKE '%@%//%' THEN

				CAST(SUBSTRING(MDC.UserName, CHARINDEX('@', MDC.UserName, 0)+1, PATINDEX(N'%[^0-9]%',RIGHT(MDC.UserName, LEN(MDC.UserName) - CHARINDEX('@', MDC.UserName, 0)))-1) AS int)

			ELSE

				0

			END AS ArchiveNumber,

			MD.DeviceTypeId,

			MP.MountPathId

		FROM MMDeviceController MDC WITH (READUNCOMMITTED)

			INNER JOIN MMDevice MD WITH (READUNCOMMITTED) ON MD.DeviceId = MDC.DeviceId

			INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.DeviceId = MD.DeviceId

			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId

WHERE (MDC.UserName like '%@%//%'AND MD.DeviceTypeId in (23, 2, 3))

		DELETE T

		FROM @tblMP T WHERE 

		EXISTS 

		(

			SELECT 1 FROM #tmpArchNumDevType TMP WITH (READUNCOMMITTED)

			WHERE TMP.MountPathId = T.MountPathId AND

			(

(TMP.ArchiveNumber >= 8 AND TMP.DeviceTypeId = 23)

OR ((TMP.ArchiveNumber >= 8) AND TMP.DeviceTypeId = 2)

OR (TMP.ArchiveNumber >= 3 AND TMP.DeviceTypeId = 3)

			)

		)
		INSERT INTO @l_DefragJobStores


		SELECT	DISTINCT MV.SIDBStoreId, 0

		FROM	MMVolume MV WITH (READUNCOMMITTED)

				INNER JOIN @tblMP MP ON MV.MediaSideId = MP.MediaSideId

		UPDATE	S

		SET		S.lastFullReconJobId = (SELECT  ISNULL(MAX(AdminJobId), 0)

										FROM    IdxSIDBRecoveryHistory WITH (READUNCOMMITTED)

										WHERE   SIDBStoreId = S.SIDBStoreId

												AND (flags &  4 /*IDX_RECOVERY_HISTORY_DDB_FULL_RECON*/) > 0

												AND Status IN (1, 3, 14))

		FROM	@l_DefragJobStores S

		DELETE  ISRH

		FROM	IdxSIDBRecoveryHistory ISRH, @l_DefragJobStores S

		WHERE	ISRH.SIDBStoreId = S.SIDBStoreId

				AND ISRH.AdminJobId IN (0, 1)

				AND S.lastFullReconJobId = 0
		INSERT INTO IdxSIDBRecoveryHistory(SIDBStoreId, AdminJobId, CommCellId, StartTime, EndTime, InitFrom, Status, FailureReason, AllPrimaryEntries, AllSecondaryEntries, NewPrimaryEntries, NewSecondaryEntries, SubStoreId, flags)


		SELECT SS.SIDBStoreId, 1, 2, @l_currentTime, @l_currentTime, 4, 1, N'', 0, 0, 0, 0, MIN(SS.SubStoreId), 4 /*IDX_RECOVERY_HISTORY_DDB_FULL_RECON*/

		FROM	IdxSIDBSubStore SS WITH (READUNCOMMITTED), @l_DefragJobStores S

		WHERE   SS.SIDBStoreId = S.SIDBStoreId

				AND S.lastFullReconJobId = 0

		GROUP BY SS.SIDBStoreId

		UPDATE	H

		SET		H.flags = H.flags & ~8 /*IDX_RECOVERY_HISTORY_DDB_OCL_COMPLETED_ARTER_FULL_RECON*/

		FROM	IdxSIDBRecoveryHistory H WITH (READUNCOMMITTED), @l_DefragJobStores S

		WHERE   H.SIDBStoreId = S.SIDBStoreId

			AND H.AdminJobId = S.lastFullReconJobId

			AND (H.flags &  4 /*IDX_RECOVERY_HISTORY_DDB_FULL_RECON*/) > 0

			AND H.Status IN (1, 3, 14)

			AND S.lastFullReconJobId > 0

		--Allow defrag on cloud libraries

		IF NOT EXISTS (SELECT 1 from MMConfigs where (name = 'MMCONFIG_DV_ALLOW_DEFRAG_JOB_ON_CLOUD_LIBRARY'))

		BEGIN
			INSERT INTO MMConfigs(name, value, bExposeInGUI, nType, nMin, nMax, nConfigSubSystemId, fallBackValueName)


			VALUES('MMCONFIG_DV_ALLOW_DEFRAG_JOB_ON_CLOUD_LIBRARY', 1, 1, 1, 0, 1, 3, 'Allow to run Space Reclaimation jobs on cloud libraries.')

			IF NOT EXISTS(SELECT 1 FROM    GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '36A0BD98-94F8-4EA6-9D0E-57919F85DCDD')

			BEGIN
				INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


				VALUES('36A0BD98-94F8-4EA6-9D0E-57919F85DCDD', 'UpdateAllowDefragJobOnCloudLibrary', 'Update 1llow to run Space Reclaimation jobs on cloud libraries.', @l_currentTime, 16, 0, (16 + 2))

			END

		END

		ELSE

		BEGIN    

			IF NOT EXISTS(SELECT 1 FROM    GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = '36A0BD98-94F8-4EA6-9D0E-57919F85DCDD')

			BEGIN

				UPDATE MMConfigs

					SET value = 1,

					bExposeInGUI = 1,

					nType = 1,

					nMin = 0,

					nMax = 1,

					nConfigSubSystemId = 3,

					fallBackValueName = 'Allow to run Space Reclaimation jobs on cloud libraries.'

				WHERE name = 'MMCONFIG_DV_ALLOW_DEFRAG_JOB_ON_CLOUD_LIBRARY'
				INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


				VALUES('36A0BD98-94F8-4EA6-9D0E-57919F85DCDD', 'UpdateAllowDefragJobOnCloudLibrary', 'Update Allow to run Space Reclaimation jobs on cloud libraries.', @l_currentTime, 16, 0, (16 + 2))

			END

		END
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


		VALUES('0731B214-9A86-444E-AB70-984DC09916C5', 'UpdateToMarkStoresWritingToCloudLibraryUsingHSMAForOCL', 'Update to run Space Reclaimation job with OCL on cloud libraries with HyperScale MA.', @l_currentTime, 16, 0, (16 + 2))

	END

	COMMIT TRANSACTION;

END TRY

BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	-- Rollback any active or uncommittable transactions before

	-- inserting information in the ErrorLog

	IF XACT_STATE() <> 0

	BEGIN

		ROLLBACK TRANSACTION;

	END

	;THROW

END CATCH;
