

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/FixAPPTrivialConfigForAdvancedFirewall.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- Script : FixAPPTrivialConfigForAdvancedFirewall

-- Purpose : This script restores the 'Configure Network Route Settings' flag for all the clients that had 'Advanced' Network configuration selected and had their 'Configure Network Route Settings' flag reset.

-- Fix : Find all clients that have a row in APP_FirewallOptions but don't have their isTrivialConfig set to 2[Advanced] in APP_FWTrivialConfig table and update the isTrivialConfig column value with 2 for those rows only.

SET NOCOUNT ON

DECLARE @FixAPPTrivialConfigForAdvancedFirewall INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '81FAA520-657D-427D-90D7-B90D5EC47554'

SELECT @FixAPPTrivialConfigForAdvancedFirewall = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @FixAPPTrivialConfigForAdvancedFirewall = 0

BEGIN

UPDATE AFTC

SET isTrivialConfig = 2

FROM

APP_FWTrivialConfig AFTC INNER JOIN APP_FirewallOptions AFO

ON AFTC.clientId = AFO.clientId and AFTC.clientId <> 0

WHERE AFTC.isTrivialConfig <> 2
INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'FixAPPTrivialConfigForAdvancedFirewall','Fix APP_FWTrivialConfig entries for clients that have an entry in APP_FirewallOptions table but don''t have the correct value[2] in isTrivialConfig column of APP_FWTrivialConfig', DATEDIFF(second,'01/01/1970',CURRENT_TIMESTAMP) , 16, 0, (16 + 1))

END

SET NOCOUNT OFF
