

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/EvGuiAuditMessage.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/EvGuiAuditMessage.script,v $ $Id: EvGuiAuditMessage.script,v 1.1.2.3.26.1 2021/05/13 18:41:56 pankajkumar Exp $";
-- TABLENAME EvGuiAuditMessage

print '... inserting Table: EvGuiAuditMessage'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME EvGuiAuditMessage

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @nowTime	INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @auditGuid    VARCHAR(40)

SET @auditGuid =  'DF3157FA-D6B7-4A24-9547-F6BBD00187DF'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @auditGuid)

BEGIN

	PRINT  'Renaming Operation Window text to Blackout Window.'

	--	GUIAUDIT_OPS_ADD_OPERATION_WINDOW 1409286271

	--	GUIAUDIT_OPS_CHANGE_OPERATION_WINDOW 1409286272

	--	GUIAUDIT_OPS_DELETE_OPERATION_WINDOW 1409286273

	--	GUIAUDIT_OPS_DISABLE_OPERATION_WINDOW_RULES 1409286571

	--	GUIAUDIT_OPS_ENABLE_OPERATION_WINDOW_RULES 1409286572

	-- GUIAUDIT_PARAMS_JOBS_RUN_PAST_OPERATION 1426064774

	-- GUIAUDIT_PARAMS_OPERATION_RULE_NAME_CHANGED 1426064600

	-- GUIAUDIT_PARAMS_OPERATION_TIME_ADDED  1426064605

	-- GUIAUDIT_PARAMS_OPERATION_TIME_REMOVED 1426064606

	-- messageIdTable will contain the messageIds, which will be updated by the script.

	DECLARE @messageIdTable TABLE (

		messageId INT

	);
	INSERT INTO @messageIdTable (messageId) VALUES


		(1409286271), (1409286272), (1409286273), (1409286571), (1409286572),

		(1426064774), (1426064600), (1426064605), (1426064606)

	DECLARE @messageInfoTable TABLE (

		messageId INT,

		evMsgId INT,

		localeId INT,

		rawMessage NVARCHAR(MAX)

	);
	INSERT INTO @messageInfoTable (messageId, evMsgId, localeId, rawMessage)


	SELECT EvGAM.messageId, EvGAM.evMsgId, EvGAM.locId, LMgs.Message

	FROM EvGuiAuditMessage AS EvGAM

	INNER JOIN EvLocaleMsgs AS LMgs

		ON EvGAM.messageId = LMgs.MessageID AND EvGAM.locId = LMgs.LocaleID

	INNER JOIN @messageIdTable AS MIT

		ON  EvGAM.messageId  = MIT.messageId

	UPDATE T

	SET T.rawMessage = REPLACE(T.rawMessage, '^1%s', evParam.data)

	FROM @messageInfoTable T

	INNER JOIN evParam

		ON evParam.evMsgId = T.evMsgId

	WHERE evParam.position = 1

	UPDATE T

	SET T.rawMessage = REPLACE(T.rawMessage, '^2%s', evParam.data)

	FROM @messageInfoTable T

	INNER JOIN evParam

		ON evParam.evMsgId = T.evMsgId

	WHERE evParam.position = 2

	UPDATE EvGAM

	SET EvGAM.messageText = MIT.rawMessage

	FROM EvGuiAuditMessage AS EvGAM

	INNER JOIN @messageInfoTable AS MIT

		ON EvGAM.messageId = MIT.messageId AND EvGAM.locId = MIT.localeId AND EvGAM.evMsgId = MIT.evMsgId

	PRINT  'Completed: Renaming Operation Window text to Blackout Window.'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@auditGuid, 'RenamingOperationWindowToBlackout Window', 'Renaming Operation Window text to Blackout Window', @nowTime,  16, 0, (16 + 2))

END

DECLARE @delBloatedAuditGuid    VARCHAR(40)

SET @delBloatedAuditGuid =  '70A70F5F-DE50-4837-AA52-B2B0CEAF65AF'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @delBloatedAuditGuid)

BEGIN

	--GUIAUDIT_DM2_RESTORE_PROCESS     1409286451		 Download process from the end user compliance page.

	-- GUIAUDIT_PARAMS_DM2_ARCHIVED_RESTORE 1426064016   PST restore performed by User [] with total items : [100]

	DECLARE @maxAuditPruneInBatch  INTEGER =10000

	DECLARE @errVal INTEGER = 0

    DECLARE @rowCnt INTEGER = 0	

    SELECT @maxAuditPruneInBatch = ISNULL(value, 10000) 

    FROM GXGlobalParam

    WHERE name = 'DM2_AUDIT_PRUNE_IN_BATCH'

	WHILE (1 = 1)

    BEGIN 

        DELETE TOP (@maxAuditPruneInBatch) 

		FROM EvGuiAuditMessage

        WHERE opid in (

		SELECT DISTINCT  opid FROM EvGuiAuditMessage (NOLOCK)  where messageId = 1426064016 AND messageText like '%100%')

        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT

        IF @errVal != 0 OR @rowCnt = 0

            BREAK                

    END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@delBloatedAuditGuid, 'Delete unwanted Audit rows', 'Delete unwanted Audit rows', @nowTime,  16, 0, (16 + 2))

END

