

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/DeleteDuplicateCreatorsForClients.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/********************************************************************************/

/* MR: 265175                                                                   */

/* This script is created to delete duplicate creators for clients.             */

/* Duplicate creators will be removed from UMSecurityAssociations table.        */  

/* script: DeleteDuplicateCreatorForClients.sp                                  */

/********************************************************************************/

/*

1. If a client has multiple creators and one of them is master group then keep it and delete others from UMSecurityAssociations table.

2. If a client has multiple creators and none of them is master group then keep first owner entry and delete all others.

*/

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

BEGIN

	BEGIN TRY	

		-- get distinct userOrGroupId, userId, entityId and ownersCount(sequential number for distinct owners of each entity)

		IF OBJECT_ID('tempdb.dbo.#clientCreators') IS NOT NULL 

		DROP TABLE #clientCreators

		CREATE TABLE #clientCreators ( userOrGroupId INT, isUser INT, clientId INT, ownersCount int)

		-- clientIds which have master group as owner, ownersCount is row number with distinct owners for given client grp

		IF OBJECT_ID('tempdb.dbo.#clientsWithMaster') IS NOT NULL 

		DROP TABLE #clientsWithMaster

		CREATE TABLE #clientsWithMaster(clientId INT, ownersCount INT)

		DECLARE @masterGroupId INT = dbo.getMasterGroupId()
		INSERT INTO #clientCreators (userOrGroupId, isUser, clientId, ownersCount)	 


		SELECT sec.userOrGroupId, sec.isuser,  sec.entityid1, 

			  ROW_NUMBER() OVER(

						PARTITION BY

						sec.entityid1

						ORDER BY

						sec.entityid1

			) row_num  

			FROM 

			(

				SELECT DISTINCT entityID1, userOrGroupId, isUser 

				FROM UMSecurityAssociations

WHERE entityType1 = 3 AND isCreator = 1

			) sec 

		-- remove clients for which only 1 creator is present

		DELETE FROM #clientCreators WHERE clientId IN (SELECT clientId FROM #clientCreators GROUP BY clientId HAVING max(ownersCount) = 1)

		-- Execute the script only if duplicate creators are present

		IF EXISTS(SELECT TOP(1) 1 FROM #clientCreators)

		BEGIN
			INSERT INTO #clientsWithMaster (clientId, ownersCount)


			SELECT cg.clientId, cg.ownersCount FROM #clientCreators cg WHERE cg.userOrGroupId = @masterGroupId AND cg.isUser = 0

			-- If master group is one of the owners then keep it and delete all other owners

			IF EXISTS (SELECT TOP(1) 1 FROM #clientsWithMaster)

			BEGIN

				DELETE sec FROM UMSecurityAssociations sec 

				INNER JOIN #clientCreators CG 

ON CG.userOrGroupId = sec.userOrGroupId AND CG.isUser = sec.isUser AND CG.clientId = sec.entityId1 AND sec.isCreator = 1 AND sec.entityType1 = 3

				INNER JOIN #clientsWithMaster CM

					ON CG.clientId = CM.clientId AND CG.ownersCount <> CM.ownersCount

				-- remove clients with master user group owner from #clientCreators

				DELETE CG FROM #clientCreators CG 

				INNER JOIN #clientsWithMaster CM 

					ON CG.clientId = CM.clientId

			END

			-- Delete other duplicate creators AND keep first creator as owner. (when none of the owners is master user group)

			IF EXISTS (SELECT TOP(1) 1 FROM #clientCreators)

			BEGIN

				DELETE sec FROM UMSecurityAssociations sec INNER JOIN #clientCreators CG

				ON CG.userOrGroupId = sec.userOrGroupId AND CG.isUser = sec.isUser AND CG.clientId = sec.entityId1  

AND sec.isCreator = 1 AND sec.entityType1 = 3 AND CG.ownersCount > 1

			END

		END

	END TRY	

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), 'DeleteDuplicateCreatorForClients') + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH	

END

SET NOCOUNT OFF

SET QUOTED_IDENTIFIER OFF
