

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/DeleteDuplicateCreatorsForCG.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/********************************************************************************/

/* MR: 265175                                                                   */

/* This script is created to delete duplicate creators for client groups.       */

/* Duplicate creators will be removed from UMSecurityAssociations table.        */

/* Duplicate CG creator entry was causing failure during installation for this  */

/* script: sec_upgradeClientGroupPermissions.sp                                 */

/********************************************************************************/

SET NOCOUNT ON

BEGIN

	BEGIN TRY	

		-- get distinct userOrGroupId, userId, entityId and ownersCount(sequential number for distinct owners of each entity)

		IF OBJECT_ID('tempdb.dbo.#clientGroupCreators') IS NOT NULL 

		DROP TABLE #clientGroupCreators

		CREATE TABLE #clientGroupCreators ( userOrGroupId INT, isUser INT, clientGroupId INT, ownersCount int)

		-- clientGroupIds which have master group as owner, ownersCount is row number with distinct owners for given client grp

		IF OBJECT_ID('tempdb.dbo.#cGWithMaster') IS NOT NULL 

		DROP TABLE #cGWithMaster

		CREATE TABLE #cGWithMaster(clientGroupId INT, ownersCount INT)

		DECLARE @masterGroupId INT = dbo.getMasterGroupId()
		INSERT INTO #clientGroupCreators (userOrGroupId, isUser, clientGroupId, ownersCount)	 


		SELECT sec.userOrGroupId, sec.isuser,  sec.entityid1, 

			  ROW_NUMBER() OVER(

						PARTITION BY

						sec.entityid1

						ORDER BY

						sec.entityid1

			) row_num  

			FROM 

			(

				SELECT DISTINCT entityID1, userOrGroupId, isUser 

				FROM UMSecurityAssociations

WHERE entityType1 = 28 AND isCreator = 1

			) sec 

		-- remove client groups for which only 1 creator is present

		DELETE FROM #clientGroupCreators WHERE clientGroupId IN (SELECT clientGroupId FROM #clientGroupCreators GROUP BY clientGroupId HAVING max(ownersCount) = 1)

		-- Execute the script only if duplicate creators are present

		IF EXISTS(SELECT TOP(1) 1 FROM #clientGroupCreators)

		BEGIN
			INSERT INTO #cGWithMaster (clientGroupId, ownersCount)


			SELECT cg.clientGroupId, cg.ownersCount FROM #clientGroupCreators cg WHERE cg.userOrGroupId = @masterGroupId AND cg.isUser = 0

			-- If master group is one of the owners then keep it and delete all other owners

			IF EXISTS (SELECT TOP(1) 1 FROM #cGWithMaster)

			BEGIN

				DELETE sec FROM UMSecurityAssociations sec 

				INNER JOIN #clientGroupCreators CG 

ON CG.userOrGroupId = sec.userOrGroupId AND CG.isUser = sec.isUser AND CG.clientGroupId = sec.entityId1 AND sec.isCreator = 1 AND sec.entityType1 = 28

				INNER JOIN #cGWithMaster CM

					ON CG.clientGroupId = CM.clientGroupId AND CG.ownersCount <> CM.ownersCount

				-- remove client groups with master user group owner from #clientGroupCreators

				DELETE CG FROM #clientGroupCreators CG 

				INNER JOIN #cGWithMaster CM 

					ON CG.clientGroupId = CM.clientGroupId

			END

			-- Delete other duplicate creators AND keep first creator as owner. (when none of the owners is master user group)

			IF EXISTS (SELECT TOP(1) 1 FROM #clientGroupCreators)

			BEGIN

				DELETE sec FROM UMSecurityAssociations sec INNER JOIN #clientGroupCreators CG

				ON CG.userOrGroupId = sec.userOrGroupId AND CG.isUser = sec.isUser AND CG.clientGroupId = sec.entityId1  

AND sec.isCreator = 1 AND sec.entityType1 = 28 AND CG.ownersCount > 1

			END

		END

	END TRY	

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), 'DeleteDuplicateCreatorsForCG') + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH	

END
