

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/DM2Container.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

DECLARE @usrId INT = ISNULL((SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 = 0x040 AND Name <> 'ROMS'), 1)

IF NOT EXISTS (SELECT * FROM DM2Container WHERE (containerName = 'CommonTags'))

BEGIN
	INSERT INTO		DM2Container


		(containerGuid ,

        containerName ,

        containerType ,

        userId ,

        attribute ,

        comment ,

        origCommcellID,

		createTime)

	VALUES 

		(NEWID(), 

		'CommonTags', 

		9504, 

		@usrId, 

		0,

		'System default tag set',

		2,

		GETUTCDATE())

	--Insert association to CommonTags tag set for all users with EDIT and VISIBILITY capapbility
	INSERT INTO UMUserandGroupEntityAssociation(userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId)


	SELECT 0,groupId,0, CONVERT(bigint, POWER(2.0, 34 - 1)) | CONVERT(bigint, POWER(2.0, 31 - 1)),9504,@@IDENTITY,@usrId

	FROM UMGroupCapability 

	WHERE capabilityId = 25

END	

DECLARE @TagSetId INT = 0

SELECT @TagSetId = ContainerId FROM DM2Container WHERE containerName = 'CommonTags' AND ContainerType = 9504 AND UserId = @usrId

IF @TagSetId IS NOT NULL AND @TagSetId > 0

BEGIN

	UPDATE DM2Container SET Attribute = Attribute | 2 WHERE containerId = @TagSetId AND Attribute & 2 = 0

END

IF NOT EXISTS (SELECT * FROM DM2Container WHERE (containerName = 'DiscoveryEntity'))

BEGIN	
	INSERT INTO		DM2Container


		(containerGuid ,

        containerName ,

        containerType ,

        userId ,

        attribute ,

        comment ,

        origCommcellID,

		createTime)

	VALUES 

		(NEWID(), 

		'DiscoveryEntity', 

		9504, 

		@usrId, 

		0,

		'Discovery Entity Tag Set',

		2,

		GETUTCDATE())

END

SET @TagSetId = 0

SELECT @TagSetId = ContainerId FROM DM2Container WHERE containerName = 'DiscoveryEntity' AND ContainerType = 9504 AND UserId = @usrId

IF @TagSetId IS NOT NULL AND @TagSetId > 0

BEGIN

	UPDATE DM2Container SET Attribute = Attribute | 2 WHERE containerId = @TagSetId AND Attribute & 2 = 0

END

IF NOT EXISTS (SELECT * FROM DM2Container WHERE (containerName = 'PersonalRecords'))

BEGIN		
	INSERT INTO		DM2Container


		(containerGuid ,

        containerName ,

        containerType ,

        userId ,

        attribute ,

        comment ,

        origCommcellID,

		createTime)

	VALUES 

		(NEWID(), 

		'PersonalRecords', 

		9504, 

		@usrId, 

		0,

		'Personal Records Tag Set',

		2,

		GETUTCDATE())

END

SET @TagSetId = 0

SELECT @TagSetId = ContainerId FROM DM2Container WHERE containerName = 'PersonalRecords' AND ContainerType = 9504 AND UserId = @usrId

IF @TagSetId IS NOT NULL AND @TagSetId > 0

BEGIN

	UPDATE DM2Container SET Attribute = Attribute | 2 WHERE containerId = @TagSetId AND Attribute & 2 = 0

END

IF NOT EXISTS (SELECT * FROM DM2Container WHERE (containerName = 'HealthSafetyRecords'))

BEGIN		
	INSERT INTO		DM2Container


		(containerGuid ,

        containerName ,

        containerType ,

        userId ,

        attribute ,

        comment ,

        origCommcellID,

		createTime)

	VALUES 

		(NEWID(), 

		'HealthSafetyRecords', 

		9504, 

		@usrId, 

		0,

		'Health & Safety Records Tag Set',

		2,

		GETUTCDATE())

END

SET @TagSetId = 0

SELECT @TagSetId = ContainerId FROM DM2Container WHERE containerName = 'HealthSafetyRecords' AND ContainerType = 9504 AND UserId = @usrId

IF @TagSetId IS NOT NULL AND @TagSetId > 0

BEGIN

	UPDATE DM2Container SET Attribute = Attribute | 2 WHERE containerId = @TagSetId AND Attribute & 2 = 0

END

IF NOT EXISTS(SELECT * FROM DM2Container WHERE containerName='WebReports Tag')

BEGIN
	INSERT INTO DM2Container


		(containerGuid,

		containerName,

		containerType,

		userId,

		attribute,

		comment,

		origCommcellID,

		createTime) 

	VALUES

		(NEWID(),

		'WebReports Tag',

		0,

		@usrId,

		0,

		'Tags Set for WebReports page',

		0,

		GETUTCDATE())

END		

IF NOT EXISTS(SELECT * FROM DM2Container WHERE containerName='Workflow Tag')

BEGIN
	INSERT INTO DM2Container


		(containerGuid,

		containerName,

		containerType,

		userId,

		attribute,

		comment,

		origCommcellID,

		createTime) 

	VALUES

		(NEWID(),

		'Workflow Tag',

		0,

		@usrId,

		0,

		'Tags Set for Workflows page',

		0,

		GETUTCDATE())

END	

IF NOT EXISTS(SELECT * FROM DM2Container WHERE containerName='Indexing Tags')

BEGIN
    INSERT INTO DM2Container


        (containerGuid,

        containerName,

        containerType,

        userId,

        attribute,

        comment,

        origCommcellID,

        createTime) 

    VALUES

        (NEWID(),

        'Indexing Tags',

        0,

        @usrId,

        0,

        'Tags set for Indexing',

        0,

        GETUTCDATE())

END     

DECLARE @DISABLE_CONTENT_SEARCH int = 1

-- Mark old version reviewsets

--

DECLARE @upgradeFromRel INT = 0

SELECT @upgradeFromRel = status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'

IF (@upgradeFromRel IN (14, 15))

BEGIN

	UPDATE DM2Container SET attribute = @DISABLE_CONTENT_SEARCH WHERE containerType = 9501 AND CloudId = 0

END

-- We are not going to index content for any my reviewset so that export or legal hold jobs can run faster

IF EXISTS (SELECT TOP 1 containerId FROM DM2Container WHERE containerType = 9501 AND ContainerName = 'My ReviewSet' AND Attribute & @DISABLE_CONTENT_SEARCH = 0)

BEGIN

	UPDATE DM2Container SET Attribute = Attribute | @DISABLE_CONTENT_SEARCH 

	WHERE containerType = 9501 AND ContainerName = 'My ReviewSet' AND Attribute & @DISABLE_CONTENT_SEARCH = 0

END

--Insert custom entity if not exists.

--

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= '22CD8879-B2FD-4A63-8096-B515FC13502D')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

'22CD8879-B2FD-4A63-8096-B515FC13502D','Custom Entity', 9517,

		1,0, 'Custom Entity',

		0, GETUTCDATE())

END

-- Insert default category types if not exists

--

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= '4518B100-7D9C-4AD2-8589-96234A8DD585')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

		'4518B100-7D9C-4AD2-8589-96234A8DD585','Personal', 9520, -- EntityCategoryTypesForEE in DM2EntityType (DM2ContentContentIndexing.x)

		1,0, 'Personal',

		0, GETUTCDATE())

END

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= '695A312D-EB95-459C-99B8-FFD719E45B90')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

		'695A312D-EB95-459C-99B8-FFD719E45B90','Financial', 9520, -- EntityCategoryTypesForEE in DM2EntityType (DM2ContentContentIndexing.x)

		1,0, 'Financial',

		0, GETUTCDATE())

END

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= '5BE549B4-73F6-4BDE-A630-18EFF3B8FF85')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

		'5BE549B4-73F6-4BDE-A630-18EFF3B8FF85','Healthcare', 9520, -- EntityCategoryTypesForEE in DM2EntityType (DM2ContentContentIndexing.x)

		1,0, 'Healthcare',

		0, GETUTCDATE())

END

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= 'E0F5B079-527C-44B4-96D2-5098934FC777')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

		'E0F5B079-527C-44B4-96D2-5098934FC777','Global', 9520, -- EntityCategoryTypesForEE in DM2EntityType (DM2ContentContentIndexing.x)

		1,0, 'Global',

		0, GETUTCDATE())

END

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

		'C99E55EF-5875-425C-98A9-8DF5F5F0DF27','Classifiers', 9520, -- EntityCategoryTypesForEE in DM2EntityType (DM2ContentContentIndexing.x)

		1,0, 'Classifiers',

		0, GETUTCDATE())

END

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid= 'B05D1D67-FCE2-493B-A7F4-5400938EAF70')

BEGIN
    INSERT INTO DM2Container (


			containerGuid, containerName, containerType,

			 userId, attribute, comment, 

			 origCommcellID, createTime) 

    VALUES (

		'B05D1D67-FCE2-493B-A7F4-5400938EAF70','Custom', 9520, -- EntityCategoryTypesForEE in DM2EntityType (DM2ContentContentIndexing.x)

		1,0, 'Custom',

		0, GETUTCDATE())

END

-- Category parent child relationship

-- 

-- x_containerDesc and x_entityDesc are description in DM2Container and Dm2DocTags. If it needs be changed, then change it here 

--

--#def to clean up dm2container and dm2doc for containertype = 9516 , which are created with random guid.

-- which ever matches input x_containerName  but doesnt match x_containerGuid of type 9516

--

SET QUOTED_IDENTIFIER ON

GO

	--clean up dm2container and dm2doctags and repopulate fresh with explicit TagId and ContainerGuid

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'Personal' AND containerType = 9516 AND containerGuid != '26081960-61FD-4311-A7EA-A7285C3924C9' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'Personal' AND containerType = 9516 AND containerGuid != '26081960-61FD-4311-A7EA-A7285C3924C9') 
		DELETE DM2Container WHERE containername = 'Personal' AND containerType = 9516 AND containerGuid != '26081960-61FD-4311-A7EA-A7285C3924C9' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'Financial' AND containerType = 9516 AND containerGuid != '91777916-8F19-4EC3-B54E-901843D8B604' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'Financial' AND containerType = 9516 AND containerGuid != '91777916-8F19-4EC3-B54E-901843D8B604') 
		DELETE DM2Container WHERE containername = 'Financial' AND containerType = 9516 AND containerGuid != '91777916-8F19-4EC3-B54E-901843D8B604' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'Global' AND containerType = 9516 AND containerGuid != '9169EF3C-22E6-4C48-8732-6CAA0A7F779B' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'Global' AND containerType = 9516 AND containerGuid != '9169EF3C-22E6-4C48-8732-6CAA0A7F779B') 
		DELETE DM2Container WHERE containername = 'Global' AND containerType = 9516 AND containerGuid != '9169EF3C-22E6-4C48-8732-6CAA0A7F779B' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'Finland' AND containerType = 9516 AND containerGuid != 'C6417D18-D6D4-4DCC-AC4B-318093D8285B' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'Finland' AND containerType = 9516 AND containerGuid != 'C6417D18-D6D4-4DCC-AC4B-318093D8285B') 
		DELETE DM2Container WHERE containername = 'Finland' AND containerType = 9516 AND containerGuid != 'C6417D18-D6D4-4DCC-AC4B-318093D8285B' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'France' AND containerType = 9516 AND containerGuid != '9BABF459-AF92-48C4-B1B7-584C52BA6721' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'France' AND containerType = 9516 AND containerGuid != '9BABF459-AF92-48C4-B1B7-584C52BA6721') 
		DELETE DM2Container WHERE containername = 'France' AND containerType = 9516 AND containerGuid != '9BABF459-AF92-48C4-B1B7-584C52BA6721' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'Greece' AND containerType = 9516 AND containerGuid != 'DFEE2E47-A154-4708-895A-76E27F4A8A2F' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'Greece' AND containerType = 9516 AND containerGuid != 'DFEE2E47-A154-4708-895A-76E27F4A8A2F') 
		DELETE DM2Container WHERE containername = 'Greece' AND containerType = 9516 AND containerGuid != 'DFEE2E47-A154-4708-895A-76E27F4A8A2F' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'Germany' AND containerType = 9516 AND containerGuid != 'F67BC27B-0A31-418D-8CB9-1420BFF99B82' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'Germany' AND containerType = 9516 AND containerGuid != 'F67BC27B-0A31-418D-8CB9-1420BFF99B82') 
		DELETE DM2Container WHERE containername = 'Germany' AND containerType = 9516 AND containerGuid != 'F67BC27B-0A31-418D-8CB9-1420BFF99B82' 
	END

IF EXISTS (SELECT 1 FROM DM2Container WHERE containername = 'UK' AND containerType = 9516 AND containerGuid != '2F6752AB-4EEA-428A-A462-9A10548E3FEE' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containername = 'UK' AND containerType = 9516 AND containerGuid != '2F6752AB-4EEA-428A-A462-9A10548E3FEE') 
		DELETE DM2Container WHERE containername = 'UK' AND containerType = 9516 AND containerGuid != '2F6752AB-4EEA-428A-A462-9A10548E3FEE' 
	END

	--delete previous categories and tags

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '26081960-61FD-4311-A7EA-A7285C3924C9' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '26081960-61FD-4311-A7EA-A7285C3924C9') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '26081960-61FD-4311-A7EA-A7285C3924C9' 
	END -- Personal

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '91777916-8F19-4EC3-B54E-901843D8B604' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '91777916-8F19-4EC3-B54E-901843D8B604') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '91777916-8F19-4EC3-B54E-901843D8B604' 
	END -- Financial

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '9169EF3C-22E6-4C48-8732-6CAA0A7F779B' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '9169EF3C-22E6-4C48-8732-6CAA0A7F779B') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '9169EF3C-22E6-4C48-8732-6CAA0A7F779B' 
	END -- Global

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'DB175D68-3B3D-4C2E-A5DC-ED5C0AFD2456' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'DB175D68-3B3D-4C2E-A5DC-ED5C0AFD2456') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'DB175D68-3B3D-4C2E-A5DC-ED5C0AFD2456' 
	END -- Medical

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'BC6F937C-A440-4752-826E-6FB2185353A5' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'BC6F937C-A440-4752-826E-6FB2185353A5') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'BC6F937C-A440-4752-826E-6FB2185353A5' 
	END -- Australia

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '375339FC-5BFB-4133-9A82-888061A7BE64' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '375339FC-5BFB-4133-9A82-888061A7BE64') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '375339FC-5BFB-4133-9A82-888061A7BE64' 
	END -- Austria

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'E7D76FF2-024A-43F3-A39E-2FF7F5B5B76B' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'E7D76FF2-024A-43F3-A39E-2FF7F5B5B76B') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'E7D76FF2-024A-43F3-A39E-2FF7F5B5B76B' 
	END -- Canada

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'AEE19A88-4812-425C-BAB2-6A06E3F1F074' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'AEE19A88-4812-425C-BAB2-6A06E3F1F074') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'AEE19A88-4812-425C-BAB2-6A06E3F1F074' 
	END -- Danish

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'F354D641-5855-40A2-AFCC-4D237CA0F607' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'F354D641-5855-40A2-AFCC-4D237CA0F607') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'F354D641-5855-40A2-AFCC-4D237CA0F607' 
	END -- Dutch

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'C6417D18-D6D4-4DCC-AC4B-318093D8285B' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'C6417D18-D6D4-4DCC-AC4B-318093D8285B') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'C6417D18-D6D4-4DCC-AC4B-318093D8285B' 
	END -- Finland

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '9BABF459-AF92-48C4-B1B7-584C52BA6721' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '9BABF459-AF92-48C4-B1B7-584C52BA6721') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '9BABF459-AF92-48C4-B1B7-584C52BA6721' 
	END -- France

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'DFEE2E47-A154-4708-895A-76E27F4A8A2F' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'DFEE2E47-A154-4708-895A-76E27F4A8A2F') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'DFEE2E47-A154-4708-895A-76E27F4A8A2F' 
	END -- Greece

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'F67BC27B-0A31-418D-8CB9-1420BFF99B82' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'F67BC27B-0A31-418D-8CB9-1420BFF99B82') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'F67BC27B-0A31-418D-8CB9-1420BFF99B82' 
	END -- Germany

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'F89800F0-D370-4D2F-9BC9-8E36C96D3A9D' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'F89800F0-D370-4D2F-9BC9-8E36C96D3A9D') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'F89800F0-D370-4D2F-9BC9-8E36C96D3A9D' 
	END -- Hungary

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '74CD3396-5456-492A-8E40-3A926310FB28' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '74CD3396-5456-492A-8E40-3A926310FB28') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '74CD3396-5456-492A-8E40-3A926310FB28' 
	END -- Ireland

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '5A789F92-C58E-45CB-9093-B8CE5A767595' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '5A789F92-C58E-45CB-9093-B8CE5A767595') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '5A789F92-C58E-45CB-9093-B8CE5A767595' 
	END -- Italy

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '37A49936-3120-48F6-99B2-F36753966A0C' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '37A49936-3120-48F6-99B2-F36753966A0C') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '37A49936-3120-48F6-99B2-F36753966A0C' 
	END -- Sweden

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '2F6752AB-4EEA-428A-A462-9A10548E3FEE' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '2F6752AB-4EEA-428A-A462-9A10548E3FEE') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '2F6752AB-4EEA-428A-A462-9A10548E3FEE' 
	END -- UK

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'D5B7768D-6A6F-40F9-B386-8C3CEE084DC9' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'D5B7768D-6A6F-40F9-B386-8C3CEE084DC9') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'D5B7768D-6A6F-40F9-B386-8C3CEE084DC9' 
	END -- US

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'BA42DE95-6D02-4340-BDB8-517EE6C96110' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = 'BA42DE95-6D02-4340-BDB8-517EE6C96110') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = 'BA42DE95-6D02-4340-BDB8-517EE6C96110' 
	END -- Poland

IF EXISTS (SELECT 1 FROM DM2Container WHERE containerType = 9516 AND containerGuid = '6AB8CEEA-D9BA-419D-A7A2-B8C0DC0DDB4E' ) 
	BEGIN 
		DELETE DM2DocTags WHERE ContainerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType = 9516 AND containerGuid = '6AB8CEEA-D9BA-419D-A7A2-B8C0DC0DDB4E') 
		DELETE DM2Container WHERE containerType = 9516 AND containerGuid = '6AB8CEEA-D9BA-419D-A7A2-B8C0DC0DDB4E' 
	END -- Generic (HealthCare)

	-- delete container tag mapping

IF EXISTS(SELECT 1 FROM DM2DocTags WHERE ContainerGuid='5BE549B4-73F6-4BDE-A630-18EFF3B8FF85' and TagID = 'EEB46521-AA51-4326-9268-8F061BD7CD46')  
	BEGIN  
		DELETE DM2DocTags WHERE containerGuid = '5BE549B4-73F6-4BDE-A630-18EFF3B8FF85' AND TagID = 'EEB46521-AA51-4326-9268-8F061BD7CD46'  
	END -- healthcare --> Generic

	DECLARE @l_containerGuid VARCHAR(36) = ''	

	--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

	---------------------------------------------------------------- Custom Entity Container ---------------------------------------------------------------------------------

	SELECT @l_containerGuid = '22CD8879-B2FD-4A63-8096-B515FC13502D'

	MERGE DM2DocTags DT

	USING (SELECT EntityID, Name FROM EntityAnnotator WHERE Attribute is Null) EA

ON CAST(EA.EntityID as nvarchar(512)) = DT.TagValue AND DT.containerGuid IN (SELECT containerGuid FROM DM2Container WHERE containerType=9517)

	WHEN NOT MATCHED THEN	

	INSERT (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute)

	values(NEWID(), @l_containerGuid, EA.EntityID, EA.Name ,1, 'Custom', 0)

	WHEN MATCHED THEN

	UPDATE SET DT.TagDesc = EA.Name;

	DECLARE @parentCategoryGuid VARCHAR(36) = ''

	DECLARE @categoryName VARCHAR(256) = ''

	--------------------------------------------------------------------------------------------------------------------------------------

	------------------------------------------------------ New Category Hierarchy ----------------------------------------------------------------

	---------------------------------------------------------------- Personal Category Type --------------------------------------------------------------------------------------

	-- parent child category hierarchy

	-- Personal parent category	

	SELECT @parentCategoryGuid = '4518B100-7D9C-4AD2-8589-96234A8DD585'

	-- Generic category

	SELECT @categoryName = 'Generic'

	SELECT @l_containerGuid = '81DBC230-2262-4073-8C7C-44CBF1E8E2E5'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '3ECD1D60-9AAC-4455-B7BB-9F5E0DEF32C1') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '3ECD1D60-9AAC-4455-B7BB-9F5E0DEF32C1', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Address'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '796D2F7A-AAAF-407E-975A-2DA516992077') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '796D2F7A-AAAF-407E-975A-2DA516992077', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Address', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='82FA329C-2148-4F52-8C46-1736437F9129' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '796D2F7A-AAAF-407E-975A-2DA516992077' AND TagDesc != 'Address') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Address' WHERE containerGuid = @l_containerGuid AND TagId = '796D2F7A-AAAF-407E-975A-2DA516992077' 
	END

	-- 'Date of Birth'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '5E55E39A-1453-47B7-A0D3-FFED5BBBA0E4') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '5E55E39A-1453-47B7-A0D3-FFED5BBBA0E4', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Date of Birth', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='D28E5106-2053-4341-8EB9-921763527778' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '5E55E39A-1453-47B7-A0D3-FFED5BBBA0E4' AND TagDesc != 'Date of Birth') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Date of Birth' WHERE containerGuid = @l_containerGuid AND TagId = '5E55E39A-1453-47B7-A0D3-FFED5BBBA0E4' 
	END

	-- 'Email'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'B5EE9119-4DB8-428D-A938-2F6EEF6ACEFF') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'B5EE9119-4DB8-428D-A938-2F6EEF6ACEFF', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Email', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='DCCB4D84-EA03-49F3-91D7-0D9A6C97BA6E' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'B5EE9119-4DB8-428D-A938-2F6EEF6ACEFF' AND TagDesc != 'Email') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Email' WHERE containerGuid = @l_containerGuid AND TagId = 'B5EE9119-4DB8-428D-A938-2F6EEF6ACEFF' 
	END

	-- 'Location'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '0FD5B4F7-DFD6-4526-BDF3-1B3D5A59F61D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '0FD5B4F7-DFD6-4526-BDF3-1B3D5A59F61D', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Location (Country)', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='208A08A4-8DB8-429B-A029-1847D11B9BEE' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '0FD5B4F7-DFD6-4526-BDF3-1B3D5A59F61D' AND TagDesc != 'Location (Country)') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Location (Country)' WHERE containerGuid = @l_containerGuid AND TagId = '0FD5B4F7-DFD6-4526-BDF3-1B3D5A59F61D' 
	END

	-- 'Person'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '07DEF83E-2807-4053-815F-0F055B063C92') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '07DEF83E-2807-4053-815F-0F055B063C92', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Person Name', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='EE2B7A69-71F2-4777-B3EA-C9D676B2AEF0' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '07DEF83E-2807-4053-815F-0F055B063C92' AND TagDesc != 'Person Name') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Person Name' WHERE containerGuid = @l_containerGuid AND TagId = '07DEF83E-2807-4053-815F-0F055B063C92' 
	END

	-- 'Phone Number'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'D8B52237-A1DE-4223-80CB-E65275A33C83') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'D8B52237-A1DE-4223-80CB-E65275A33C83', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Phone', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='F1668A2E-FC5A-49B9-9A3A-EAD2E53C7366' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'D8B52237-A1DE-4223-80CB-E65275A33C83' AND TagDesc != 'Phone') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Phone' WHERE containerGuid = @l_containerGuid AND TagId = 'D8B52237-A1DE-4223-80CB-E65275A33C83' 
	END

	-- Australia category

	SELECT @categoryName = 'Australia'

	SELECT @l_containerGuid = '5F530B23-53AC-4374-BABD-2A8C94759144'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '0C123B50-D0D0-4280-B4A6-AD35E720EE1D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '0C123B50-D0D0-4280-B4A6-AD35E720EE1D', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Australia Driver License'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'AB27B050-1E06-4B37-91E8-1867CEB58075') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'AB27B050-1E06-4B37-91E8-1867CEB58075', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Australian Driver License', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='A80587EB-048B-48D8-8CDA-7C920C358CAB' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'AB27B050-1E06-4B37-91E8-1867CEB58075' AND TagDesc != 'Australian Driver License') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Australian Driver License' WHERE containerGuid = @l_containerGuid AND TagId = 'AB27B050-1E06-4B37-91E8-1867CEB58075' 
	END

	-- 'Australia Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'EDB24061-C85C-4853-AECB-1D6583FA74DB') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'EDB24061-C85C-4853-AECB-1D6583FA74DB', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Australian Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='A3FEC574-FF21-4225-8980-E5A95642BE35' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'EDB24061-C85C-4853-AECB-1D6583FA74DB' AND TagDesc != 'Australian Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Australian Passport' WHERE containerGuid = @l_containerGuid AND TagId = 'EDB24061-C85C-4853-AECB-1D6583FA74DB' 
	END

	-- Austria category

	SELECT @categoryName = 'Austria'

	SELECT @l_containerGuid = '7790B2B1-E80A-41A7-8B46-612E6CA573C0'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '2F745F51-ABAB-4223-841F-0C12F877062E') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '2F745F51-ABAB-4223-841F-0C12F877062E', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Austria Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '5A28114B-38AB-4EDF-AAB6-ED66D43C34CD') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '5A28114B-38AB-4EDF-AAB6-ED66D43C34CD', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Austrian Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='EB678521-8F67-4473-B8D2-C03FB6E331BC' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '5A28114B-38AB-4EDF-AAB6-ED66D43C34CD' AND TagDesc != 'Austrian Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Austrian Passport' WHERE containerGuid = @l_containerGuid AND TagId = '5A28114B-38AB-4EDF-AAB6-ED66D43C34CD' 
	END

	-- Canada category

	SELECT @categoryName = 'Canada'

	SELECT @l_containerGuid = 'D6A7960A-178F-4C1A-9CC0-E09807743142'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '7E41B77E-C9D0-4B89-A79F-9F6B0D4AEE45') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '7E41B77E-C9D0-4B89-A79F-9F6B0D4AEE45', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Canada SIN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'E18935FD-43B1-4286-B56F-728D921A98EB') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'E18935FD-43B1-4286-B56F-728D921A98EB', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Social Insurance Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='EA28E3D8-0180-4D80-A83A-1CF3694D78E0' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'E18935FD-43B1-4286-B56F-728D921A98EB' AND TagDesc != 'Canadian Social Insurance Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Social Insurance Number' WHERE containerGuid = @l_containerGuid AND TagId = 'E18935FD-43B1-4286-B56F-728D921A98EB' 
	END

	-- 'Canada Ontario Driver License'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '0994D497-E29D-4B33-967B-7E02738CA39B') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '0994D497-E29D-4B33-967B-7E02738CA39B', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Ontario Driver License', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='EBBFA4BB-2637-409A-B305-E136D1BA44F4' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '0994D497-E29D-4B33-967B-7E02738CA39B' AND TagDesc != 'Canadian Ontario Driver License') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Ontario Driver License' WHERE containerGuid = @l_containerGuid AND TagId = '0994D497-E29D-4B33-967B-7E02738CA39B' 
	END

	-- 'Canada Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '051C6528-CF2C-4179-B764-65ED9DA9D939') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '051C6528-CF2C-4179-B764-65ED9DA9D939', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='9591DC70-3EDB-480D-9FDF-32BEFD77CAFE' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '051C6528-CF2C-4179-B764-65ED9DA9D939' AND TagDesc != 'Canadian Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Passport' WHERE containerGuid = @l_containerGuid AND TagId = '051C6528-CF2C-4179-B764-65ED9DA9D939' 
	END

	-- 'Canada Postal Code'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '4C6CB1EA-2256-48CC-8FA3-886222E61EC0') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '4C6CB1EA-2256-48CC-8FA3-886222E61EC0', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Postal Code', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='D81D5ECA-956D-4483-892E-1E10FE18BDC6' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '4C6CB1EA-2256-48CC-8FA3-886222E61EC0' AND TagDesc != 'Canadian Postal Code') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Postal Code' WHERE containerGuid = @l_containerGuid AND TagId = '4C6CB1EA-2256-48CC-8FA3-886222E61EC0' 
	END

	-- Denmark category

	SELECT @categoryName = 'Denmark'

	SELECT @l_containerGuid = '686C4912-7038-416A-B056-E3A5AD762812'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'C0335BD9-D6D1-4B63-AA25-F72D7ECDB343') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'C0335BD9-D6D1-4B63-AA25-F72D7ECDB343', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Danish SSN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '74DC6642-2D70-4DCD-87A1-9C36C42945D6') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '74DC6642-2D70-4DCD-87A1-9C36C42945D6', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Danish Social Security number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='8EB42EFC-BA81-45DE-8C23-F60F1251F1AF' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '74DC6642-2D70-4DCD-87A1-9C36C42945D6' AND TagDesc != 'Danish Social Security number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Danish Social Security number' WHERE containerGuid = @l_containerGuid AND TagId = '74DC6642-2D70-4DCD-87A1-9C36C42945D6' 
	END

	-- 'Danish Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '56A15D89-0E94-4A25-B680-8232365ADE30') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '56A15D89-0E94-4A25-B680-8232365ADE30', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Danish Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='FB2F2A67-EA2D-43C4-A9E6-73BE62B64B94' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '56A15D89-0E94-4A25-B680-8232365ADE30' AND TagDesc != 'Danish Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Danish Passport' WHERE containerGuid = @l_containerGuid AND TagId = '56A15D89-0E94-4A25-B680-8232365ADE30' 
	END

	-- Finland category

	SELECT @categoryName = 'Finland'

	SELECT @l_containerGuid = 'D408561F-F603-4957-B2E4-2A50323A93E6'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'D594FFB8-E907-41DD-8D1C-AEC17EDA0DB9') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'D594FFB8-E907-41DD-8D1C-AEC17EDA0DB9', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Finland Hetu'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '86C83E26-95F1-4044-9433-D70333E890A7') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '86C83E26-95F1-4044-9433-D70333E890A7', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Finnish Hetu', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='D5FEEA9D-C0B0-4B6F-ADE2-4253860F17F4' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '86C83E26-95F1-4044-9433-D70333E890A7' AND TagDesc != 'Finnish Hetu') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Finnish Hetu' WHERE containerGuid = @l_containerGuid AND TagId = '86C83E26-95F1-4044-9433-D70333E890A7' 
	END

	-- 'Finland Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '4CD932A1-04FB-4B94-A8A9-003D166F5E18') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '4CD932A1-04FB-4B94-A8A9-003D166F5E18', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Finnish Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='C3CA1049-B5E9-489C-980C-079A4BA93D91' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '4CD932A1-04FB-4B94-A8A9-003D166F5E18' AND TagDesc != 'Finnish Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Finnish Passport' WHERE containerGuid = @l_containerGuid AND TagId = '4CD932A1-04FB-4B94-A8A9-003D166F5E18' 
	END

	-- France category

	SELECT @categoryName = 'France'

	SELECT @l_containerGuid = 'F00783B4-431C-4177-8561-85D783D5E18F'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '8A7FDCED-1862-40BF-9A16-6FE419E8ED47') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '8A7FDCED-1862-40BF-9A16-6FE419E8ED47', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'France INSEE'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '8C82BC0C-1930-498A-8FC4-80DABB2119BA') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '8C82BC0C-1930-498A-8FC4-80DABB2119BA', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'French INSEE', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='BC451DC2-1807-4813-AE5E-741FE274231D' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '8C82BC0C-1930-498A-8FC4-80DABB2119BA' AND TagDesc != 'French INSEE') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'French INSEE' WHERE containerGuid = @l_containerGuid AND TagId = '8C82BC0C-1930-498A-8FC4-80DABB2119BA' 
	END

	-- 'France Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '9C53AA0A-CE23-44BF-B44C-3035D27068FF') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '9C53AA0A-CE23-44BF-B44C-3035D27068FF', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'French Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='0F2EB75A-E5FA-4A55-82A1-034DBE82D8E7' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '9C53AA0A-CE23-44BF-B44C-3035D27068FF' AND TagDesc != 'French Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'French Passport' WHERE containerGuid = @l_containerGuid AND TagId = '9C53AA0A-CE23-44BF-B44C-3035D27068FF' 
	END

	-- Germany category

	SELECT @categoryName = 'Germany'

	SELECT @l_containerGuid = '8CA3EF04-3553-4A44-BF4F-EAB40926B1F7'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '8A7A5BC9-4ECA-408A-92C6-4DB6FD4B2DE5') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '8A7A5BC9-4ECA-408A-92C6-4DB6FD4B2DE5', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Germany PK'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '6E0CC9A2-24FE-4C9F-8459-A0C238B803DC') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '6E0CC9A2-24FE-4C9F-8459-A0C238B803DC', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'German PK', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='155D44C7-8E8F-4686-B94C-F0C0D217891B' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '6E0CC9A2-24FE-4C9F-8459-A0C238B803DC' AND TagDesc != 'German PK') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'German PK' WHERE containerGuid = @l_containerGuid AND TagId = '6E0CC9A2-24FE-4C9F-8459-A0C238B803DC' 
	END

	-- 'Germany VSNR'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '051415BD-5A83-4C12-9A39-E5165CEB8175') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '051415BD-5A83-4C12-9A39-E5165CEB8175', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'German VSNR', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='50B4415F-C48A-454B-8DA1-71B19E4A253D' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '051415BD-5A83-4C12-9A39-E5165CEB8175' AND TagDesc != 'German VSNR') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'German VSNR' WHERE containerGuid = @l_containerGuid AND TagId = '051415BD-5A83-4C12-9A39-E5165CEB8175' 
	END

	-- 'Germany Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'A92E3E25-3F8E-42A5-857E-C8F38115751C') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'A92E3E25-3F8E-42A5-857E-C8F38115751C', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'German Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='DFF664D5-22B2-47E4-85B2-8BD4D2667EEA' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'A92E3E25-3F8E-42A5-857E-C8F38115751C' AND TagDesc != 'German Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'German Passport' WHERE containerGuid = @l_containerGuid AND TagId = 'A92E3E25-3F8E-42A5-857E-C8F38115751C' 
	END

	-- Greece category

	SELECT @categoryName = 'Greece'

	SELECT @l_containerGuid = 'C7B0D69F-8CBD-42D9-9868-82EBD1B9AF49'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'F8936B41-E58B-4259-A55F-F5E8043654AA') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'F8936B41-E58B-4259-A55F-F5E8043654AA', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Greece Tautotita'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'D767DE76-B919-4582-BC52-3D6F69C24589') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'D767DE76-B919-4582-BC52-3D6F69C24589', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Greek Tautotita', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='8ECF7BA5-AD5D-4C24-B871-FD4D96453010' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'D767DE76-B919-4582-BC52-3D6F69C24589' AND TagDesc != 'Greek Tautotita') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Greek Tautotita' WHERE containerGuid = @l_containerGuid AND TagId = 'D767DE76-B919-4582-BC52-3D6F69C24589' 
	END

	-- 'Greece Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'C89271CE-7E12-4AE3-893D-C17B45C9D15D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'C89271CE-7E12-4AE3-893D-C17B45C9D15D', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Greek Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='046C302A-9A26-49C6-AF1D-99E72EADE4FB' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'C89271CE-7E12-4AE3-893D-C17B45C9D15D' AND TagDesc != 'Greek Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Greek Passport' WHERE containerGuid = @l_containerGuid AND TagId = 'C89271CE-7E12-4AE3-893D-C17B45C9D15D' 
	END

	-- Hungary category

	SELECT @categoryName = 'Hungary'

	SELECT @l_containerGuid = 'C559A8B7-FC79-415E-A5DE-A9D213E262F1'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '30186A77-EB99-4AB9-BA28-7A2268CBAC18') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '30186A77-EB99-4AB9-BA28-7A2268CBAC18', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Hungary Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '40169289-1F8B-4BE3-B869-C128F12D9A13') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '40169289-1F8B-4BE3-B869-C128F12D9A13', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Hungarian Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='AC481833-55CB-451E-B255-C12D8F1D4DC5' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '40169289-1F8B-4BE3-B869-C128F12D9A13' AND TagDesc != 'Hungarian Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Hungarian Passport' WHERE containerGuid = @l_containerGuid AND TagId = '40169289-1F8B-4BE3-B869-C128F12D9A13' 
	END

    -- India category

	SELECT @categoryName = 'India'

	SELECT @l_containerGuid = 'D68448B4-5C63-43BE-AD26-B44457E599C3'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '12C77358-B448-4B7C-8477-A0D5EC17DDA2') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '12C77358-B448-4B7C-8477-A0D5EC17DDA2', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Indian Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '6BD90B59-5CF0-4720-B498-E4E45A0B07D4') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '6BD90B59-5CF0-4720-B498-E4E45A0B07D4', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Indian Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='312A7A92-692C-4DB9-A75E-F9A27A9353C4' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '6BD90B59-5CF0-4720-B498-E4E45A0B07D4' AND TagDesc != 'Indian Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Indian Passport' WHERE containerGuid = @l_containerGuid AND TagId = '6BD90B59-5CF0-4720-B498-E4E45A0B07D4' 
	END

    -- 'Indian Aadhaar'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '088A59B0-C00C-4EFB-95C4-A656BFD2598A') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '088A59B0-C00C-4EFB-95C4-A656BFD2598A', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Indian Aadhaar', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='4BDEBC91-17D0-4940-9C0D-DF9E74C80E81' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '088A59B0-C00C-4EFB-95C4-A656BFD2598A' AND TagDesc != 'Indian Aadhaar') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Indian Aadhaar' WHERE containerGuid = @l_containerGuid AND TagId = '088A59B0-C00C-4EFB-95C4-A656BFD2598A' 
	END

    -- 'Indian Driver License'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '0F761BCC-D120-4A68-9B12-096F0BE39B65') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '0F761BCC-D120-4A68-9B12-096F0BE39B65', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Indian Driver License', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='14614F65-33B3-4DF2-84E9-17D4B457AD1B' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '0F761BCC-D120-4A68-9B12-096F0BE39B65' AND TagDesc != 'Indian Driver License') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Indian Driver License' WHERE containerGuid = @l_containerGuid AND TagId = '0F761BCC-D120-4A68-9B12-096F0BE39B65' 
	END

    -- 'Indian Voter ID'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '103E17A0-D5FE-4C0D-936C-C096A217DA79') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '103E17A0-D5FE-4C0D-936C-C096A217DA79', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Indian Voter ID', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='E4F2A891-E36D-4899-A5DE-C906D6512987' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '103E17A0-D5FE-4C0D-936C-C096A217DA79' AND TagDesc != 'Indian Voter ID') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Indian Voter ID' WHERE containerGuid = @l_containerGuid AND TagId = '103E17A0-D5FE-4C0D-936C-C096A217DA79' 
	END

	-- South Africa category

	SELECT @categoryName = 'South Africa'

	SELECT @l_containerGuid = 'F469DB7B-C70E-43CC-8868-53018F2E3CEE'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '46E41EAB-3F57-4F05-BE7E-07798F65C5CE') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '46E41EAB-3F57-4F05-BE7E-07798F65C5CE', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- 'South Africa ID'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'E0D2DEC5-9F20-4AC5-AE94-F0EE065823AF') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'E0D2DEC5-9F20-4AC5-AE94-F0EE065823AF', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'South African ID', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='C3A827BC-8ED5-400D-89D7-BE9B452DECCB' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'E0D2DEC5-9F20-4AC5-AE94-F0EE065823AF' AND TagDesc != 'South African ID') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'South African ID' WHERE containerGuid = @l_containerGuid AND TagId = 'E0D2DEC5-9F20-4AC5-AE94-F0EE065823AF' 
	END

	-- Ireland category

	SELECT @categoryName = 'Ireland'

	SELECT @l_containerGuid = 'C069C51D-66BD-40F3-8361-A77E738DA0A6'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '557C4579-250D-403D-855A-3EA11B8C2FFB') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '557C4579-250D-403D-855A-3EA11B8C2FFB', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Ireland PPSN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'C1D47F1F-CEB3-48A5-BF7E-B47C92E9D829') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'C1D47F1F-CEB3-48A5-BF7E-B47C92E9D829', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Irish PPSN', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='9926AC1B-29B0-428C-B48B-72F51758F7BB' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'C1D47F1F-CEB3-48A5-BF7E-B47C92E9D829' AND TagDesc != 'Irish PPSN') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Irish PPSN' WHERE containerGuid = @l_containerGuid AND TagId = 'C1D47F1F-CEB3-48A5-BF7E-B47C92E9D829' 
	END

	-- Italy category

	SELECT @categoryName = 'Italy'

	SELECT @l_containerGuid = 'B9D68206-6BE3-4608-9681-D525B2C2D89D'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '8F89DDA2-2B58-42F7-B497-8D86502F195C') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '8F89DDA2-2B58-42F7-B497-8D86502F195C', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Italy Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '6167E6FF-69EE-475E-9E74-81CACFF3A8ED') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '6167E6FF-69EE-475E-9E74-81CACFF3A8ED', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Italian Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='3E353548-8A13-46EF-8AA9-0C85B1286C2B' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '6167E6FF-69EE-475E-9E74-81CACFF3A8ED' AND TagDesc != 'Italian Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Italian Passport' WHERE containerGuid = @l_containerGuid AND TagId = '6167E6FF-69EE-475E-9E74-81CACFF3A8ED' 
	END

	-- Netherlands category

	SELECT @categoryName = 'Netherlands'

	SELECT @l_containerGuid = '18726D86-CDC4-4306-8928-CA97E60FC56D'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '1503CCEC-C351-40A1-8953-8D030746014D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '1503CCEC-C351-40A1-8953-8D030746014D', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Dutch SSN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'BE1D87F3-59E4-4CAB-A451-9A0EC4840E19') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'BE1D87F3-59E4-4CAB-A451-9A0EC4840E19', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Dutch Social Security number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='DEC63EDC-E24A-46F7-BFD4-69697466881D' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'BE1D87F3-59E4-4CAB-A451-9A0EC4840E19' AND TagDesc != 'Dutch Social Security number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Dutch Social Security number' WHERE containerGuid = @l_containerGuid AND TagId = 'BE1D87F3-59E4-4CAB-A451-9A0EC4840E19' 
	END

	-- Poland category

	SELECT @categoryName = 'Poland'

	SELECT @l_containerGuid = '0700E6BB-24E2-446F-BBC2-46AAEE602628'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'E12CBB3E-C548-4EE1-9282-C3B4598D4CE4') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'E12CBB3E-C548-4EE1-9282-C3B4598D4CE4', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'PESEL'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '261FBC4D-290C-4210-9974-7A0F63562037') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '261FBC4D-290C-4210-9974-7A0F63562037', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'PESEL', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='C6179DB1-021A-4957-8FDA-48BBFFE8C98A' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '261FBC4D-290C-4210-9974-7A0F63562037' AND TagDesc != 'PESEL') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'PESEL' WHERE containerGuid = @l_containerGuid AND TagId = '261FBC4D-290C-4210-9974-7A0F63562037' 
	END

	-- Sweden category

	SELECT @categoryName = 'Sweden'

	SELECT @l_containerGuid = '3FCBA974-B688-41E9-94A0-5FCBE0F572EC'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '309CAAC7-5D2A-4B5E-8969-258DC6EE99BB') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '309CAAC7-5D2A-4B5E-8969-258DC6EE99BB', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Swedish Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'A054623C-D9C1-4A43-A207-B1114A2C9329') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'A054623C-D9C1-4A43-A207-B1114A2C9329', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Swedish Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='9830E9BE-7C72-45BA-8103-F50DA187C909' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'A054623C-D9C1-4A43-A207-B1114A2C9329' AND TagDesc != 'Swedish Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Swedish Passport' WHERE containerGuid = @l_containerGuid AND TagId = 'A054623C-D9C1-4A43-A207-B1114A2C9329' 
	END

	-- UK category

	SELECT @categoryName = 'UK'

	SELECT @l_containerGuid = '12C703B8-74EA-4C00-AF7B-D1832BD8DE83'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'EA7C7A8E-024D-4FBE-9D20-51AB1E562042') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'EA7C7A8E-024D-4FBE-9D20-51AB1E562042', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'UK Nino'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '3ADACA62-C454-4653-9026-50616DA10B64') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '3ADACA62-C454-4653-9026-50616DA10B64', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'UK NINO', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='5A5A4CFA-1D69-4E9A-8B0D-9EFA04510932' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '3ADACA62-C454-4653-9026-50616DA10B64' AND TagDesc != 'UK NINO') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'UK NINO' WHERE containerGuid = @l_containerGuid AND TagId = '3ADACA62-C454-4653-9026-50616DA10B64' 
	END

	-- 'UK Driver License'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'E9253C4A-EB80-47CF-A34B-417A3137FCFC') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'E9253C4A-EB80-47CF-A34B-417A3137FCFC', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'UK DL', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='63B54DE6-7372-4907-B838-FE2282231FD9' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'E9253C4A-EB80-47CF-A34B-417A3137FCFC' AND TagDesc != 'UK DL') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'UK DL' WHERE containerGuid = @l_containerGuid AND TagId = 'E9253C4A-EB80-47CF-A34B-417A3137FCFC' 
	END

	-- 'UK Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '9960C5F3-E401-4CCF-861D-13CE3A6844C3') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '9960C5F3-E401-4CCF-861D-13CE3A6844C3', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'UK Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='C62928C0-7EA5-4261-BBDE-75BB3B3B8FC6' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '9960C5F3-E401-4CCF-861D-13CE3A6844C3' AND TagDesc != 'UK Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'UK Passport' WHERE containerGuid = @l_containerGuid AND TagId = '9960C5F3-E401-4CCF-861D-13CE3A6844C3' 
	END

	-- US category

	SELECT @categoryName = 'US'

	SELECT @l_containerGuid = 'B0996719-8128-4F28-8804-C4B0F98A439F'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '7BDEF450-3563-472D-BCA5-DE47991E1324') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '7BDEF450-3563-472D-BCA5-DE47991E1324', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'SSN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '1CCE21DC-AA07-4801-A5A1-F7C4F4BA8E90') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '1CCE21DC-AA07-4801-A5A1-F7C4F4BA8E90', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Social Security number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='755859D9-F003-4325-88F6-96FED8372011' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '1CCE21DC-AA07-4801-A5A1-F7C4F4BA8E90' AND TagDesc != 'US Social Security number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Social Security number' WHERE containerGuid = @l_containerGuid AND TagId = '1CCE21DC-AA07-4801-A5A1-F7C4F4BA8E90' 
	END

	-- 'US Driver License'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '7BB1EE81-E0A9-4D61-9FF2-A54A5023646C') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '7BB1EE81-E0A9-4D61-9FF2-A54A5023646C', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Driver License', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='F72F9670-2227-47EB-A00A-5C88EB854DAD' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '7BB1EE81-E0A9-4D61-9FF2-A54A5023646C' AND TagDesc != 'US Driver License') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Driver License' WHERE containerGuid = @l_containerGuid AND TagId = '7BB1EE81-E0A9-4D61-9FF2-A54A5023646C' 
	END

	-- 'USA Passport'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '9F4AFBA0-B7AB-48DF-8880-F2C1DD6C86A1') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '9F4AFBA0-B7AB-48DF-8880-F2C1DD6C86A1', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Passport', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='B01E514B-F17B-4EE2-9353-E12A85582007' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '9F4AFBA0-B7AB-48DF-8880-F2C1DD6C86A1' AND TagDesc != 'US Passport') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Passport' WHERE containerGuid = @l_containerGuid AND TagId = '9F4AFBA0-B7AB-48DF-8880-F2C1DD6C86A1' 
	END

	---------------------------------------------------------------- Financial Category Type --------------------------------------------------------------------------------------

	-- parent child category hierarchy

	-- Financial parent category	

	SELECT @parentCategoryGuid = '695A312D-EB95-459C-99B8-FFD719E45B90'

	-- Generic category

	SELECT @categoryName = 'Generic'

	SELECT @l_containerGuid = 'B28694EC-C5B5-4F64-B64E-967EDFCE6B4B'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'E89F15A9-1593-4EBD-9476-1960D5993EB3') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'E89F15A9-1593-4EBD-9476-1960D5993EB3', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'CreditCard'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '64609D18-FE48-4CF5-9F8F-A3178CBFA9C8') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '64609D18-FE48-4CF5-9F8F-A3178CBFA9C8', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Credit Card Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='2D5344D3-2A37-4BC8-910C-D520473DFE25' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '64609D18-FE48-4CF5-9F8F-A3178CBFA9C8' AND TagDesc != 'Credit Card Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Credit Card Number' WHERE containerGuid = @l_containerGuid AND TagId = '64609D18-FE48-4CF5-9F8F-A3178CBFA9C8' 
	END

	-- 'IBAN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '76654508-01C6-46D1-BD46-2D42A1E7A13A') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '76654508-01C6-46D1-BD46-2D42A1E7A13A', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'International Bank Account Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='FF8913A9-D40A-4E85-99E4-63552511A159' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '76654508-01C6-46D1-BD46-2D42A1E7A13A' AND TagDesc != 'International Bank Account Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'International Bank Account Number' WHERE containerGuid = @l_containerGuid AND TagId = '76654508-01C6-46D1-BD46-2D42A1E7A13A' 
	END

	-- 'Money'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '27E68731-9FDC-43B7-8D84-D15E7C2A2E6D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '27E68731-9FDC-43B7-8D84-D15E7C2A2E6D', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Currency (Money)', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='0CCDFFAF-039D-4C1F-BC05-36C0EAF679AD' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '27E68731-9FDC-43B7-8D84-D15E7C2A2E6D' AND TagDesc != 'Currency (Money)') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Currency (Money)' WHERE containerGuid = @l_containerGuid AND TagId = '27E68731-9FDC-43B7-8D84-D15E7C2A2E6D' 
	END

	-- 'BankRouting'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '57329341-8EA9-4B9A-AB57-BB04A5EDC324') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '57329341-8EA9-4B9A-AB57-BB04A5EDC324', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Routing Transit Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='01D93C7D-F38A-48CD-8AAB-560BCE27E8C3' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '57329341-8EA9-4B9A-AB57-BB04A5EDC324' AND TagDesc != 'Routing Transit Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Routing Transit Number' WHERE containerGuid = @l_containerGuid AND TagId = '57329341-8EA9-4B9A-AB57-BB04A5EDC324' 
	END

	-- Australia category

	SELECT @categoryName = 'Australia'

	SELECT @l_containerGuid = '44A981FE-8BB6-4727-BDBC-6E1E7E41AF62'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '3D2E9487-9D74-4050-B079-F595BEE10634') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '3D2E9487-9D74-4050-B079-F595BEE10634', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Australia Bank State Branch Code'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '2F7295DC-3088-49C3-A37A-B4980653A048') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '2F7295DC-3088-49C3-A37A-B4980653A048', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Australian Bank State Branch Code', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='BAD04EB6-3112-44A8-A902-E839E065ACF5' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '2F7295DC-3088-49C3-A37A-B4980653A048' AND TagDesc != 'Australian Bank State Branch Code') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Australian Bank State Branch Code' WHERE containerGuid = @l_containerGuid AND TagId = '2F7295DC-3088-49C3-A37A-B4980653A048' 
	END

	-- 'Australia Tax File Number'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '39FF24C9-0EEA-4286-9AE2-6CA2FFF81C56') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '39FF24C9-0EEA-4286-9AE2-6CA2FFF81C56', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Australian Tax File Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='F008827B-4F87-49BC-B26F-A051930288A5' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '39FF24C9-0EEA-4286-9AE2-6CA2FFF81C56' AND TagDesc != 'Australian Tax File Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Australian Tax File Number' WHERE containerGuid = @l_containerGuid AND TagId = '39FF24C9-0EEA-4286-9AE2-6CA2FFF81C56' 
	END

	-- Canada category

	SELECT @categoryName = 'Canada'

	SELECT @l_containerGuid = '062AF2E8-7524-4C51-B5DE-0B4A1C8CBADD'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'E0C95523-2010-4799-B331-AC01145049D9') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'E0C95523-2010-4799-B331-AC01145049D9', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Canada Bank Transit Number'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '9E118B22-7FFD-4828-AEBF-89B9DAF8581D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '9E118B22-7FFD-4828-AEBF-89B9DAF8581D', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Bank Transit Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='16AD3E4C-0F12-4607-A1D8-BE2015902042' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '9E118B22-7FFD-4828-AEBF-89B9DAF8581D' AND TagDesc != 'Canadian Bank Transit Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Bank Transit Number' WHERE containerGuid = @l_containerGuid AND TagId = '9E118B22-7FFD-4828-AEBF-89B9DAF8581D' 
	END

	-- Germany category

	SELECT @categoryName = 'Germany'

	SELECT @l_containerGuid = '54039AD9-BFCA-41E1-87B7-D6585ADCA677'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '4A16FD8A-30D3-4E18-AEF9-F5F033037BBE') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '4A16FD8A-30D3-4E18-AEF9-F5F033037BBE', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Germany Steuer ID'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '04E43073-28D1-481E-8D21-DEC86B5B018B') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '04E43073-28D1-481E-8D21-DEC86B5B018B', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'German SteuerID', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='ACEBE15A-1F0D-406C-BC2D-C43586A92B87' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '04E43073-28D1-481E-8D21-DEC86B5B018B' AND TagDesc != 'German SteuerID') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'German SteuerID' WHERE containerGuid = @l_containerGuid AND TagId = '04E43073-28D1-481E-8D21-DEC86B5B018B' 
	END

	-- Greece category

	SELECT @categoryName = 'Greece'

	SELECT @l_containerGuid = 'F86D8BD0-2322-4B85-A3FE-5270178D9C0B'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'FAB84116-6399-432B-95CF-63E77C8459CE') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'FAB84116-6399-432B-95CF-63E77C8459CE', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy

	-- 'Greece AFM'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'A94DCB05-2E83-4060-B135-8406C1F06825') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'A94DCB05-2E83-4060-B135-8406C1F06825', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Greek AFM', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='0996BD6B-93C4-4B14-A0B0-17686647258F' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'A94DCB05-2E83-4060-B135-8406C1F06825' AND TagDesc != 'Greek AFM') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Greek AFM' WHERE containerGuid = @l_containerGuid AND TagId = 'A94DCB05-2E83-4060-B135-8406C1F06825' 
	END

	-- India category

	SELECT @categoryName = 'India'

	SELECT @l_containerGuid = '7F09C154-9802-49F1-B518-6BB13F0685EE'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'EC93B445-080A-40F8-878C-12A6C4E2216B') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'EC93B445-080A-40F8-878C-12A6C4E2216B', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Indian PAN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'B7F81911-858E-40A8-8B84-2B8A36319F9C') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'B7F81911-858E-40A8-8B84-2B8A36319F9C', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Indian Permanent Account Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='6531448C-2B30-4BC8-8928-E5D15F759C24' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'B7F81911-858E-40A8-8B84-2B8A36319F9C' AND TagDesc != 'Indian Permanent Account Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Indian Permanent Account Number' WHERE containerGuid = @l_containerGuid AND TagId = 'B7F81911-858E-40A8-8B84-2B8A36319F9C' 
	END

    -- 'Indian TAN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'A7EC5E6D-C2E5-4127-B5A0-231064AA6EE8') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'A7EC5E6D-C2E5-4127-B5A0-231064AA6EE8', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Indian Tax Account Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='5216B7C6-59B9-462A-A799-295DE7546620' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'A7EC5E6D-C2E5-4127-B5A0-231064AA6EE8' AND TagDesc != 'Indian Tax Account Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Indian Tax Account Number' WHERE containerGuid = @l_containerGuid AND TagId = 'A7EC5E6D-C2E5-4127-B5A0-231064AA6EE8' 
	END

	-- US category

	SELECT @categoryName = 'US'

	SELECT @l_containerGuid = 'B216073A-7D0A-4AFD-A51A-66B1E47D1690'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '63C9A70F-31A5-4124-8897-6FC09F3A931A') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '63C9A70F-31A5-4124-8897-6FC09F3A931A', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'ITIN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '7F24AE56-D7A6-427F-B6E0-3EFA9D6C4BFA') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '7F24AE56-D7A6-427F-B6E0-3EFA9D6C4BFA', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Individual Taxpayer Identification Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='F7722C32-2195-4D32-A86E-88DBAC89DAA6' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '7F24AE56-D7A6-427F-B6E0-3EFA9D6C4BFA' AND TagDesc != 'US Individual Taxpayer Identification Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Individual Taxpayer Identification Number' WHERE containerGuid = @l_containerGuid AND TagId = '7F24AE56-D7A6-427F-B6E0-3EFA9D6C4BFA' 
	END

	---------------------------------------------------------------- Healthcare Category Type --------------------------------------------------------------------------------------

	-- parent child category hierarchy

	-- Healthcare parent category	

	SELECT @parentCategoryGuid = '5BE549B4-73F6-4BDE-A630-18EFF3B8FF85'

	-- US category

	SELECT @categoryName = 'US'

	SELECT @l_containerGuid = 'EBA20F69-1EE5-4A52-A92E-5968B05B94F8'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '45261601-BD27-4C52-A032-55CF33555032') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '45261601-BD27-4C52-A032-55CF33555032', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'HICN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'BC1C45B7-ACD0-4A92-9422-DD61A6CD099C') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'BC1C45B7-ACD0-4A92-9422-DD61A6CD099C', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Health Insurance Claim Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='EB9A5307-7DC6-4822-8921-32849ABEE9B5' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'BC1C45B7-ACD0-4A92-9422-DD61A6CD099C' AND TagDesc != 'US Health Insurance Claim Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Health Insurance Claim Number' WHERE containerGuid = @l_containerGuid AND TagId = 'BC1C45B7-ACD0-4A92-9422-DD61A6CD099C' 
	END

	-- 'MBI'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '08CB5850-5DFD-44A1-8DDB-999AD696F685') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '08CB5850-5DFD-44A1-8DDB-999AD696F685', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Medicare Beneficiary Identifier', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='130814C5-A987-4DB5-8CA3-2874D84208C3' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '08CB5850-5DFD-44A1-8DDB-999AD696F685' AND TagDesc != 'US Medicare Beneficiary Identifier') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Medicare Beneficiary Identifier' WHERE containerGuid = @l_containerGuid AND TagId = '08CB5850-5DFD-44A1-8DDB-999AD696F685' 
	END

	-- Australia category

	SELECT @categoryName = 'Australia'

	SELECT @l_containerGuid = '566508E1-3144-4705-867C-9D4C98B2D55B'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '06AB5AB2-882B-4745-AE04-DE3BF9F48F10') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '06AB5AB2-882B-4745-AE04-DE3BF9F48F10', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Australia Medical Account Number'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'A1A7CB27-01A1-48EC-9DC1-0D43D00C4F7E') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'A1A7CB27-01A1-48EC-9DC1-0D43D00C4F7E', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Australian Medical Account Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='1CEC13CF-C9AE-45ED-B3D1-F878B3659DCD' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'A1A7CB27-01A1-48EC-9DC1-0D43D00C4F7E' AND TagDesc != 'Australian Medical Account Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Australian Medical Account Number' WHERE containerGuid = @l_containerGuid AND TagId = 'A1A7CB27-01A1-48EC-9DC1-0D43D00C4F7E' 
	END

	-- Canada category

	SELECT @categoryName = 'Canada'

	SELECT @l_containerGuid = 'AECE56E2-00E2-430B-BD5D-8FD9682C464F'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'CF4DBC40-4AC0-4237-8667-AC0BB9AAA4DD') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'CF4DBC40-4AC0-4237-8667-AC0BB9AAA4DD', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Canada Health Service Number'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'D4F6DA7F-3831-47FA-8DBF-72B349C94D8A') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'D4F6DA7F-3831-47FA-8DBF-72B349C94D8A', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Health Service Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='9FB7523B-C463-41CD-A54F-351EBDD9BD87' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'D4F6DA7F-3831-47FA-8DBF-72B349C94D8A' AND TagDesc != 'Canadian Health Service Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Health Service Number' WHERE containerGuid = @l_containerGuid AND TagId = 'D4F6DA7F-3831-47FA-8DBF-72B349C94D8A' 
	END

	-- 'Canada PHIN'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'DEFF47A7-DA49-4211-B091-36661467B565') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'DEFF47A7-DA49-4211-B091-36661467B565', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Canadian Personal Health Information Number', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='2667026A-C2D6-4219-B544-DD2B8BEF29B9' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'DEFF47A7-DA49-4211-B091-36661467B565' AND TagDesc != 'Canadian Personal Health Information Number') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Canadian Personal Health Information Number' WHERE containerGuid = @l_containerGuid AND TagId = 'DEFF47A7-DA49-4211-B091-36661467B565' 
	END

	-- UK category

	SELECT @categoryName = 'UK'

	SELECT @l_containerGuid = 'FF7BA445-AF85-4EC8-BF03-C7C3E742FE7A'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '2521D860-9887-481F-A6DF-1EC767AD458E') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '2521D860-9887-481F-A6DF-1EC767AD458E', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'UK NHS Number'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '27302D34-3895-4A6B-9935-DE5014AB505B') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '27302D34-3895-4A6B-9935-DE5014AB505B', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'UK NHS', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='4D2973AD-AA4D-439A-AD84-4DF034499111' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '27302D34-3895-4A6B-9935-DE5014AB505B' AND TagDesc != 'UK NHS') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'UK NHS' WHERE containerGuid = @l_containerGuid AND TagId = '27302D34-3895-4A6B-9935-DE5014AB505B' 
	END

	---------------------------------------------------------------- Global Category Type --------------------------------------------------------------------------------------

	-- parent child category hierarchy

	-- Global parent category	

	SELECT @parentCategoryGuid = 'E0F5B079-527C-44B4-96D2-5098934FC777'

	-- Generic category

	SELECT @categoryName = 'Generic'

	SELECT @l_containerGuid = '5448ABDB-DD24-4440-AF82-1D00D60818A5'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '1A89F558-B78F-4CAA-975C-E4C60E256FC2') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '1A89F558-B78F-4CAA-975C-E4C60E256FC2', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'ContextualDate'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '2458307D-782F-4E84-A744-C78173DAA669') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '2458307D-782F-4E84-A744-C78173DAA669', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Contextual Date', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='D728F6BD-FBB3-4378-9564-101F867DA919' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '2458307D-782F-4E84-A744-C78173DAA669' AND TagDesc != 'Contextual Date') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Contextual Date' WHERE containerGuid = @l_containerGuid AND TagId = '2458307D-782F-4E84-A744-C78173DAA669' 
	END

	-- 'Date'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'C2C87D84-AAFC-49C3-A18B-95631FB62F35') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'C2C87D84-AAFC-49C3-A18B-95631FB62F35', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Date', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='5533D135-1A66-48A5-975A-FF1D0998DC32' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'C2C87D84-AAFC-49C3-A18B-95631FB62F35' AND TagDesc != 'Date') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Date' WHERE containerGuid = @l_containerGuid AND TagId = 'C2C87D84-AAFC-49C3-A18B-95631FB62F35' 
	END

	-- 'Hostname'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '6D306B47-36E9-4EBC-9BA2-2E2DC3B0CA5E') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '6D306B47-36E9-4EBC-9BA2-2E2DC3B0CA5E', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Hostname', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='B958FFDA-8EE5-4692-989F-7B9683BE9C70' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '6D306B47-36E9-4EBC-9BA2-2E2DC3B0CA5E' AND TagDesc != 'Hostname') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Hostname' WHERE containerGuid = @l_containerGuid AND TagId = '6D306B47-36E9-4EBC-9BA2-2E2DC3B0CA5E' 
	END

	-- 'IP Address'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '462DD630-F629-4EB0-AB88-A4B49190F5AC') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '462DD630-F629-4EB0-AB88-A4B49190F5AC', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'IP Address', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='BAB64C21-94F5-49FE-925F-CA4D9D86E91F' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '462DD630-F629-4EB0-AB88-A4B49190F5AC' AND TagDesc != 'IP Address') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'IP Address' WHERE containerGuid = @l_containerGuid AND TagId = '462DD630-F629-4EB0-AB88-A4B49190F5AC' 
	END

	-- 'Organization'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'D4DA2960-8EB9-48FE-89D0-8E9C3969ED5F') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'D4DA2960-8EB9-48FE-89D0-8E9C3969ED5F', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Organization', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='AF614815-68E2-4334-B860-281BE32408A4' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'D4DA2960-8EB9-48FE-89D0-8E9C3969ED5F' AND TagDesc != 'Organization') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Organization' WHERE containerGuid = @l_containerGuid AND TagId = 'D4DA2960-8EB9-48FE-89D0-8E9C3969ED5F' 
	END

	-- 'FinanceTags'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'FD0FDC93-CF2F-4612-9C9C-7A5978541427') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'FD0FDC93-CF2F-4612-9C9C-7A5978541427', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Sentiment tags', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='9B7145ED-3379-48EE-AC6A-081F280CBFB2' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'FD0FDC93-CF2F-4612-9C9C-7A5978541427' AND TagDesc != 'Sentiment tags') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Sentiment tags' WHERE containerGuid = @l_containerGuid AND TagId = 'FD0FDC93-CF2F-4612-9C9C-7A5978541427' 
	END

	-- 'Time'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'B5C6FD61-C271-4DD5-A2A8-DE12F32D6102') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'B5C6FD61-C271-4DD5-A2A8-DE12F32D6102', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Time', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='FF8EEBDD-BDFF-4B11-95A8-38E68DA1016B' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'B5C6FD61-C271-4DD5-A2A8-DE12F32D6102' AND TagDesc != 'Time') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Time' WHERE containerGuid = @l_containerGuid AND TagId = 'B5C6FD61-C271-4DD5-A2A8-DE12F32D6102' 
	END

	---------------------------------------------------------------- Custom Category Type --------------------------------------------------------------------------------------

	-- parent child category hierarchy

	-- Custom parent category	

	SELECT @parentCategoryGuid = 'B05D1D67-FCE2-493B-A7F4-5400938EAF70'

	-- Generic category

	SELECT @categoryName = 'Generic'

	SELECT @l_containerGuid = '22CD8879-B2FD-4A63-8096-B515FC13502D'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '877E8FAA-227D-498C-A0BB-EE45130D5231') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '877E8FAA-227D-498C-A0BB-EE45130D5231', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	---------------------------------------------------------------- Classifiers Category Type --------------------------------------------------------------------------------------

	-- parent child category hierarchy

	-- Classifiers parent category	

	SELECT @parentCategoryGuid = 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27'

	-- System category

	SELECT @categoryName = 'System'

	SELECT @l_containerGuid = 'BA5D5532-2DEC-4183-AEED-D4737DA89F36'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '803B4745-D9A8-4B8F-8CB0-64C19CA9C5DD') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '803B4745-D9A8-4B8F-8CB0-64C19CA9C5DD', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	-- entity category hierarchy	

	-- 'Finance'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = 'CA708842-ED99-4848-8009-A5E07888B59D') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT 'CA708842-ED99-4848-8009-A5E07888B59D', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Finance', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='2E208427-84AC-4D9F-8F7C-202EFBFF8F13' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = 'CA708842-ED99-4848-8009-A5E07888B59D' AND TagDesc != 'Finance') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Finance' WHERE containerGuid = @l_containerGuid AND TagId = 'CA708842-ED99-4848-8009-A5E07888B59D' 
	END

	-- 'Legal'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '308857BB-3445-4BBA-9758-134819EC1ADA') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '308857BB-3445-4BBA-9758-134819EC1ADA', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Legal', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='FBF53513-258A-4402-B84B-4BF60CB1ABD4' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '308857BB-3445-4BBA-9758-134819EC1ADA' AND TagDesc != 'Legal') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Legal' WHERE containerGuid = @l_containerGuid AND TagId = '308857BB-3445-4BBA-9758-134819EC1ADA' 
	END

	-- 'Technical'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '540A6F7D-420E-4274-BB65-49BE06579128') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '540A6F7D-420E-4274-BB65-49BE06579128', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'Technical', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='43EB9381-3963-4B92-9A3E-E79141924FAF' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '540A6F7D-420E-4274-BB65-49BE06579128' AND TagDesc != 'Technical') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'Technical' WHERE containerGuid = @l_containerGuid AND TagId = '540A6F7D-420E-4274-BB65-49BE06579128' 
	END

	-- 'US Medical Forms'

IF NOT EXISTS (SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
    	INSERT INTO DM2Container(containerGuid, containerName, containerType, userId, attribute, comment, origCommcellID, createTime, cloudId) 
			VALUES (@l_containerGuid, @categoryName, 9516, 1,0, @categoryName , 0, GETDATE(),0) 
    END 
	ELSE IF EXISTS(SELECT 1 FROM DM2Container WHERE containerGuid = @l_containerGuid AND containerType = 9516) 
	BEGIN 
		UPDATE DM2Container SET containerName = @categoryName, comment = @categoryName  WHERE containerGuid = @l_containerGuid AND containerType = 9516 
	END 
	IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '7979C57E-9058-4BA2-BEE5-75D1B717EB72') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '7979C57E-9058-4BA2-BEE5-75D1B717EB72', DM.containerGuid, CAST(EA.EntityID AS NVARCHAR(64)), 'US Medical Forms', 1, 'Administrator', 2  
			FROM DM2Container DM 
			INNER JOIN EntityAnnotator EA 
				ON EA.EntityGUID='0BE6564B-9D6C-43B9-9B37-13BA960E9667' 
			WHERE DM.containerGuid=@l_containerGuid 
	END 
	ELSE IF EXISTS(SELECT 1 FROM DM2DocTags WHERE TagID = '7979C57E-9058-4BA2-BEE5-75D1B717EB72' AND TagDesc != 'US Medical Forms') 
	BEGIN 
		UPDATE DM2DocTags SET TagDesc = 'US Medical Forms' WHERE containerGuid = @l_containerGuid AND TagId = '7979C57E-9058-4BA2-BEE5-75D1B717EB72' 
	END

	-- Custom category

	SELECT @categoryName = 'Generic'

	SELECT @l_containerGuid = '22CD8879-B2FD-4A63-8096-B515FC13502D'

IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE TagID = '9F3C939F-9AA0-4503-8D12-9F77C1DF0745') 
	BEGIN 
		INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 
		SELECT '9F3C939F-9AA0-4503-8D12-9F77C1DF0745', @parentCategoryGuid, @l_containerGuid, '', 1, 'Administrator', 2  
	END

	------------------------------------------------- End Category Hierarchy ---------------------------------------------------------------------------------------------------

	-- update security associations for existing containers

	--

	DECLARE @ConvertDM2EntitySecurity uniqueidentifier = 'EBEDAE09-18A1-4059-AE3A-2E8457E5B8D0' -- unique identifier helps avoid repeated runs through Service Pack installs.

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @ConvertDM2EntitySecurity)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#containersNotInUMSecurity') IS NOT NULL DROP TABLE #containersNotInUMSecurity

		CREATE TABLE #containersNotInUMSecurity

		(

			containerId int,

			containerType int,

			userId int

		)
		INSERT INTO #containersNotInUMSecurity


		SELECT DISTINCT containerId, containerType, userId

		FROM DM2Container

		WHERE containerId NOT IN (SELECT entityId1 FROM UMSecurityAssociations WHERE isCreator=1 AND entityType1=containerType)
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@ConvertDM2EntitySecurity, 'ConvertDM2EntitySecurity', 'Upgrade DM2 entities such as review set, query set etc. to new security framework', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

		IF OBJECT_ID('tempdb.dbo.#permissionsList') IS NOT NULL DROP TABLE #permissionsList

		CREATE TABLE #permissionsList

		(

			permissionId int

		)

		-- Get list of permissions depending on the entity type

		--  We already have DISTINCT here which is good but we need this to run as part of SP14 hot fix
		INSERT INTO #permissionsList


		SELECT DISTINCT A.capabilityId

		FROM UMDM2EntityCapability A, UMPermissions B, #containersNotInUMSecurity CNU

		WHERE A.entityType = CNU.containerType AND A.capabilityId = B.id
		INSERT INTO #permissionsList


SELECT 107 -- Change Securiy Setting
		INSERT INTO UMSecurityAssociations


			(roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator)

		SELECT 0, permissionId, userId, 1, containerType, containerId, 1

		FROM #containersNotInUMSecurity, #permissionsList

		IF OBJECT_ID('tempdb.dbo.#containersNotInUMSecurity') IS NOT NULL DROP TABLE #containersNotInUMSecurity

		IF OBJECT_ID('tempdb.dbo.#permissionsList') IS NOT NULL DROP TABLE #permissionsList

	END

	-- copy existing custom entities (i.e. entities created before multi-tenant support) to individual company custom containers

	DECLARE @CopyCustomEntitiesToCompanies uniqueidentifier = '6389BE2B-EDE3-4E17-A8E8-26FE3B0BFE0A' -- unique identifier helps avoid repeated runs through Service Pack installs.	

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @CopyCustomEntitiesToCompanies)

	BEGIN
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@CopyCustomEntitiesToCompanies, 'CopyCustomEntitiesToCompanies', 'Copy existing custom entities to companies custom containers', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

		-- check if there is no container of type 9517 other than default custom container

IF NOT EXISTS(SELECT 1 FROM DM2Container WHERE containerType=9517 and containerGuid<>'22CD8879-B2FD-4A63-8096-B515FC13502D')

		BEGIN

			-- for each company 

				-- create a custom container of type 9517

				-- create a parent child relationship with containerType 9520

				-- create DM2DocTags entries for each custom entity with created container

				-- give permissions to the container

					-- get any user from tenant admin group for ownership

			declare @companyId int = 0

			declare @tenant_admin_group int = 0

			declare @tenant_admin_user int = 0

			declare @tenant_admin_user_name nvarchar(256) = N''

			declare @custom_containerId int = 0

			declare @custom_container_guid nvarchar(100) = N''	

			DECLARE @DEFAULT_CUSTOM_PARENT_CONTAINER_GUID nvarchar(40) = 'B05D1D67-FCE2-493B-A7F4-5400938EAF70' -- default custom parent container guid

			DECLARE company_cursor CURSOR LOCAL FAST_FORWARD

FOR SELECT id FROM UMDSProviders WHERE serviceType=5

			OPEN company_cursor

			FETCH NEXT FROM company_cursor INTO @companyId

			WHILE @@FETCH_STATUS = 0

			BEGIN

				-- get tenant admin group for the company

SELECT TOP 1 @tenant_admin_group = id FROM UMGroups WHERE umdsProviderId = @companyId AND (groupFlags & 0x10000 = 0x10000)

				--check if tenant_admin_group exists

				IF ISNULL(@tenant_admin_group, 0) != 0

				BEGIN

					-- get any tenant admin user for above tenant group

					SELECT TOP 1 @tenant_admin_user = UG.userId, @tenant_admin_user_name=US.name FROM UMUserGroup UG INNER JOIN UMUsers US ON UG.groupId=@tenant_admin_group and UG.userId = US.id

					IF ISNULL(@tenant_admin_user, 0) != 0

					BEGIN

						-- create a custom container of type 9517

						SET @custom_container_guid = NEWID()
						INSERT INTO DM2Container (


							containerGuid, containerName, containerType,

							 userId, attribute, comment, 

							 origCommcellID, createTime) 

						VALUES (

@custom_container_guid,'Custom Entity', 9517,

							@tenant_admin_user,0, 'Custom Entity',

							0, GETUTCDATE())		        

						SELECT @custom_containerId = containerId FROM DM2Container WHERE containerGuid = @custom_container_guid

						-- parent child category hierarchy

						-- Custom parent category		        

						SELECT @parentCategoryGuid = @DEFAULT_CUSTOM_PARENT_CONTAINER_GUID

						-- Generic category

						SELECT @categoryName = 'Generic'        

						IF NOT EXISTS (SELECT 1 FROM DM2DocTags WHERE containerGuid = @parentCategoryGuid AND TagValue = @custom_container_guid) 

						BEGIN 
							INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute) 


							SELECT NEWID(), @parentCategoryGuid, @custom_container_guid, '', @tenant_admin_user, @tenant_admin_user_name, 2              

						END

						-- store ownership information

						-- get Tenant Admin, Tenant Operator and Tenant Users group for user organization

						DECLARE @permissionsList    NVARCHAR(MAX) = N''

						--          

						-- Get list of permissions depending on the entity type		        

						declare @permissions_list_table table(

							permissionId int

						)
						INSERT INTO @permissions_list_table


						SELECT DISTINCT A.capabilityId FROM UMDM2EntityCapability A, UMPermissions B

WHERE A.entityType = 9517 AND A.capabilityId = B.id

						Group By A.CapabilityId  

						DECLARE @o_ErrorCode int 

						DECLARE @o_ErrorString nvarchar(max)          		        

						DECLARE @tenant_operator_group int = 0

						DECLARE @tenant_user_group int = 0

						-- get all the tenant groups part of this organization        

SELECT @tenant_operator_group = id FROM UMGroups WHERE umdsProviderId = @companyId AND (groupFlags & 0x40000 = 0x40000)

						IF ISNULL(@tenant_operator_group,0) !=0

						BEGIN

SELECT @tenant_user_group = id FROM UMGroups WHERE umdsProviderId = @companyId AND name = 'Tenant Users' -- not aware of any group flags for tenant users group

							IF ISNULL(@tenant_user_group,0) !=0

							BEGIN

        						DECLARE @group_creator_map table(

		        					userOrGroupId int,		        	

									isCreator int	        		       

								)
        						INSERT INTO @group_creator_map values(@tenant_admin_group, 1) -- tenant admin group as creator of the container

        						INSERT INTO @group_creator_map values(@tenant_operator_group, 0)

        						INSERT INTO @group_creator_map values(@tenant_user_group, 0)


								-- set tenant parent group as creator of entity

--EXEC sec_setCreatorForEntity @tenant_admin_user, 0, @permissionsList, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @custom_containerId,0,0,0,0,0,0,0,0,@tenant_admin_group

--EXEC sec_insertSecurityAssociation @tenant_admin_user, 0, @permissionsList, 0, @tenant_operator_group, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @custom_containerId

--EXEC sec_insertSecurityAssociation @tenant_admin_user, 0, @permissionsList, 0, @tenant_user_group, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 9517, @custom_containerId
								INSERT INTO UMSecurityAssociations


									(roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId, companyId)

SELECT 0, PL.permissionId, GCM.userOrGroupId, 0, 9517, @custom_containerId, GCM.isCreator, @tenant_admin_user, @companyId

								FROM @permissions_list_table PL, @group_creator_map GCM							

							END

						END

						-- make dm2doctag relationship for all existing custom entities with new container
						INSERT INTO DM2DocTags (TagID, containerGuid, TagValue, TagDesc, ownerUserId, CreatedBy, Attribute)


						SELECT NEWID(), @custom_container_guid, EntityID, Name , @tenant_admin_user, 'Custom', 0 FROM EntityAnnotator where (Attribute is Null or Attribute = 0)

						-- clear previous entries

						DELETE FROM @permissions_list_table

						DELETE FROM @group_creator_map

					END

				END

				FETCH NEXT FROM company_cursor INTO @companyId

			END

		END		

	END

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @tblRetCode integer

