

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/DM2Cloud.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/DM2Cloud.script,v $ $Id: DM2Cloud.script,v 1.1.4.15.8.2 2021/01/16 14:23:06 pankajkumar Exp $";

GO

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @analyticsCloudUpgrade INT = 0

DECLARE @analyticsCloudVersion varchar(36) = 'A9B35649-8296-4CB5-ADD3-B9069F675606'

SELECT @analyticsCloudUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @analyticsCloudVersion

IF (@analyticsCloudUpgrade = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN

	UPDATE DM2Cloud 

	SET displayName = name 

	WHERE displayName =N''

	UPDATE DM2Cloud 

SET CloudType = (CASE WHEN (flags & 16) >0  THEN 2   --App::CloudServerType_ContentAnalyzer

WHEN (flags & 2) >0  THEN 7		--App::CloudServerType_ExchangeCloud

WHEN (flags & 4) >0  THEN 7		--App::CloudServerType_ExchangeCloud

WHEN (flags & 8) >0  THEN 8		--App::CloudServerType_VirtualCloud

						  ELSE 1				--App::CloudServerType_AnalyticsEngine

					  END) 

	WHERE CloudType =0 --App::CloudServerType_None

	UPDATE DM2SearchServerCoreInfo 

	SET DM2SearchServerCoreInfo.CloudType = d.cloudType 

	FROM DM2Cloud d 

	WHERE DM2SearchServerCoreInfo.cloudId =d.cloudId

	UPDATE DM2SearchServerCoreInfo 

	SET CloudType = 3 --App::CloudServerType_SearchEngine

	WHERE  CloudType = 0 and cloudID NOT IN (SELECT cloudID FROM DM2Cloud (nolock))

	 UPDATE DM2SearchServerCoreInfo 

	 SET Portno = ISNULL(SUBSTRING(ServiceLink,LEN(ServiceLink) - CHARINDEX(':',REVERSE(ServiceLink)) + 2,5),0) 

	 WHERE Portno =0	 

	UPDATE DM2CloudRoleMaster 

	SET roleTypeDisplayName = roleTypeName 

	WHERE roleTypeDisplayName =N''	

	--cloud props

	UPDATE DM2Cloud

	SET		cloudProps =  ISNULL((SELECT 'INDEXLOCATION' as '@name', ATTRVAL AS '@value'

						FROM DM2SearchserverCoreInfo S (nolock)

						JOIN APP_ClientProp CP (nolock) ON S.clientId = CP.componentNameId

						WHERE  S.cloudId = DM2Cloud.CloudId  AND DM2Cloud.cloudType = 1 AND CP.attrName = 'Analytics_index-dir' AND modified = 0					

						FOR XML PATH('cloudMetaInfos'), ROOT('CloudMetaProp')) ,N'')

	WHERE ISNULL(cloudProps,'') ='' AND cloudType =1

	--node props

	DECLARE @nodeProperties TABLE (t_clientId INT, t_name NVARCHAR(1024), T_value NVARCHAR(1024))
	INSERT INTO @nodeProperties


	SELECT ClientId, 'ISENABLED', (CASE WHEN ATTRVAL = '1' THEN 'true' ELSE 'false' END)

	FROM DM2SearchServerCoreInfo (NOLOCK)

	JOIN APP_ClientProp  (NOLOCK) ON componentNameId = ClientId

	WHERE attrName ='AnalyticSearchEngineEnabled' AND modified = 0

			AND ISNULL(NodeProps,'') ='' AND cloudType =1
	INSERT INTO @nodeProperties


	SELECT ClientId, 'JVMMAXMEMORY', ATTRVAL

	FROM DM2SearchServerCoreInfo (NOLOCK)

	JOIN APP_ClientProp  (NOLOCK) ON componentNameId = ClientId

	WHERE attrName ='Analytics_Memory_MB' AND modified = 0

		AND ISNULL(NodeProps,'') ='' AND cloudType =1
	INSERT INTO @nodeProperties


	SELECT ClientId, 'PORTNO', ATTRVAL

	FROM DM2SearchServerCoreInfo (NOLOCK)

	JOIN APP_ClientProp  (NOLOCK) ON componentNameId = ClientId

	WHERE attrName ='Analytics_baseport' AND modified = 0

		AND ISNULL(NodeProps,'') ='' AND cloudType =1
	INSERT INTO @nodeProperties


	SELECT ClientId, 'INDEXLOCATION', ATTRVAL

	FROM DM2SearchServerCoreInfo (NOLOCK)

	JOIN APP_ClientProp  (NOLOCK) ON componentNameId = ClientId

	WHERE attrName ='Analytics_index-dir' AND modified = 0

		AND ISNULL(NodeProps,'') ='' AND cloudType =1

	UPDATE DM2SearchServerCoreInfo

	SET NodeProps =(SELECT t_name as '@name', T_value AS '@value'

					FROM @nodeProperties P WHERE P.t_clientId = DM2SearchServerCoreInfo.clientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))

	WHERE ISNULL(NodeProps,'') ='' AND cloudType =1

	UPDATE DM2SearchServerCoreInfo

	SET status = 1	

	WHERE  cloudType IN (1, 2)

	UPDATE DM2Cloud

	SET status = 1	

	WHERE  cloudType IN (1,2)

	UPDATE DM2CloudCoreRole

	SET status = 1

	WHERE status = 0
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@analyticsCloudVersion, 'SCPAnalyticsCloudUpgrade', 'Upgrade analytics Cloud', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--add tppm entries for each configured node

DECLARE @analyticsTppmUpgrade INT = 0

DECLARE @analyticsTppmVersion varchar(36) = '7676E925-6454-4D27-A2B9-D4FD7D1B215A'

SELECT @analyticsTppmUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @analyticsTppmVersion

IF (@analyticsTppmUpgrade = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN
		INSERT INTO  app_firewalltppm (tppmType, fromEntityType, fromEntityId, fromPortNumber, toEntityType, toEntityId, toPortNumber, status, tppmParams)


		SELECT DISTINCT 8, 3, clientId, 8700, 3, clientId, portNo, 1, '' --Fix for MR:206555

		FROM DM2SearchServerCoreInfo S (NOLOCK)

		JOIN APP_Client C (NOLOCK) ON S.ClientId = C.id

		WHERE cloudType IN (1,5,9) AND S.status = 1

			AND NOT EXISTS (SELECT 1 FROM app_firewalltppm WHERE fromEntityId = ClientId AND toEntityId = ClientId AND toPortNumber= portNo and cloudType IN (1,5,9))
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@analyticsTppmVersion, 'SCPAnalyticsTppmUpgrade', 'Upgrade analytics tppm', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--handle index server display name for existing setup

DECLARE @indexServerDisplayName INT = 0

DECLARE @indexServerDisplayNameVersion varchar(36) = '97AF2007-F876-4571-85ED-6CB9BB5ED618'

SELECT @indexServerDisplayName = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerDisplayNameVersion

IF (@indexServerDisplayName = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN

		UPDATE DM2Cloud 

		SET displayName = name 

		WHERE (displayName = 'N''' OR LEN(displayName) = 0) AND cloudType = 1
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerDisplayNameVersion, 'indexServerDisplayName', 'index server display name', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--update content analyzer pseudoclient information for existing setup

DECLARE @caPseudoClientId INT = 0

DECLARE @caPseudoClientIdVersion varchar(36) = '334ED879-5C8A-4668-88C8-85FC33EC7B99'

SELECT @caPseudoClientId = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @caPseudoClientIdVersion

IF (@caPseudoClientId = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN

		UPDATE DM2Cloud 

		SET pseudoclientid = C.id

		FROM APP_Client C (NOLOCK)

		WHERE DM2Cloud.cloudType = 2 AND DM2Cloud.pseudoclientid = 0 AND C.name = DM2Cloud.name
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@caPseudoClientIdVersion, 'UpdateContentAnalyzerPseudoClientId', 'update content analyzer PseudoClientId', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--handle index server cluster type for existing setup

DECLARE @indexServerClusterType INT = 0

DECLARE @indexServerClusterTypeVersion varchar(36) = '04C498AB-1713-42E7-BC49-C6096BA315B6'

SELECT @indexServerClusterType = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerClusterTypeVersion

IF (@indexServerClusterType = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN
		INSERT INTO APP_InstanceProp (componentNameId,attrName, attrType, attrVal,created, modified)


SELECT S.instance, 'Distributed Cluster Type', 2, CP.attrval, dbo.getUnixTime(GETDATE()),0

		FROM APP_Application S (NOLOCK)

JOIN APP_clientProp CP(NOLOCK) ON S.clientId = CP.componentNameId AND CP.attrName='Index Server Type' AND attrval in (6, 7)

		LEFT JOIN APP_InstanceProp I (NOLOCK) ON S.instance = I.componentNameId

		WHERE I.attrName = 'Distributed Cluster Type' AND I.modified =0 AND I.componentNameId IS NULL

		UPDATE APP_clientProp 

SET attrval = 15

WHERE attrname = 'Index Server Type' AND attrval in (6, 7) AND modified = 0
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerClusterTypeVersion, 'indexServerClusterTypeVersion', 'update index server cluster type', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--handle existing HAC Cluster configuration

DECLARE @HACClusterCloudMode INT = 0

DECLARE @HACClusterCloudVersion varchar(36) = '728D584E-CB28-4E3B-AF5F-06595EEE1008'

SELECT @HACClusterCloudMode = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @HACClusterCloudVersion

IF (@HACClusterCloudMode = 0)            -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN	
		INSERT INTO DM2Cloud (commCellId,name,description,flags,createTime,CloudType,zookeeperCloudId,CloudProps,displayName,attribute,modifiedTime,status,pseudoClientId,indexServerPoolClientId)


SELECT DISTINCT 2, C.name, '', 1, dbo.GetUnixTime (GETUTCDATE()), 6, 0, '', C.displayName, 0, 0, 1, C.Id ,0

		FROM APP_Client C (NOLOCK)

		JOIN APP_ClientProp CP (NOLOCK) ON C.Id=CP.componentNameId

		LEFT JOIN DM2Cloud DC (NOLOCK) ON C.id = DC.pseudoClientId

WHERE CP.attrName = 'Index Server Type' AND CP.attrVal = 12 AND CP.modified = 0 AND DC.pseudoClientId IS NULL

		 --Get HAC Cluster client and nodes						

		 IF object_id('tempdb.dbo.#tmpHACClientXML') IS NOT NULL drop table #tmpHACClientXML

			CREATE TABLE #tmpHACClientXML(t_clientId     integer primary key,                

						t_zkNodesXml XML

						)
			INSERT INTO #tmpHACClientXML (t_clientId,t_zkNodesXml)


			SELECT DISTINCT  cp.componentNameId,  SUBSTRING(attrVal, CHARINDEX('>', attrVal)+1, LEN(attrVal)) 

			FROM APP_ClientProp cp(NOLOCK)

			WHERE attrName = 'HAC Cluster Nodes'  AND cp.modified =0

			IF object_id('tempdb.dbo.#tmpHACNodesClient') IS NOT NULL drop table #tmpHACNodesClient

			create table #tmpHACNodesClient(t_pseudoClientId      integer,                        

								t_zkNodeClientId           integer,

								t_zkNodeStatus		INT DEFAULT 3,

								t_zkNodeListenerPort INT DEFAULT 0,   

								t_ZKDataPort	INT DEFAULT 0,

								t_zkElectionPort INT DEFAULT 0,

								t_zkServerID    INT DEFAULT 0,

								t_zkDataDir NVARCHAR(1024),

								t_zkNodeMetaInfos NVARCHAR(2048) DEFAULT ''

								)
			INSERT INTO #tmpHACNodesClient(t_pseudoClientId,t_zkNodeClientId)


			SELECT DISTINCT C.t_clientId, a.value('(@val)[1]', 'int') 

			FROM #tmpHACClientXML C

			CROSS APPLY C.t_zkNodesXml.nodes('App_ClientList/clientId') rc(a)

			WHERE        a.value('@val', 'int') IS NOT NULL   

		--Get ZK node properties 

			IF object_id('tempdb.dbo.#zkNodeProperties') IS NOT NULL drop table #zkNodeProperties

			create table #zkNodeProperties (clientId INT,attVal NVARCHAR(1024), attName NVARCHAR(1024))
			INSERT INTO #zkNodeProperties


			SELECT DISTINCT CP.componentNameId, CP.attrVal,CP.attrName

			FROM APP_ClientProp AS CP (NOLOCK)    

			JOIN #tmpHACNodesClient T ON CP.componentnameId = T.t_zkNodeClientId

			WHERE CP.attrName IN ('Zookeeper Installation Status', 'Zookeeper Listener Port', 'Zookeeper Data Port', 'Zookeeper Election Port', 'Zookeeper Server ID') 

			AND CP.modified = 0 

		--Get ZKDataDirectory
			INSERT INTO #zkNodeProperties (clientId,attVal, attName)


SELECT DISTINCT C.Id, C.jobResultDir +'/' + 'ZKData', 'zkDataDir'

			FROM APP_Client C (NOLOCK)

			JOIN #zkNodeProperties T ON C.id = T.clientId

		--Get ZK node pivot properties 

			IF object_id('tempdb.dbo.#zkNodePivotProperties') IS NOT NULL drop table #zkNodePivotProperties

			create table #zkNodePivotProperties (    

										clientId      INT,		

										t_zkNodeStatus	INT,

										t_zkNodeListenerPort INT ,   

										t_ZKDataPort	INT ,

										t_zkElectionPort INT ,

										t_zkServerID    INT                          

									  )

			INSERT #zkNodePivotProperties (clientId, t_zkNodeStatus, t_zkNodeListenerPort, t_ZKDataPort, t_zkElectionPort, t_zkServerID)

			SELECT clientId,					   

					   ISNULL([Zookeeper Installation Status],1) AS t_zkNodeStatus, -- if value doesnt exists, default it to success 1.

					   [Zookeeper Listener Port] AS t_zkNodeListenerPort,

					   [Zookeeper Data Port] AS t_ZKDataPort,

					   [Zookeeper Election Port] AS t_zkElectionPort,

					   [Zookeeper Server ID] AS t_zkServerID

				FROM (

					SELECT  clientId, attVal, attName FROM #zkNodeProperties

					) AS ZKNodeList

				PIVOT ( MAX( attVal ) FOR attName IN ( [Zookeeper Installation Status], [Zookeeper Listener Port],[Zookeeper Data Port], [Zookeeper Election Port], [Zookeeper Server ID] ) 

				) AS P

			UPDATE #zkNodeProperties

SET attName =  (CASE WHEN attName = 'Zookeeper Listener Port' THEN 'zkListenerPort'

WHEN attName = 'Zookeeper Data Port' THEN 'zkDataPort'

WHEN attName = 'Zookeeper Election Port' THEN 'zkElectionPort'

WHEN attName = 'Zookeeper Server ID' THEN 'zkServerId'

WHEN attName = 'Zookeeper Installation Status' THEN 'zkNodeStatus'

																ELSE attName

															END)

			UPDATE #tmpHACNodesClient

			SET t_zkNodeStatus = ZK.t_zkNodeStatus,

			t_zkNodeListenerPort = ZK.t_zkNodeListenerPort,

			t_ZKDataPort = ZK.t_ZKDataPort,

			t_zkElectionPort = ZK.t_zkElectionPort,

			t_zkServerID = ZK.t_zkServerID,

			t_zkNodeMetaInfos =(SELECT attName as '@name', attVal AS '@value'

							FROM #zkNodeProperties P WHERE P.clientId = t_zkNodeClientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))

			FROM #zkNodePivotProperties ZK

			WHERE clientId = t_zkNodeClientId
			INSERT INTO DM2SearchServerCoreInfo


						(

							CoreName, CommCellId, CloudId, ClientId,

							CreateTime,

							SoftState, Enabled,

							Attributes,

							ServiceLink, CoreRoles,

							CollectionSize, FreeSpace, OccupiedSpace,

							Description,

							skippedItems, failedItems, numFiles, numEmails, status, cloudType, portNo, nodeProps, modifiedTime

						)

			SELECT 'Cloud_' + CAST(C.CloudId as varchar(10)) + '_Client_' + CAST(N.t_zkNodeClientId as varchar(10)) + '_Core', C.CommCellId, C.CloudId, N.t_zkNodeClientId,

							getutcdate(),

							1, 1,

							0,  '', 24 ,

							0, -1, 0,

'', 0, 0, 0, 0, ISNULL(t_zkNodeStatus, 3), 6, 0, t_zkNodeMetaInfos,0

			FROM DM2Cloud C

			JOIN #tmpHACNodesClient N ON C.pseudoClientId = N.t_pseudoClientId

LEFT JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.ClientId = N.t_zkNodeClientId AND S.cloudType = 6

			WHERE S.ClientId IS NULL

		IF object_id('tempdb.dbo.#zkNodeProperties') IS NOT NULL drop table #zkNodeProperties

		IF object_id('tempdb.dbo.#zkNodePivotProperties') IS NOT NULL drop table #zkNodePivotProperties

		IF object_id('tempdb.dbo.#tmpHACClientXML') IS NOT NULL drop table #tmpHACClientXML

		IF object_id('tempdb.dbo.#tmpHACNodesClient') IS NOT NULL drop table #tmpHACNodesClient

		--rename existing entries for zookeeper into app_clientprop table to _old

		UPDATE APP_ClientProp

		SET AttrName = AttrName + '_Old'

		WHERE AttrName IN ('Zookeeper Installation Status','Zookeeper Listener Port','Zookeeper Data Port','Zookeeper Election Port','Zookeeper Server ID','HAC Cluster Nodes')
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@HACClusterCloudVersion, 'HACClusterCloudVersion', 'update HAC Cluster to cloud mode', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--newer version 

DECLARE @indexServerDefaultNodeVersionNew varchar(36) = '4EA187B4-1721-4004-A521-5CE72393DABA'

--delete duplicate index server node meta infos

DECLARE @delDupicateISMetaInfoVersion varchar(36) = 'EA7F2DDF-DDA9-4BD0-B792-7A99210B21CC'

DECLARE @delDupicateISMetaInfo INT = 0

SELECT @delDupicateISMetaInfo = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @delDupicateISMetaInfoVersion

--Mark existing index server node as default node

DECLARE @indexServerDefaultNodeVersion varchar(36) = '42623EBF-8E12-4666-AF7A-8E560278DD71'

DECLARE @indexServerDefaultNode INT = 0

SELECT @indexServerDefaultNode = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerDefaultNodeVersion

IF (@indexServerDefaultNode = 1)  AND  (@delDupicateISMetaInfo =0)       

BEGIN   

	--remove duplicate meta properties for standalone index server

	BEGIN TRY

	BEGIN TRAN 

	--get index server node and its properties

		DECLARE @nodePropsXML TABLE (t_cloudId INT, t_clientId INT,  t_nodeProps XML)
		INSERT INTO @nodePropsXML (t_cloudId, t_clientId, t_nodeProps)		


		SELECT cloudId, clientId, NodeProps

		FROM   DM2SearchServerCoreInfo  

WHERE  cloudType = 1

		--get node properties for each attributes

		DECLARE @nodeNameValueProp TABLE (t_cloudId INT, t_clientId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @nodeNameValueProp


		SELECT DISTINCT t_cloudId, t_clientId, ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')

		FROM  @nodePropsXML N

			CROSS APPLY N.t_nodeProps.nodes('NodeMetaProp/nodeMetaInfos') as R1(ref1)

		--REMOVE DUPLICATE PORT NO

		DELETE T

		FROM @nodeNameValueProp T JOIN DM2SearchServerCoreInfo S ON T.t_clientId = S.ClientId AND T.t_cloudId = S.CloudId

		WHERE T.t_name ='PORTNO' AND T.t_value <> S.Portno

		--REMOVE DUPLICATE JVMMAXMEMORY

		;WITH CTE AS 

		(

			SELECT rn = ROW_NUMBER() 

						OVER( 

							PARTITION BY t_cloudId , t_clientId , t_name  

							ORDER BY t_clientId ASC), * 

			FROM @nodeNameValueProp

			WHERE t_name ='JVMMAXMEMORY'

		)

		DELETE FROM cte 

		WHERE  rn > 1

		--delete unwanted properties for standalone index server

		DELETE  

		FROM @nodeNameValueProp 

		WHERE t_name IN ('zkDataDir', 'zkDataPort', 'zkElectionPort', 'zkServerId', 'zkServerInfo', 'zkListenerPort','zkNodeStatus', 'URL', 'WEBSERVER','ISENABLED','ISASSOCIATED')

		UPDATE DM2SearchServerCoreInfo 

		SET NodeProps =(SELECT t_name as '@name', T_value AS '@value'

						FROM @nodeNameValueProp P WHERE P.t_cloudId = N.cloudId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))

		FROM DM2SearchServerCoreInfo N

WHERE N.cloudType = 1
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@delDupicateISMetaInfoVersion, 'delDupicateISMetaInfoVersion', 'delete duplicate index server node meta infos', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerDefaultNodeVersionNew, 'indexServerDefaultNodeVersionNew', 'update index server node as default', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

DECLARE @indexServerDefaultNodeNew INT = 0

SELECT @indexServerDefaultNodeNew = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerDefaultNodeVersionNew

IF (@indexServerDefaultNodeNew =0)           -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN 

		--Mark existing index server node as default node

		UPDATE DM2SearchServerCoreInfo 

SET coreRoles =  coreRoles | 128

WHERE cloudType= 1

		--store Index directory at Node level for standalone index server

		--get index server properties XML

		DECLARE @indexServerPropsXML TABLE (t_cloudId INT, t_cloudProps XML, t_nodeProps XML)
		INSERT INTO @indexServerPropsXML (t_cloudId, t_cloudProps, t_nodeProps)


		SELECT C.cloudId, C.CloudProps, S.NodeProps

		FROM   DM2SearchServerCoreInfo S JOIN DM2Cloud C ON C.CloudId = S.cloudId

WHERE  C.cloudType = 1

		--get node properties for each attributes

		DECLARE @nodeNameValueMap TABLE (t_cloudId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @nodeNameValueMap


		SELECT DISTINCT t_cloudId, ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')

		FROM  @indexServerPropsXML N

			CROSS APPLY N.t_nodeProps.nodes('NodeMetaProp/nodeMetaInfos') as R1(ref1)

		--delete unwanted props 

		DELETE FROM @nodeNameValueMap WHERE t_name IN ('INDEXLOCATION', 'zkDataDir', 'zkDataPort', 'zkElectionPort', 'zkServerId', 'zkServerInfo', 'zkListenerPort', 'zkNodeStatus','URL', 'WEBSERVER','ISENABLED','ISASSOCIATED')

		--get cloud properties for each attributes

		DECLARE @cloudNameValueMap TABLE (t_cloudId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @cloudNameValueMap


		SELECT DISTINCT t_cloudId, ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')

		FROM  @indexServerPropsXML N

			CROSS APPLY N.t_cloudProps.nodes('CloudMetaProp/cloudMetaInfos') as R1(ref1)
		INSERT INTO @nodeNameValueMap (t_cloudId, t_name, t_value)		


		SELECT DISTINCT C.t_cloudId, C.t_name, C.t_value

		FROM @cloudNameValueMap C JOIN @nodeNameValueMap N on C.t_cloudId= N.t_cloudId

		WHERE C.t_name = 'INDEXLOCATION'

		UPDATE DM2SearchServerCoreInfo 

		SET NodeProps =(SELECT t_name as '@name', T_value AS '@value'

						FROM @nodeNameValueMap P WHERE P.t_cloudId = N.cloudId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))

		FROM DM2SearchServerCoreInfo N

WHERE N.cloudType = 1
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerDefaultNodeVersionNew, 'indexServerDefaultNodeVersionNew', 'update index server node as default', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--update osid for existing index server

DECLARE @indexServerOsIdUpdateVersion varchar(36) = '45D8FAD4-B975-4DB7-A103-89C095A3103F'

DECLARE @indexServerOsIdUpdate INT = 0

SELECT @indexServerOsIdUpdate = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerOsIdUpdateVersion

IF (@indexServerOsIdUpdate =0)           -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN 

		IF object_id('tempdb.dbo.#indexServerOsId') IS NOT null DROP TABLE #indexServerOsId

		CREATE TABLE #indexServerOsId  (

										t_indexServerClientId     INT,

										t_osId      INT

									  )
		INSERT INTO #indexServerOsId


		SELECT MAX(D.pseudoClientId), MAX(simOperatingSystemId)

		FROM DM2SearchServerCoreInfo S (NOLOCK)

		JOIN APP_Client C (NOLOCK) ON S.ClientId = C.id

		JOIN DM2Cloud D (NOLOCK) ON S.CloudId = D.cloudId

WHERE S.CloudType IN (1, 5)

		GROUP BY S.CloudId

		UPDATE APP_Client 

		SET simOperatingSystemId = t_osId

		FROM #indexServerOsId

		WHERE APP_Client.id = t_indexServerClientId AND simOperatingSystemId = 0
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerOsIdUpdateVersion, 'indexServerOsIdUpdate', 'update index server os id', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--exclude SLA for distributed Apps pseudo clients - Index server pool, HAC, Content analyzer

DECLARE @excludeSLAISPoolVersion varchar(36) = '5E8BDF12-8F1B-4200-B0BC-DB44EAC301F2'

DECLARE @excludeSLAISPool INT = 0

SELECT @excludeSLAISPool = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @excludeSLAISPoolVersion

IF (@excludeSLAISPool =0)           -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN 

		MERGE  App_ClientProp as Dest

            USING (SELECT DISTINCT pseudoClientId 

						FROM DM2Cloud 

WHERE CloudType IN (9,

6,

2)

				) AS Src

            on  Dest.componentNameId = Src.pseudoClientId

                AND Dest.attrName = 'Exclude from SLA'

                AND Dest.modified = 0 

            WHEN MATCHED 

                THEN UPDATE SET attrVal = '1'

            WHEN NOT MATCHED THEN

            INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

            Values( Src.pseudoClientId, 'Exclude from SLA', 2, '1', dbo.GetUnixTime(GetUTCDate()), 0, 0);
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@excludeSLAISPoolVersion, 'excludeSLAISPool', 'Exclude SLA for Index Server Pool', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

--Enable backup activity for all existing index servers

DECLARE @indexServerbackupActivityVersion varchar(36) = '3E408993-A6CA-45F0-B643-3C74EADE4624'

DECLARE @indexServerEnablebackupActivity INT = 0

SELECT @indexServerEnablebackupActivity = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexServerbackupActivityVersion

IF (@indexServerEnablebackupActivity =0)           -- not done, do the db upgrade

BEGIN   

	BEGIN TRY

	BEGIN TRAN 

		UPDATE A

		SET A.action = 2				--CVAvtivityAction::EABLEACTIVITY = 2

		FROM JMJobAction A

		JOIN DM2Cloud DC (NOLOCK) ON A.clientId = DC.pseudoClientId

		JOIN APP_Application S (NOLOCK) ON DC.pseudoClientId = S.clientId

WHERE DC.cloudType IN (1, 5)

			AND A.action =1						--CVAvtivityAction::DISABLEACTIVITY = 1

			AND A.optype =4						--backup activity

			AND A.apptype =0 AND A.appId =1			
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexServerbackupActivityVersion, 'indexServerEnablebackupActivity', 'Enable index server backup activity', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

	COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		SELECT @@ERROR, ERROR_MESSAGE()

	END CATCH	

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

