

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/DIAG_AllChangeTrackingTableTriggers.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/DIAG_AllChangeTrackingTableTriggers.script,v $ $Id: DIAG_AllChangeTrackingTableTriggers.script,v 1.1.2.1 2018/07/28 03:52:52 abilbrey Exp $';

-- This script drops, creates, and disables table triggers on all CCS Related Tables

-- for diagnostic purposes to capture all table row changes that may impact CCSDb

-- that are occurring frequently.

--====================================================================================================================

-- This script generates triggers against most of the CCS Tables shipped to the Client that are used to track CS

-- udpates against these tables.

--====================================================================================================================

SET NOCOUNT ON

DECLARE @sqlCmd NVARCHAR(MAX) = N''

DECLARE @nl NVARCHAR(4) = NCHAR(13) + NCHAR(10)

DECLARE @triggerName NVARCHAR(128) = N''

DECLARE @go NVARCHAR(10) = 'GO'  + @nl + @nl		-- note EXEC does not like GO statements

DECLARE @noExec TINYINT = 0

DECLARE @debug TINYINT = 0

IF OBJECT_ID('DIAG_TableRowChangeTracking') IS NULL

BEGIN

	PRINT 'ERROR: DIAG_TableRowChangeTracking table does not exist not creating triggers.'

	GOTO END_OF_SCRIPT

END

-- Generate and Create Triggers against the CCS Tables that check for data rows updated but incur NO DATA CHANGE

DECLARE TblCur CURSOR FOR

	SELECT

		id,

		tableName,

		primaryId

	FROM APP_CCSXMLMapping WITH(NOLOCK)

	WHERE primaryId <> ''

OPEN TblCur

DECLARE @tableType		INT = 0

DECLARE @tableName		NVARCHAR(128) = N''

DECLARE @tablePkId		NVARCHAR(128) = N''

DECLARE @tableCpkId1	NVARCHAR(128) = N''

DECLARE @tableCpkId2	NVARCHAR(128) = N''

-- Loop for tables with Primary Keys

FETCH NEXT FROM TblCur INTO @tableType, @tableName, @tablePkId

WHILE @@FETCH_STATUS = 0

BEGIN

	PRINT '-- ======== Trigger Processing: ' + @tableName + ' ========' + @nl

	SET @triggerName = @tableName + '_DIAGChangeTracking'

	SET @sqlCmd = 'IF OBJECT_ID(''' + @triggerName + ''') IS NOT NULL' + @nl

				+ 'BEGIN' + @nl

				+ '	PRINT ''-- Executing Operation: DROP TRIGGER ' +  @triggerName + '''' + @nl

				+ '	DROP TRIGGER ' + @triggerName + @nl

				+ 'END' + @nl

	IF (@debug > 0)

	BEGIN

		PRINT @sqlCmd

		PRINT 'GO' + @nl + @nl

	END

	IF (@noExec = 0)

	BEGIN

		EXEC(@sqlCmd)

		PRINT  @nl

	END

	SET @sqlCmd = 'CREATE TRIGGER ' + @triggerName + @nl

				+ 'ON ' + @tableName  + '

AFTER UPDATE, INSERT, DELETE

AS

BEGIN

    SET NOCOUNT ON

    DECLARE @TableType INT = ' + CAST(@tableType AS NVARCHAR(12)) + '

	DECLARE @sqlCmd	NVARCHAR(MAX) = ''''

	DECLARE @pgm	NVARCHAR(255) = ''''

	SELECT 

		@pgm = ISNULL(RTRIM(p.program_name), ''?'')

	FROM sys.sysprocesses p  WITH(NOLOCK)

	WHERE spid = @@SPID

	DECLARE @ProdBld INT = 0

	DECLARE @ProdRel INT = 0

	SELECT @ProdBld = CAST(SERVERPROPERTY(''ProductBuild'') AS INT), @ProdRel = CAST(SERVERPROPERTY(''ProductMajorVersion'') AS INT)

	IF (@ProdRel >= 13 OR (@ProdRel = 12 AND @ProdBld >= 5000))		-- SQL2016+ OR SQL2014 SP2+

	BEGIN

		SELECT 

			@sqlCmd = ISNULL(ib.event_info, '''')

		FROM sys.dm_exec_sessions s WITH(NOLOCK)

			CROSS APPLY sys.dm_exec_input_buffer(s.session_id, NULL) AS ib

		WHERE 

			s.session_id =  @@SPID

	END

	ELSE

	BEGIN

		SELECT

			@sqlCmd = ISNULL(t.text, '''')

		FROM sys.sysprocesses p WITH(NOLOCK)

			CROSS APPLY sys.dm_exec_sql_text(p.sql_handle) t

		WHERE

			p.spid =  @@SPID

	END

	DECLARE @NoDataChange TABLE (

		id		INT PRIMARY KEY

	)
	INSERT INTO @NoDataChange


		SELECT DISTINCT

			q.' + @tablePkId + '

		FROM (

				-- If rows match between inserted and deleted, than there was no data updated in the row.  

				-- Useless update operation!

				SELECT

					t.' + @tablePkId + ',

					(

						SELECT

							Cmp.* 

						FROM INSERTED Cmp

						WHERE Cmp.' + @tablePkId + ' = t.' + @tablePkId + '

						FOR XML AUTO

					) cmp

				FROM INSERTED t

				INTERSECT

				SELECT

					t.' + @tablePkId + ',

					(

						SELECT

							Cmp.* 

						FROM DELETED Cmp

						WHERE Cmp.' + @tablePkId + ' = t.' + @tablePkId + '

						FOR XML AUTO

					) cmp

				FROM DELETED  t

			) q

	DECLARE @Changes TABLE (

		id				INT PRIMARY KEY,

		opType			TINYINT,

		noDataChange	TINYINT

	)
	INSERT INTO @Changes (id, opType, noDataChange)


		SELECT DISTINCT

			i.' + @tablePkId + ',

			CASE

				WHEN d.' + @tablePkId + ' IS NULL THEN 1

				ELSE 4

			END opType,

			CASE

				WHEN ndc.id IS NULL THEN 0

				ELSE 1

			END noDataChange

		FROM INSERTED i

			LEFT OUTER JOIN DELETED d ON

				i.' + @tablePkId + ' = d.' + @tablePkId + '

			LEFT OUTER JOIN @NoDataChange ndc ON

				ndc.id = i.' + @tablePkId + '

		UNION ALL

		SELECT DISTINCT

			d.' + @tablePkId + ',

			2 opType,

			0 noDataChange

		FROM DELETED d

			LEFT OUTER JOIN INSERTED i ON

				i.' + @tablePkId + ' = d.' + @tablePkId + '

		WHERE

			i.' + @tablePkId + ' IS NULL
	INSERT INTO DIAG_TableRowChangeTracking (tblType, tblName, spid, pgmName, opType, noDataChange, xmlRow, sqlCmd)


		SELECT

			@TableType,

			''' + @tableName +''',

			@@SPID,

			@pgm,

			CASE c.opType

				WHEN 1 THEN ''Insert''

				WHEN 2 THEN ''Delete''

				ELSE ''Update''

			END,

			c.noDataChange,

			''<Records>'' +

			ISNULL(CAST((

					SELECT

						ins.* 

					FROM INSERTED ins

					WHERE ins.' + @tablePkId + ' = c.id

					FOR XML AUTO

				) AS NVARCHAR(MAX)),

				''''

			) +

			ISNULL(CAST((

					SELECT

						del.* 

					FROM DELETED  del

					WHERE del.' + @tablePkId + ' = c.id

					FOR XML AUTO

				) AS NVARCHAR(MAX)),

				''''

			)

			+ ''</Records>'',

			@sqlCmd

		FROM @Changes c

END' + @nl

	IF (@debug > 0)

	BEGIN

		PRINT @sqlCmd

		PRINT 'GO' + @nl + @nl

	END

	IF (@noExec = 0)

	BEGIN

		EXEC(@sqlCmd)

		PRINT '-- Executed Operation: CREATE TRIGGER ' + @triggerName + @nl + @nl

	END

	SET @sqlCmd = 'IF OBJECT_ID(''' + @triggerName + ''') IS NOT NULL' + @nl

				+ '	DISABLE TRIGGER ' + @triggerName + ' ON ' + @tableName + @nl

	IF (@debug > 0)

	BEGIN

		PRINT @sqlCmd

		PRINT 'GO' + @nl + @nl

	END

	IF (@noExec = 0)

	BEGIN

		EXEC(@sqlCmd)

		PRINT '-- Executed Operation: DISABLE TRIGGER ' + @triggerName + @nl + @nl

	END

	FETCH NEXT FROM TblCur INTO @tableType, @tableName, @tablePkId

END

CLOSE TblCur

DEALLOCATE TblCur

DECLARE TblCur CURSOR FOR

	SELECT

		id,

		tableName,

		cpkId1Name,

		cpkId2Name

	FROM APP_CCSXMLMapping WITH(NOLOCK)

	WHERE primaryId = ''

		AND cpkId1Name <> ''

		AND cpkId2Name <> ''

OPEN TblCur

-- Loop for Tables with composite primary keys

FETCH NEXT FROM TblCur INTO @tableType, @tableName, @tableCpkId1, @tableCpkId2

WHILE @@FETCH_STATUS = 0

BEGIN

	PRINT '-- ======== Trigger Processing: ' + @tableName + ' ========' + @nl

	SET @triggerName = @tableName + '_DIAGChangeTracking'

	SET @sqlCmd = 'IF OBJECT_ID(''' + @triggerName + ''') IS NOT NULL' + @nl

				+ 'BEGIN' + @nl

				+ '	PRINT ''-- Executing Operation: DROP TRIGGER ' +  @triggerName + '''' + @nl

				+ '	DROP TRIGGER ' + @triggerName + @nl

				+ 'END' + @nl

	IF (@debug > 0)

	BEGIN

		PRINT @sqlCmd

		PRINT 'GO' + @nl + @nl

	END

	IF (@noExec = 0)

	BEGIN

		EXEC(@sqlCmd)

		PRINT  @nl

	END

	SET @sqlCmd = 'CREATE TRIGGER ' + @triggerName + @nl

				+ 'ON ' + @tableName  + '

AFTER UPDATE, INSERT, DELETE

AS

BEGIN

    SET NOCOUNT ON

    DECLARE @TableType INT = ' + CAST(@tableType AS NVARCHAR(12)) + '

	DECLARE @sqlCmd	NVARCHAR(4000) = ''''

	DECLARE @pgm	NVARCHAR(255) = ''''

	SELECT 

		@pgm = ISNULL(RTRIM(p.program_name), ''?'')

	FROM sys.sysprocesses p WITH(NOLOCK)

	WHERE spid = @@SPID

	DECLARE @ProdBld INT = 0

	DECLARE @ProdRel INT = 0

	SELECT @ProdBld = CAST(SERVERPROPERTY(''ProductBuild'') AS INT), @ProdRel = CAST(SERVERPROPERTY(''ProductMajorVersion'') AS INT)

	IF (@ProdRel >= 13 OR (@ProdRel = 12 AND @ProdBld >= 5000))		-- SQL2016+ OR SQL2014 SP2+

	BEGIN

		SELECT 

			@sqlCmd = ISNULL(ib.event_info, '''')

		FROM sys.dm_exec_sessions s WITH(NOLOCK)

			CROSS APPLY sys.dm_exec_input_buffer(s.session_id, NULL) AS ib

		WHERE 

			s.session_id =  @@SPID

	END

	ELSE

	BEGIN

		SELECT

			@sqlCmd = ISNULL(t.text, '''')

		FROM sys.sysprocesses p WITH(NOLOCK)

			CROSS APPLY sys.dm_exec_sql_text(p.sql_handle) t

		WHERE

			p.spid =  @@SPID

	END

	DECLARE @NoDataChange TABLE (

		id1		INT,

		id2		INT,

		PRIMARY KEY(id1, id2)

	)
	INSERT INTO @NoDataChange


		SELECT DISTINCT

			q.' + @tableCpkId1 + ',

			q.' + @tableCpkId2 + '

		FROM (

				-- If rows match between inserted and deleted, than there was no data updated in the row.  

				-- Useless update operation!

				SELECT

					t.' + @tableCpkId1 + ',

					t.' + @tableCpkId2 + ',

					(

						SELECT

							Cmp.* 

						FROM INSERTED Cmp

						WHERE Cmp.' + @tableCpkId1 + ' = t.' + @tableCpkId1 + '

							AND Cmp.' + @tableCpkId2 + ' = t.' + @tableCpkId2 + '

						FOR XML AUTO

					) cmp

				FROM INSERTED t

				INTERSECT

				SELECT

					t.' + @tableCpkId1 + ',

					t.' + @tableCpkId2 + ',

					(

						SELECT

							Cmp.* 

						FROM DELETED Cmp

						WHERE Cmp.' + @tableCpkId1 + ' = t.' + @tableCpkId1 + '

							AND Cmp.' + @tableCpkId2 + ' = t.' + @tableCpkId2 + '

						FOR XML AUTO

					) cmp

				FROM DELETED  t

			) q

	DECLARE @Changes TABLE (

		id1				INT,

		id2				INT,

		opType			TINYINT,

		noDataChange	TINYINT,

		PRIMARY KEY(id1, id2)

	)
	INSERT INTO @Changes (id1, id2, opType, noDataChange)


		SELECT DISTINCT

			i.' + @tableCpkId1 + ',

			i.' + @tableCpkId2 + ',

			CASE

				WHEN d.' + @tableCpkId2 + ' IS NULL THEN 1

				ELSE 4

			END opType,

			CASE

				WHEN ndc.id1 IS NULL THEN 0

				ELSE 1

			END noDataChange

		FROM INSERTED i

			LEFT OUTER JOIN DELETED d ON

				i.' + @tableCpkId1 + ' = d.' + @tableCpkId1 + '

				AND i.' + @tableCpkId2 + ' = d.' + @tableCpkId2 + '

			LEFT OUTER JOIN @NoDataChange ndc ON

				ndc.id1 = i.' + @tableCpkId1 + '

				AND ndc.id2 = i.' + @tableCpkId2 + '

		UNION ALL

		SELECT DISTINCT

			d.' + @tableCpkId1 + ',

			d.' + @tableCpkId2 + ',

			2 opType,

			0 noDataChange

		FROM DELETED d

			LEFT OUTER JOIN INSERTED i ON

				i.' + @tableCpkId1 + ' = d.' + @tableCpkId1 + '

				AND i.' + @tableCpkId2 + ' = d.' + @tableCpkId2 + '

		WHERE

			i.' + @tableCpkId1 + ' IS NULL
	INSERT INTO DIAG_TableRowChangeTracking (tblType, tblName, spid, pgmName, opType, noDataChange, xmlRow, sqlCmd)


		SELECT

			@TableType,

			''' + @tableName +''',

			@@SPID,

			@pgm,

			CASE c.opType

				WHEN 1 THEN ''Insert''

				WHEN 2 THEN ''Delete''

				ELSE ''Update''

			END,

			c.noDataChange,

			''<Records>'' +

			ISNULL(CAST((

					SELECT

						ins.* 

					FROM INSERTED ins

					WHERE ins.' + @tableCpkId1 + ' = c.id1

						AND ins.' + @tableCpkId2 + ' = c.id2

					FOR XML AUTO

				) AS NVARCHAR(MAX)),

				''''

			) +

			ISNULL(CAST((

					SELECT

						del.* 

					FROM DELETED  del

					WHERE del.' + @tableCpkId1 + ' = c.id1

						AND del.' + @tableCpkId2 + ' = c.id2

					FOR XML AUTO

				) AS NVARCHAR(MAX)),

				''''

			)

			+ ''</Records>'',

			@sqlCmd

		FROM @Changes c

END' + @nl

	IF (@debug > 0)

	BEGIN

		PRINT @sqlCmd

		PRINT 'GO' + @nl + @nl

	END

	IF (@noExec = 0)

	BEGIN

		EXEC(@sqlCmd)

		PRINT '-- Executed Operation: CREATE TRIGGER ' + @triggerName + @nl + @nl

	END

	SET @sqlCmd = 'IF OBJECT_ID(''' + @triggerName + ''') IS NOT NULL' + @nl

				+ '	DISABLE TRIGGER ' + @triggerName + ' ON ' + @tableName + @nl

	IF (@debug > 0)

	BEGIN

		PRINT @sqlCmd

		PRINT 'GO' + @nl + @nl

	END

	IF (@noExec = 0)

	BEGIN

		EXEC(@sqlCmd)

		PRINT '-- Executed Operation: DISABLE TRIGGER ' + @triggerName + @nl + @nl

	END

	FETCH NEXT FROM TblCur INTO @tableType, @tableName, @tableCpkId1, @tableCpkId2

END

CLOSE TblCur

DEALLOCATE TblCur

END_OF_SCRIPT:

