

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/CustomAlarmProps.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- this script to handle case where alarm propties has been modfied

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON
-- TABLENAME CustomAlarmProps

print '... inserting Table: CustomAlarmProps'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME CustomAlarmProps

--http:--meyerweb.com/eric/tools/dencoder/

/*This macro has these inputs 

--1. x_reportName					- ReportName which need to be changes

--2. x_ColumnOldName				- old column name which is renamed

--3. x_ColumnOldNameDEncoded		- old column double encoded value  , generate this by perform encoding using above url

--4. x_ColumnNewName				- new column name which is renamed

--5. x_ColumnNewNameDEncoded	  	- new column double encoded value  , generate this by perform encoding using above url

*/

		 GO 



/*This macro has these inputs 

--1. x_reportName					- ReportName which need to be changes

--2. x_reportNewName				- new ReportName

*/

/*This macro has these inputs 

--1. x_oldManageURLPath					- old URL

--2. x_NewManageURLPath				- new URL

*/

/*This macro has these inputs 

--1. x_oldManageURLPath					- old URL

--2. x_NewManageURLPath				- new URL

*/

IF EXISTS (select * from sysobjects where name='UpdateCustomAlarmProp')

    DROP PROCEDURE UpdateCustomAlarmProp

GO

CREATE PROCEDURE UpdateCustomAlarmProp

@entityId INTEGER,

@reportName NVARCHAR(MAX) ,

@ColumnOldName NVARCHAR(MAX),

@ColumnOldNameDEncoded NVARCHAR(MAX),

@ColumnNewName NVARCHAR(MAX),

@ColumnNewNameDEncoded  NVARCHAR(MAX),

@reportNewName NVARCHAR(MAX)

AS

BEGIN

	SET QUOTED_IDENTIFIER ON

	IF (@entityId = 1) -- UPDATE COLUMN NAME ONLY 

	BEGIN

		DECLARE @oldColumnNameEncodedSearch NVARCHAR(MAX) 

		DECLARE @oldColumnNameSearch NVARCHAR(MAX) 

		SET @oldColumnNameSearch = '%' +@ColumnOldName +'%'

		SET @oldColumnNameEncodedSearch = '%' +@ColumnOldNameDEncoded +'%'

		IF object_id('tempdb.dbo.#updatableCustomAlarmProps') IS NOT null DROP TABLE #updatableCustomAlarmProps

		CREATE TABLE #updatableCustomAlarmProps (alarmId INT, updatedURL NVARCHAR(MAX), colTitle NVARCHAR(MAX), colMDataProp NVARCHAR(MAX), SNMPDescription  NVARCHAR(MAX), description NVARCHAR(MAX))
		INSERT INTO #updatableCustomAlarmProps


		SELECT  O.alarmId, ''

				, '', '','',''

		FROM  CustomAlarmProps O

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE reportName = @reportName                     

		UPDATE K 

		SET updatedURL = REPLACE(t.value('@alarmURL', 'NVARCHAR(MAX)'), @ColumnOldNameDEncoded, @ColumnNewNameDEncoded)

		FROM #updatableCustomAlarmProps K

		INNER JOIN     CustomAlarmProps O

		 ON K.alarmId = O.alarmId   

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE reportName = @reportName                     

		  AND PATINDEX(@oldColumnNameEncodedSearch, t.value('@alarmURL', 'NVARCHAR(MAX)')) > 0

		UPDATE K

		SET SNMPDescription = REPLACE(t.value('@SNMPDescription', 'NVARCHAR(MAX)'), @ColumnOldName, @ColumnNewName)

		FROM #updatableCustomAlarmProps K

		INNER JOIN     CustomAlarmProps O

		 ON K.alarmId = O.alarmId   

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE reportName = @reportName                     

		 AND PATINDEX(@oldColumnNameSearch, t.value('@SNMPDescription', 'NVARCHAR(MAX)')) > 0

		 UPDATE K

		SET description = REPLACE(t.value('@description', 'NVARCHAR(MAX)'), @ColumnOldName, @ColumnNewName)

		FROM #updatableCustomAlarmProps K

		INNER JOIN     CustomAlarmProps O

		 ON K.alarmId = O.alarmId   

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE reportName = @reportName                     

		 AND PATINDEX(@oldColumnNameSearch, t.value('@description', 'NVARCHAR(MAX)')) > 0

		UPDATE U

		SET colTitle = REPLACE(m.value('@title', 'NVARCHAR(MAX)'), @ColumnOldName, @ColumnNewName),

			colMDataProp = REPLACE(m.value('@mDataProp', 'NVARCHAR(MAX)'), @ColumnOldName, @ColumnNewName)

		FROM CustomAlarmProps K  

		INNER JOIN     #updatableCustomAlarmProps U

			 ON K.alarmId = U.alarmId               

		CROSS APPLY K.extendedProps.nodes('//./alarmColList') B(m)

		WHERE PATINDEX(@oldColumnNameSearch,  m.value('@title', 'NVARCHAR(MAX)')) > 0

		UPDATE CustomAlarmProps

		SET extendedProps.modify('replace value of (/alarmProps/@alarmURL)[1] with sql:column("S.updatedURL")') 

		FROM CustomAlarmProps O

		INNER JOIN     #updatableCustomAlarmProps S

		ON O.alarmId = S.alarmId AND LEN(S.updatedURL)>0

		UPDATE CustomAlarmProps

		SET extendedProps.modify('replace value of (/alarmProps/@description)[1] with sql:column("S.description")') 

		FROM CustomAlarmProps O

		INNER JOIN     #updatableCustomAlarmProps S

		ON O.alarmId = S.alarmId AND LEN(S.description)>0

		UPDATE CustomAlarmProps

		SET extendedProps.modify('replace value of (/alarmProps/@SNMPDescription)[1] with sql:column("S.SNMPDescription")') 

		FROM CustomAlarmProps O

		INNER JOIN     #updatableCustomAlarmProps S

		ON O.alarmId = S.alarmId AND LEN(S.SNMPDescription)>0

		UPDATE CustomAlarmProps

			SET extendedProps.modify('replace value of (//./alarmColList/@title[.=sql:variable("@ColumnOldName")])[1] with sql:column("S.colTitle")')

		FROM   CustomAlarmProps O

		INNER JOIN     #updatableCustomAlarmProps S

		ON O.alarmId = S.alarmId  AND LEN(S.colTitle)>0

		UPDATE CustomAlarmProps

			SET extendedProps.modify('replace value of (//./alarmColList/@mDataProp[.=sql:variable("@ColumnOldName")])[1] with sql:column("S.colMDataProp")')   

		FROM   CustomAlarmProps O

		INNER JOIN     #updatableCustomAlarmProps S

		ON O.alarmId = S.alarmId  AND LEN(S.colMDataProp)>0

		IF object_id('tempdb.dbo.#updatableCustomAlarmProps') IS NOT null DROP TABLE #updatableCustomAlarmProps

	END

	ELSE IF (@entityId = 2) -- Rename report

	BEGIN

		UPDATE CustomAlarmProps

		SET reportName = @reportNewName,

			extendedProps.modify('replace value of (/alarmProps/@reportName)[1] with sql:variable("@reportNewName")')

		WHERE reportName = @reportName

	END

	ELSE IF (@entityId = 3) -- UPDATE manageURL 

	BEGIN

		IF object_id('tempdb.dbo.#updatablemanageURL') IS NOT null DROP TABLE #updatablemanageURL

		CREATE TABLE #updatablemanageURL (alarmId INT, manageURL NVARCHAR(MAX))

		DECLARE @oldPathSyntax NVARCHAR(MAX)  =@reportName

		DECLARE @NewPathSyntax NVARCHAR(MAX)  =@reportNewName

		DECLARE @oldPathSyntaxSearch NVARCHAR(MAX) 

		SET @oldPathSyntaxSearch = '%' +@oldPathSyntax +'%'
		INSERT INTO #updatablemanageURL


		SELECT  O.alarmId, ''				

		FROM  CustomAlarmProps O

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		UPDATE K 

		SET manageURL = REPLACE(t.value('@manageURL', 'NVARCHAR(MAX)'), @oldPathSyntax, @NewPathSyntax)

		FROM #updatablemanageURL K

		INNER JOIN     CustomAlarmProps O

		 ON K.alarmId = O.alarmId   

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE PATINDEX(@oldPathSyntaxSearch, t.value('@manageURL', 'NVARCHAR(MAX)')) > 0

		UPDATE CustomAlarmProps

		SET extendedProps.modify('replace value of (/alarmProps/@manageURL)[1] with sql:column("S.manageURL")') 

		FROM CustomAlarmProps O

		INNER JOIN     #updatablemanageURL S

		ON O.alarmId = S.alarmId AND LEN(S.manageURL)>0

	END

	ELSE IF (@entityId = 4) -- UPDATE Description 

	BEGIN

		IF object_id('tempdb.dbo.#updatabledescription') IS NOT null DROP TABLE #updatabledescription

		CREATE TABLE #updatabledescription (alarmId INT, description NVARCHAR(MAX))

		DECLARE @oldDescriptionSyntax NVARCHAR(MAX)  =@reportName

		DECLARE @NewDescriptionSyntax NVARCHAR(MAX)  =@reportNewName

		DECLARE @oldDescriptionSyntaxSearch NVARCHAR(MAX) 

		SET @oldPathSyntaxSearch = '%' +@oldDescriptionSyntax +'%'
		INSERT INTO #updatabledescription


		SELECT  O.alarmId, ''				

		FROM  CustomAlarmProps O

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		UPDATE K 

		SET description = REPLACE(t.value('@description', 'NVARCHAR(MAX)'), @oldDescriptionSyntax, @NewDescriptionSyntax)

		FROM #updatabledescription K

		INNER JOIN     CustomAlarmProps O

		 ON K.alarmId = O.alarmId   

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE PATINDEX(@oldPathSyntaxSearch, t.value('@description', 'NVARCHAR(MAX)')) > 0

		UPDATE CustomAlarmProps

		SET extendedProps.modify('replace value of (/alarmProps/@description)[1] with sql:column("S.description")') 

		FROM CustomAlarmProps O

		INNER JOIN     #updatabledescription S

		ON O.alarmId = S.alarmId AND LEN(S.description)>0

		DROP TABLE #updatabledescription

		IF object_id('tempdb.dbo.#updatablealarmName') IS NOT null DROP TABLE #updatablealarmName

		CREATE TABLE #updatablealarmName (alarmId INT, alarmName NVARCHAR(MAX))
		INSERT INTO #updatablealarmName


		SELECT  O.alarmId, ''				

		FROM  CustomAlarmProps O

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		UPDATE K 

		SET alarmName = REPLACE(t.value('@alarmName', 'NVARCHAR(MAX)'), @oldDescriptionSyntax, @NewDescriptionSyntax)

		FROM #updatablealarmName K

		INNER JOIN     CustomAlarmProps O

		 ON K.alarmId = O.alarmId   

		 CROSS APPLY O.extendedProps.nodes('//./alarmProps[1]') A(t)

		WHERE PATINDEX(@oldPathSyntaxSearch, t.value('@alarmName', 'NVARCHAR(MAX)')) > 0

		UPDATE CustomAlarmProps

		SET extendedProps.modify('replace value of (/alarmProps/@alarmName)[1] with sql:column("S.alarmName")') 

		FROM CustomAlarmProps O

		INNER JOIN     #updatablealarmName S

		ON O.alarmId = S.alarmId AND LEN(S.alarmName)>0

		UPDATE CustomAlarmProps

		SET displayname =replace (displayname,@oldDescriptionSyntax, @NewDescriptionSyntax)

		FROM CustomAlarmProps O

		INNER JOIN     #updatablealarmName S

		ON O.alarmId = S.alarmId AND LEN(S.alarmName)>0

	END

END

GO

EXEC UpdateCustomAlarmProp 1 , N'DDB Performance and Status' , N'Pending Record Deletes' , N'Pending%2520Record%2520Deletes', N'CommServe Job Records to be Deleted', N'CommServe%2520Job%2520Records%2520to%2520be%2520Deleted' ,N''

EXEC UpdateCustomAlarmProp 1 , N'DDB Disk Space Utilization' , N'Size of DDB Path' , N'Size%2520of%2520DDB%2520Path', N'Used DDB Size', N'Used%2520DDB%2520Size' ,N''

EXEC UpdateCustomAlarmProp 1 , N'DDB Disk Space Utilization' , N'Total Space of DDB Disk' , N'Total%2520Space%2520of%2520DDB%2520Disk', N'Total Path Size', N'Total%2520Path%2520Size' ,N''

EXEC UpdateCustomAlarmProp 1 , N'DDB Disk Space Utilization' , N'Free Space of DDB Disk' , N'Free%2520Space%2520of%2520DDB%2520Disk', N'Path Free Space', N'Path%2520Free%2520Space' ,N''

EXEC UpdateCustomAlarmProp 1 , N'License Usage' , N'Enterprise Backup Size' , N'Enterprise%2520Backup%2520Size', N'Backup Size', N'Backup%2520Size' ,N''

EXEC UpdateCustomAlarmProp 1 , N'License Usage' , N'Enterprise Archive Size' , N'Enterprise%2520Archive%2520Size', N'Archive Size', N'Archive%2520Size' ,N''

EXEC UpdateCustomAlarmProp 1 , N'License Usage' , N'Application Name' , N'Application%2520Name', N'License Name', N'License%2520Name' ,N''

EXEC UpdateCustomAlarmProp 1 , N'Job Details' , N'hour of' , N'hour%2520of', N'Backup Hours', N'Backup%2520Hours' ,N''

EXEC UpdateCustomAlarmProp 1 , N'Release Adoption Rate' , N'Service Pack' , N'Service%2520Pack', N'Feature Release', N'Feature%2520Release' ,N''

EXEC UpdateCustomAlarmProp 1 , N'CommCells' , N'Version' , N'Version', N'Software Version', N'Software%2520Version' ,N''

EXEC UpdateCustomAlarmProp 1 , N'Client Details' , N'Version' , N'Version', N'Software Version', N'Software%2520Version' ,N''

--Rename Individual commcell links first

EXEC UpdateCustomAlarmProp 3,N'webconsole/customreports/reportSettings.jsp?commUniId=', '','','','',N'webconsole/reportsplus/reportManager.jsp?tab=alarmsSettings&commUniId=' 
		 GO

--Rename worldwide link now

EXEC UpdateCustomAlarmProp 3,N'webconsole/customreports/reportSettings.jsp', '','','','',N'webconsole/reportsplus/reportManager.jsp?tab=alarmsSettings' 
		 GO

--Rename commcell links 

EXEC UpdateCustomAlarmProp 3,N'webconsole/reportsplus/reportManager.jsp?tab=alarmsSettings', '','','','',N'webconsole/reports/reports.jsp?report=alarmsSettings' 
		 GO

EXEC UpdateCustomAlarmProp 4,N'DR Backup Configuration', '','','','',N'DR Backup' 
		 GO

EXEC UpdateCustomAlarmProp 4,N'DR Backup Statistics', '','','','',N'DR Backup' 
		 GO

EXEC UpdateCustomAlarmProp 2,'Restore Statistics for last 90 days', '','','','','Restore Failure in the Last 90 Days' 
		 GO

EXEC UpdateCustomAlarmProp 2,'Low Disk Space', '','','','','Storage Policy Disk Usage' 
		 GO

EXEC UpdateCustomAlarmProp 2,'CommCell Version', '','','','','Version and Service Pack' 
		 GO

EXEC UpdateCustomAlarmProp 2,'DR Backup', '','','','','Disaster Recovery Backup' 
		 GO

-- Rebuild whole index cache related alerts: from SP23+ we use custom reports for the index cache health and it's necessary to change all the alert properties from this table

IF EXISTS (

	SELECT 1

	FROM CustomAlarmProps WITH(NOLOCK)

	WHERE (reportName = 'Index Cache Space Utilization' OR (reportName = 'Index Cache Location' AND extendedProps.value('(/alarmProps/@reportUniqId)[1]', 'NVARCHAR(MAX)') <> 'IndexCacheLocation'))

AND ISNULL(extendedProps.value('(/alarmProps/@templateId)[1]', 'INT'), 0) IN (3, 14, 15, 16))

BEGIN

	IF OBJECT_ID('tempdb.dbo.#tblIndexCacheAlarms') IS NOT NULL DROP TABLE #tblIndexCacheAlarms

	CREATE TABLE #tblIndexCacheAlarms (

		alarmId INT,

		alarmName NVARCHAR(MAX),

		reportUrl NVARCHAR(MAX),

		alarmUrl NVARCHAR(MAX),

		scheduleInfo NVARCHAR(MAX)

	)
	INSERT INTO #tblIndexCacheAlarms


		SELECT 

			C.AlarmId, 

			C.alarmName,

			REPLACE(

				REPLACE(

					T.alarmProps.value('(/alarmProps/@reportURL)[1]', 'NVARCHAR(MAX)'),

					'$ENTITY_ID$',

					CASE C.templateId

WHEN 3 THEN C.commUniId

WHEN 14 THEN C.ccGroupId

WHEN 15 THEN C.companyId

						ELSE 0

					END

				),

				'$WEBCONSOLE_HOSTNAME$',

				C.webconsoleUrl

			),

			REPLACE(

				T.alarmProps.value('(/alarmProps/@alarmURL)[1]', 'NVARCHAR(MAX)'),

				'$ENTITY_ID$',

				CASE C.templateId

WHEN 3 THEN C.commUniId

WHEN 14 THEN C.ccGroupId

WHEN 15 THEN C.companyId

					ELSE 0

				END

			),

			CASE 

				WHEN C.scheduleInfo IS NOT NULL THEN

					REPLACE(

						C.scheduleInfo,

						SUBSTRING(

							scheduleInfo,

							CHARINDEX('reportId=&quot;', C.scheduleInfo) + 15,

							CHARINDEX('&quot;', C.scheduleInfo, CHARINDEX('reportId=&quot;', C.scheduleInfo) + 15) - (CHARINDEX('reportId=&quot;', C.scheduleInfo) + 15)

							),

						'IndexCacheLocation'

					)

				ELSE NULL

			END

		FROM (

			SELECT 

				AlarmId, 

				REPLACE(displayName, 'Index Cache Space Utilization', 'Index Cache Location') AS alarmName, 

				extendedProps.value('(/alarmProps/@commUniId)[1]', 'NVARCHAR(MAX)') AS commUniId,

				extendedProps.value('(/alarmProps/@ccGroupId)[1]', 'NVARCHAR(MAX)') AS ccGroupId,

				extendedProps.value('(/alarmProps/@companyId)[1]', 'NVARCHAR(MAX)') AS companyId,

				extendedProps.value('(/alarmProps/@templateId)[1]', 'INT') AS templateId,

				SUBSTRING(

					extendedProps.value('(/alarmProps/@reportURL)[1]', 'NVARCHAR(MAX)'),

					1,

					PATINDEX('%/webconsole%', extendedProps.value('(/alarmProps/@reportURL)[1]', 'NVARCHAR(MAX)')) - 1) AS webconsoleUrl,

				extendedProps.value('(/alarmProps/@scheduleInfo)[1]', 'NVARCHAR(MAX)') AS scheduleInfo

			FROM CustomAlarmProps WITH(NOLOCK)

WHERE ISNULL(extendedProps.value('(/alarmProps/@templateId)[1]', 'INT'), 0) IN (3, 14, 15, 16)

		) AS C

		JOIN CustomAlarmTemplates T WITH (NOLOCK) ON C.templateId = T.templateId

WHERE (C.templateId = 3 AND C.commUniId IS NOT NULL)

OR (C.templateId = 14 AND C.ccGroupId IS NOT NULL)

OR (C.templateId = 15 AND C.companyId IS NOT NULL)

OR C.templateId = 16

	-- Update scheduleInfo reportId to match new report name IndexCacheLocation

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@scheduleInfo)[1] with sql:column("T.scheduleInfo")')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	WHERE T.scheduleInfo IS NOT NULL

	-- Change alarm columns

	UPDATE C

	SET extendedProps.modify('delete (/alarmProps/alarmColList)')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	UPDATE C

	SET extendedProps.modify('

		insert 

		(

			<alarmColList renderer="" visible="1" mDataProp="Media Agent" dataType="String" index="5" title="Media Agent" />,

			<alarmColList renderer="" visible="1" mDataProp="Index Cache Path" dataType="String" index="6" title="Index Cache Path" />,

			<alarmColList renderer="" visible="1" mDataProp="Type" dataType="String" index="7" title="Type" />,

			<alarmColList renderer="" visible="1" mDataProp="Index Cache Size" dataType="Long" index="8" title="Index Cache Size" />,

			<alarmColList renderer="" visible="1" mDataProp="Free Disk Space" dataType="Long" index="9" title="Free Disk Space" />,

			<alarmColList renderer="" visible="1" mDataProp="Capacity" dataType="Long" index="10" title="Capacity" />,

			<alarmColList renderer="" visible="1" mDataProp="Disk Usage (%)" dataType="Integer" index="18" title="Disk Usage (%)" />,

			<alarmColList renderer="" visible="1" mDataProp="Date to be Full" dataType="TimeStamp" index="19" title="Date to be Full" />,

			<alarmColList renderer="" visible="1" mDataProp="Status" dataType="String" index="24" title="Status" />,

			<alarmColList renderer="" visible="1" mDataProp="Remarks" dataType="Integer" index="25" title="Remarks" />

		)

		into (/alarmProps)[1]')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	-- Change alarm name 

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@alarmName)[1] with sql:column("T.alarmName")')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	WHERE T.alarmName IS NOT NULL

	-- Change report URL

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@reportURL)[1] with sql:column("T.reportUrl")')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	WHERE T.reportUrl IS NOT NULL

	-- Change alarm URL

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@alarmURL)[1] with sql:column("T.alarmUrl")')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	WHERE T.alarmUrl IS NOT NULL

	-- Change report name to Index Cache Location

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@reportName)[1] with "Index Cache Location"')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	-- Change report enum to CustomReports

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@reportEnum)[1] with "CustomReports"')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	-- Change reportUniqId

	UPDATE C

	SET extendedProps.modify('replace value of (/alarmProps/@reportUniqId)[1] with "IndexCacheLocation"')

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

	-- Change alarm name

	UPDATE C

	SET reportName = 'Index Cache Location',

		displayName = T.alarmName

	FROM CustomAlarmProps C

	JOIN #tblIndexCacheAlarms T ON C.AlarmId = T.alarmId

END

