

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/CreateClientCheckReadiness_WF.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

BEGIN TRY

	DECLARE @ProcessTran INT

	SET @ProcessTran = 0

	IF (@@TRANCOUNT = 0)

	BEGIN

		BEGIN TRANSACTION CreateClientWF

		SET @ProcessTran = 1

	END

	DECLARE @nowTime int

	SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

	DECLARE @name nvarchar(255)

	DECLARE @description nvarchar(MAX)

	DECLARE @definition nvarchar(MAX)

	DECLARE @workflowId int

	DECLARE @version INT

	DECLARE @flags INT

	DECLARE @currentFlags INT

	DECLARE @errCode INT = 0

	DECLARE @errStr varchar(1024) ='Success'

	DECLARE @revision nvarchar(255)

	DECLARE @currentRevision nvarchar(255)

	SET @revision = '$Revision: 1.1.2.7.8.1 $'

	SET @name = 'Client Check Readiness'

	SET @description = 'Performs Check Readiness on every client'

	SET @version = 1

	SET @flags = 6

	SET @definition =

	'<workflow apiMode="0" config="&lt;configuration /&gt;" description="Performs Check Readiness on every client" executeOnWeb="0" inputs="&lt;inputs&gt;&lt;ClientIdList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&lt;/ClientIdList&gt;&lt;/inputs&gt;" interactive="0" isHtmlDescription="0" manualPercentageComplete="0" name="Client Check Readiness" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.7.8.1 $" tags="" uniqueGuid="66255553-493e-4317-a9ec-53e03448fe33" variables="&lt;variables /&gt;" webHidden="0" workflowId="125">

		<schema>

		<inputs attribute="0" className="" name="inputs" type="">

		  <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="ClientIdList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

		</inputs>

		<variables className="" name="variables" type="" />

		<outputs className="" name="outputs" type="" />

		<config className="" name="configuration" type="" />

	  </schema>

	  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="112" y="241">

		<inputs val="&lt;inputs /&gt;" />

		<transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="141" sourceY="259" status="0" style="defaultEdge" targetX="185" targetY="433" transitionIndex="0" x="0" y="0">

		  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

		</transition>

	  </Start>

	  <Activity commented="0" continueOnFailure="0" created="1558335160439" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="648" y="242">

		<inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

	  </Activity>

	  <Activity commented="0" continueOnFailure="0" created="1559215648820" description="" displayName="Execute" height="34" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_1" waitSetting="0" width="100" x="393" y="242">

		<inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row/col}&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

		<transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="443" sourceY="259" status="0" style="defaultEdge" targetX="521" targetY="451" transitionIndex="0" x="0" y="0">

		  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

		</transition>

		</Activity>

		<Activity commented="0" continueOnFailure="0" created="1575914442467" description="executes queries against a commcell database" displayName="CommServDBQuery" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="143" x="194" y="415">

		<onEnter language="1" script="xpath:{/workflow/inputs/ClientIdList}" />

		<inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;SET NOCOUNT ON&amp;#xD;&#xD;&#xA;BEGIN TRANSACTION&amp;#xD;&#xD;&#xA;DECLARE @clientIdList VARCHAR(MAX) &amp;#xD;&#xD;&#xA;SET @clientIdList = ?&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @ErrorCode INTEGER&amp;#xD;&#xD;&#xA;IF (LEN(@clientIdList) = 0)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;IF NOT EXISTS (select * from GXGlobalParam where name = ''ClientCheckReadinessWFJobCount'')&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;       INSERT INTO GXGlobalParam (name, value, created, modified)&amp;#xD;&#xD;&#xA;       select ''ClientCheckReadinessWFJobCount'',0,(datediff(second, ''01/01/1970'', GetUTCdate())),0&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @csTimeZone    NVARCHAR(1024) = ''''&amp;#xD;&#xD;&#xA;SELECT  @csTimeZone = dbo.GetClientTimeZone(2)&#x9;&amp;#xD;&#xD;&#xA;declare @currentCSDate DATETIME = dbo.UTCToLocalTime(getUTCDate(),@csTimeZone)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @currentTime time &amp;#xD;&#xD;&#xA;select @currentTime = convert(varchar(10),@currentCSDate, 108)&amp;#xD;&#xD;&#xA; &amp;#xD;&#xD;&#xA;IF (@currentTime &amp;gt;= ''00:00:00'' AND @currentTime &amp;lt;= ''00:59:59'')&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;UPDATE GXGlobalParam&amp;#xD;&#xD;&#xA;&#x9;SET value = 0&amp;#xD;&#xD;&#xA;&#x9;where name like ''ClientCheckReadinessWFJobCount'' and modified = 0&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @ErrorCode = @@ERROR&amp;#xD;&#xD;&#xA;IF @ErrorCode &amp;lt;&amp;gt; 0&amp;#xD;&#xD;&#xA;&#x9;GOTO EXIT_QUERY&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @WFJobInDay  INT = (SELECT Value from GXGlobalParam where name = ''ClientCheckReadinessWFJobCount'')&amp;#xD;&#xD;&#xA;declare @clientWithoutCCR INT = (SELECT COUNT(*) from App_client where status &amp;lt;&amp;gt; 2 and id &amp;gt; 1)&amp;#xD;&#xD;&#xA;declare @ClientCountForCCR INT = (@clientWithoutCCR*((@WFJobInDay+1)*10.0)/100)&amp;#xD;&#xD;&#xA;declare @PreviousItrCount INT = (@clientWithoutCCR*((@WFJobInDay*10.0)/100))&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @CCRClient table(clientId INT)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;INSERT INTO @CCRClient&amp;#xD;&#xD;&#xA;SELECT TOP (@ClientCountForCCR) id from App_client where status &amp;lt;&amp;gt; 2 and id &amp;gt; 1 order by id asc&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;delete from @CCRClient where clientId IN (&amp;#xD;&#xD;&#xA;SELECT TOP (@PreviousItrCount) clientId&amp;#xD;&#xD;&#xA;FROM @CCRClient&amp;#xD;&#xD;&#xA;ORDER BY clientId asc)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;delete from @CCRClient where clientId IN (&amp;#xD;&#xD;&#xA;select Id from&amp;#xD;&#xD;&#xA; APP_Client CR WITH (NOLOCK) &amp;#xD;&#xD;&#xA;&#x9;&#x9;where CR.status &amp;amp; 0x1000 &amp;gt; 0)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;#xD;&#xD;&#xA;IF (@WFJobInDay = 9)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;       UPDATE GXGlobalParam&amp;#xD;&#xD;&#xA;       set value = 0&amp;#xD;&#xD;&#xA;       where name = ''ClientCheckReadinessWFJobCount'' &amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;ELSE&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;       UPDATE GXGlobalParam&amp;#xD;&#xD;&#xA;       set value = @WFJobInDay + 1&amp;#xD;&#xD;&#xA;       where name = ''ClientCheckReadinessWFJobCount''&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA; SELECT @ErrorCode = @@ERROR&amp;#xD;&#xD;&#xA; IF @ErrorCode &amp;lt;&amp;gt; 0&amp;#xD;&#xD;&#xA;&#x9;GOTO EXIT_QUERY&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA; SELECT @ErrorCode = @@ERROR&amp;#xD;&#xD;&#xA; IF @ErrorCode &amp;lt;&amp;gt; 0&amp;#xD;&#xD;&#xA; GOTO EXIT_QUERY&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select CAST (''&amp;lt;App_CheckClientReadinessReq includeAllClient =&quot;0&quot;&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;processinginstructioninfo&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;user _type_=&quot;13&quot; userId=&quot;1&quot; userName=&quot;admin&quot;/&amp;gt;&amp;lt;locale _type_=&quot;66&quot; localeId=&quot;0&quot;/&amp;gt; &amp;lt;/processinginstructioninfo&amp;gt;''&amp;#xD;&#xD;&#xA;+(&amp;#xD;&#xD;&#xA;select clientId AS ''@clientId''&amp;#xD;&#xD;&#xA;from @CCRClient &amp;#xD;&#xD;&#xA;for xml path(''CCRclient''))+''&amp;#xD;&#xD;&#xA;&amp;lt;/App_CheckClientReadinessReq&amp;gt;''AS XML) AS ''InputXML''&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;ELSE&amp;#xD;&#xD;&#xA;select CAST (@clientIdList AS XML)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;EXIT_QUERY: &amp;#xD;&#xD;&#xA;IF @ErrorCode = 0&amp;#xD;&#xD;&#xA;&#x9;COMMIT TRANSACTION&amp;#xD;&#xD;&#xA;ELSE&amp;#xD;&#xD;&#xA;&#x9;ROLLBACK TRANSACTION&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&lt;/query&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/inputs/ClientIdList}&lt;/value&gt;&lt;type&gt;STRING&lt;/type&gt;&lt;/parameters&gt;&lt;/inputs&gt;" />

		<transition activity="Execute_1" commented="0" originalStyle="" points="" sourceX="265" sourceY="432" status="0" style="defaultEdge" targetX="411" targetY="270" transitionIndex="0" x="0" y="0">

		  <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

		</transition>

		</Activity>

		</workflow>'

	IF not exists (select * from WF_Definition WITH (NOLOCK) where Name = @name)

	BEGIN
		INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


		VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

		SET @workflowId = @@IDENTITY
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

	ELSE

	BEGIN

		SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

		IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

		BEGIN

			SET @version = @version + 1

			UPDATE WF_Definition

			SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

			WHERE Name = @name

			IF (@flags & 8 > 0 OR @flags & 16 > 0)

			BEGIN

				UPDATE WF_Definition 

				SET flags = @flags

				WHERE Name = @name

			END
			INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


			VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

		END

	END

	IF (@ProcessTran = 1)

	BEGIN

		COMMIT TRANSACTION CreateClientWF

		SET @ProcessTran = 0

		PRINT 'Workflow Execution is Completed Successfully'

	END

END TRY

BEGIN CATCH

        SET @errCode = ERROR_NUMBER()

        SET @errStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @errCode) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()               

		IF (@ProcessTran = 1)

		BEGIN

			ROLLBACK TRANSACTION CreateClientWF

			SET @ProcessTran = 0

        END

END CATCH   

