

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/CreateCLRFunctionsDuringUpgrade.script] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON

DECLARE @DBDataPath NVARCHAR(256) = ''

DECLARE @baseFolderPath NVARCHAR(256) = ''

DECLARE @dllPath NVARCHAR(256) = ''

DECLARE @retVal INT = 0

DECLARE @errCode INT = 0

DECLARE @isWindowsOS INT = 1

DECLARE @finalPath NVARCHAR(MAX) = ''

DECLARE @sqlQuery NVARCHAR(MAX) = ''

IF EXISTS (SELECT 1 FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1) 

BEGIN

	SELECT @isWindowsOS = Status FROM DBUpgradeSteps WHERE Step = 'IsWindowsOS'

	IF @isWindowsOS = 1

	BEGIN

		SELECT @baseFolderPath = Status FROM DBUpgradeSteps WHERE Step = 'BaseFolderPath'

		IF LEN (@baseFolderPath) > 0

		BEGIN

			SELECT @dllPath = CASE WHEN RIGHT(@baseFolderPath, 1) = '\' THEN SUBSTRING( @baseFolderPath, 1, LEN(@baseFolderPath) - 1 ) ELSE @baseFolderPath END

			SET @dllPath = @dllPath + '\dbCLR.dll'

			EXEC @retVal = appCreateCLRFunctions @dllPath

			SET @errCode = @@ERROR

			IF @errCode <> 0 OR @retVal <> 0

				GOTO CX_EXIT

		END

	END

	ELSE

	BEGIN

		DECLARE @saoEnabled TINYINT = 0

		IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'show advanced options' AND CAST(value_in_use AS INT) = 0)

		BEGIN

			EXEC ('USE MASTER; EXEC sp_configure ''show advanced options'', 1; RECONFIGURE WITH OVERRIDE;')

			SET @saoEnabled = 1

		END

		-- Would like to test a Linux configuration with enabled(1), to see if the Commserver works in CLR Strict Security mode.

		IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr strict security' AND CAST(value_in_use AS INT) = 1)

		BEGIN

			EXEC ('USE MASTER; EXEC sp_configure ''clr strict security'', 0; RECONFIGURE;')

		END

		IF (@saoEnabled = 1)

		BEGIN

			-- only disable if this script enabled it.

			EXEC ('USE MASTER; EXEC sp_configure ''show advanced options'', 0; RECONFIGURE WITH OVERRIDE;')

		END

		EXEC DbclrInstall_1_Init;

		SELECT @DBDataPath = Status FROM DBUpgradeSteps WHERE Step = 'DBDataPathUnix'

		IF LEN (@DBDataPath) > 0

		BEGIN

			SELECT @dllPath = CASE WHEN RIGHT(@DBDataPath, 1) = '/' THEN SUBSTRING( @DBDataPath, 1, LEN(@DBDataPath) - 1 ) ELSE @DBDataPath END

			SET @finalPath = @dllPath + '/cv_dbclr_safe.dll'

			SET @sqlQuery = 'CREATE ASSEMBLY dbclr FROM N''' + @finalPath + ''' WITH PERMISSION_SET = SAFE; '

			EXECUTE sp_executeSql @sqlQuery

			SET @finalPath = @dllPath + '/cv_dbclr_timezone_safe.dll'

			SET @sqlQuery = 'CREATE ASSEMBLY timezoneclr FROM N''' + @finalPath + ''' WITH PERMISSION_SET = SAFE; '

			EXECUTE sp_executeSql @sqlQuery

		END

		ELSE

		BEGIN

			RAISERROR('DBDataPathUnix not set in DBUpgradeSteps', -1, -1)

		END

		EXEC DbclrInstall_3_CommservProc;	

		EXEC ('

			ALTER PROCEDURE dbo.executeCSSetupScripts

				@GalaxyHomeDir nvarchar(255)

			AS

				DECLARE @retVal integer

			BEGIN

				SET NOCOUNT ON

				SET @retVal = 0

				SELECT @retVal

				RETURN @retVal

			END

		')

	END

END

CX_EXIT:

IF @retVal <> 0

    GOTO RETURN_PROC

SET @retVal = @errCode

RETURN_PROC:

    SELECT @retVal

GO

