

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/ConsolidateFirewallRoutes.script] ---------- 


SET QUOTED_IDENTIFIER ON

-----------------------------------------------------------------------------------------------------------------------------------------

-- 	Script 	: 	ConsolidateFirewallRoutes

--	Purpose :	This script consolidates entries in App_Firewall, App_FWOutGoingRoutes and App_Firewall to remove the usage of topologyId

--				Also it generates required assocations to go into App_FirewallRoutesTopoAssoc and App_FWOutGoingRoutesTopoAssoc			

-----------------------------------------------------------------------------------------------------------------------------------------

DECLARE @ConsolidateFirewallRules INT = 0

DECLARE @uniqueScriptID uniqueidentifier = 'BFF13E8B-24EB-49DE-B428-7FB9B6568C3A'

SET NOCOUNT ON

SELECT @ConsolidateFirewallRules = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

IF @ConsolidateFirewallRules = 0

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION

			/* We dont have multiple entries between the same client groups yet as the same group is not allowed in multiple topologies

				Also, if firewall is configured for a client group, it cannot be part of a topology

				So, we can safely associate routes to topologies */
			INSERT INTO App_FirewallRoutesTopoAssoc ([routeId], [topologyId])


			SELECT AF.id, FTA.topologyId

			FROM App_Firewall AF

			INNER JOIN APP_FirewallTopologyAssoc FTA

			ON AF.clientGroupId=FTA.groupId
			INSERT INTO App_FWOutGoingRoutesTopoAssoc ([routeId], [topologyId])


			SELECT FWOR.id, FTA.topologyId

			FROM App_FWOutGoingRoutes FWOR

			INNER JOIN APP_FirewallTopologyAssoc FTA

			ON FWOR.clientGroupId=FTA.groupId

			-- Update App_Firewall flag column 

			-- Here we know that if a client group is part of topology, we cannot explicitly configure on the group without deleting the topology

			-- So, if either of clientGroupId is part of a topology association, it is definitely in a topology

			UPDATE AF

SET AF.flag=CASE WHEN FT.flag & 1 = 1 THEN 4 ELSE 2 END

			FROM APP_Firewall AF

			INNER JOIN APP_FirewallTopologyAssoc FTA

			ON AF.clientGroupId=FTA.groupId

			INNER JOIN APP_FirewallTopology FT

			ON FTA.topologyId = FT.topologyId

			-- Update App_FWOutGoingRoutes flag column 

			UPDATE FWOR

SET FWOR.flag=CASE WHEN FT.flag & 1 = 1 THEN 4 ELSE 2 END

			FROM App_FWOutGoingRoutes FWOR

			INNER JOIN APP_FirewallTopologyAssoc FTA

			ON FWOR.clientGroupId=FTA.groupId

			INNER JOIN APP_FirewallTopology FT

			ON FTA.topologyId = FT.topologyId

			-- When multiple smart topologies are configured, we might have multiple App_FirewallOptions entries for the mnemonics

			-- We have to consolidate these to a single entry 

			-- For Smart Topology, extendedProperties xml is always default options, so they will be the same

			-- Options row for mnemonics is not needed

			DELETE APP_FirewallOptions

			WHERE clientGroupId < 0

			DECLARE @clientGroupsWithMultipleEntries TABLE (clientGroupId INTEGER)
			INSERT INTO @clientGroupsWithMultipleEntries


			SELECT clientGroupId

			FROM App_FirewallOptions

			WHERE clientGroupId<>0

			GROUP BY clientGroupId

			HAVING COUNT (*) > 1

			DELETE FO

			FROM App_FirewallOptions FO

			INNER JOIN @clientGroupsWithMultipleEntries CG

			ON FO.clientGroupId=CG.clientGroupId

			-- Now Insert one such entry with default options 

			DECLARE @firewallExtendedProperties xml = (SELECT 2 /* HTTPSA */ as '@defaultOutgoingProtocol', 1 as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
			 INSERT INTO [dbo].[App_FirewallOptions]


			 ([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])

SELECT 0, clientGroupId, 0, 8403,180,30,0,0,0,0,@firewallExtendedProperties, 4

			 FROM @clientGroupsWithMultipleEntries
        INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


        VALUES (@uniqueScriptID

				, 'ConsolidateFirewallRoutesExec'

				, 'This script consolidates entries in App_Firewall, App_FWOutGoingRoutes and App_FirewallOptions to remove the usage of topologyId. Also it generates required assocations to go into App_FirewallRoutesTopoAssoc and App_FWOutGoingRoutesTopoAssoc'

				, DATEDIFF(second,'01/01/1970',CURRENT_TIMESTAMP) 

, 16

				, 0

, (16 + 1))

		COMMIT TRANSACTION

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		ROLLBACK TRANSACTION

	END CATCH

END

SET NOCOUNT OFF
