

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/CloudArchiveStorage.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @l_nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '4F351545-A01D-47E2-A436-AB3BB15D6C22')

BEGIN

	--

	-- Check for archive storage

	-- For direct archive

	--		Disable micro pruning

	--		Set seal DDB every year

	--		Set seal and continue DDB on corruption

	-- For combined tier

	--		Set don't dedupe objects older than year.

	--

	IF OBJECT_ID('tempdb.dbo.#lt_ArchiveMountPath') is not null DROP TABLE #lt_ArchiveMountPath	

	CREATE TABLE #lt_ArchiveMountPath(

		MountPathId		INTEGER,

		MasterPoolId		INTEGER,

		isDirectArchive	TINYINT

	)
	INSERT INTO #lt_ArchiveMountPath


	SELECT 	MP.MountPathId, MP.MasterPoolId, 

			CASE WHEN 

(D.ArchiveNumber > 8 AND D.DeviceTypeId = 23)

OR (D.ArchiveNumber > 8 AND D.ArchiveNumber <> 16 AND D.DeviceTypeId = 2)

OR ((D.ArchiveNumber = 4 OR D.ArchiveNumber = 5) AND D.DeviceTypeId = 3)

			THEN 0 /*Combined tier*/ ELSE 1 /*Direct Archive*/ END	isDirectArchive		

	FROM 	(

				SELECT 	MD.DeviceId, MD.DeviceTypeId,

						CASE WHEN MDC.UserName LIKE '%@%//%' 

							THEN CAST(SUBSTRING(MDC.UserName, CHARINDEX('@', MDC.UserName, 0)+1, PATINDEX(N'%[^0-9]%',RIGHT(MDC.UserName, LEN(MDC.UserName) - CHARINDEX('@', MDC.UserName, 0)))-1) AS int)

						ELSE 0 END AS ArchiveNumber

				FROM	MMDeviceController MDC WITH (READUNCOMMITTED)

						INNER JOIN MMDevice MD WITH (READUNCOMMITTED) ON MD.DeviceId = MDC.DeviceId

WHERE	MD.DeviceTypeId in (22, 28)

OR (MDC.UserName like '%@%//%'AND MD.DeviceTypeId in (23, 2, 3))

			) AS D

			INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.DeviceId = D.DeviceId

			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId

WHERE 	(D.ArchiveNumber = 8 AND D.DeviceTypeId = 23)

OR (D.ArchiveNumber > 8 AND D.DeviceTypeId = 23)

OR ((D.ArchiveNumber = 8 OR D.ArchiveNumber = 16) AND D.DeviceTypeId = 2)

OR (D.ArchiveNumber > 8 AND D.ArchiveNumber <> 16 AND D.DeviceTypeId = 2)

OR (D.ArchiveNumber = 3 AND D.DeviceTypeId = 3)

OR ((D.ArchiveNumber = 4 OR D.ArchiveNumber = 5) AND D.DeviceTypeId = 3)

OR (D.DeviceTypeId = 28)

OR (D.DeviceTypeId = 22)

	IF @@ROWCOUNT > 0

	BEGIN

		--

		-- Disable micro pruning 

		--

		UPDATE 	MP

SET		Attribute = Attribute & ~32

		FROM	MMMountPath MP, #lt_ArchiveMountPath T

		WHERE	MP.MountPathId = T.MountPathId

				AND T.isDirectArchive = 1

		IF OBJECT_ID('tempdb.dbo.#lt_ArchiveCopy') is not null DROP TABLE #lt_ArchiveCopy	

		CREATE TABLE #lt_ArchiveCopy(CopyId	INT, SPId INT, SealStoreTaskId INT, isDirectArchive TINYINT, MinRetention INT, MaxRetention INT)
		INSERT INTO #lt_ArchiveCopy


		SELECT	AGC.id, AGC.archGroupId, AGC.SealStoreTaskId, MAX(MP.isDirectArchive), MIN(AR.retentionDays), MAX(AR.retentionDays)

		FROM	#lt_ArchiveMountPath MP

				INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED) ON MP.MasterPoolId = DPool.MasterPoolId

				INNER JOIN MMDataPath DP WITH(READUNCOMMITTED) ON DPool.DrivePoolId = DP.DrivePoolId

				INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED) ON DP.CopyId = AGC.id				

				LEFT OUTER JOIN ArchAgingRule AR WITH(READUNCOMMITTED) ON AGC.id = AR.CopyId

WHERE	AGC.dedupeFlags & (134217728 | 262144) = 262144  --Dedupe host copies

		GROUP BY AGC.id, AGC.archGroupId, AGC.SealStoreTaskId

		UPDATE 	C

		SET		MinRetention = R.MinRetention,

				MaxRetention = R.MaxRetention		

		FROM	#lt_ArchiveCopy C,

				(

					SELECT  T.CopyId, MIN(AR.retentionDays) MinRetention, MAX(AR.retentionDays) MaxRetention

					FROM 	#lt_ArchiveCopy T					

							INNER JOIN ArchCopyToGlobalPolicy CG WITH(READUNCOMMITTED) ON T.SPId = CG.globalPolicyId

							INNER JOIN ArchAgingRule AR WITH(READUNCOMMITTED) ON AR.CopyId = CG.CopyId					

					GROUP BY T.CopyId

				) AS R

		WHERE	C.CopyId = R.CopyId

		--Skip infinite copies 

		DELETE #lt_ArchiveCopy

WHERE	MinRetention = -1 AND MaxRetention = -1

		--

		-- Set seal and continue DDB on corruption

		-- Set flag to remove sealed DDBs from disk

		--

		UPDATE 	AGC

SET		dedupeFlags = dedupeFlags | 131072 & ~(33554432 | 67108864)

		FROM	ArchGroupCopy AGC, #lt_ArchiveCopy C, ArchTask T

		WHERE	AGC.id = C.CopyId

				AND C.SealStoreTaskId = T.id

				AND C.isDirectArchive = 1

				AND T.numPeriod = 0 AND T.periodType = 0

		--

		-- Seal DDB every year or half of the retention, whichever is higher.

		--

		UPDATE 	T

SET		numPeriod = CASE WHEN C.MaxRetention / 2 < 365 THEN 365 ELSE C.MaxRetention / 2 END,

periodType = 3,

				type = 1,

				active = 1

		FROM	#lt_ArchiveCopy C, ArchTask T

		WHERE	C.SealStoreTaskId = T.id

				AND C.isDirectArchive = 1

				AND T.numPeriod = 0 AND T.periodType = 0

		--

		-- For combined tier set don't dedupe objects older than x days

		--

		UPDATE	S

SET		oldestEligibleObjArchiveTime = CASE WHEN C.MaxRetention / 2 < 365 THEN 365 ELSE C.MaxRetention / 2 END

		FROM	IdxSIDBStore S,

				archCopySIDBStore CS, #lt_ArchiveCopy C

		WHERE	S.SIDBStoreId = CS.SIDBStoreId

				AND CS.copyId = C.CopyId

				AND C.isDirectArchive = 0 --combined tier

				AND S.sealedTime = 0  --skip sealed DDBs

				AND S.oldestEligibleObjArchiveTime <= 0

	END

	IF OBJECT_ID('tempdb.dbo.#lt_ArchiveMountPath') is not null DROP TABLE #lt_ArchiveMountPath

	IF OBJECT_ID('tempdb.dbo.#lt_ArchiveCopy') is not null DROP TABLE #lt_ArchiveCopy	
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('4F351545-A01D-47E2-A436-AB3BB15D6C22', 'CloudArchiveStorageScript', 'Upgrade script to set seal DDB and other opitons for cloud archive storage', @l_nowTime, 16, 0, 16 + 1)

END

