

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/CCRClientToClient.script] ---------- 


SET QUOTED_IDENTIFIER OFF

BEGIN TRY

   BEGIN TRANSACTION DelDuplicateRowtran

   SET NOCOUNT ON

   ;WITH CTE AS

    (

	   SELECT *,

			 ROW_NUMBER() OVER (PARTITION BY FromClientId,serviceType,ToClientId ORDER BY LastUpdateTime DESC) AS rn

	   FROM CCRClientToClient (NOLOCK)

	)

	DELETE  

	FROM cte

	WHERE rn != 1

	IF object_id('tempdb.dbo.#clientIdToDelete') IS NOT NULL drop table #clientIdToDelete

	create table #clientIdToDelete	(clientId		integer	)
	INSERT INTO #clientIdToDelete


	SELECT DISTINCT clientid

	   FROM siminstalledpackages (NOLOCK)

	DELETE  ccr

	FROM CCRClientToClient ccr

	LEFT OUTER JOIN #clientIdToDelete c1 on  c1.clientid = ccr.toclientid

    LEFT OUTER JOIN #clientIdToDelete c2 on  c2.clientid = ccr.fromclientId

	where

		c1.clientid is null

	or c2.clientid is null

	drop table #clientIdToDelete

	SET NOCOUNT OFF

	COMMIT TRANSACTION DelDuplicateRowtran

END TRY

BEGIN CATCH

    IF @@TRANCOUNT > 0

        ROLLBACK TRANSACTION DelDuplicateRowtran

	DECLARE @errStr nvarchar(max)   

    SET @errStr = N'Failed to delete CCRClientToClient duplicate rows. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')      

    RAISERROR(@errStr, 15, 1)

END CATCH

