

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/AutoCorrectSystemReenableDA.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/AutoCorrectSystemReenableDA.script,v $ $Id: AutoCorrectSystemReenableDA.script,v 1.1.2.2 2019/08/07 17:17:07 asenguttuvan Exp $";

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

BEGIN TRY

BEGIN TRANSACTION AutocorrectSystemReenableDATran

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

DECLARE @AutocorrectSystemDisabledDAGUID VARCHAR(50) = '486F209A-F36A-4F1C-9676-53F8E1834DF7' 

DECLARE @AutocorrectSystemDisabledDAUpgrade INT = 0

SELECT

    @AutocorrectSystemDisabledDAUpgrade = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID =  @AutocorrectSystemDisabledDAGUID   

--If already run in previous service packs

IF @AutocorrectSystemDisabledDAUpgrade =1 

BEGIN

	goto EXIT_SCRIPT

END	
INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@AutocorrectSystemDisabledDAGUID, 'AutocorrectSystemDisabledDAGUID', 'Autocorrection script to re-enable data aging on affected clients', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

IF OBJECT_ID('tempdb.dbo.#tempSystemDisabledClients') IS NOT NULL     DROP TABLE #tempSystemDisabledClients

IF OBJECT_ID('tempdb.dbo.#tempUserDisabledClients') IS NOT NULL     DROP TABLE #tempUserDisabledClients

CREATE TABLE #tempSystemDisabledClients (clientId INT NOT NULL UNIQUE, clientName nvarchar(max), lastOccurence int)

CREATE TABLE #tempUserDisabledClients (clientName nvarchar(max), lastOccurence int)

--Insert all clients where data aging was disabled improperly due to reason GUIAUDIT_PARAMS_DATA_AGING_DISABLED_ON_CLIENT
INSERT INTO #tempSystemDisabledClients


SELECT distinct CL.id, CL.name, MAX(msg.lastoccurrence)

FROM EvMsg msg with(nolock) 

INNER JOIN evParam evparam with(nolock) ON msg.id = evparam.evMsgId AND evparam.position = 1 AND msg.messageId = (1704 | (CAST(POWER(2, 24) AS BIGINT) * 85))

INNER JOIN APP_Client CL with(nolock) ON CL.name = evparam.data

INNER JOIN JMJobAction with(nolock) ON JMJobAction.clientId=CL.id

AND JMJobAction.optype = 10 --enum CVOpType PRUNE : Data aging

AND JMJobAction.action = 1 --DISABLEACTIVITY 

AND JMJobAction.apptype =0

GROUP BY CL.id, CL.name

--If there are no clients for which DA need to be reenabled.

IF NOT EXISTS (select 1 from #tempSystemDisabledClients)

BEGIN

	goto EXIT_SCRIPT

END

--Get user disabled DA operation clientname and last occurence 

--Note: GUIAUDIT_PARAMS_ACTIVITYCONTROL_ENABLE_AFTER_DELAY_IN_TIME is not handled since delay is not available for disable

DECLARE @minSystemDisabledLastOccurence INT = (SELECT MIN(lastOccurence) from #tempSystemDisabledClients)
INSERT INTO #tempUserDisabledClients


SELECT evparam.data, max(msg.lastOccurrence)

FROM EvMsg msg with(nolock) 

INNER JOIN evParam evparam with(nolock) ON msg.id = evparam.evMsgId AND evparam.position = 1 and msg.messageId = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))

INNER JOIN EvGuiAuditParameter evap with(nolock) ON evap.evmsgid = evparam.evmsgid 

INNER JOIN EvGuiAuditOperation evao with(nolock) ON evao.id = evap.opId

INNER JOIN 

(

--select operations with data aging disabled after system disabled.

SELECT evao.id as id FROM EvGuiAuditOperation evao with(nolock) 

INNER JOIN EvGuiAuditParameter evap with(nolock) ON evap.opid = evao.id  AND evap.NewValue='false' AND evap.OldValue='true'

INNER JOIN evParam evparam with(nolock) ON evap.evMsgId = evparam.evMsgId AND evparam.position = 1 AND evparam.data = 'ARCHIVEPRUNE'

INNER JOIN EvMsg msg with(nolock) ON msg.id= evap.evMsgId AND msg.lastOccurrence > @minSystemDisabledLastOccurence AND  msg.messageId = (1004 | (CAST(POWER(2, 24) AS BIGINT) * 85))

) DAdisableTable ON DAdisableTable.id=evap.opId 

GROUP BY evparam.data

--For SP18+, Update clientName column if value is "Display Name (clientName)"

update #tempUserDisabledClients 

SET clientName = 

SUBSTRING(clientName, CHARINDEX('(', clientName) + 1, CHARINDEX(')', clientName) - CHARINDEX('(', clientName)-1)

WHERE clientName like '%(%'

--Delete all user disabled clients after system disabled, from the list to reenable

DELETE #tempSystemDisabledClients 

FROM #tempSystemDisabledClients

INNER JOIN

(SELECT clientName as clientName, MAX(lastOccurence) as lastOccurence from #tempUserDisabledClients GROUP BY clientName) as UserDisabledTable 

ON #tempSystemDisabledClients.clientName=UserDisabledTable.clientName

AND #tempSystemDisabledClients.lastOccurence < UserDisabledTable.lastOccurence

--If there are no clients for which DA need to be reenabled.

IF NOT EXISTS (select 1 from #tempSystemDisabledClients)

BEGIN

	goto EXIT_SCRIPT

END

--List all clients that need data aging to be re-enabled

DECLARE @listOfClients NVARCHAR(MAX);

SELECT @listOfClients= COALESCE(@listOfClients + ',','') + clientName --Get client list without trailing comma

FROM #tempSystemDisabledClients 

--Re-Enable back all clients whose data aging is disabled.

UPDATE JMJobAction 

SET action = 2 --ENABLEACTIVITY

FROM JMJobAction 

INNER JOIN #tempSystemDisabledClients ON #tempSystemDisabledClients.clientId = JMJobAction.clientId

AND JMJobAction.optype = 10 --enum CVOpType PRUNE : Data aging

AND JMJobAction.action = 1 --DISABLEACTIVITY 

AND JMJobAction.apptype =0

--Add audit trail for tracking who re-enabled DA aging on system disabled clients.

DECLARE @paramMsgId INTEGER

DECLARE @paramData NVARCHAR(1024)

DECLARE @dataIsEvent INTEGER = 0

--Set Gui Audit Operation

DECLARE @opMsgId INTEGER = (656 | (CAST(POWER(2, 24) AS BIGINT) * 84))

DECLARE @userId INTEGER  = 0 

DECLARE @opEvMsgId INTEGER

DECLARE @opId INTEGER

SET @userId = (SELECT TOP 1 id FROM UMUsers with(nolock) WHERE flags & 0x040 <> 0)

EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT

SET @paramMsgId  = (975 | (CAST(POWER(2, 24) AS BIGINT) * 85))

EXEC EvGuiAuditSetParamData @opId, @listOfClients, @dataIsEvent

EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId

IF OBJECT_ID('tempdb.dbo.#tempSystemDisabledClients') IS NOT NULL     DROP TABLE #tempSystemDisabledClients

IF OBJECT_ID('tempdb.dbo.#tempUserDisabledClients') IS NOT NULL     DROP TABLE #tempUserDisabledClients

EXIT_SCRIPT:

COMMIT TRANSACTION AutocorrectSystemReenableDATran    

END TRY

BEGIN CATCH

	DECLARE @errStr nvarchar(max) = N'Error occured. At Line(' + CAST(ERROR_LINE() AS NVARCHAR) + N') ErrorNo(' + CAST(ERROR_NUMBER() AS NVARCHAR) + N') ErrorMsg(' + ERROR_MESSAGE() + N').'

    PRINT @errStr

    PRINT N'So Rolling back Transaction AutocorrectSystemReenableDATran.'

    IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION AutocorrectSystemReenableDATran

	RAISERROR(@errStr, 15, 1)

END CATCH

SET NOCOUNT OFF
