

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/ArchDeferredCatalogProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/******************************************************************************/

/*  Copyright (c) CommVault Systems                                           */

/*  All Rights Reserved                                                       */

/*                                                                            */

/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */

/*  The copyright notice above does not evidence any                          */

/*  actual or intended publication of such source code.                       */

/*                                                                            */

/*  File name   :   ArchDeferredCatalogProp.script                            */

/*                                                                            */

/*  Description :   Script to move the deferred catalog property to           */

/*					new V11 table   										  */

/*                                                                            */

/*  Author      :   Praveen Krishnan                                          */

/*                                                                            */

/******************************************************************************/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/ArchDeferredCatalogProp.script,v $ $Id: ArchDeferredCatalogProp.script,v 1.1 2014/09/11 18:31:34 pkrishnan Exp $";

IF EXISTS (SELECT 1 FROM archMaterializeSnapshotProp WHERE enabled = 2) --Deferred catalog property is saved in archMaterializeSnapshotProp with enabled field 2 in 10.0

BEGIN	

	BEGIN TRY

		BEGIN TRAN MOVEROWS
		INSERT INTO ArchDeferredCatalogProp


		SELECT archGroupId, 1 /*enabled*/, type, flags, startTime, sourceCopyId, deferredDays, numPeriod, dayNumber, currPeriodBegin, currPeriodEnd, calendarId, numOfReaders, prevPeriodBegin, nextPeriodEnd

		FROM archMaterializeSnapshotProp WHERE enabled = 2		

		DELETE archMaterializeSnapshotProp 

		FROM archMaterializeSnapshotProp AMPROP INNER JOIN ArchDeferredCatalogProp DCPROP ON AMPROP.archGroupId = DCPROP.archGroupId

		WHERE AMPROP.enabled = 2

		COMMIT TRAN MOVEROWS

	END TRY

	BEGIN CATCH

		IF @@TRANCOUNT > 0

			ROLLBACK TRAN MOVEROWS

		DECLARE @errStr nvarchar(max)			

		SET @errStr = N'Failed to move rows of deferred catalog property. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')		

		RAISERROR(@errStr, 16, 1)		

	END CATCH

END

