

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/ArchCopyEncProperties.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

--if SafeNet is in use move properties from MMEntityProp to this new table. 

--Get SAFNET provider id

DECLARE @KeyProviderId INT = (SELECT TOP 1 KeyProviderId FROM ArchEncKeyProvider WHERE KeyProviderType = 5 /*CVA_ENC_KEY_PROVIDER_SAFENET*/)

IF ISNULL(@KeyProviderId, 0) <> 0		

AND EXISTS(SELECT 1 FROM MMEntityProp WHERE EntityType =  2 /*MM_STORAGE_POLICY_COPY_TYPE*/  AND propertyName = 'EncSafeNetKeyUID')

BEGIN			
	INSERT INTO ArchCopyEncProperties (CopyId, PubKey, PriKey, MasterKeyId, KeyProviderId, EncType)


	SELECT  AGC.id, EP.PubKey, EP.PriKey, EP.KeyUID, @KeyProviderId, 0

	FROM	ArchGroupCopy AGC, 

			(

				SELECT	EntityId,

MAX(case when propertyName = 'EncCopyRSAPubKey' then stringVal else '' end) AS PubKey,

MAX(case when propertyName = 'EncCopyRSAPriKey' then stringVal else '' end) AS PriKey,

MAX(case when propertyName = 'EncSafeNetKeyUID' then stringVal else '' end) AS KeyUID

				FROM 	MMEntityProp 

WHERE	EntityType = 2 /*MM_STORAGE_POLICY_COPY_TYPE*/

AND propertyName IN ('EncCopyRSAPubKey', 'EncCopyRSAPriKey', 'EncSafeNetKeyUID')

				GROUP BY EntityId

			) AS EP

	WHERE	AGC.id = EP.EntityId AND EP.KeyUID <> ''

	DELETE 	MMEntityProp 

WHERE	EntityType = 2 /*MM_STORAGE_POLICY_COPY_TYPE*/

AND propertyName IN ('EncCopyRSAPubKey', 'EncCopyRSAPriKey', 'EncSafeNetKeyUID', 'EncCopyRestoreAccess')

END

