

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_WorkQueueRequestFailoverSMTP.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_WorkQueueRequestFailoverSMTP.script,v $ $Id: App_WorkQueueRequestFailoverSMTP.script,v 1.1.2.2 2020/08/19 04:43:09 mnatarajan Exp $';

--TABLENAME APP_WorkQueueRequest

SET QUOTED_IDENTIFIER ON

GO

-- One time Script to push SMTP configuration using workqueue to failover clients. 

declare @guid uniqueidentifier = 'AF0B179B-CC4B-4C15-AD78-4CE4A90A4B80'

DECLARE @workTokenId INT = 48 -- WORK_TOKEN_REFRESH_SMTP_CONFIG

DECLARE @workTokenAlert INT = 47 -- WORK_TOKEN_REFRESH_ALERT_CONFIG

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	-- Submit workqueue request to all failover nodes to refresh SMTP config.
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)


	SELECT C.Id, 

		@workTokenId,

		'',

		@curUtcDateTime, 0, 0, 0, -1

		FROM SimInstalledPackages WITH (READUNCOMMITTED) 

        INNER JOIN App_client C WITH (READUNCOMMITTED) on SimInstalledPackages.clientId = C.Id

        and (C.status&2)=0 and simPackageID = 24 --N_WIN_PACKAGE_COMMSERVE_FAILOVER

	UNION ALL

	SELECT C.Id, 

		@workTokenAlert,

		'',

		@curUtcDateTime, 0, 0, 0, -1

		FROM SimInstalledPackages WITH (READUNCOMMITTED) 

        INNER JOIN App_client C WITH (READUNCOMMITTED) on SimInstalledPackages.clientId = C.Id

        and (C.status&2)=0 and simPackageID = 24 --N_WIN_PACKAGE_COMMSERVE_FAILOVER
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'ChangeWQSMTPAssoc', 'Create workqueue requests to update SMTP config on client', @curUtcDateTime, 16, 0 , (16 + 2))

END

