

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_VSAReplicationV2UpdateSubclient.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_VSAReplicationV2UpdateSubclient.script,v $ $Id: App_VSAReplicationV2UpdateSubclient.script,v 1.1.4.3 2020/01/07 15:46:12 sjohnson Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @guid uniqueidentifier = 'D5BD64AF-BF3E-45B7-A6E8-C5A946FE1BDE'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())

DECLARE @IsTranStarted INT = 0

DECLARE @newLine    NVARCHAR(3) = NCHAR(13) -- + CHAR(10)

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	BEGIN TRY

        IF @@TRANCOUNT=0

        BEGIN

            SET @IsTranStarted = 1

            BEGIN TRAN

        END

		UPDATE App_VSAReplication

		SET subclientId = CHILD.Id,

		backupsetId = CHILD.backupSet

		FROM App_VSAReplication INNER JOIN App_Application PARENT (NOLOCK) ON App_VSAReplication.subclientId = PARENT.ID

		INNER JOIN App_ClientProp PARENTCLIENT (NOLOCK) ON PARENTCLIENT.ComponentnameId = PARENT.clientId 

		AND PARENTCLIENT.attrName='IndexingV2_VSA' AND PARENTCLIENT.modified=0 AND PARENTCLIENT.attrVal=N'1' --CV_PROP_VSA_INDEXING_V2 ensure client is VSAv2 enabled. 

		INNER JOIN APP_VMBackupSet (NOLOCK) ON PARENT.backupSet = APP_VMBackupSet.ParentBackupSetId

		INNER JOIN App_Application CHILD (NOLOCK) ON CHILD.backupSet = APP_VMBackupSet.ChildBackupSetId

		AND (CHILD.subclientstatus & (4|2))=0   --- We dont want deleted and uninstalled subclients _CV_STATUS_DELETED| CV_STATUS_UNINSTALLED

		INNER JOIN App_Clientprop CHILDCLIENT ON CHILDCLIENT.componentNameId = CHILD.clientId -- Identify the correct child client based on VM Guid. 

			AND CHILDCLIENT.attrName='Virtual Machine Instance UUID'

			AND CHILDCLIENT.modified = 0

			AND CHILDCLIENT.attrVal = App_VSAReplication.sourceGuid
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'V2FixAssocInVSAReplicationTable', 'Update child subclient for VSA clients in App_VSAReplication where indexing v2 is enabled', @curUtcDateTime, 16, 0 , (16 + 2))

		IF (@IsTranStarted=1)

        BEGIN

            COMMIT TRAN

        END

	END TRY

	BEGIN CATCH 

		DECLARE @msg NVARCHAR(2047) = @newLine + @newLine

        SET @msg += 'INSIDE CATCH BLOCK WITH FOLLOWING ERROR: ' + @newLine

        SET @msg += '   ERROR CODE: ' + CAST(ERROR_NUMBER() AS NVARCHAR(12)) + @newLine

        SET @msg += '   SQL SCRIPT: App_VSAReplicationV2UpdateSubclient' + @newLine

        SET @msg += '   ERROR LINE NO: ' + CAST(ERROR_LINE() AS NVARCHAR(12)) + @newLine

        SET @msg += '   ERROR MESSAGE: ' + ERROR_MESSAGE() + @newLine

        SET @msg += '   ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS NVARCHAR(12)) + @newLine

        SET @msg += '   ERROR STATE: ' + CAST(ERROR_STATE() AS NVARCHAR(12)) + @newLine + @newLine

        PRINT @msg

		IF (@IsTranStarted=1)

		BEGIN

			ROLLBACK TRAN

		END

		RAISERROR(@msg, 16, 1);     -- rethrow the exception

	END CATCH;	

END

GO

