

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_VMProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_VMProp.script,v $ $Id: App_VMProp.script,v 1.1.4.7 2020/06/04 04:14:36 bzhu Exp $";

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO
-- TABLENAME App_VMProp

print '... inserting Table: App_VMProp'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME App_VMProp

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @insetSocketInfoGuid    VARCHAR(40) = '8BBD1E13-3E8D-4F6A-AD78-4BFA3FD6FE17'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @insetSocketInfoGuid)

BEGIN

	DECLARE @tblBackupLevel TABLE (BackupLevel INT)
	INSERT INTO @tblBackupLevel VALUES(1)

	INSERT INTO @tblBackupLevel VALUES(1024)

	INSERT INTO @tblBackupLevel VALUES(32768)

	INSERT INTO @tblBackupLevel VALUES(64)

	INSERT INTO @tblBackupLevel VALUES(128) -- Synth full followed by incremental

	INSERT INTO @tblBackupLevel VALUES(16384)


	IF OBJECT_ID('tempdb..#VMBkpJobInfo') IS NOT NULL

	drop table #VMBkpJobInfo

	CREATE TABLE #VMBkpJobInfo (

		commcellid                  INT,

		clientId                    INT,   

		LastSuccessfulBackupJobId   BIGINT

	)
	INSERT INTO #VMBkpJobInfo


	SELECT V.commCellId,V.VMclientId, MAX(JM.jobid)  from JMBkpStats JM WITH (NOLOCK), APP_VMProp V WITH (NOLOCK) 

	WHERE   JM.jobId = V.jobId AND appType = 106 AND  bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel)

	AND status in (1, 3, 14, 16) AND dataStatus = 0  AND JM.commCellId = V.commCellId AND

	V.attrName = 'vmStatus' AND  V.attrVal IN ('0', '3')

	GROUP BY  V.VMclientId, V.commCellId
	insert into APP_VMProp 


	select LastSuccessfulBackupJobId, VM.commcellId, VM.clientId,'vmNumHostCPUSockets',2,CP.attrVal,0 from APP_ClientProp CP,#VMBkpJobInfo VM 

	where clientId=componentNameId and CP.attrName='numHostCPUSockets' 

	drop table #VMBkpJobInfo
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@insetSocketInfoGuid, 'InsertSocketInfo', 'Update script to insert socket info from client Properties table', @nowTime,  16, 0, (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'BE89E202-B4D7-47FC-A969-553D421B307D')

BEGIN

	DECLARE @count INT 

	SET @count = 1

	WHILE @count > 0

	BEGIN

		-- update ClientJobId for V2 jobs in batch

		WITH C AS

		(

			SELECT TOP 500000 VMP.ClientJobId AS dClientJobId,

				 DL.childJobId AS sClientJobId

			FROM APP_VMProp VMP 

			INNER JOIN JMJobDataLink DL ON VMP.jobid = DL.parentJobId AND VMP.commCellId = DL.commCellId

			INNER JOIN APP_Application APP ON VMP.VMclientId = APP.clientId AND DL.childAppid = APP.id

			WHERE DL.linkType = 7 AND (VMP.ClientJobId = 0 OR VMP.ClientJobId IS NULL) 

		)

		UPDATE C

		SET dClientJobId = sClientJobId

		SET @count = @@ROWCOUNT 

	END

	SET @count = 1

	WHILE @count > 0

	BEGIN

		-- update ClientJobId for V1 jobs in batch - set it to itself if no child job found

		WITH C AS

		(

			SELECT TOP 500000 ClientJobId,

				 jobid

			FROM APP_VMProp  

			WHERE ClientJobId = 0 OR ClientJobId IS NULL 

		)

		UPDATE C

		SET ClientJobId = jobid

		SET @count = @@ROWCOUNT 

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('BE89E202-B4D7-47FC-A969-553D421B307D', 'UpdateClientJobId2', 'Update script to update client Job id', @nowTime,  16, 0, (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'CB4A56DA-95AD-441C-BD3B-10EFA99BA6C6')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#vmJobInfo') IS NOT NULL

		DROP TABLE #vmJobInfo

	IF OBJECT_ID('tempdb.dbo.#vmPropInfo') IS NOT NULL

		DROP TABLE #vmPropInfo

	CREATE TABLE #vmJobInfo (vmclientID1 INT, jobID1 INT)

	CREATE TABLE #vmPropInfo (vmclientID2 INT, attrName2 NVARCHAR(1024), attrType2 INT, attrVal2 NVARCHAR(1024))

	CREATE CLUSTERED INDEX vmJobInfo_vmclientID1_IDX on #vmJobInfo(vmclientID1, jobID1)

	CREATE CLUSTERED INDEX vmPropInfo_vmclientID2_IDX on #vmPropInfo(vmclientID2)

	-- Populate #vmJobInfo
	INSERT INTO #vmJobInfo


	SELECT DISTINCT VMP.VMclientID, ACPJOB.attrVal

	FROM APP_VMProp VMP WITH(NOLOCK)

	INNER JOIN APP_ClientProp ACPVM  WITH (NOLOCK)

	ON ACPVM.componentNameId=VMP.VMclientId AND ACPVM.attrName='Virtual Server Discovered Clients' AND ACPVM.attrval='1' AND ACPVM.modified=0

	LEFT OUTER JOIN APP_ClientProp ACPJOB WITH(NOLOCK)

	ON ACPJOB.componentNameId=VMP.VMclientId AND ACPJOB.attrName='Last Backup JobID' AND ACPJOB.modified=0

	IF EXISTS(SELECT 1 FROM #vmJobInfo WHERE jobID1 IS NULL)

	BEGIN

		UPDATE #vmJobInfo

		SET jobID1 = LATESTJOB.jobId

		FROM #vmJobInfo VMI

		INNER JOIN (SELECT VMP.vmClientId, MAX(VMP.jobId) AS jobId

					FROM #vmJobInfo VMI2

					INNER JOIN APP_VMProp VMP WITH(NOLOCK) 

					ON VMI2.vmclientID1 = VMP.vmClientId 

					INNER JOIN JMBkpStats BKP

					ON VMP.jobId = BKP.jobId AND VMP.commcellId = BKP.commcellId

					WHERE VMI2.jobID1 IS NULL -- Do this join only for rows with no jobid

					GROUP BY VMP.vmClientId) LATESTJOB

		ON VMI.vmclientID1 = LATESTJOB.VMclientId

	END
	INSERT INTO #vmPropInfo (vmclientID2, attrName2, attrType2, attrVal2)


		SELECT

			VMclientId,

				CASE attrName

					WHEN 'vmDatastore' THEN 'Virtual Machine Datastore'

					WHEN 'vmHardwareVersion' THEN 'Virtual Machine Hardware Version'

					WHEN 'vmHostVersion' THEN 'Virtual Machine Host Version'

					WHEN 'vmInstanceSize' THEN 'Virtual Machine Instance Size'

					WHEN 'vmOperatingSystem' THEN 'Operating System Name'

					WHEN 'vmToolsVersion' THEN 'Virtual Machine Tools Version'

				END,

			attrType,

			attrVal

		FROM APP_VMProp VMP WITH(NOLOCK)

		INNER JOIN #vmJobInfo INF

		ON INF.vmclientID1 = VMP.vmClientId AND INF.jobID1 = VMP.jobId

		WHERE VMP.attrName IN (

		'vmDatastore',

		'vmHardwareVersion',

		'vmHostVersion',

		'vmInstanceSize',

		'vmOperatingSystem',

		'vmToolsVersion')

	-- Insert all rows from #vmPropInfo into APP_ClientProp without creating duplicates
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT VMP.vmclientID2, VMP.attrName2, VMP.attrType2, VMP.attrVal2, @nowTime, 0, 0

	FROM #vmPropInfo VMP

	INNER JOIN APP_Client CLI

	ON VMP.vmclientID2 = CLI.id

	LEFT OUTER JOIN APP_ClientProp ACP WITH(NOLOCK)

	ON ACP.componentNameId=VMP.vmclientID2 AND ACP.attrName=VMP.attrName2 AND ACP.modified=0

	WHERE ACP.attrName IS NULL
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('CB4A56DA-95AD-441C-BD3B-10EFA99BA6C6', 'MoveVMPropsToClientProp', 'Update script to move select APP_VMProp rows to APP_ClientProp', @nowTime,  16, 0, (16 + 2))

END

