

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_VMAllocationPolicy.script] ---------- 


SET QUOTED_IDENTIFIER OFF

--  +==============================================================================+

--  |       Name: App_VMAllocationPolicy

--  |       Description: Script to insert default vm allocation policy and application type for replication group assocaited policies. 

--  |             

--  |       Author: Rajesh Polimera and Prasanna Kumar TR

--  +==============================================================================+

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

BEGIN TRY

IF NOT EXISTS ( SELECT * from App_VMAllocationPolicy where name = '_NO_NAME_')

BEGIN

  DECLARE @nowTime                      int  

  Set     @nowTime                      =  datediff(second, '01/01/1970', GetUTCdate())

  declare @strDCID nvarchar(32)

  declare @dcID int =null

  select @dcID = id FROM APP_VMDataCenter where name ='_NO_NAME_'

  IF ( @dcID is not null )

  BEGIN

     set @strDCID = convert(nvarchar(32), @dcID)

     declare @inputXML xml ='<policy daysRetainUntil="-1" minNICs="1" minCores="1" minMemory="1" allDataStoresSelected="1" description="Sytem Policy to be used for internal purposes" maxDiskSpace="1024" maxVMQuota="9999" maxNICs="10" minDiskSpace="1" enabled="0" minDiscs="1" vharddisktype="1" maxMemory="1024" maxDiscs="2" maxCores="16" allESXServersSelected="1" namingPattern="*" allTemplatesSelected="1" maxSnapshots="100">

  <entity  vmAllocPolicyName="_NO_NAME_" />

</policy>'
     insert into APP_VMAllocationPolicy values ('_NO_NAME_', @dcID, 'Sytem Policy to be used for internal purposes', @inputXML, 1, @nowTime,0,1,1)


  END

END

DECLARE @VMAllocationPolicyTbl TABLE (vmPolicyId INT, policyXML XML)

--collect replication targets assocaited with periodic replication group
INSERT INTO @VMAllocationPolicyTbl 


SELECT DISTINCT TM_SubTaskOptions.value, NULL FROM TM_SubTaskOptions

        INNER JOIN TM_Subtask ON TM_SubTaskOptions.subtaskId=TM_subtask.subtaskId

        INNER JOIN TM_task ON TM_task.taskId = TM_subtask.taskID

        WHERE TM_SubTaskOptions.optionId=1008442949 --vmAllocationPolicyId property

        AND TM_subtask.subtasktype = 3

        AND TM_task.deleted=0 -- Ensure task isnt deleted

--collect replication targets assocaited with contionous replication group

DECLARE @blrReplicationTaskInfo TABLE  (taskinfoxml XML)
INSERT INTO @blrReplicationTaskInfo 


	SELECT CASE WHEN (CHARINDEX( '?xml',attrVal,1) = CHARINDEX( '<',attrVal,1)+1) 

				THEN 

					CONVERT(XML,SUBSTRING(attrVal,CHARINDEX('?>',attrVal,1)+2,LEN(attrVal)),2) 

				ELSE 

					CONVERT(XML,attrVal)

				END

			FROM App_SubclientProp WITH(NOLOCK) WHERE attrName = 'Virtual Server Block Level Replication Restore XML'

			AND modified = 0 AND attrVal IS NOT NULL

--insert only new policies which was not assocaited with periodic replication group
INSERT INTO @VMAllocationPolicyTbl 


SELECT DISTINCT taskinfoxml.value('(/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','INT'), NULL

   FROM @blrReplicationTaskInfo	

   LEFT JOIN @VMAllocationPolicyTbl PT

   ON PT.vmPolicyId = taskinfoxml.value('(/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','INT')

   WHERE PT.vmPolicyId IS NULL

UPDATE PT 

SET PT.policyXML = VP.vxml

FROM @VMAllocationPolicyTbl PT

 INNER JOIN App_VMAllocationPolicy VP ON VP.id = PT.vmPolicyId

        AND VP.name != '_NO_NAME_'  --system policy need to be skipped

        AND VP.vxml IS NOT NULL

--remove stale targets or already upgraded targets or newly created targets from sp21

DELETE PT 

FROM @VMAllocationPolicyTbl PT

WHERE PT.policyXML IS NULL OR ISNULL(PT.policyXML.value('policy[1]/@vmPolicyAppType','INT'),-1) = 0

UPDATE @VMAllocationPolicyTbl

SET policyXML.modify('delete (policy/@vmPolicyAppType)[1]')

UPDATE @VMAllocationPolicyTbl

SET policyXML.modify('insert (

								attribute vmPolicyAppType {"0"}

                             )

                         into (policy)[1]')

UPDATE VP SET VP.vxml = VMP.policyXML

	FROM App_VmAllocationPolicy VP

	INNER JOIN @VMAllocationPolicyTbl VMP	

	ON VMP.vmPolicyId = VP.id

END TRY

BEGIN CATCH

    PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

            ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

            ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

            ERROR MESSAGE: ' + ERROR_MESSAGE() + '

            ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

            ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

END CATCH
