

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_UpdateJsonForGuidedSetup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2017  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

--		  Author : Nagaraju Uppu

-- ----------------------------------------------------------------------*/

Set Nocount ON

SET QUOTED_IDENTIFIER ON

DECLARE @json NVARCHAR(MAX) = '', @jsonStr NVARCHAR(MAX) = ''

DECLARE @pos INT = 0, @id INT = 0, @NumberRecords int, @RowCount int 

DECLARE @name NVARCHAR(max)

DECLARE @r_json NVARCHAR(MAX) = ''

DECLARE @sqlScriptGUID varchar(48) = 'C4312E12-F408-4FF9-B832-FDA903ED25FA'

DECLARE @createdTime INT = dbo.getUnixtime(GETUTCDATE())

IF EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking (NOLOCK) WHERE SqlScriptGUID = @sqlScriptGUID)

GOTO ERROR_EXIST

IF OBJECT_ID('tempdb.dbo.#TenantProp') IS NOT NULL	DROP TABLE #TenantProp

CREATE TABLE   #TenantProp  (num INT IDENTITY(1,1), id INT, jsonStr nvarchar(max))

BEGIN TRY

IF EXISTS(SELECT 1 FROM App_CompanyProp (NOLOCK ) where  attrname = 'CompletedSetups')

BEGIN

BEGIN TRANSACTION UpdateO365JsonTran	
	INSERT INTO #TenantProp SELECT componentNameId, attrVal FROM App_CompanyProp (NOLOCK) where attrname = 'CompletedSetups' and modified = 0	


	SET @NumberRecords = @@ROWCOUNT

	SET @RowCount = 1

	--For each entry of office 365 Apps, append Office365:true if applicable        

    WHILE @RowCount <= 	@NumberRecords

    BEGIN

	  SELECT @id = id , @jsonStr = jsonStr FROM #TenantProp WHERE num = @RowCount 

		DECLARE @splitTable TABLE (Id INT, name nvarchar(max),value NVARCHAR(MAX))

		SET	@json = ISNULL(@jsonStr, '')

		SET @json = REPLACE(@json,'}','')

		SET @r_json = @json

		SET @json = REPLACE(@json,'{','')

		IF @json != ''

		BEGIN

			WHILE CHARINDEX(',', @json) > 0

			BEGIN

				SELECT @pos  = CHARINDEX(',', @json)  

				SELECT @name = SUBSTRING(@json, 1, @pos-1)

				SELECT @json = SUBSTRING(@json, @pos+1, LEN(@json)-@pos)

				SELECT @pos  = CHARINDEX(':', @name)
				INSERT INTO @splitTable (id, name,value) VALUES(@id, SUBSTRING(@name, 0, @pos),SUBSTRING(@name, @pos+1, LEN(@name)-@pos))


			END	

			SELECT @pos  = CHARINDEX(':', @json)
			INSERT INTO @splitTable (id, name,value) VALUES(@id, SUBSTRING(@json, 0, @pos),SUBSTRING(@json, @pos+1, LEN(@json)-@pos))


		END

		IF EXISTS (SELECT 1 FROM @splitTable WHERE id = @id AND ((name like '%EXCHANGE_ONLINE%' AND value like '%true%') OR (name like '%CAPPS_ONEDRIVE%' AND value like '%true%') OR (name like '%SHAREPOINT_ONLINE%' AND value like '%true%')))

		 AND NOT EXISTS (SELECT 1 FROM @splitTable WHERE id = @id AND name = 'OFFICE365')

		BEGIN

			SET @r_json =  @r_json + ',"OFFICE365":true}'				

			UPDATE #TenantProp SET jsonStr = @r_json Where id = @id 

		END

	SET @RowCount += 1 

    END

	UPDATE App_CompanyProp  

	SET attrVal = T.jsonStr 

	FROM #TenantProp T 

	Where componentNameId = T.id AND attrName = 'CompletedSetups' And modified = 0			
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES(@sqlScriptGUID, 'APP_Office365_UpdateCompletedSetupJSON', 'Added Office365 Package Completed', @createdTime, 16, 0 , (16+ 1))

	COMMIT TRANSACTION UpdateO365JsonTran  

END

END TRY

BEGIN CATCH

    PRINT N'Error occured. At Line(' + CAST(ERROR_LINE() AS NVARCHAR) + N') ErrorNo(' + CAST(ERROR_NUMBER() AS NVARCHAR) + N') ErrorMsg(' + ERROR_MESSAGE() + N').'

    PRINT N'So Rolling back Transactions.'

    ROLLBACK TRANSACTION UpdateO365JsonTran

END CATCH

ERROR_EXIST:

SET NOCOUNT OFF
