

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_UpdateExchDagClients.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_UpdateExchDagClients.script,v $ $Id: App_UpdateExchDagClients.script,v 1.1.2.3 2020/10/04 00:58:59 abilbrey Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '8056548E-0F86-4C09-A567-0E8C6456962B')

BEGIN

	DECLARE @curTime INT=0 

	SET @curTime  = datediff(second, '01/01/1970', GETDATE())

	--Add IDA prop entry 'Exchange Version' for Exchange DAG clients .

	-- Get Dag Clients

	IF OBJECT_ID('tempdb.dbo.#tempDAG') IS NOT NULL

         DROP TABLE #tempDAG

	CREATE TABLE #tempDAG (id INT)
INSERT INTO #tempDAG select id from app_client where (status & 0x200000) > 0


	--Get Dag member servers 

	IF OBJECT_ID('tempdb.dbo.#tempMembers') IS NOT NULL

         DROP TABLE #tempMembers

	CREATE TABLE #tempMembers (Dagid INT, Memberid INT, ver INT)
	INSERT INTO #tempMembers 


	SELECT d.id, c.id, 0

	FROM APP_Client c, #tempDAG d

	JOIN APP_ClientProp cp ON cp.componentNameId = d.id AND cp.attrType = 125 

	WHERE c.net_hostname = cp.attrName

	--Get Dag Exchange version from one of its members server

	UPDATE #tempMembers

	SET ver = ISNULL((select TOP 1 P.attrval 

	FROM  APP_IDAProp P, APP_IDAName N

	JOIN #tempDAG d ON d.id =  Dagid         

	WHERE N.clientId = Memberid AND N.appTypeId = 53 AND P.componentNameId = N.Id AND P.attrname = 'IDA Version' AND P.modified = 0), 0)

	--Add entry into ida_prop for DAG clients

	IF NOT EXISTS (select * from APP_IDAProp IP , #tempMembers TM where IP.componentNameId = TM.Dagid and IP.attrName = 'DAG Exchange Version' )

	BEGIN
	INSERT INTO APP_IDAProp


	SELECT  I.id, N'DAG Exchange Version' , 10 , D.ver, @curTime, 0, 0

	FROM 

	(

		SELECT Max(T.ver) AS ver , T.DagId

		FROM #tempMembers T

		WHERE  T.ver <> 0

		group by T.DagId

	) D

	JOIN App_idaname I WITH(NOLOCK)  ON I.clientId = D.Dagid

	WHERE I.appTypeId = 53 

	END

	IF OBJECT_ID('tempdb.dbo.#tempDAG') IS NOT NULL

	DROP TABLE #tempDAG 	

	IF OBJECT_ID('tempdb.dbo.#tempMembers') IS NOT NULL

	DROP TABLE #tempMembers

	-- Tbl script file should not have any function calls because they may not exist during upgrade
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


    VALUES('8056548E-0F86-4C09-A567-0E8C6456962B', 'App_UpdateExchDagClients', 'Add Exchange version on Existing DAG clients', @curTime, 16, 0, (16 + 2)) --SIM_ID_GX_REL110 = 16

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

