

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_Template_DuplicateFix.script] ---------- 


SET QUOTED_IDENTIFIER OFF

        -- Fix duplicate templates of 'Audit Trail','Event Viewer'

		--1. get template id for the actual template and its duplicate 

		--2. change the association from of duplicate entry in App_MonitorTemplateAssoc

		--3. delete the duplicate entry

SET NOCOUNT ON

GO

DECLARE @DuplicateTemplateFixScriptExec INT = 0

SELECT

    @DuplicateTemplateFixScriptExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = '671B8DD8-ACFF-4574-AB66-8721FFC5EA9A'

IF(@DuplicateTemplateFixScriptExec = 0)

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION

			DECLARE @AuditDuplicate INT = 0

			DECLARE @Audit INT = 0

			SELECT @Audit = templateId

			FROM App_Template 

			WHERE templateName = 'Audit Trail' and templateForMonitoringType = 5

			SELECT @AuditDuplicate = templateId 

			FROM App_Template 

			WHERE templateName = 'Audit Trail' AND templateForMonitoringType = 0

			IF @Audit <> 0 AND @AuditDuplicate <> 0

			BEGIN

				UPDATE App_MonitorTemplateAssoc

				SET templateId = @Audit 

				WHERE templateId = @AuditDuplicate

				DELETE FROM App_Template WHERE templateId = @AuditDuplicate

				DELETE FROM APP_TemplateColumn WHERE templateId = @AuditDuplicate

			END

			SET @AuditDuplicate = 0

			SELECT @AuditDuplicate = templateId 

			FROM App_Template 

			WHERE templateName = 'Audit Trail Log' AND templateForMonitoringType = 0

			IF @Audit <> 0 AND @AuditDuplicate <> 0

			BEGIN

				UPDATE App_MonitorTemplateAssoc

				SET templateId = @Audit 

				WHERE templateId = @AuditDuplicate

				DELETE FROM App_Template WHERE templateId = @AuditDuplicate

				DELETE FROM APP_TemplateColumn WHERE templateId = @AuditDuplicate

			END

			--disable the policy

            UPDATE App_MonitoringPolicy set status=1 where MonitorPolicyName='Gui Event Viewer Policy'

			-----------------------------------------------------------------------------------------

			DECLARE @EventDuplicate INT = 0

			DECLARE @Event INT = 0

			SELECT @Event = templateId

			FROM App_Template 

			WHERE templateName = 'Event Viewer' and templateForMonitoringType = 5

			SELECT @EventDuplicate = templateId 

			FROM App_Template 

			WHERE templateName = 'Event Viewer' AND templateForMonitoringType = 0

			IF @Event <> 0 AND @EventDuplicate <> 0

			BEGIN

				UPDATE App_MonitorTemplateAssoc

				SET templateId = @Event 

				WHERE templateId = @EventDuplicate

				DELETE FROM App_Template WHERE templateId = @EventDuplicate

				DELETE FROM APP_TemplateColumn WHERE templateId = @EventDuplicate

			END

			SET @EventDuplicate = 0

			SELECT @EventDuplicate = templateId 

			FROM App_Template 

			WHERE templateName = 'Event Viewer Log' AND templateForMonitoringType = 0

			IF @Event <> 0 AND @EventDuplicate <> 0

			BEGIN

				UPDATE App_MonitorTemplateAssoc

				SET templateId = @Event 

				WHERE templateId = @EventDuplicate

				DELETE FROM App_Template WHERE templateId = @EventDuplicate

				DELETE FROM APP_TemplateColumn WHERE templateId = @EventDuplicate

			END

             UPDATE App_MonitoringPolicy set status=1 where MonitorPolicyName='Gui Audit Trail Policy'
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('671B8DD8-ACFF-4574-AB66-8721FFC5EA9A', 'DuplicateTemplateFixScript', 'Fix Event Viewer, Audit Trail Duplicate Template', datediff(second, '01/01/1970', GETUTCDATE()), 16, 0 , (16 + 1))

		COMMIT TRANSACTION

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT N'Rolling back Transactions.'

		ROLLBACK TRANSACTION

	END CATCH

END

SET NOCOUNT OFF

GO

