

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_SyncCloudConfig.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_SyncCloudConfig.script,v $ $Id: App_SyncCloudConfig.script,v 1.1.2.9 2018/03/09 19:17:25 bjoseph Exp $";

SET QUOTED_IDENTIFIER ON

GO

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '02610238-C269-476D-9459-62FC54CCEE59')

BEGIN

-------------------------------------------------------------------------------------

	----------------------------------------------------------------------------

	--									Variables							  --

	----------------------------------------------------------------------------

	DECLARE @shareId			INT = 0

	DECLARE @newShareId			INT = 0

	DECLARE @shareFlag			INT = 0

	DECLARE @clientId			INT = 0

	DECLARE @nowTime			INT = DATEDIFF(second, '01/01/1970', GetUTCdate())  

	DECLARE @shareName			NVARCHAR(MAX) = ''

	DECLARE @path				NVARCHAR(MAX) = ''

	DECLARE @webConsoleURL		NVARCHAR(MAX) = '/webconsole/'

	DECLARE @goToLink			NVARCHAR(MAX) = ISNULL((SELECT value FROM GXGlobalParam WHERE name='Short Url Template' AND modified=0), 'gtl.do?gid=')

	DECLARE @hasShort			INT = 0

	DECLARE @errorCode			INT = 0

	DECLARE @errorString		NVARCHAR(MAX) = ''

	DECLARE @shareUrl			NVARCHAR(MAX) = ''

	DECLARE @browseUrl			NVARCHAR(MAX) = ''

	DECLARE @shortUrl			NVARCHAR(MAX) = ''

	DECLARE @clientStatus		INT = 0

	DECLARE @isEdgeClient		INT = 0

	DECLARE @browseXMLReq		XML

	DECLARE @CV_STATUS_EDGE_DRIVE INT = CAST(0x10000000 AS INT)

	DECLARE @SYNC_FOLDER_IS_SHARE_FOLDER INT = 4

	DECLARE @SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER INT = 8

	DECLARE @SYNC_FOLDER_IS_PUBLIC_UPLOAD_SHARE_FOLDER INT = 0x80

	DECLARE @SYNC_FOLDER_IS_PUBLIC_PRIVATE_SHARE_FOLDER INT = 12

	DECLARE @userId				INT = ISNULL((SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40), 1)

BEGIN TRAN

	DECLARE changeOptionCur CURSOR

	FOR

	SELECT syncWebFolderId, syncWebFolderName, flag, configOptions, clientId, ownerId, syncPath

	FROM

	(

		SELECT CF.syncWebFolderId, CF.syncWebFolderName, CC.clientId, CF.flag, CC.configOptions configOptions, CF.ownerId, CC.syncPath

		FROM App_SyncCloudFolder CF

		JOIN App_SyncCloudConfig CC ON CC.syncWebFolderId = CF.syncWebFolderId

	) Q

	CROSS APPLY Q.configOptions.nodes('//browseInfo/emailInfo') AS O(op)

	OPEN changeOptionCur

	FETCH FROM changeOptionCur INTO @shareId, @shareName, @shareFlag, @browseXMLReq, @clientId, @userId, @path

	WHILE @@FETCH_STATUS = 0 

	BEGIN

		SET @shortUrl = ''

		SET @browseUrl = ISNULL (( SELECT ref.value('@browseUrl', 'NVARCHAR(MAX)')

									FROM @browseXMLReq.nodes ('/browseInfo/emailInfo') R(ref)), '') 

		SET @hasShort = PATINDEX(@goToLink, @webConsoleURL)

		SELECT @clientStatus = status FROM App_Client WITH (NOLOCK)

		WHERE id = @clientId

		IF @clientStatus & @CV_STATUS_EDGE_DRIVE = @CV_STATUS_EDGE_DRIVE

			SET @isEdgeClient = 1

		ELSE

			SET @isEdgeClient = 0

		SET @shareUrl = @webConsoleURL

		IF @isEdgeClient = 1

			SET @shareUrl = @shareUrl + 'browse/MyDrive.do?' + 'path=' + @path + '&'

		ELSE

			SET @shareUrl = @shareUrl + 'browse/fsBrowse.do?'

		IF @hasShort = 0

		BEGIN

			--ONLY UPDATE URL FOR EXISTING SHARES ONCE

			SET @browseUrl = @shareUrl + 'shareFolderId=' + CAST(@shareId AS NVARCHAR(10))

			IF @shareFlag & (@SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER | @SYNC_FOLDER_IS_PUBLIC_UPLOAD_SHARE_FOLDER) <> 0

				SET @browseUrl = @browseUrl + '&iP=PUBLIC'

			--CREATE SHORT URL FOR EMAIL

			EXEC AppShortUrlConvertion @userId, @browseUrl OUTPUT, @shortUrl OUTPUT, @errorCode OUTPUT

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to convert to short url for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

			SET @shortUrl = @webConsoleURL + @goToLink + @shortUrl 

			--ADD SHORT URL TO BROWSEURL RESPONSE	

			IF (@browseXMLReq.exist('/browseInfo/emailInfo/@browseUrl')) = 1

				SET @browseXMLReq.modify('replace value of (/browseInfo/emailInfo/@browseUrl)[1] with sql:variable("@shortUrl")')

			UPDATE App_SyncCloudConfig SET configOptions = @browseXMLReq WHERE syncWebFolderId = @shareId

			SELECT @errorCode = @@ERROR

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to update App_SyncCloudConfig for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

		END

		--REMOVE USERS FROM PUBLIC SHARE AND CREATE A NEW PRIVATE SHARE

		IF @shareFlag & @SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER = @SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER

			AND

			EXISTS(

				SELECT * FROM App_SharingUserInfo SU 

				WHERE SU.shareId = @shareId AND isOwner = 0

			)

		BEGIN

			SET @shortUrl = ''

			--REMOVE THE PUBLIC BIT

			SET @shareFlag = @shareFlag & ~@SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER

			SET @shareFlag = @shareFlag | @SYNC_FOLDER_IS_SHARE_FOLDER

			GENERATE_RETRY:

			SET @newShareId = ABS(CHECKSUM(NEWID())) % 1000000 + 1;

			IF EXISTS (SELECT 1 FROM App_SyncCloudFolder WITH(NOLOCK) WHERE syncWebFolderId = @newShareId)

				GOTO GENERATE_RETRY
			INSERT INTO App_SyncCloudFolder (syncWebFolderName, description, created, modified, flag, ownerId, syncWebFolderId)


			SELECT @shareName, description, created, modified, @shareFlag, @userId, @newShareId 

			FROM App_SyncCloudFolder WHERE syncWebFolderId = @shareId

			SELECT @errorCode = @@ERROR

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to create mew private share for existing shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

			SET @browseUrl = @shareUrl + 'shareFolderId=' + CAST(@newShareId AS NVARCHAR(10))

			--CREATE SHORT URL FOR EMAIL

			EXEC AppShortUrlConvertion @userId, @browseUrl OUTPUT, @shortUrl OUTPUT, @errorCode OUTPUT

			IF @errorCode <> 0 GOTO ERROR

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to convert new share url to short url for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

			SET @shortUrl = @webConsoleURL + @goToLink + @shortUrl 

			--ADD SHORT URL TO BROWSEURL RESPONSE	

			IF (@browseXMLReq.exist('/browseInfo/emailInfo/@browseUrl')) = 1

				SET @browseXMLReq.modify('replace value of (/browseInfo/emailInfo/@browseUrl)[1] with sql:variable("@shortUrl")')
			INSERT INTO App_SyncCloudConfig(syncWebFolderId, syncPath, clientId, subclientId, syncType, scFilterFileId, created, flag, configOptions)


				SELECT @newShareId, syncPath, clientId, subclientId, syncType, scFilterFileId, created, flag, @browseXMLReq

				FROM App_SyncCloudConfig

				WHERE syncWebFolderId = @shareId

			SELECT @errorCode = @@ERROR

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to add configuration for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

			--ADD SHARE FOLDER USERS
			INSERT INTO App_SharingUserInfo(shareId, sharedTo, sharedBy, userType, enabled, deleted, permission, created, modified, isOwner, excluded)


				SELECT @newShareId, sharedTo, sharedBy, userType, enabled, deleted, permission, created, modified, isOwner, excluded 

				FROM App_SharingUserInfo

				WHERE shareId = @shareId

			SELECT @errorCode = @@ERROR

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to add users for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

			UPDATE App_SyncCloudFolder SET flag = @SYNC_FOLDER_IS_PUBLIC_SHARE_FOLDER

			WHERE syncWebFolderId = @shareId

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to convert new share url to short url for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

			DELETE App_SharingUserInfo

			WHERE shareId = @shareId AND isOwner = 0

			SELECT @errorCode = @@ERROR

			IF @errorCode <> 0

			BEGIN

				SET @errorString = 'Failed to remove users from public for shareId [' + + CAST(@shareId AS NVARCHAR(10)) + ']'

				GOTO ERROR

			END

		END

		ELSE IF @shareFlag & @SYNC_FOLDER_IS_PUBLIC_PRIVATE_SHARE_FOLDER = @SYNC_FOLDER_IS_PUBLIC_PRIVATE_SHARE_FOLDER

		BEGIN

			--REMOVE THE PUBLIC BIT

			SET @shareFlag = @shareFlag & ~@SYNC_FOLDER_IS_SHARE_FOLDER

			UPDATE App_SyncCloudFolder SET flag = @shareFlag

			WHERE syncWebFolderId = @shareId

		END

		FETCH FROM changeOptionCur INTO  @shareId, @shareName, @shareFlag, @browseXMLReq, @clientId, @userId, @path

	END
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


        VALUES ('02610238-C269-476D-9459-62FC54CCEE59', 'ScriptToSeparateSharesOfV10', 

'Script to separate combined (private and public view) V10 shares', @nowTime, 16, 0, 18)

ERROR:

	CLOSE changeOptionCur

	DEALLOCATE changeOptionCur

IF @errorCode <> 0

	ROLLBACK TRAN

ELSE

	COMMIT TRAN

ERROR_EXIT:

	IF @errorCode <> 0

		PRINT 'Errorcode = '+CAST(@errorCode AS nvarchar(10)) + ' Error= ' + @errorString

	ELSE

		PRINT 'Script completed successfully'

END

