

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_SubClientProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_SubClientProp.script,v $ $Id: App_SubClientProp.script,v 1.6.12.64.8.4 2021/02/12 04:47:14 gpattabiraman Exp $";

GO

SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON

GO

DECLARE @curTime INT 

-- Replacing GETDATE with GETUTCDATE

SET @curTime  = datediff(second, '01/01/1970', GETUTCDATE())

-- VSS Options upgrade for subclients of subclient policy

-- Just a replica of AppIdaUpgrade_UseVSSOptions

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease' AND CAST(Status AS INTEGER) IN (13, 14) )

BEGIN

	DECLARE @tempTbl TABLE

	(

		subClientId INT,

		VSSValue nvarchar(MAX)

	)

	-- Push all the subclients of appType = CV_APPTYPE_SUBCLIENT_POLICY(1030)
	INSERT INTO @tempTbl


		SELECT DISTINCT Appl.id, 

				CASE WHEN EXISTS (SELECT * 

								  FROM APP_SubclientProp 

WHERE componentNameId = Appl.id AND attrName = 'Use Shadow Copy' AND attrVal = '1' AND modified = 0)

						 THEN '1'

					 ELSE

						'0'		

				END

		FROM APP_Application AS Appl 

WHERE Appl.appTypeId = 1030

	-- Age the old property

	UPDATE APP_SubclientProp

	SET modified = @curTime

WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = 'Use Shadow Copy' AND modified = 0

	/*-- Doing this for a safer case. This property should ideally not exist for 9.0 subclients. 

	UPDATE APP_SubclientProp

	SET modified = @curTime

WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = 'Use VSS Enabled' AND modified = 0

	UPDATE APP_SubclientProp

	SET modified = @curTime

WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = 'Use VSS Options' AND modified = 0*/

	-- If 'Use Shadow Copy' was '1', then 'Use VSS Enabled' will be '1'.

	-- If 'Use Shadow Copy' was '0', then 'Use VSS Enabled' will be '0'.
	INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)


SELECT subclientId, 'Use VSS Enabled', 2, VSSValue, @curTime, 0

		FROM @tempTbl

WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Use VSS Enabled' AND modified = 0)

	-- If 'Use Shadow Copy' was '1, then 'Use VSS Options' should be '1'. (Dont rely on the default value in AppMgr. Better set it here)
	INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)


SELECT subclientId, 'Use VSS Options', 7, VSSValue, @curTime, 0

		FROM @tempTbl

WHERE VSSValue = '1' AND NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Use VSS Options' AND modified = 0)

END

DECLARE @indexBackupSubclientUpgrade INT = 0

DECLARE @indexBackupSubclientVersion varchar(36) = '802D33AD-1B7E-460A-81D9-4D3429C44F36'

SELECT @indexBackupSubclientUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @indexBackupSubclientVersion

IF (@indexBackupSubclientUpgrade = 0)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#IndexBackupSubclient') IS NOT NULL

    DROP TABLE #IndexBackupSubclient

	CREATE TABLE #IndexBackupSubclient (subclientId INT PRIMARY KEY )
	INSERT INTO #IndexBackupSubclient


	SELECT 

		   componentNameId

	FROM APP_SubClientProp

	WHERE 

		   attrName = 'Index Subclient'

		   AND attrVal = '1'

		   AND modified = 0

	EXCEPT

	SELECT 

		   componentNameId

	FROM APP_SubClientProp prop

	WHERE 

		   prop.attrName = 'Enable Snap Backups' 

		   AND prop.attrVal = '0' 

		   AND prop.modified = 0

	UPDATE APP_SubClientProp

	SET modified = @curTime

	FROM #IndexBackupSubclient S

	WHERE componentNameId = S.subclientId

	AND attrName = 'Enable Snap Backups'

	AND modified = 0

	INSERT APP_SubClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)

	SELECT subclientId, 'Enable Snap Backups', 2, '0', @curTime, 0, 0

	FROM #IndexBackupSubclient

	IF OBJECT_ID('tempdb.dbo.#IndexBackupSubclient') IS NOT NULL 

		DROP TABLE #IndexBackupSubclient
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@indexBackupSubclientVersion, 'DisableSnapOnIndexBackupSubclient', 'Disable snap backup on Index backup subclient.', @curTime, 16, 0 , (16 + 1))

END

DECLARE @edgeDriveRetentionUpgrade INT = 0

DECLARE @edgeDriveRetentionVersion varchar(36) = '51E0FCF1-EE66-4B96-9414-2BFBCEA6655B'

SELECT @edgeDriveRetentionUpgrade = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @edgeDriveRetentionVersion

IF (@edgeDriveRetentionUpgrade = 0)            -- not done, do the db upgrade

BEGIN

	IF OBJECT_ID('tempdb.dbo.#edgeSubclientPolicies') IS NOT NULL 

		DROP TABLE #edgeSubclientPolicies

	CREATE TABLE #edgeSubclientPolicies 

	(

		subclientId INT PRIMARY KEY,

		policyId	INT,

		clientStatus INT

	) 
	INSERT INTO #edgeSubclientPolicies


	SELECT APP.id, APP.backupSet, CL.status 

	FROM APP_Application APP

	INNER JOIN App_EdgeDriveAssociation EDA ON EDA.entityType = 65 AND EDA.entityId = APP.backupSet

	INNER JOIN APP_Client CL ON CL.id = EDA.clientId

	WHERE APP.subclientStatus & 131080 = 131080

	AND APP.appTypeId = 1030

	-- Insert new defaults
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT subclientId, 'Versions in Drive', 7, '10', @curTime, 0, 0

	FROM #edgeSubclientPolicies

	WHERE NOT EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId = subclientId AND attrName = 'Versions in Drive' AND modified = 0)
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT subclientId, 'Grace Period For Versions', 7, '30', @curTime, 0, 0

	FROM #edgeSubclientPolicies

	WHERE NOT EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId = subclientId AND attrName = 'Grace Period For Versions' AND modified = 0)

	MERGE APP_SubClientProp as Dest

        USING (SELECT subclientId,'Trash Can Retention' as attrType,

			(CASE 

				WHEN clientStatus & 0x40000000 = 0x40000000 --CV_STATUS_SYSTEM_EDGE_DRIVE

				THEN '730'

				ELSE '30'

			END) as attrVal

	FROM #edgeSubclientPolicies) AS Src

        on  Dest.componentNameId = Src.subclientId

                AND Dest.attrName = Src.attrType 

                AND Dest.modified = 0 

            WHEN MATCHED 

                THEN UPDATE SET Dest.attrVal = Src.attrVal

            WHEN NOT MATCHED THEN

				INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

				Values( Src.subclientId, Src.attrType, 7, Src.attrVal, @curTime, 0, 0);

	UPDATE APP_BackupSetName

	SET status = status | 0x40000

	WHERE id IN (SELECT policyId  FROM #edgeSubclientPolicies WHERE clientStatus & 0x40000000 = 0x40000000) --CV_STATUS_SYSTEM_EDGE_DRIVE

	IF OBJECT_ID('tempdb.dbo.#edgeSubclientPolicies') IS NOT NULL 

		DROP TABLE #edgeSubclientPolicies
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@edgeDriveRetentionVersion, 'SCPEdgeDriveRetention', 'Create SubClient Property Rows: Versions in Drive, Grace Period For Versions and Trash Can Retention.', @curTime, 16, 0 , (16 + 1))

END

DECLARE @retentionGUID VARCHAR(50) = '486F209A-F36A-4F1C-9676-53F8E1834DF9'	-- Previous GUIDs: '67622FAD-38EA-4111-B224-69D247C55E5B', '237F15A9-7E38-41E0-8A27-6F5D3DC15AFB'

DECLARE @retentionDbUpgrade INT = 0

SELECT

	@retentionDbUpgrade = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID =  @retentionGUID		

IF (@retentionDbUpgrade = 0)		-- not done, do the db upgrade

BEGIN

	IF OBJECT_ID('tempdb.dbo.#clients') IS NOT NULL 

		DROP TABLE #clients

	CREATE TABLE #clients (

		appId					INT PRIMARY KEY,

		newDaysPastVal			INT

	)

	DECLARE @unixTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	-- get subclients that do not have a physically set retention row
	INSERT INTO #clients (appId, newDaysPastVal)


		SELECT DISTINCT

			a.id appId,

			CASE

				WHEN a.appTypeId = 54 THEN 1825			-- Exchange Mailbox configuration 1825 day retention

				WHEN a.appTypeId <> 54 

					AND (

							(c.status & 4096) = 4096	-- client laptop configuration status bit set

							OR (	-- client laptop configuration property set

								cp.attrVal IS NOT NULL

								AND cp.attrVal = N'1'

							)

							OR (	-- OnePass NAS Turbo Backupset configured 

								bsp.attrVal IS NOT NULL

								AND bsp.attrVal = N'1'

							)

							OR (	-- OnePass SubClient Turbo configured

								onePass.attrVal IS NOT NULL

								AND onePass.attrVal = N'1'

							)

					)

				THEN 730			-- 730 day retention (Laptop, NAS Turbo, SubClient Turbo)

				ELSE 0				-- non-laptop / non-ExchangeMB / non-NASTurbo / non-FSTurbo delete immediately NOT PRESENT: 0 day retention

			END newDaysPastVal

		FROM

			APP_Client c WITH(NOLOCK)

			INNER JOIN APP_Application a WITH(NOLOCK) ON

				a.clientId = c.id

			INNER JOIN APP_AppTypeGroupAssoc at WITH(NOLOCK) ON

				(

					a.appTypeId = 54		-- Exchange Mailbox

					AND at.appTypeId = a.appTypeId

				)

				OR (

					at.appGroupId = 35				-- File System Grouping

					AND at.typeOfGroup = 0

					AND at.appTypeId = a.appTypeId	-- File System

				)

			LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK) ON

				scp.cs_attrName = CHECKSUM(N'Days to keep items past their expiration')

				AND scp.componentNameId = a.id

				AND scp.modified = 0

				AND scp.attrName = N'Days to keep items past their expiration'

			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON		-- check for laptop property being set and client status NOT set

				cp.componentNameId = a.clientId

				AND cp.modified = 0

				AND cp.attrName = N'Personal Workstation'

			LEFT OUTER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON

				bsp.componentNameId = a.backupSet

				AND bsp.modified = 0

				AND bsp.attrName = N'NAS Turbo Backupset'	-- OnePass NAS Turbo Configuration

			LEFT OUTER JOIN APP_SubClientProp onePass WITH(NOLOCK) ON

				onePass.cs_attrName = CHECKSUM(N'Is Turbo Subclient')

				AND onePass.componentNameId = a.id

				AND onePass.modified = 0

				AND onePass.attrName = N'Is Turbo Subclient'	-- OnePass SubClient Turbo Configuration

		WHERE

			scp.id IS NULL	-- property row does not exist - during upgrade create one

	IF (@@ROWCOUNT > 0)

	BEGIN

		-- insert retention rows for subclients missing these rows
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


			SELECT

				c.appId, 

				N'Days to keep items past their expiration', 

				7, 

				CAST(c.newDaysPastVal AS NVARCHAR(20)),

				@unixTime, 

				0, 

				0

			FROM #clients c

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES( @retentionGUID, 'SCPDaysPastRetentionDbUpgrade', 'Create SubClient Property Rows: Days to keep items past their expiration', @unixTime, 16, 0 , (16 + 1))

	IF OBJECT_ID('tempdb.dbo.#clients') IS NOT NULL 

		DROP TABLE #clients

END

DECLARE @v2RetentionGUID VARCHAR(50) = '079CABCF-4677-4B2A-B4BE-3E59D4F03755'

DECLARE @v2RetentionPropUpgrade INT = 0

SELECT

	@v2RetentionPropUpgrade = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID =  @v2RetentionGUID		

IF (@v2RetentionPropUpgrade = 0)		-- not done, do the db upgrade

BEGIN

	DECLARE @nowTime INT = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	IF OBJECT_ID('tempdb.dbo.#subclientRetention') IS NOT NULL 

	DROP TABLE #subclientRetention

	CREATE TABLE #subclientRetention (

							appId INT PRIMARY KEY,						

							enableOnePass INT NULL,

							deletedStubRetention INT NULL,

							deletedFileRetention INT NULL,

							keepVersions INT NULL,

							isDaysBasedRetention INT DEFAULT 0,

							storagePolicyDaysBasedRetention INT,

							isLaptop INT DEFAULT 0,

							dmDoNotCreateStub INT NULL,

							archiveExpirationDays INT DEFAULT -1,

							enableSnap INT NULL

	)

	INSERT #subclientRetention(appId)

	SELECT DISTINCT subclient.id FROM APP_Application subclient

	INNER JOIN APP_AppTypeGroupAssoc appType ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS

	INNER JOIN APP_ClientProp clientProp ON clientProp.componentNameId = subclient.clientId AND clientProp.attrName = N'IndexingV2' AND clientProp.attrVal = N'1' AND clientProp.modified = 0 --Get subcliets of Index v2 

	------------------------------

	UPDATE T

		SET T.enableOnePass = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Is Turbo Subclient' AND prop.modified = 0

	UPDATE T

		SET T.deletedStubRetention = CAST(prop.attrVal AS INT)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'User deleted stubs expiration days' AND prop.modified = 0

	UPDATE T

		SET T.deletedFileRetention = CAST(prop.attrVal AS INT)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Days to keep items past their expiration' AND prop.modified = 0

	UPDATE T

		SET T.keepVersions = CAST(prop.attrVal AS INT)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Number of Synth Full Versions' AND prop.modified = 0

	UPDATE T

		SET T.isDaysBasedRetention = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Honor Archiver Agent Retention' AND prop.modified = 0

	UPDATE T

		SET T.isLaptop = (SELECT CASE (client.status & 4096) WHEN 4096 THEN 1 ELSE 0 END)

	FROM #subclientRetention T

	INNER JOIN APP_Application subclient ON subclient.id = T.appId

	INNER JOIN App_Client client ON client.id = subclient.clientid

	UPDATE T

		SET T.dmDoNotCreateStub = (CAST(attrVal AS INT) & 0x04)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Data Migrator Rule Flag' AND prop.modified = 0

	UPDATE T

		SET T.archiveExpirationDays = CAST(attrVal AS INT)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Archived expiration days' AND prop.modified = 0

	UPDATE T

		SET T.enableSnap = CAST(prop.attrVal AS INT)

	FROM #subclientRetention T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Enable Snap Backups' AND prop.modified = 0

	UPDATE T

		SET T.storagePolicyDaysBasedRetention = (SELECT CASE WHEN MIN(AAR.archiverRetDays) = -1 THEN -1 ELSE MAX(AAR.archiverRetDays) END AS MaxArchiverRetDays

										FROM archGroupCopy AGC WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)

										WHERE AGC.archGroupId = subclient.dataArchGrpId

										AND      AGC.id = AAR.copyId

										AND      AGC.isSnapCopy = 0

										AND      AGC.type = 1)

	FROM #subclientRetention T

	INNER JOIN App_Application subclient ON subclient.id = T.appId

	UPDATE T

		SET T.modified = @nowTime

	FROM APP_SubClientProp T

	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId

	AND T.attrName IN(N'Is Archive Retention Mode Enabled', N'Is Backup Retention Mode Enabled', N'Keep older Synth Full Versions' ) AND T.modified = 0

	INSERT APP_SubClientProp	

	----------------Archiver-------------------------------

	SELECT appId, N'Is Archive Retention Mode Enabled', 2, (CASE enableOnePass WHEN 1 THEN N'1' ELSE N'0' END), @nowTime, 0, 0 FROM #subclientRetention

	UNION ALL

	---------------Archiver Retention----------------------

	SELECT appId, N'User deleted stubs expiration days', 7, N'-1', @nowTime, 0, 0  FROM #subclientRetention WHERE deletedStubRetention IS NULL

	UNION ALL

	--------------Deleted file retention-------------------

	SELECT appId, N'Days to keep items past their expiration', 7, N'0', @nowTime, 0, 0  FROM #subclientRetention WHERE deletedFileRetention IS NULL

	UNION ALL

	---------------Backup Mode-----------------------------

	SELECT appId, N'Is Backup Retention Mode Enabled', 2, N'0', @nowTime, 0, 0  FROM #subclientRetention

	---------------Archive retention days------------------

	UPDATE T

		SET T.modified = @nowTime

	FROM APP_SubClientProp T

	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId

	WHERE S.dmDoNotCreateStub = 4

	AND T.attrName = N'User deleted stubs expiration days' AND T.modified = 0

	INSERT APP_SubClientProp

	SELECT appId, N'User deleted stubs expiration days', 7, archiveExpirationDays, @nowTime, 0, 0 FROM #subclientRetention WHERE dmDoNotCreateStub = 4

	---------------Backup Mode-----------------------------

	UPDATE T

		SET T.attrVal = N'1'

	FROM APP_SubClientProp T

	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId

	WHERE ((S.enableOnePass = 1 AND S.isDaysBasedRetention = 0) OR ((S.enableOnePass = 0 OR S.enableOnePass IS NULL) AND (S.deletedFileRetention > 0 OR S.deletedFileRetention = -1 OR S.keepVersions > 0) AND (S.enableSnap IS NULL OR S.enableSnap = 0)))

		AND T.attrName = N'Is Backup Retention Mode Enabled' AND T.modified = 0

	----------------ESP/enableOnePass---------------------

	UPDATE T

		SET T.modified = @nowTime

	FROM APP_SubClientProp T

	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId

	WHERE (S.deletedFileRetention = -1 OR S.deletedFileRetention > 0 OR S.keepVersions > 0) AND (S.enableSnap IS NULL OR S.enableSnap = 0)

		AND T.attrName = N'Is Turbo Subclient' AND T.modified = 0

	INSERT APP_SubClientProp

	SELECT appId, N'Is Turbo Subclient', 2, N'1', @nowTime, 0, 0 FROM #subclientRetention WHERE (deletedFileRetention = -1 OR deletedFileRetention > 0 OR keepVersions > 0) AND (enableSnap IS NULL OR enableSnap = 0)

	--------------Deleted file retention-------------------

	UPDATE T

		SET T.attrVal = N'730'

	FROM APP_SubClientProp T

	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId

	WHERE (S.deletedFileRetention IS NULL AND (S.enableOnePass = 1 OR S.isLaptop = 1 ))

		AND T.attrName = N'Days to keep items past their expiration' AND T.modified = 0

	---------------Days based retention is ON---------------

	UPDATE T

		SET T.modified = @nowTime

	FROM APP_SubClientProp T

	INNER JOIN #subclientRetention S ON S.appId = T.componentNameId

	WHERE (S.enableOnePass = 1 AND S.isDaysBasedRetention = 1)

		AND T.attrName = N'User deleted stubs expiration days' AND T.modified = 0

	INSERT APP_SubClientProp	

	SELECT appId, N'User deleted stubs expiration days', 7, storagePolicyDaysBasedRetention, @nowTime, 0, 0 FROM #subclientRetention WHERE enableOnePass = 1 AND isDaysBasedRetention = 1	

	---------------Keep Versions----------------------------

	INSERT APP_SubClientProp

	SELECT appId, N'Number of Synth Full Versions', 7, N'0', @nowTime, 0, 0  FROM #subclientRetention WHERE keepVersions IS NULL

	INSERT APP_SubClientProp

	SELECT appId, N'Keep older Synth Full Versions', 7, N'2', @nowTime, 0, 0  FROM #subclientRetention
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES( @v2RetentionGUID, 'UpgradeForV2Retention', 'Create default SubClient Property Rows for v2 retention', @nowTime, 16, 0 , (16 + 1))

	IF OBJECT_ID('tempdb.dbo.#subclientRetention') IS NOT NULL 

		DROP TABLE #subclientRetention

END

--Fix ESP on subclients associated to policy that do not have retention

DECLARE @setESPRetentionGUID VARCHAR(50) = '442D3D76-D87F-44CE-B84C-6C4067907DC2'

DECLARE @setESPRetentionPropUpgrade INT = 0

SELECT

	@setESPRetentionPropUpgrade = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID =  @setESPRetentionGUID

IF (@setESPRetentionPropUpgrade = 0)		-- not done, do the db upgrade

BEGIN

	DECLARE @nowESPTime INT = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	IF OBJECT_ID('tempdb.dbo.#fixESPOnSubclients') IS NOT NULL 

	DROP TABLE #fixESPOnSubclients

	CREATE TABLE #fixESPOnSubclients (

							appId INT PRIMARY KEY,						

							subclientPolicyId INT NULL,

							subclientPolicyHasRetention INT DEFAULT 0,

							enableOnePass INT NULL,

							isArchiveModeEnabled INT DEFAULT 0,

							isBackupModeEnabled INT DEFAULT 0,

	)

	INSERT #fixESPOnSubclients(appId, subclientPolicyId)

	SELECT DISTINCT subclient.id, CAST(subclientProp.attrVal AS INT)FROM APP_Application subclient WITH(NOLOCK)

	INNER JOIN APP_AppTypeGroupAssoc appType WITH(NOLOCK) ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS

	INNER JOIN APP_ClientProp clientProp WITH(NOLOCK) ON clientProp.componentNameId = subclient.clientId AND clientProp.attrName = N'IndexingV2' AND clientProp.attrVal = N'1' AND clientProp.modified = 0 --Get subcliets of Index v2 

	INNER JOIN APP_SubClientProp subclientProp WITH(NOLOCK) ON subclientProp.componentNameId = subclient.id

	WHERE subclientProp.attrName = N'Associated subclient Policy' AND subclientProp.attrVal IS NOT NULL AND subclientProp.modified = 0

	UPDATE T

		SET T.subclientPolicyHasRetention = (CASE prop.attrVal WHEN N'1' THEN 1 ELSE 0 END)

	FROM #fixESPOnSubclients T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.subclientPolicyId

	WHERE prop.attrName = N'Subclient Policy Has Retention' AND prop.modified = 0

	--If subclient policy has retention then associated subclient will follow policy.

	--So remove subclients associated to policy that has retention.

	--ESP fix is required on subclients associated to policy that do not have retention.

	DELETE #fixESPOnSubclients

	WHERE subclientPolicyHasRetention = 1

	UPDATE T

		SET T.enableOnePass = (CASE prop.attrVal WHEN '1' THEN 1 ELSE 0 END)

	FROM #fixESPOnSubclients T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Is Turbo Subclient' AND prop.modified = 0

	UPDATE T

		SET T.isArchiveModeEnabled = (CASE prop.attrVal WHEN N'1' THEN 1 ELSE 0 END)

	FROM #fixESPOnSubclients T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Is Archive Retention Mode Enabled' AND prop.modified = 0

	UPDATE T

		SET T.isBackupModeEnabled = (CASE prop.attrVal WHEN N'1' THEN 1 ELSE 0 END)

	FROM #fixESPOnSubclients T

	INNER JOIN APP_SubClientProp prop on prop.componentNameId = T.appId

	WHERE prop.attrName = N'Is Backup Retention Mode Enabled' AND prop.modified = 0

	----------------ESP/enableOnePass---------------------

	UPDATE T

		SET T.modified = @nowESPTime

	FROM APP_SubClientProp T

	INNER JOIN #fixESPOnSubclients S ON S.appId = T.componentNameId

	WHERE 

		(enableOnePass is NULL or enableOnePass = 0)

		AND (isArchiveModeEnabled = 1 OR  isBackupModeEnabled = 1)

		AND T.attrName = N'Is Turbo Subclient' AND T.modified = 0

	INSERT APP_SubClientProp

		SELECT appId, N'Is Turbo Subclient', 2, N'1', @nowESPTime, 0, 0 FROM #fixESPOnSubclients 

		WHERE 

		(enableOnePass is NULL or enableOnePass = 0) 

		AND (isArchiveModeEnabled = 1 OR  isBackupModeEnabled = 1)
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES( @setESPRetentionGUID, 'FixESPOnSubclientAssociatedToPolicy', 'Set ESP on subclients associated to policy that do not have retention', @nowESPTime, 16, 0 , (16 + 1))

	IF OBJECT_ID('tempdb.dbo.#fixESPOnSubclients') IS NOT NULL 

		DROP TABLE #fixESPOnSubclients

END

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = 'B346B935-3C7D-4BEE-ABF8-948E7E978909')

BEGIN

	DECLARE @SubclientTbl TABLE (subclientId INT, isWinIDA INT)
	INSERT INTO @SubclientTbl


	SELECT AAP.id, 

	CASE

WHEN APP.attrName='Subclient policy 2' THEN 1

		ELSE 0

	END

	 FROM App_PlanProp APP WITH(NOLOCK)

	INNER JOIN APP_Application AAP WITH(NOLOCK)

ON AAP.backupSet=APP.attrVal AND APP.attrType=7 AND AAP.appTypeId=1030

	MERGE APP_SubClientProp AS DEST

		USING @SubclientTbl AS SRC

			ON DEST.componentNameId = SRC.subclientId AND DEST.attrname='Use Change Journal' AND DEST.modified = 0

		WHEN MATCHED 

			THEN UPDATE SET attrval = N'0'

		WHEN NOT MATCHED THEN

			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

				Values( Src.subclientId, 'Use Change Journal', 2, N'0', @curTime, 0, 0);

	MERGE APP_SubClientProp AS DEST

		USING @SubclientTbl AS SRC

			ON DEST.componentNameId = SRC.subclientId AND DEST.attrname='Use Classic File Scan' AND DEST.modified = 0

		WHEN MATCHED 

			THEN UPDATE SET attrval = CASE WHEN SRC.isWinIDA=1 THEN N'0' ELSE N'1' END

		WHEN NOT MATCHED THEN

			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

				Values( Src.subclientId, 'Use Classic File Scan', 2, CASE WHEN SRC.isWinIDA=1 THEN N'0' ELSE N'1' END, @curTime, 0, 0);

	MERGE APP_SubClientProp AS DEST

		USING @SubclientTbl AS SRC

			ON DEST.componentNameId = SRC.subclientId AND DEST.attrname='Use DC for FS backups' AND DEST.modified = 0

		WHEN MATCHED 

			THEN UPDATE SET attrval = CASE WHEN SRC.isWinIDA=1 THEN N'1' ELSE N'0' END

		WHEN NOT MATCHED THEN

			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

				Values( Src.subclientId, 'Use DC for FS backups', 2, CASE WHEN SRC.isWinIDA=1 THEN N'1' ELSE N'0' END, @curTime, 0, 0);
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('B346B935-3C7D-4BEE-ABF8-948E7E978909', 'PlanPropUpdate', 'Update Subclient Policies created via AdminConsole For Scan Properties', @curTime, 16, 0, (16 + 2))

END

DECLARE @driverLessGUID VARCHAR(50) = '853551F7-09A0-4D75-8E5C-4F7B27EDED64'

DECLARE @driverLessUpgrade INT = 0

SELECT

	@driverLessUpgrade = 1

FROM

	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

	gp.SqlScriptGUID =  @driverLessGUID

IF (@driverLessUpgrade = 0)		-- not done, do the db upgrade

BEGIN

	DECLARE @nowTimeDrv INT = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	IF OBJECT_ID('tempdb.dbo.#driverLessAgent') IS NOT NULL 

	DROP TABLE #driverLessAgent

	CREATE TABLE #driverLessAgent( agentId INT PRIMARY KEY, explorerBasedRecall INT NULL )

	--Get agent id of v11 WinFS subclients

	INSERT #driverLessAgent(agentId)

	SELECT DISTINCT agent.id FROM APP_IDAName agent

	INNER JOIN APP_AppTypeGroupAssoc appTypeAssociation ON appTypeAssociation.appTypeId = agent.appTypeId AND appTypeAssociation.appGroupId = 22 AND appTypeAssociation.typeOfGroup = 0 --22:WinFS

	INNER JOIN APP_Client client ON client.id = agent.clientId AND client.releaseId = 16

	IF (@@ROWCOUNT > 0)

	BEGIN

		UPDATE T

			SET T.explorerBasedRecall = CAST(prop.attrVal AS INT)

		FROM #driverLessAgent T

		INNER JOIN APP_IDAProp prop on prop.componentNameId = T.agentId

		WHERE prop.attrName = N'Explorer Based End User Recall Enabled' AND prop.modified = 0

		UPDATE T

			SET T.modified = @nowTimeDrv

		FROM APP_IDAProp T

		INNER JOIN #driverLessAgent S ON T.componentNameId = S.agentId

		WHERE T.attrName = 'Explorer Based End User Recall Enabled' AND T.modified = 0 AND S.explorerBasedRecall = 0

		INSERT APP_IDAProp

		SELECT agentId, N'Explorer Based End User Recall Enabled', 2, N'1', @nowTimeDrv, 0, 0 FROM #driverLessAgent WHERE explorerBasedRecall IS NULL OR explorerBasedRecall = 0

	END
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES( @driverLessGUID, 'UpgradeForDriverLessAgent', 'Create driver less key for subclients having enable onepass', @nowTimeDrv, 16, 0 , (16 + 1))

	IF OBJECT_ID('tempdb.dbo.#driverLessAgent') IS NOT NULL 

		DROP TABLE #driverLessAgent

END

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '16280A46-C748-4326-AA7C-0BA78C466A9A')

BEGIN

	DECLARE @SubclientTable TABLE (subclientId INT)
	INSERT INTO @SubclientTable


	SELECT AAP.id 

		 FROM App_PlanProp APP WITH(NOLOCK)

			INNER JOIN APP_Application AAP WITH(NOLOCK)

ON AAP.backupSet=APP.attrVal AND APP.attrType=7 AND AAP.appTypeId=1030

	MERGE APP_SubClientProp AS DEST

		USING @SubclientTable AS SRC

			ON DEST.componentNameId = SRC.subclientId AND DEST.attrname=N'Single Instancing Option' AND DEST.modified = 0 AND DEST.cs_attrName = checksum(N'Single Instancing Option') 

		WHEN MATCHED 

			THEN UPDATE SET attrval = N'1'

		WHEN NOT MATCHED THEN

			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

				Values( Src.subclientId, N'Single Instancing Option', 7, N'1', @curTime, 0, 0);
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('16280A46-C748-4326-AA7C-0BA78C466A9A', 'PlanPropUpdate_1', 'Update Subclient Policies created via AdminConsole For Client Side Dedup Policy', @curTime, 16, 0, (16 + 2))

END

-- Fix for one pass first turbo jobid

DECLARE @firstTurboJobIdFixDone INT = 0

DECLARE @firstTurboJobIdFixGUID varchar(36) = '248D1822-ACEC-4565-BE82-2E7E0C9AEB42'

SELECT @firstTurboJobIdFixDone = 1

FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)

WHERE GS.SqlScriptGUID = @firstTurboJobIdFixGUID

IF (@firstTurboJobIdFixDone = 0)            -- not done, do the db upgrade

BEGIN

	IF OBJECT_ID('tempdb.dbo.#onePassSubclients') IS NOT NULL 

		DROP TABLE #onePassSubclients

	CREATE TABLE #onePassSubclients 

	(

		subclientId INT PRIMARY KEY,

		jobId	INT

	) 
	INSERT INTO #onePassSubclients


	SELECT appId, MIN(jobId) 

	FROM JMBkpStats JM 

	INNER JOIN APP_Application APP ON JM.appId = APP.id

	WHERE JM.bkpattributes & 0x80000000000000 = 0x80000000000000 -- JMBKP_TURBO_FS_MODE

	AND status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS

	AND opType <> 14 --SYNTHFULL

	GROUP BY appId

	MERGE APP_SubClientProp AS TARGET

	USING (SELECT subclientId, jobId 

			FROM #onePassSubclients) AS 

			SOURCE (appId, jobId)

		ON (TARGET.componentNameId = SOURCE.appId AND TARGET.attrName = 'First Turbo Job Id' AND TARGET.modified = 0)

	WHEN NOT MATCHED THEN

		INSERT(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

		VALUES(SOURCE.appId, 'First Turbo Job Id', 2, CAST(SOURCE.jobId AS NVARCHAR(MAX)), @curTime, 0, 0);

	IF OBJECT_ID('tempdb.dbo.#onePassSubclients') IS NOT NULL 

		DROP TABLE #onePassSubclients
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@firstTurboJobIdFixGUID, 'FixFirstTurboJobID', 'Fix missing first turbo jobId property', @curTime, 16, 0 , (16 + 1))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'F4F5348C-6A28-45AD-82FE-F8AB3DC216DB')

BEGIN

	create table #jobBackupFailureCount

	(

		subclientID    integer,

		maxSucessJobTime integer,

		failureCount integer

	)
	INSERT INTO #jobBackupFailureCount


	(subclientID, maxSucessJobTime, failureCount)

    SELECT JM.appid, 0, 0

    FROM JMBkpStats JM

    INNER JOIN APP_Application APP ON JM.appId = APP.id

    WHERE status in (1,2,3,9,14)

    GROUP BY JM.appid       

	UPDATE J

    SET maxSucessJobTime = endDate

    FROM #jobBackupFailureCount J

    JOIN(

		SELECT appId, MAX(servEndDate) AS "endDate"

        FROM JMBkpStats JM

        WHERE status in (1,3,14) 

        GROUP BY AppId) TEMP ON J.subclientID = TEMP.appId

    UPDATE J

    SET failureCount = count

    FROM #jobBackupFailureCount J

    JOIN(

		SELECT JM.appId, COUNT(*) AS "count"

        FROM JMBkpStats JM

        INNER JOIN #jobBackupFailureCount J ON J.subclientID = JM.appId

        WHERE status in (2, 9) 

        AND servEndDate > maxSucessJobTime

        GROUP BY JM.AppId)TEMP ON J.subclientID = TEMP.appId

	-- Tbl script file should not have any function calls because they may not exist during upgrade

	MERGE INTO APP_SubClientProp AS target

    USING (SELECT subclientID, maxSucessJobTime, failureCount from #jobBackupFailureCount) AS source

    ON (target.componentNameId = source.subclientID AND target.attrName = 'Consecutive Backup Failures Count')

    WHEN MATCHED THEN

    UPDATE SET attrVal = source.failureCount

    WHEN NOT MATCHED THEN

    INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	VALUES (source.subclientID, 'Consecutive Backup Failures Count', 7, source.failureCount, @curTime, 0, 0);

	if OBJECT_ID('tempdb.dbo.#jobBackupFailureCount') is not null drop table dbo.#jobBackupFailureCount

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('F4F5348C-6A28-45AD-82FE-F8AB3DC216DB', 'Consecutive Backup Failures Count', 'Consecutive Backup Failures Count', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'E20D76FF-C68D-4C66-B44D-FE72B578315D')

BEGIN

	UPDATE APP_SubClientProp

	SET modified = @curTime

	WHERE attrName = 'sys:last backupcopy'

	UPDATE APP_SubClientProp

	SET modified = @curTime

	WHERE attrName = 'sys:last backupcopy incr'
	INSERT INTO APP_SubClientProp


	(componentNameId, attrName, attrType, attrVal, created,modified,ccpId)

	SELECT appid, 'sys:last backupcopy incr', 8, max(jobreferencetime), max(jobreferencetime),0,0 

	FROM JMBkpStats 

	INNER JOIN APP_Application subid ON subid.id = JMBkpStats.appid

WHERE (opType = 60 OR (opType = 59 AND ((bkpAttributesEx & 0x800000) <> 0))) AND bkpLevel = 2 AND status IN (1,3,14)

	GROUP BY appid

	UNION ALL

	SELECT appid, 'sys:last backupcopy', 8, max(jobreferencetime), max(jobreferencetime), 0, 0 

	FROM JMBkpStats 

	INNER JOIN APP_Application subid ON subid.id = JMBkpStats.appid

WHERE (opType = 60 OR (opType = 59 AND ((bkpAttributesEx & 0x800000) <> 0))) AND bkpLevel = 1 AND status IN (1,3,14)

	GROUP BY appid

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('E20D76FF-C68D-4C66-B44D-FE72B578315D', 'BackupCopyRefTime', 'Update Backup Copy Reference Time', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'A30480A3-B4EE-44C9-A3AD-689E65DE2F47')

BEGIN

	-- Tbl script file should not have any function calls because they may not exist during upgrade

	MERGE INTO APP_ScFilterFile AS target

	USING (SELECT id FROM APP_Application WHERE appTypeId = 1030 AND subclientStatus & 0x20000 = 0x20000 /*CV_STATUS_EDGEDRIVE_SUB*/) AS source

	ON (target.componentNameId = source.id AND target.fileName = '**\ntuser.dat*')

	WHEN NOT MATCHED THEN

	INSERT (componentNameId, type, fileName, created, modified, ccpId)

	VALUES (source.id, 3,  '**\ntuser.dat*', @curTime, 0, 0);

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('A30480A3-B4EE-44C9-A3AD-689E65DE2F47', 'NtUserDatEdgeDriveFilter', 'Add exclude filters for Edge drive', @curTime, 16, 0, (16 + 2))

END

-- This is to update existing laptop plans where if none of the retention settings are enabled then delete the "Is Turbo Subclient" property which enables us to modify Backup content

-- from Admin Console.

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'D8E26298-2A40-479D-AC42-579893D92343')

BEGIN

	DECLARE @subClientTbl1 TABLE	(subClientId INT)

	-- Push all the subclients of appType = CV_APPTYPE_SUBCLIENT_POLICY(1030)
	INSERT INTO @subClientTbl1


	SELECT AAP.id 

	FROM App_PlanProp APP WITH(NOLOCK)

	INNER JOIN APP_Application AAP WITH(NOLOCK)

ON AAP.backupSet=APP.attrVal AND APP.attrType=7 AND AAP.appTypeId=1030

	UPDATE SP

	SET SP.attrVal = '0'

	FROM APP_SubClientProp SP

	INNER JOIN @subClientTbl1 S

	  ON SP.componentNameId = S.subClientId

	LEFT JOIN APP_SubClientProp A

	  ON A.componentNameId = SP.componentNameId AND A.attrName = 'Is Backup Retention Mode Enabled' AND A.modified = 0

	LEFT JOIN APP_SubClientProp B

	  ON B.componentNameId = SP.componentNameId  AND B.attrName = 'Is Archive Retention Mode Enabled' AND B.modified = 0

	  WHERE (B.attrVal = '0' OR B.attrVal IS NULL) AND (A.attrVal = '0' OR A.attrVal IS NULL) AND SP.attrName = 'Is Turbo Subclient' AND SP.modified = 0 AND SP.attrVal = '1' 

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('D8E26298-2A40-479D-AC42-579893D92343', 'EnableOnePassCleanUp', 'Update Enable one pass if no retention settings present', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = '8CCE3E15-8C8E-4972-80CB-612D55087C6C')

BEGIN

	DECLARE @subclientPoliciesTbl  TABLE ( subclientId INT PRIMARY KEY)
	INSERT INTO @subclientPoliciesTbl(subclientId)


	SELECT DISTINCT AAP.id 

		FROM App_PlanProp APP WITH (NOLOCK)

			INNER JOIN APP_Application AAP WITH (NOLOCK)

				ON AAP.backupSet = APP.attrVal

			INNER JOIN App_Plan P WITH (NOLOCK)

				ON P.id = APP.componentNameId

WHERE APP.attrName in ('Subclient policy 2','Subclient policy 3','Subclient policy 4')

AND P.subType = 33554439

	-- Tbl script file should not have any function calls because they may not exist during upgrade

	UPDATE SCP

		SET SCP.attrVal = '0', SCP.created = @curTime

		FROM APP_SubClientProp SCP

		INNER JOIN @subclientPoliciesTbl S

		  ON SCP.componentNameId = S.subclientId

WHERE SCP.attrName = 'Forced Archiving'

			AND SCP.modified = 0

			AND SCP.attrVal = '1'

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('8CCE3E15-8C8E-4972-80CB-612D55087C6C', 'ForcedArchivingCleanup', 'Update incorrect Forced Archiving settings present in Laptop plan subclient policies', @curTime, 16, 0, (16 + 2))

END

-- This is to update existing laptop subclients which are already associated with plan but there backup retention property is not set properly.

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '4FF1FD34-29F4-422E-AA8A-B251B9333211')

BEGIN

	DECLARE @subClientTbl_backup TABLE	(subClientId INT)
	INSERT INTO @subClientTbl_backup


	SELECT APP.id FROM APP_ClientProp ACP

	INNER JOIN APP_Client AC

ON AC.id=ACP.componentNameId AND (AC.status&0x1000<>0)

	INNER JOIN App_Plan AP

ON ACP.attrName='Associated Plan' and ACP.modified=0 and CAST(AP.id AS NVARCHAR(64))=ACP.attrVal AND AP.subType=33554439

	INNER JOIN APP_Application APP

ON APP.clientId=ACP.componentNameId AND (APP.subclientStatus & 0x00008) <> 0

	INNER JOIN APP_BackupSetName BS 

ON BS.id =  APP.backupset and (BS.status & 0x00008) <> 0

	INNER JOIN APP_SubClientProp ASCP

		ON APP.id=ASCP.componentNameId AND ASCP.attrName='Days to keep items past their expiration' AND ASCP.modified=0 AND ASCP.attrVal=N'30'

	LEFT OUTER JOIN APP_SubClientProp ASCP2

		ON APP.id=ASCP2.componentNameId AND ASCP2.attrName='Is Backup Retention Mode Enabled' AND ASCP2.modified=0

	WHERE ASCP2.id IS NULL

    MERGE APP_SubClientProp AS DEST

        USING @subClientTbl_backup AS SRC

            ON DEST.componentNameId = SRC.subclientId AND DEST.attrname=N'Is Backup Retention Mode Enabled' AND DEST.modified = 0 AND DEST.cs_attrName = checksum(N'Is Backup Retention Mode Enabled') 

        WHEN NOT MATCHED THEN

            INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

                Values( Src.subclientId, N'Is Backup Retention Mode Enabled', 7, N'1', @curTime, 0, 0);

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('4FF1FD34-29F4-422E-AA8A-B251B9333211', 'EnableOnePassCleanUp', 'Update Enable one pass if no retention settings present', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '6e4ebe2c-02cc-4d2e-9893-46f51778bdc5')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#SubclientForDCPlanTbl') IS NOT NULL

		DROP TABLE #SubclientForDCPlanTbl

	CREATE TABLE #SubclientForDCPlanTbl ( id INT IDENTITY(1,1), subclient INT, clientId INT, planId INT, indexServer INT, ciPolicyId INT)
	INSERT INTO #SubclientForDCPlanTbl (subclient, clientId, planId)


	SELECT AAP.id, AAP.clientId, AP.id FROM APP_Application AAP WITH(NOLOCK)

	INNER JOIN APP_ClientProp ACP WITH(NOLOCK)

ON ACP.componentNameId=AAP.clientId AND AAP.appTypeId=106 AND ACP.attrName IN ('Associated Plan', 'Default Data classification Plan') AND ACP.modified=0

	INNER JOIN App_Plan AP

ON CAST(AP.id AS NVARCHAR(128))=ACP.attrVal AND AP.subType=117506053 AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)

	LEFT OUTER JOIN APP_ClientProp ACPVM

		ON ACP.componentNameId=ACPVM.componentNameId AND ACPVM.attrName = 'Virtual Server Discovered Clients' AND ACPVM.attrVal = '1' AND ACPVM.modified = 0

	WHERE ACPVM.componentNameId IS NULL

	UPDATE #SubclientForDCPlanTbl

	SET 

ciPolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Content Indexing Policy',  default), 0),

indexserver = ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Analytics Index Server Id',  default), 0)

	--	Finally update the table
	INSERT INTO APP_SubClientProp  (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)


	SELECT subclient, 'Associated index server id', 7, indexServer, @curTime, 0, 0 FROM #SubclientForDCPlanTbl 
	INSERT INTO APP_SubClientProp  (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)


	SELECT subclient, 'Indexing Configuration Policy', 7, ciPolicyId, @curTime, 0, 0 FROM #SubclientForDCPlanTbl 

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('6e4ebe2c-02cc-4d2e-9893-46f51778bdc5', 'PortLegacyDCPlanSupportForVSASubclient', 'Copy DC plan property to all applicable subclients', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'adfc294f-64c1-4d25-b922-8536dea6a011')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#SubclientForDCPlanTbl1') IS NOT NULL

		DROP TABLE #SubclientForDCPlanTbl1

	CREATE TABLE #SubclientForDCPlanTbl1 ( id INT IDENTITY(1,1), subclient INT, clientId INT, planId INT, indexServer INT, ciPolicyId INT)
	INSERT INTO #SubclientForDCPlanTbl1 (subclient, clientId, planId)


	SELECT AAP.id, AAP.clientId, AP.id FROM APP_Application AAP WITH(NOLOCK)

	INNER JOIN APP_ClientProp ACP WITH(NOLOCK)

ON ACP.componentNameId=AAP.clientId AND AAP.appTypeId=106 AND ACP.attrName IN ('Associated Plan', 'Default Data classification Plan') AND ACP.modified=0

	INNER JOIN App_Plan AP WITH(NOLOCK)

ON CAST(AP.id AS NVARCHAR(128))=ACP.attrVal AND AP.subType=117506053 AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)

	INNER JOIN APP_ClientProp ACPVM WITH(NOLOCK)

		ON ACP.componentNameId=ACPVM.componentNameId AND ACPVM.attrName = 'Virtual Server Discovered Clients' AND ACPVM.attrVal = '1' AND ACPVM.modified = 0

	UPDATE #SubclientForDCPlanTbl1

	SET 

ciPolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Content Indexing Policy',  default), 0),

indexserver = ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Analytics Index Server Id',  default), 0)

	--	Finally update the table

	MERGE APP_SubClientProp AS DEST

        USING #SubclientForDCPlanTbl1 AS SRC

            ON DEST.componentNameId = SRC.subclient AND DEST.attrname=N'Associated index server id' AND DEST.modified = 0 AND DEST.cs_attrName = checksum(N'Associated index server id') 

        WHEN NOT MATCHED THEN

            INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

                Values( Src.subclient, N'Associated index server id', 7, SRC.indexServer, @curTime, 0, 0);

	MERGE APP_SubClientProp AS DEST

        USING #SubclientForDCPlanTbl1 AS SRC

            ON DEST.componentNameId = SRC.subclient AND DEST.attrname=N'Indexing Configuration Policy' AND DEST.modified = 0 AND DEST.cs_attrName = checksum(N'Indexing Configuration Policy') 

        WHEN NOT MATCHED THEN

            INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

                Values( Src.subclient, N'Indexing Configuration Policy', 7, SRC.ciPolicyId, @curTime, 0, 0);

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('adfc294f-64c1-4d25-b922-8536dea6a011', 'PortLegacyDCPlanSupportForVSASubclient', 'VM Client - Copy DC plan property to all applicable subclients', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '899f96d1-e4e4-45eb-a847-dc83535ec741')

BEGIN
	INSERT INTO APP_SubClientProp


	SELECT ASCP2.componentNameId, 'Advanced indexing status', ASCP2.attrType, '1', ASCP2.created,0,0 FROM APP_SubClientProp ASCP2 WITH(NOLOCK)

	LEFT OUTER JOIN APP_SubClientProp ASCP3  WITH(NOLOCK) ON

		ASCP3.componentNameId=ASCP2.componentNameId AND ASCP3.attrName='Advanced indexing status' AND ASCP3.modified=0 AND ASCP3.cs_attrName = checksum(N'Advanced indexing status')

	WHERE ASCP2.attrName='Associated index server id' AND ASCP2.modified=0 AND ASCP2.cs_attrName = checksum(N'Associated index server id') AND ASCP2.attrVal<>'0'

	AND ASCP3.ID IS NULL

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('899f96d1-e4e4-45eb-a847-dc83535ec741', 'PortLegacyDCPlanSupportForVSASubclient', 'VM Client - Update advanced indexing server status', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '0289A5F0-DFDD-45AA-B67C-2676E67ADF69')

BEGIN
	INSERT INTO APP_SubClientProp


	(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT appId, 'Last Data Protected Time', 7, MAX(lastBackup), @curTime, 0, 0

	FROM

	(

		SELECT componentNameId appId, attrVal lastBackup

		FROM APP_SubClientProp WHERE attrName = 'Nothing to backup' AND cs_attrName = CHECKSUM(N'Nothing to backup') AND modified = 0

		UNION

		SELECT appId, MAX(servEndDate) lastBackup

		FROM JMBkpStats B

		JOIN APP_Application A ON A.id = B.appId

		WHERE B.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS

		AND B.opType in (4 /*BACKUP*/, 18 /*BACKUP3RD*/, 59 /*SNAPBACKUP*/, 65 /*SNAPBACKUP3RD*/, 30 /*SYSSTATEBACKUP*/, 43 /*SYSRECOVERYBACKUP*/) -- JMShouldUpdateLastBackupTime

		GROUP BY appId

	) T

	LEFT OUTER JOIN APP_SubClientProp SP ON SP.componentNameId = T.appId AND SP.attrName = 'Last Data Protected Time' AND SP.cs_attrName = CHECKSUM(N'Last Data Protected Time') AND SP.modified = 0

	WHERE SP.attrVal IS NULL

	GROUP BY appId

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('0289A5F0-DFDD-45AA-B67C-2676E67ADF69', 'setLastDataProtectedTimeV3', 'Set Last Data Protected Time property', @curTime, 16, 0, (16 + 2))

END

-- One time update for NFS clients to set retention properties 'Grace Period For Versions' and 'Versions in Drive' to '0'.

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '09E4E2CE-18CF-4775-8604-64271D562609')

BEGIN

	UPDATE SCP 

		SET SCP.attrVal = '0'

	FROM App_Edgedriveassociation (nolock) AE

	INNER JOIN App_Application (nolock) SC ON AE.entityid = SC.backupset

	INNER JOIN App_Subclientprop SCP ON SCP.componentNameId = SC.ID              

	INNER JOIN App_Clientprop CP (nolock) ON CP.componentNameId = AE.clientid   

	WHERE AE.entitytype = 65 /**SUBCLIENT_POLICY_ENTITY **/ 

	AND SCP.attrname in ('Grace Period For Versions', 'Versions in Drive') AND SCP.modified = 0 

	AND CP.attrname = N'System Drive Type' AND CP.modified = 0 AND CP.attrVal = '4' --NFS Object Store
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('09E4E2CE-18CF-4775-8604-64271D562609', 'NFSDataAgingDefaultsUpdate', 'Update Data Aging defaults for NFS object store', @curTime, 16, 0, (16 + 2))

END

DECLARE @disableContentStoreScheduleGUID varchar(36) = 'EB408E06-57C6-4EF8-B54B-5A1449ACF8DB'   

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @disableContentStoreScheduleGUID)

BEGIN   

	UPDATE TM_Task SET deleted = 1 WHERE taskName = 'System Created for Content Store'
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@disableContentStoreScheduleGUID, 'Delete Content Store schedule', 'Deleting content store system created schedule', datediff(second, '01/01/1970', GETDATE()), 16, 0 , (16 + 1))

END

IF object_id('tempdb.dbo.#subclient_OptionTable') is not null 

	DROP TABLE #subclient_OptionTable

CREATE TABLE #subclient_OptionTable (subclientId INT, collectMetaInfo INT, granularrecovery INT, collectVMGranularRecoveryMetadataForBkpCopy INT, ccpId INT);

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '4EC5A0AC-238E-4F27-9CF1-EE7C4C363F63')

	OR NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '9F779184-C25C-4657-8291-1B0CBDA8D13A')

BEGIN

    WITH ScheduleIds (

        scheduleId,

        taskId

    ) AS (

        SELECT DISTINCT 

            STASK.subTaskid,

            TASK.taskId

        FROM TM_Task AS TASK WITH(READUNCOMMITTED)

        INNER JOIN TM_SubTask AS STASK WITH(READUNCOMMITTED)

            ON TASK.taskId = STASK.taskId

        INNER JOIN TM_SubTaskOptions AS SOPT WITH(READUNCOMMITTED)

            ON STASK.subTaskId = SOPT.subTaskId

        INNER JOIN TM_PatternAssoc AS PATASSOC WITH(READUNCOMMITTED)

            ON PATASSOC.subTaskId = STASK.subTaskId

        INNER JOIN TM_Pattern AS PAT WITH(READUNCOMMITTED)

            ON PAT.patternId = PATASSOC.patternId

        INNER JOIN TM_RunTime AS RT WITH(READUNCOMMITTED)

            ON RT.patternId = PAT.patternId

        INNER JOIN TM_RunTimeAssoc AS RTASSOC WITH(READUNCOMMITTED)

            ON RTASSOC.runTimeId = RT.runTimeId

        INNER JOIN TM_AssocEntity AS ASSOC WITH(READUNCOMMITTED)

            ON ASSOC.taskId = TASK.taskId

        WHERE  

            STASK.subTaskType = 2

            AND SOPT.optionId = 458405394

            AND RTASSOC.processed = 0

            AND RTASSOC.firing = 0

            AND RT.processed = 0

            AND RT.firing = 0

            AND TASK.deleted = 0

            AND TASK.invalid = 0

            AND TASK.uninstalled = 0

    ),

    -- filter applications down to minimum set

     AppIds (

        id,

        clientId,

        appTypeId,

        instanceId,

        backupSetId

    ) AS (

    SELECT

            a.id,

            a.clientId,

            a.appTypeId,

            a.instance,

            a.backupSet

        FROM APP_Application a WITH(READUNCOMMITTED)

        WHERE

            a.subclientStatus & (0x00010) = 0 --Dummy

            AND a.subclientStatus & (0x00020) = 0 --Hidden    

            AND a.subclientStatus & (0x00004) = 0 --deleted

            AND a.subclientStatus & (0x00002) = 0 --uninstalled

            AND a.appTypeId <> 1000 --DR Subclient  

    )
	INSERT INTO #subclient_OptionTable


	(subclientId, collectMetaInfo, granularrecovery, collectVMGranularRecoveryMetadataForBkpCopy, ccpId)

	SELECT subClientId, op.value('@collectMetaInfo', 'INT') collectMetaInfo, op.value('dataOpt[1]/@granularrecovery', 'INT') granularrecovery, op.value('dataOpt[1]/@collectVMGranularRecoveryMetadataForBkpCopy', 'INT') collectVMGranularRecoveryMetadataForBkpCopy, AP.ccpId

	FROM

	(

        -- compute all subclient schedules

        SELECT 

            s.scheduleId,

            ae.subclientId subClientId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

            INNER JOIN AppIds a

                ON a.id = ae.subclientId

        WHERE

            ae.subclientId <> 0

        UNION

        SELECT 

            s.scheduleId,

            a.id appId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

                AND ae.subclientId = 0

            INNER JOIN APP_ClientGroupAssoc cga WITH(READUNCOMMITTED)

                ON (

                    ae.assocType = 28

                    AND ae.clientGroupId = cga.clientGroupId

                )

            LEFT JOIN AppIds a

                ON ae.exclude = 0

                    AND cga.clientId = a.clientId

        WHERE

            a.id IS NOT NULL

        UNION

        SELECT  

            s.scheduleId,

            a.id appId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

                AND ae.subclientId = 0

            LEFT JOIN AppIds a

                ON ae.exclude = 0

                    AND ae.clientId = a.clientId

                    AND ae.assocType = 3

        WHERE

            a.id IS NOT NULL

        UNION

        SELECT  

            s.scheduleId,

            a.id appId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

                AND ae.subclientId = 0

            LEFT JOIN AppIds a

                ON ae.exclude = 0

                    AND ae.clientId = a.clientId

                    AND ae.appTypeId = a.appTypeId

                    AND ae.assocType = 4

        WHERE

            a.id IS NOT NULL

        UNION

        SELECT  

            s.scheduleId,

            a.id appId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

                AND ae.subclientId = 0

            LEFT JOIN AppIds a

                ON ae.exclude = 0

                    AND ae.instanceId = a.instanceId

                    AND ae.assocType = 5

        WHERE

            a.id IS NOT NULL

        UNION

        SELECT  

            s.scheduleId,

            a.id appId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

                AND ae.subclientId = 0

            LEFT JOIN AppIds a

                ON ae.exclude = 0

                    AND ae.subclientId = a.id

                    AND ae.assocType = 7

        WHERE

            a.id IS NOT NULL

        UNION

        SELECT  

            s.scheduleId,

            a.id appId

        FROM ScheduleIds s

            INNER JOIN TM_AssocEntity AS ae WITH(READUNCOMMITTED)

                ON ae.taskId = s.taskId

                AND ae.subclientId = 0

            LEFT JOIN AppIds a

                ON ae.exclude = 0

                    AND ae.assocType = 2

        WHERE

            a.id IS NOT NULL

	) SE

	JOIN APP_Application (NOLOCK) AP ON AP.id = SE.subClientId AND AP.appTypeId = 106

	JOIN TM_SubTaskXMLOptions (NOLOCK) XO ON XO.subTaskId = SE.scheduleId

	CROSS APPLY XO.xmlValue.nodes('/TMMsg_JobOption/backupOpts') O(op)

	ORDER BY subClientId

END

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '4EC5A0AC-238E-4F27-9CF1-EE7C4C363F63')

BEGIN

	--As per Ajay do not check for existing property and follow below logic

	--if (Collectmetadata)

	--{

	--	If (snap subclient)

	--		Virtual Server Catalog File Details For Snap = 1

	--	Else

	--		Virtual Server Catalog File Details  = 1

	--}

	--If (collectVMGranularRecoveryMetadataForBkpCopy is set)

	--{

	--	If (collectVMGranularRecoveryMetadataForBkpCopy == true)

	--		Virtual Server Catalog File Details  = 1

	--}

	--else

	--{

	--	If (granular recovery)

	--	{

	--		Virtual Server Catalog File Details  = 1

	--	}

	--}
	INSERT INTO APP_SubClientProp


	(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT subclientId, 

	CASE WHEN P.attrVal = '1' THEN 'Virtual Server Catalog File Details For Snap'

	ELSE 'Virtual Server Catalog File Details'

	END,

	2 /*PROPERTY_BOOLEAN*/ attrType,

	1,

	@curTime created,

	0 modified, 

	SO.ccpId

	FROM #subclient_OptionTable SO

	--ONLY FOR SNAP SUBCLIENTS

	LEFT OUTER JOIN APP_SubClientProp P (NOLOCK) ON P.componentNameId = SO.subclientId

		AND P.attrName = 'Enable Snap Backups' AND P.modified = 0 AND P.attrVal = '1'

		AND cs_attrName = CHECKSUM(N'Enable Snap Backups')

		AND P.ccpId = SO.ccpId

	WHERE collectMetaInfo = 1

	UNION

	SELECT T.subclientId, 'Virtual Server Catalog File Details', 2 /*PROPERTY_BOOLEAN*/ attrType, 

	1 attrVal,

	@curTime created,

	0 modified, 

	T.ccpId

	FROM

	(

		SELECT subclientId, ccpId

		FROM #subclient_OptionTable

		WHERE collectVMGranularRecoveryMetadataForBkpCopy = 1

		UNION

		SELECT subclientId, ccpId

		FROM #subclient_OptionTable

		WHERE collectVMGranularRecoveryMetadataForBkpCopy IS NULL AND granularrecovery = 1

	) T

	--ONLY FOR SNAP SUBCLIENTS

	JOIN APP_SubClientProp P (NOLOCK) ON P.componentNameId = T.subclientId

		AND P.attrName = 'Enable Snap Backups' AND P.modified = 0 AND P.attrVal = '1'

		AND cs_attrName = CHECKSUM(N'Enable Snap Backups')

		AND P.ccpId = T.ccpId

IF object_id('tempdb.dbo.#subclient_OptionTable') is not null 

	DROP TABLE #subclient_OptionTable
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('4EC5A0AC-238E-4F27-9CF1-EE7C4C363F63', 'setGranularRecoveryProperty', 'Set Granular recovery property fix', @curTime, 16, 0, (16 + 2))

END

ELSE IF EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '4EC5A0AC-238E-4F27-9CF1-EE7C4C363F63') --THE SET SCRIPT HAS ALREADY RUN

	AND NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '9F779184-C25C-4657-8291-1B0CBDA8D13A')

	--IF SET SCRIPT ALREADY RUN BUT UPDATE SCRIPT HAS NOT THEN

BEGIN

	--REMOVE THOSE THAT ARE NOT SNAPS SUBCLIENTS

	UPDATE APP_SubClientProp SET modified=@curTime

	WHERE id IN (

		SELECT SP.id

		FROM

		(

			SELECT subclientId, ccpId

			FROM #subclient_OptionTable

			WHERE collectVMGranularRecoveryMetadataForBkpCopy = 1 AND collectMetaInfo = 0

			UNION

			SELECT subclientId, ccpId

			FROM #subclient_OptionTable

			WHERE collectVMGranularRecoveryMetadataForBkpCopy IS NULL AND granularrecovery = 1

		) T

		JOIN APP_SubClientProp SP (NOLOCK) ON SP.componentNameId = T.subclientId

			AND SP.cs_attrName = CHECKSUM(N'Virtual Server Catalog File Details')

			AND SP.attrName = 'Virtual Server Catalog File Details'

			AND SP.attrVal = '1'

			AND SP.modified = 0

		--ONLY FOR SNAP SUBCLIENTS

		LEFT JOIN APP_SubClientProp P (NOLOCK) ON P.componentNameId = T.subclientId

			AND P.attrName = 'Enable Snap Backups' AND P.modified = 0

			AND P.cs_attrName = CHECKSUM(N'Enable Snap Backups')

			AND P.ccpId = T.ccpId

		WHERE P.attrVal = '0' OR P.attrVal IS NULL

	)

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('9F779184-C25C-4657-8291-1B0CBDA8D13A', 'updateGranularRecoveryProperty', 'Update Granular recovery property fix', @curTime, 16, 0, (16 + 2))

END

IF object_id('tempdb.dbo.#subclient_OptionTable') is not null 

	DROP TABLE #subclient_OptionTable

-- Execute below script everytime, we should remove it after couple of service packs or once we know that majority of the customers are upgraded to index V2.

-- There was some index copy issue specific to Index V2 introduced in 11.0 SP5, to fix it we created couple of HFs. As part of the fix to indicate whether the subclient has run a full scan or not we introduced a new subclient property. If the subclient property is not present or not set to Ignore then we force a full scan.

-- Starting SP8, Index has started supporting V1 to V2 upgrade for FS snap iDAs. After the index is upgraded, above HF is forcing full scan since the subclient property is not present.

-- For Win/UNIX FS iDAs under NetApp NAS clients with Index V1 add the subclient property so that after index upgrade full scan is not forced.

DECLARE @now INT = datediff(second, '01/01/1970', GETDATE())

DECLARE @newPropName VARCHAR(max) = 'Performed full scan job-id'

DECLARE @newPropValue VARCHAR(max) = 'Ignore'
INSERT INTO app_subclientprop


SELECT app.id, @newPropName, 1, @newPropValue, @now, 0, 0 FROM APP_Application app WITH(NOLOCK)

							INNER JOIN APP_AppTypeGroupAssoc idaType WITH(NOLOCK) ON app.appTypeId = idaType.appTypeId

												AND idaType.appGroupId IN( 22, 34)

												AND NOT EXISTS (SELECT 1 FROM app_subclientprop WHERE attrName=@newPropName and attrval=@newPropValue and modified=0 and componentNameId=app.id) 

							INNER JOIN APP_Client cli WITH(NOLOCK) ON cli.id = app.clientId

												AND cli.simOperatingSystemId = 16

												AND NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentnameid=cli.id and attrname='IndexingV2' and attrval='1' and modified=0)

-- Removing the rows which have duplicate properties for each Component Id

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '7F22FCD2-0965-404A-A0BB-B9EB4B6F01E9')

BEGIN

	DECLARE @lt_doubleEntries TABLE (componentNameId INTEGER, attrName NVarChar(255), MaxId INTEGER)
	INSERT INTO @lt_doubleEntries


	SELECT

       scp.componentNameId,

       scp.attrName,

       MAX(scp.id) maxId

	FROM APP_SubClientProp scp WITH(NOLOCK)

	WHERE

       scp.modified = 0

	GROUP BY

       scp.componentNameId,

       scp.attrName

	HAVING

       COUNT(scp.id) > 1

	DELETE APP_subclientprop

	FROM    APP_subclientprop AS SCP, @lt_doubleEntries AS tt

	WHERE   SCP.componentNameId = tt.ComponentNameId 

	        AND SCP.attrName = tt.attrName

	        AND SCP.modified = 0 AND SCP.id <> tt.MaxId

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('7F22FCD2-0965-404A-A0BB-B9EB4B6F01E9', 'Removing the rows which have duplicate properties for each Component Id', 'Removing the rows which have duplicate properties for each Component Id', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'CC51BBF1-D244-42E8-B4E4-8EBB14031644')

BEGIN

	WITH LastJobsCTE AS  

	(  

		SELECT ROW_NUMBER() OVER (PARTITION BY appId ORDER BY servEndDate DESC) AS ROWNUM, appId, totalUncompBytes

		FROM JMBkpStats B

		JOIN APP_Application A ON A.id = B.appId

		WHERE B.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS

		AND B.opType in (4, 18, 59, 65, 30, 43) -- JMShouldUpdateLastBackupTime  

	)
	INSERT INTO APP_SubClientProp


	(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT appId, 'Last Backup Size', 15, CAST(totalUncompBytes AS NVARCHAR(MAX)), @curTime, 0, 0

	FROM LastJobsCTE CTE

	LEFT OUTER JOIN APP_SubClientProp SP ON SP.componentNameId = CTE.appId AND SP.attrName = 'Last Backup Size' AND SP.cs_attrName = CHECKSUM(N'Last Backup Size') AND SP.modified = 0

	WHERE SP.attrVal IS NULL AND ROWNUM = 1;

	-- Prune Last data protected time if all successful jobs are deleted for the subclient

	DELETE SP

	FROM APP_SubClientProp SP

	LEFT OUTER JOIN JMBkpStats JM ON JM.appId = SP.componentNameId AND JM.status IN (1, 3, 14) 

	WHERE SP.attrName = 'Last Data Protected Time' AND SP.cs_attrName = CHECKSUM(N'Last Data Protected Time') ANd modified = 0

	AND JM.jobid IS NULL

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('CC51BBF1-D244-42E8-B4E4-8EBB14031644', 'setLastBackupSizeAndPruneDataProtectedTime', 'Set Last Backup Size property and prune Last Data Protected time', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '008E5421-7A03-45CE-904F-DE1B50199C47')

BEGIN

	DECLARE @subclientPolicyHasRetention INT = 1		--  0: Do not show retention tab on subclient policy, 1:Show retention tab on subclient policy

	DECLARE @extendStoragePolicyRetention INT = 1		--  0: Disable Object based retention, 1: Enable Object based retention

	DECLARE @archiverRetention INT = 0					--  0: Disable Archiver retention, 1:Enable Archiver retention

	DECLARE @extendRetentionForNDays INT = -1			-- -1: Extend retention indefinitely, 365 = Extend retention for 1 year

	DECLARE @backupRetention INT = 1					-- 0: Disable Backup retention, 1: Enable Backup retention

	DECLARE @afterDeletionKeepItemsForNDays INT = 730	-- -1: After deletion keep items indefinitely, 730 = After deletion keep items for 2 year

	DECLARE @olderFileVersionsMode INT = 2				-- 1: Keep older versions for days, 2: Keep versions

	DECLARE @keepOlderVersionsForNDays INT = -1			-- 365: Keep older versions for 1 year

	DECLARE @keepVersions INT = 5						-- 0: Keep 5 versions

	IF OBJECT_ID('tempdb.dbo.#subclientsOfPolicy') IS NOT NULL 

       DROP TABLE #subclientsOfPolicy

	CREATE TABLE #subclientsOfPolicy (appId INT PRIMARY KEY)

	INSERT #subclientsOfPolicy(appId)

	SELECT DISTINCT AAP.id 

		FROM App_PlanProp APP WITH (NOLOCK)

			INNER JOIN APP_Application AAP WITH (NOLOCK)

				ON CAST(AAP.backupSet AS NVARCHAR(2048)) = APP.attrVal AND AAP.appTypeId = 1030 AND (AAP.subclientStatus = 8 OR AAP.subclientStatus = 0) 

			INNER JOIN APP_BackupSetName ABN

				ON AAP.backupSet = ABN.id AND ABN.status = 128

			INNER JOIN App_Plan P WITH (NOLOCK)

				ON P.id = APP.componentNameId

WHERE APP.attrName in ('Subclient policy 2','Subclient policy 3','Subclient policy 4')

AND P.subType = 33554439

	UPDATE T

		   SET T.modified = @curTime

	FROM APP_SubClientProp T

	INNER JOIN #subclientsOfPolicy S ON S.appId = T.componentNameId

	WHERE T.attrName IN(N'Subclient Policy Has Retention', 

						N'Is Turbo Subclient',

						N'Extended Storage Policy Retention',

						N'Is Archive Retention Mode Enabled',

						N'Archived expiration days',

						N'User deleted stubs expiration days',

						N'Is Backup Retention Mode Enabled',

						N'Keep items past their expiration',

						N'Keep older Synth Full Versions',

						N'Number of Days of Synth Full Versions',

						N'Number of Synth Full Versions'

						)

	 AND T.modified = 0

	IF @subclientPolicyHasRetention = 1

		INSERT APP_SubClientProp

		SELECT appId, N'Subclient Policy Has Retention', 2, N'1', @curTime, 0, 0 FROM #subclientsOfPolicy

	ELSE

		INSERT APP_SubClientProp

		SELECT appId, N'Subclient Policy Has Retention', 2, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

	IF @extendStoragePolicyRetention = 1

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Is Turbo Subclient', 2, N'1', @curTime, 0, 0 FROM #subclientsOfPolicy

		INSERT APP_SubClientProp

		SELECT appId, N'Extended Storage Policy Retention', 2, N'1', @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	ELSE

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Is Turbo Subclient', 2, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

		INSERT APP_SubClientProp

		SELECT appId, N'Extended Storage Policy Retention', 2, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	IF @archiverRetention = 1

		INSERT APP_SubClientProp

		SELECT appId, N'Is Archive Retention Mode Enabled', 2, N'1', @curTime, 0, 0 FROM #subclientsOfPolicy

	ELSE

		INSERT APP_SubClientProp

		SELECT appId, N'Is Archive Retention Mode Enabled', 2, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

	IF @extendRetentionForNDays = -1

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Archived expiration days', 7, N'-1', @curTime, 0, 0 FROM #subclientsOfPolicy

		INSERT APP_SubClientProp

		SELECT appId, N'User deleted stubs expiration days', 7, N'-1', @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	ELSE

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Archived expiration days', 7, @extendRetentionForNDays, @curTime,0, 0 FROM #subclientsOfPolicy

		INSERT APP_SubClientProp

		SELECT appId, N'User deleted stubs expiration days', 7, @extendRetentionForNDays, @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	IF @backupRetention = 1

		INSERT APP_SubClientProp

		SELECT appId, N'Is Backup Retention Mode Enabled', 2, N'1', @curTime, 0, 0 FROM #subclientsOfPolicy

	ELSE

		INSERT APP_SubClientProp

		SELECT appId, N'Is Backup Retention Mode Enabled', 2, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

	IF @afterDeletionKeepItemsForNDays = -1

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Keep items past their expiration', 2, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	ELSE

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Keep items past their expiration', 2, N'1', @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	INSERT APP_SubClientProp

	SELECT appId, N'Keep older Synth Full Versions', 7, @olderFileVersionsMode, @curTime, 0, 0 FROM #subclientsOfPolicy

	IF @olderFileVersionsMode = 1

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Number of Days of Synth Full Versions', 7, @keepOlderVersionsForNDays, @curTime, 0, 0 FROM #subclientsOfPolicy

		INSERT APP_SubClientProp

		SELECT appId, N'Number of Synth Full Versions', 7, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	ELSE

	BEGIN

		INSERT APP_SubClientProp

		SELECT appId, N'Number of Days of Synth Full Versions', 7, N'0', @curTime, 0, 0 FROM #subclientsOfPolicy

		INSERT APP_SubClientProp

		SELECT appId, N'Number of Synth Full Versions', 7, @keepVersions, @curTime, 0, 0 FROM #subclientsOfPolicy

	END

	IF OBJECT_ID('tempdb.dbo.#subclientsOfPolicy') IS NOT NULL 

       DROP TABLE #subclientsOfPolicy
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('008E5421-7A03-45CE-904F-DE1B50199C47', 'PolicyBasedRetentionForLaptopPlans', 'Upgrading laptop plan subclient policies to have default retention settings', @curTime, 16, 0, (16 + 2))

END

DECLARE @planParentEntityGuid varchar(36) = '3fb0d424-ced1-4aa3-97b5-746d515cbb3c'

IF NOT EXISTS(SELECT 1 FROM	GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE	gp.SqlScriptGUID = @planParentEntityGuid)

BEGIN

	DECLARE @SubclientForPlanTable TABLE (subclientId INT)

	IF OBJECT_ID('tempdb.dbo.#SubclientForPlanTable') IS NOT NULL

		DROP TABLE #SubclientForPlanTable

	CREATE TABLE #SubclientForPlanTable ( id INT IDENTITY(1,1), subclientId	INT, backupSet INT, instance INT, clientId INT, planId INT, planParentEntityType INT DEFAULT NULL, planParentEntityId INT DEFAULT NULL)
	INSERT INTO #SubclientForPlanTable (subclientId, backupSet, instance, clientId, planId)


	SELECT componentNameId, backupSet, instance, clientId, CAST(attrVal AS INT)  FROM APP_SubClientProp ASCP

	INNER JOIN APP_Application AAP

		ON AAP.id=ASCP.componentNameId

WHERE ASCP.attrName='Associated Plan' AND ASCP.modified=0

	-- Now lets start looking for Parent Entity

	-- First Backupset

	UPDATE SCPT

	SET 

SCPT.planParentEntityType = 6,

		SCPT.planParentEntityId = SCPT.backupSet

	FROM #SubclientForPlanTable SCPT

	INNER JOIN APP_BackupSetProp ABP

ON ABP.componentNameId=SCPT.backupSet AND ABP.attrName='Associated Plan' AND ABP.modified=0 AND ABP.attrVal=CAST(planId AS NVARCHAR(32))

	-- Second Instance

	UPDATE SCPT

	SET

SCPT.planParentEntityType = 5,

		SCPT.planParentEntityId = SCPT.instance

	FROM #SubclientForPlanTable SCPT

	INNER JOIN App_InstanceProp ABP

ON ABP.componentNameId=SCPT.instance AND ABP.attrName='Associated Plan' AND ABP.modified=0 AND ABP.attrVal=CAST(planId AS NVARCHAR(32))

	WHERE SCPT.planParentEntityType IS NULL

	-- Third Client

	UPDATE SCPT

	SET

SCPT.planParentEntityType = 3,

		SCPT.planParentEntityId = SCPT.clientId

	FROM #SubclientForPlanTable SCPT

	INNER JOIN App_ClientProp ACP

		ON ACP.componentNameId=SCPT.clientId AND ACP.modified=0 AND ACP.attrVal=CAST(planId AS NVARCHAR(32))

WHERE (ACP.attrName =  'Associated Plan' OR ACP.attrName like 'Default % Plan') AND SCPT.planParentEntityType IS NULL

	-- Fourth Company

	UPDATE SCPT

	SET

SCPT.planParentEntityType = 61,

		SCPT.planParentEntityId = ACP1.componentNameId

	FROM #SubclientForPlanTable SCPT

	INNER JOIN App_ClientProp ACP WITH(NOLOCK)

ON ACP.componentNameId=SCPT.clientId AND ACP.attrName='Installation Company ID' AND ACP.modified=0

	INNER JOIN App_CompanyProp ACP1

			ON CAST(ACP1.componentNameId AS NVARCHAR(32))=ACP.attrVal AND ACP1.attrval=CAST(planId AS NVARCHAR(32))

WHERE ACP1.attrName LIKE 'Default % Plan' AND SCPT.planParentEntityType IS NULL

	-- Whatever NULL is left, ignore them

	DELETE FROM #SubclientForPlanTable WHERE planParentEntityType IS NULL

	--	Finally update the table

	MERGE APP_SubClientProp AS DEST

	USING #SubclientForPlanTable AS SRC

ON DEST.componentNameId = SRC.subclientId AND DEST.attrname='Associated Plan Parent EntityType' AND DEST.modified = 0

	WHEN NOT MATCHED THEN

		INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

Values( Src.subclientId, 'Associated Plan Parent EntityType', 7, SRC.planParentEntityType, @curTime, 0, 0);

	MERGE APP_SubClientProp AS DEST

	USING #SubclientForPlanTable AS SRC

ON DEST.componentNameId = SRC.subclientId AND DEST.attrname='Associated Plan Parent EntityId' AND DEST.modified = 0

	WHEN NOT MATCHED THEN

		INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)

Values( Src.subclientId, 'Associated Plan Parent EntityId', 7, SRC.planParentEntityId, @curTime, 0, 0);
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@planParentEntityGuid, 'PlanParentEntityUpdate_1', 'Update Subclient Properties with plan Parent Entity', @curTime, 16, 0, (16 + 2))

END

DECLARE @planParentEntityRemoveGuid varchar(36) = '17eb528b-6834-4267-900c-e98ba94c2b36'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @planParentEntityRemoveGuid)

BEGIN

	DELETE ASCP

		FROM APP_SubClientProp ASCP 

	INNER JOIN APP_SubClientProp ASCP2 

ON ASCP2.componentNameId=ASCP.componentNameId AND ASCP2.attrname='Associated Plan Parent EntityType' AND ASCP2.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityType')

AND ASCP2.modified=0 AND  ASCP2.attrval=CAST(61 AS NVARCHAR(16))

WHERE ASCP.attrName in ('Associated Plan Parent EntityType', 'Associated Plan Parent EntityId') AND ASCP.modified=0 AND

ASCP.cs_attrName in (CHECKSUM(N'Associated Plan Parent EntityType'), CHECKSUM(N'Associated Plan Parent EntityId'))
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@planParentEntityRemoveGuid, 'RemovePlanParentEntity', 'Update SubclientProp to not show company as plan parent entity', @curTime, 16, 0, (16 + 2))

END

DECLARE @updateSubclientPolicyGuid varchar(36) = 'b67b2f43-a413-45cf-9d29-12d144d9a292'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @updateSubclientPolicyGuid)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#subclientOfPolicy') IS NOT NULL 

        DROP TABLE #subclientOfPolicy

	CREATE TABLE #subclientOfPolicy (appId INT PRIMARY KEY, planSubType INT)

	-- getting list of id of subclient to be edited in the APP_SubClientProp table

	INSERT #subclientOfPolicy(appId, planSubType) 

		SELECT DISTINCT AAP.id , P.subType 

			FROM App_PlanProp APP WITH (NOLOCK)

				INNER JOIN APP_Application AAP WITH (NOLOCK)

ON CAST(AAP.backupSet AS NVARCHAR(2048)) = APP.attrVal AND AAP.appTypeId = 1030 AND ((AAP.subclientStatus & 0x00008)=0x00008)

				INNER JOIN APP_BackupSetName ABN WITH (NOLOCK)

ON AAP.backupSet = ABN.id AND ABN.status = 0x0080

				INNER JOIN App_Plan P WITH (NOLOCK)

					ON P.id = APP.componentNameId

WHERE APP.attrName in ('Subclient policy 2','Subclient policy 3','Subclient policy 4')

AND P.subType in (33554437 ,33554439)

	-- insert new values and update old default existing values to new default values

	INSERT APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

	SELECT appId, N'Read Buffer Size', 10, N'512', @curTime, 0, 0 FROM #subclientOfPolicy sop 

		LEFT JOIN APP_SubClientProp scp WITH (NOLOCK)

			ON sop.appId=scp.componentNameId AND scp.cs_attrName = CHECKSUM(N'Read Buffer Size') AND scp.attrName=N'Read Buffer Size' AND scp.modified=0 

			WHERE scp.componentNameId IS NULL

	UNION ALL

	SELECT appId, N'sys:nStreams', 7, N'0', @curTime, 0, 0 FROM #subclientOfPolicy sop 

		LEFT JOIN APP_SubClientProp scp WITH (NOLOCK)

			ON sop.appId=scp.componentNameId AND scp.cs_attrName = CHECKSUM(N'sys:nStreams') AND scp.attrName = N'sys:nStreams' AND scp.modified=0 

			WHERE scp.componentNameId IS NULL

	UNION ALL

	SELECT appId, N'Is true up enabled for FS', 2, N'1', @curTime, 0, 0 FROM #subclientOfPolicy sop 

		LEFT JOIN APP_SubClientProp scp WITH (NOLOCK)

			ON sop.appId=scp.componentNameId AND scp.cs_attrName = CHECKSUM(N'Is true up enabled for FS') AND scp.attrName = N'Is true up enabled for FS' AND scp.modified=0 

			WHERE scp.componentNameId IS NULL

	UNION ALL

	SELECT appId, N'run true up after days for FS', 7, N'30', @curTime, 0, 0 FROM #subclientOfPolicy sop 

		LEFT JOIN APP_SubClientProp scp WITH (NOLOCK)

			ON sop.appId=scp.componentNameId AND scp.cs_attrName = CHECKSUM(N'run true up after days for FS') AND scp.attrName = N'run true up after days for FS' AND scp.modified=0 

			WHERE scp.componentNameId IS NULL

	UPDATE scp

	SET scp.modified=@curTime 

		FROM #subclientOfPolicy sop 

		JOIN APP_SubClientProp scp WITH (NOLOCK)

ON sop.appId=scp.componentNameId  AND sop.planSubType = 33554437

		WHERE scp.cs_attrName = CHECKSUM(N'Enable ACL Collection') AND scp.attrName = N'Enable ACL Collection' AND scp.attrVal=N'1' AND scp.modified=0

		IF (@@ROWCOUNT > 0)

			INSERT APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)

				SELECT appId, N'Enable ACL Collection', 2, N'0', @curTime, 0, 0 FROM #subclientOfPolicy sop 

				LEFT JOIN APP_SubClientProp scp WITH (NOLOCK)

					ON sop.appId=scp.componentNameId AND scp.cs_attrName = CHECKSUM(N'Enable ACL Collection') AND scp.attrName = N'Enable ACL Collection' AND scp.modified=0 

WHERE scp.componentNameId IS NULL AND sop.planSubType = 33554437
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@updateSubclientPolicyGuid, 'UpdateSubclientPolicy', 'Update SubclientProp to correct default options for existing plans', @curTime, 16, 0, (16 + 2))

END

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'A3FE61B3-90DB-43CE-AB7D-C5481664940C')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#SCPolicySubclients') IS NOT NULL 

		DROP TABLE #SCPolicySubclients

	CREATE TABLE #SCPolicySubclients (appId INT PRIMARY KEY, planRetention INT)

	INSERT #SCPolicySubclients(appId, planRetention)

	SELECT DISTINCT AAP.id, ISNULL(CAST(APP1.attrVal AS INT),730)

		FROM App_PlanProp APP WITH (NOLOCK)

			INNER JOIN APP_Application AAP WITH (NOLOCK)

				ON CAST(AAP.backupSet AS NVARCHAR(2048)) = APP.attrVal AND AAP.appTypeId = 1030 AND (AAP.subclientStatus = 8 OR AAP.subclientStatus = 0) 

			INNER JOIN APP_BackupSetName ABN

				ON AAP.backupSet = ABN.id AND ABN.status = 128

			INNER JOIN App_Plan P WITH (NOLOCK)

				ON P.id = APP.componentNameId

			INNER JOIN App_PlanProp APP1

				ON APP1.componentNameId = APP.componentNameId

WHERE APP.attrName in ('Subclient policy 2','Subclient policy 3','Subclient policy 4')

AND APP1.attrName = 'Subclient retention period'

AND P.subType = 33554439

	--updating existing values and creating new ones for the deleted items retention days

	UPDATE T

		   SET T.modified = @curTime

	FROM APP_SubClientProp T

		INNER JOIN #SCPolicySubclients S 

			ON S.appId = T.componentNameId

		WHERE T.attrName = N'Days to keep items past their expiration'

			AND T.modified = 0

	INSERT APP_SubClientProp

	SELECT S.appId, N'Days to keep items past their expiration', 7, S.planRetention, @curTime, 0, 0 FROM #SCPolicySubclients S

	IF OBJECT_ID('tempdb.dbo.#SCPolicySubclients') IS NOT NULL 

       DROP TABLE #SCPolicySubclients
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


	VALUES('A3FE61B3-90DB-43CE-AB7D-C5481664940C', 'SPSCRetentionSyncForLaptopPlans', 'Keeping subclient policy retention in sync with storage policy retention', @curTime, 16, 0, (16 + 2))

END

-- fix ref time for VM subclient

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '5390096E-7CAA-4211-8D9C-93E458BF5633')

BEGIN

	IF OBJECT_ID('tempdb.dbo.#VmSubclientList') IS NOT NULL 

		DROP TABLE dbo.#VmSubclientList

	CREATE TABLE #VmSubclientList(subclientId INTEGER PRIMARY KEY, lastFullCycleNum INTEGER, fullRefTime INTEGER, incrRefTime INTEGER);

	-- find all VM subclient 
	INSERT INTO #VmSubclientList(subclientId, lastFullCycleNum, fullRefTime,  incrRefTime)


	SELECT 

		APP.id, 0, 0, 0

	FROM APP_Application APP 

		INNER JOIN APP_client CL ON APP.clientId = CL.id

		INNER JOIN APP_ClientProp CP1 ON CP1.componentNameId = CL.id

		INNER JOIN APP_ClientProp CP2 ON CP2.componentNameId = CL.id

	WHERE  CP1.attrName = 'Virtual Server Discovered Clients' AND CP1.attrVal = '1' AND CP1.modified = 0

 		AND CP2.attrName = 'IndexingV2_VSA' AND CP2.attrVal = '1' AND CP2.modified = 0

	-- remove these subclient already had both full and incr ref time

   DELETE L FROM #VmSubclientList L

   INNER JOIN APP_SubClientProp P1 ON P1.componentNameId = L.subclientId

	INNER JOIN APP_SubClientProp P2 ON P2.componentNameId = L.subclientId

   WHERE P1.attrName = 'sys:last full' AND P1.modified = 0

		AND P2.attrName = 'sys:last incr' AND P2.modified = 0

	-- find last full cycle for each subclient

   UPDATE #VmSubclientList 

   SET lastFullCycleNum = R.lastFullCycleNum

   FROM #VmSubclientList L, 

		(SELECT appId, max(fullCycleNum) as lastFullCycleNum

   		FROM #VmSubclientList L1 

   		INNER JOIN JMBkpStats JBS ON JBS.appId = L1.subclientId 

   		GROUP BY JBS.appId) R 

	where L.subclientId = R.appId 

	-- find full ref time for each subclient

   UPDATE #VmSubclientList 

   SET fullRefTime = R.fullRefTime

   FROM #VmSubclientList L, 

		(SELECT appId, min(servStartDate) as fullRefTime

   		FROM #VmSubclientList L1 

   		INNER JOIN JMBkpStats JBS ON JBS.appId = L1.subclientId 

   		WHERE JBS.fullCycleNum = L1.lastFullCycleNum

   			AND JBS.bkpLevel IN (1, 64)   -- 1-full, 64-synthetic full

   			AND JBS.status IN (1, 3, 14)

   		GROUP BY JBS.appId) R 

	where L.subclientId = R.appId 

	-- find incr ref time for each subclient

   UPDATE #VmSubclientList 

   SET incrRefTime = R.incrRefTime

   FROM #VmSubclientList L, 

		(SELECT appId, max(servStartDate) as incrRefTime

   		FROM #VmSubclientList L1 

   		INNER JOIN JMBkpStats JBS ON JBS.appId = L1.subclientId 

   		WHERE JBS.fullCycleNum = L1.lastFullCycleNum

 				AND JBS.status IN (1, 3, 14)

   		GROUP BY JBS.appId) R 

	where L.subclientId = R.appId 

	DECLARE @nowTime1 integer = dbo.GetUnixTime (GetUTCdate())

   -- update full ref time
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)


	SELECT L.subClientId, 'sys:last full', 8, L.fullRefTime, @nowTime1, 0

   FROM #VmSubclientList L

   WHERE NOT EXISTS ( SELECT 1 FROM APP_SubClientProp SCP WHERE SCP.componentNameId = L.subClientId AND SCP.attrName = 'sys:last full' AND SCP.modified = 0 )

   -- update incr ref time
   INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)


	SELECT L.subClientId, 'sys:last incr', 8, L.fullRefTime, @nowTime1, 0

   FROM #VmSubclientList L

   WHERE NOT EXISTS ( SELECT 1 FROM APP_SubClientProp SCP WHERE SCP.componentNameId = L.subClientId AND SCP.attrName = 'sys:last incr' AND SCP.modified = 0 )

	IF OBJECT_ID('tempdb.dbo.#VmSubclientList') IS NOT NULL 

		DROP TABLE #VmSubclientList

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('5390096E-7CAA-4211-8D9C-93E458BF5633', 'FixRefTimeForVMSubclient', 'Fix ref time for VM subclient', @curTime, 16, 0, (16 + 2))

END

--Update File System Quota Usage property name to Application Size

DECLARE @fsQuotaPropertyUpdateGUID varchar(36) = 'E41FD75B-ED52-4993-9A05-05F7B8321A76'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @fsQuotaPropertyUpdateGUID)

BEGIN

UPDATE APP_SubclientProp SET attrName = N'Application Size' WHERE attrname = N'File System Quota Usage' AND cs_AttrName = CHECKSUM(N'File System Quota Usage')
INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@fsQuotaPropertyUpdateGUID, 'FSQuotaPropNameUpdate', 'Update File System Quota Usage property name to Application Size in SubclientProp', @curTime, 16, 0, (16 + 2))

END

DECLARE @useLocalContentUpgradeGuid uniqueidentifier = 'B3E3483B-90D2-47A3-8451-5BB32CF732FB'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @useLocalContentUpgradeGuid)

BEGIN

	DECLARE @currentTime integer = dbo.GetUnixTime (GetUTCdate())
	INSERT INTO APP_SubClientProp


SELECT S.componentNameId,N'Use Local Content', 10, 1, @currentTime,0,0

	FROM APP_SubclientProp S

WITH(NOLOCK) WHERE S.attrName = N'Associated Plan' AND S.attrVal != N'0' AND S.modified = 0 AND S.cs_attrName = CHECKSUM(N'Associated Plan')

			AND S.componentNameId NOT IN

				(SELECT componentNameId FROM APP_SubClientProp WITH (NOLOCK) 

				WHERE 

				(

(attrName = N'Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy') AND attrVal != N'0') OR

(attrName = N'Use Local Content' AND cs_attrName = CHECKSUM(N'Use Local Content')) --exclude already added local content flags

				)

				AND modified = 0)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@useLocalContentUpgradeGuid, 'useLocalContentUpgradeGuid', 'Update script to add local content flag to subclient props', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

DECLARE @populateLastBackupJobInfoGUID uniqueidentifier = 'FC95961A-C1FD-4E2F-B094-0387BDBAAA97'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @populateLastBackupJobInfoGUID)

BEGIN

	IF OBJECT_ID('tempdb.dbo.#lastBackupInfoTmp_scProp') IS NOT NULL 

		DROP TABLE dbo.#lastBackupInfoTmp_scProp

	CREATE TABLE #lastBackupInfoTmp_scProp(subclientId INTEGER PRIMARY KEY, agentIdaId INT, instanceId INT, appType INT, isCCDataBase INT, jobId INT, commcellId INT, jobEndTime INT, lastBackupInfo XML);

	-- Prune duplicate rows first if exists.

	DELETE SP

	FROM APP_SubClientProp SP

	INNER JOIN

	(

		SELECT ROW_NUMBER() OVER (PARTITION BY componentNameId ORDER BY id DESC) AS 'rowId', id

		FROM APP_SubClientProp

		WHERE attrName = 'Last Backup Job Info' AND modified = 0 AND cs_attrName = CHECKSUM(N'Last Backup Job Info')

	)T ON T.id = SP.id

	WHERE T.rowId > 1

	DELETE IP 

	FROM APP_IDAProp IP

	INNER JOIN

	(

		SELECT ROW_NUMBER() OVER (PARTITION BY componentNameId ORDER BY id DESC) AS 'rowId', id

		FROM APP_IDAProp

		WHERE attrName = 'Last Backup Job Info' AND modified = 0

	)T ON T.id = IP.id

	WHERE T.rowId > 1

	-- find all valid subclients 
	INSERT INTO #lastBackupInfoTmp_scProp(subclientId, agentIdaId, instanceId, appType, isCCDataBase)


	SELECT SC.id, IDA.id, SC.instance, SC.appTypeId,

		   CASE WHEN SC.appTypeId IN ( 81, -- MSSQL

										22, 80, 61, -- ORACLE_8, ORACLE_RAC, SAP

									    3, 5, -- INFORMIX, SYBASE

									    37, 62, 103, -- DB2, UNIXDB2, DB2DPF

									    104, 125, -- MYSQL, POSTGRESS

									    135 -- SAP_HANA

									   ) THEN 1 

				WHEN SC.appTypeId = 134 -- CLOUD_APPS

				  	 AND IP.attrVal IN ('4', '22', '23', '26', '27') -- CloudAppsInstanceType_AMAZON_RDS , CloudAppsInstanceType_AMAZON_DYNAMODB, CloudAppsInstanceType_AZURE_COSMOS_DB_SQL_API, CloudAppsInstanceType_AMAZON_REDSHIFT, CloudAppsInstanceType_AMAZON_DOCUMENTDB 

					 THEN 1

				ELSE 0 

		   END

	FROM APP_Application AS SC WITH(NOLOCK)

	INNER JOIN APP_Client AS CL WITH(NOLOCK) ON 

                        SC.clientId = CL.id

                        AND (CL.status & 4) = 0				-- deleted/agentless client

                        AND (SC.subclientStatus & 536) != 536           -- not an indexing subclient

                        AND (SC.subclientStatus & (16|32)) = 0          -- do not backup flags are no set

                        AND (SC.subclientStatus & 4) = 0		-- subclient is not deleted

                        AND dbo.IsSubClientValid(SC.appTypeId, SC.subclientStatus, 0) = 1   -- subclient is valid

                    INNER JOIN APP_BackupSetName AS BS WITH(NOLOCK) ON 

                        BS.id = SC.backupSet

                        AND BS.name <> N'defaultDummyBackupSet'

                    INNER JOIN APP_InstanceName AS INST WITH(NOLOCK) ON 

                        INST.id = SC.instance

                        AND INST.name NOT IN (N'DefaultDummyInstanceForOracle', N'defaultDummyInstanceForSAP')

                    INNER JOIN APP_IDAName AS IDA WITH(NOLOCK) ON 

                        IDA.clientId = SC.clientId

						AND IDA.appTypeId = SC.appTypeId

					LEFT JOIN APP_InstanceProp IP WITH(NOLOCK) ON 

                        IP.componentNameId = INST.id

                        AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0

                    LEFT JOIN APP_SubClientProp p WITH(NOLOCK) ON 

                        p.componentNameId = SC.id

                        AND p.attrName IN (N'Index SubClient', N'DDB Backup')

                        AND p.modified = 0

                        AND p.attrVal = N'1'

                        AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))

                WHERE 

                    p.id IS NULL -- Not an index or DDB subclient

					AND IDA.appTypeId <> 78 -- CV_APPTYPE_MS_SHAREPOINTV2_DOC -- This will be backupset level.

	-- Populate the jobIds

	UPDATE  L

	SET jobId = J.jobId,

		commcellId = J.commCellId,

		jobEndTime = J.servEndDate,

		lastBackupInfo = (

							SELECT	J.jobId AS '@jobID',

									J.commCellId AS '@commCellID',

									J.displayStatus AS '@status', -- Use display status always so that committed jobs show correctly

									J.failureReason AS '@failureReasonIds',

									J.failureReasonMsg AS '@failureReasonMessageEnglish',

									J.servEndDate AS 'endTime/@time',

									J.servStartDate AS 'startTime/@time'

							FOR XML PATH('lastBackupJobInfo'), TYPE

						 )

	FROM #lastBackupInfoTmp_scProp L 

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commCellId, servStartDate, servEndDate, displayStatus, failureReason, dbo.JMGetLocalizedMessageFunc(0, failureReason) AS failureReasonMsg

		FROM JMBkpStats AS BKP(NOLOCK) 

		WHERE BKP.appId = L.subclientId

		AND optype IN (4, 18, 59, 65, 30, 43) -- JMShouldUpdateLastBackupTime

		ORDER BY servEndDate DESC

	)J

	-- Save in subclient level

	-- If Prop already exists, update. Else insert below.

	UPDATE SP

	SET SP.attrVal = CAST(T.lastBackupInfo AS NVARCHAR(MAX)),

		SP.created = T.jobEndTime

	FROM #lastBackupInfoTmp_scProp T

	INNER JOIN APP_SubClientProp SP ON SP.componentNameId = T.subclientId AND SP.attrName = 'Last Backup Job Info' AND SP.modified = 0 ANd SP.cs_attrName = CHECKSUM(N'Last Backup Job Info')

	WHERE jobId IS NOT NULL -- Have a valid job
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT subclientId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp_scProp T

	LEFT OUTER JOIN APP_SubClientProp SP ON SP.componentNameId = T.subclientId AND SP.attrName = 'Last Backup Job Info' AND SP.modified = 0 ANd SP.cs_attrName = CHECKSUM(N'Last Backup Job Info')

	WHERE jobId IS NOT NULL -- Have a valid job

	AND SP.id IS NULL -- Prop not already exists, so insert.

	-- For DBs in command center, remove all except 1 latest row per instance

	DELETE L1

	FROM #lastBackupInfoTmp_scProp L1

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commcellId 

		FROM #lastBackupInfoTmp_scProp L2

		WHERE L2.instanceId = L1.instanceId

		ORDER BY L2.jobEndTime DESC

	)AL

	WHERE isCCDataBase = 1

	AND (L1.jobId <> AL.jobId OR L1.jobId IS NULL)

	-- Also save in instance level for DB agents

	-- If Prop already exists, update. Else insert below.

	UPDATE IP

	SET IP.attrVal = CAST(T.lastBackupInfo AS NVARCHAR(MAX)),

		IP.created = T.jobEndTime

	FROM #lastBackupInfoTmp_scProp T

	INNER JOIN APP_InstanceProp IP ON IP.componentNameId = T.instanceId AND IP.attrName = 'Last Backup Job Info' AND IP.modified = 0 

	WHERE isCCDataBase = 1 AND jobId IS NOT NULL  -- Have a valid job
	INSERT INTO APP_InstanceProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT instanceId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp_scProp T

	LEFT OUTER JOIN APP_InstanceProp IP ON IP.componentNameId = T.instanceId AND IP.attrName = 'Last Backup Job Info' AND IP.modified = 0 

	WHERE isCCDataBase = 1 AND jobId IS NOT NULL -- Have a valid job

	AND IP.id IS NULL -- Prop not already exists, so insert.

	-- Remove all rows except 1 latest row per agent

	DELETE L1

	FROM #lastBackupInfoTmp_scProp L1

	CROSS APPLY

	(

		SELECT TOP 1 jobId, commcellId 

		FROM #lastBackupInfoTmp_scProp L2

		WHERE isCCDataBase = 0 AND appType <> 106 -- Not DB or Virtual Server

		AND L2.agentIdaId = L1.agentIdaId

		ORDER BY L2.jobEndTime DESC

	)AL

	WHERE isCCDataBase = 0 AND appType <> 106 -- Not DB or Virtual Server

	AND (L1.jobId <> AL.jobId OR L1.jobId IS NULL)

	-- Also save in agent level

	-- If Prop already exists, update. Else insert below.

	UPDATE IP

	SET IP.attrVal = CAST(T.lastBackupInfo AS NVARCHAR(MAX)),

		IP.created = T.jobEndTime

	FROM #lastBackupInfoTmp_scProp T

	INNER JOIN APP_IDAProp IP ON IP.componentNameId = T.agentIdaId AND IP.attrName = 'Last Backup Job Info' AND IP.modified = 0 

	WHERE isCCDataBase = 0 AND appType <> 106 -- Not DB or Virtual Server

	AND jobId IS NOT NULL  -- Have a valid job
	INSERT INTO APP_IDAProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT agentIdaId, 'Last Backup Job Info', 15, CAST(lastBackupInfo AS NVARCHAR(MAX)), jobEndTime, 0, 0 

	FROM #lastBackupInfoTmp_scProp T

	LEFT OUTER JOIN APP_IDAProp IP ON IP.componentNameId = T.agentIdaId AND IP.attrName = 'Last Backup Job Info' AND IP.modified = 0 

	WHERE isCCDataBase = 0 AND appType <> 106 -- Not DB or Virtual Server

	AND jobId IS NOT NULL -- Have a valid job

	AND IP.id IS NULL -- Prop not already exists, so insert.
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@populateLastBackupJobInfoGUID, 'PopulateLastBackupInfoV3', 'Update script to populate last backup info.', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

--Set Disable Extent Backup property for existing subclients of Windows and Unix FS. MR:274402

DECLARE @DisableExtentBackupGUID uniqueidentifier = 'EAFEC9E7-2278-477D-9BEF-7E412E6BD890'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @DisableExtentBackupGUID)

BEGIN

	-- if fresh install then no need to set this property for any subclient.

IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id = 2)

	BEGIN
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@DisableExtentBackupGUID, 'DisableExtentBackupExec', 'Disables extent backup property for existing subclients.', @curTime, 16, 0, (16 + 2))

	END

	ELSE

	BEGIN

		-- if upgrade then set this property for existing subclients Win and Unix FS
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


SELECT Id, 'Extent backup disabled', 2, 1, @curTime, 0, 0

		FROM App_Application subclient

		INNER JOIN App_iDAType IDA ON subclient.appTypeId = IDA.type

		INNER JOIN APP_AppTypeGroupAssoc Assoc ON Assoc.appTypeId = IDA.type and Assoc.appGroupId IN (22,34) /*Win and Unix FS*/
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@DisableExtentBackupGUID, 'DisableExtentBackupExec', 'Disables extent backup property for existing subclients.', @curTime, 16, 0, (16 + 2))

	END

END

--Set Disable Extent Backup property for existing  Isilon and Nutanix subclients of Windows and Unix FS. MR:307074

DECLARE @DisableExtentBackupFilersGUID uniqueidentifier = 'BE116DE9-53E5-4FE3-A1DA-3FFB12753976'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @DisableExtentBackupFilersGUID)

BEGIN

	-- if fresh install then no need to set this property for any subclient.

IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id = 2)

	BEGIN
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@DisableExtentBackupFilersGUID, 'DisableExtentBackupFilersExec', 'Disables extent backup property for existing subclients (Filers).', @curTime, 16, 0, (16 + 2))

	END

	ELSE

	BEGIN

		-- if upgrade then set this property for existing subclients Win and Unix FS which fall into either of these 2 grps

		-- Client's SimOS == 19 and sc property ClientAppType == 2, OR,

		-- Client's SimOS == 19 and sc property ClientAppType == 3 and (either 'NAS streaming snap scan enabled' sc property does not exist or has value 1) and (either 'Enable Snap Backups' sc property does not exist or has value 0)
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


SELECT subclient.id, 'Extent backup disabled', 2, 1, @curTime, 0, 0

		FROM App_Application subclient

		INNER JOIN App_AppTypeGroupAssoc Assoc ON Assoc.appTypeId = subclient.appTypeId and Assoc.appGroupId IN (22,34)

INNER JOIN App_Client client ON client.id = subclient.clientId AND client.simOperatingSystemId = 19

INNER JOIN App_ClientProp clientProp ON clientProp.componentNameId = client.id AND clientProp.attrName like 'Client App Type' AND clientProp.attrVal = '2'

		UNION

SELECT subclient.id, 'Extent backup disabled', 2, 1, @curTime, 0, 0

		FROM App_Application subclient

		INNER JOIN App_AppTypeGroupAssoc Assoc ON Assoc.appTypeId = subclient.appTypeId and Assoc.appGroupId IN (22,34)

INNER JOIN App_Client client ON client.id = subclient.clientId AND client.simOperatingSystemId = 19

INNER JOIN App_ClientProp clientProp ON clientProp.componentNameId = client.id AND clientProp.attrName like 'Client App Type' AND clientProp.attrVal = '3'

LEFT JOIN App_SubClientProp subProp ON subProp.componentNameId = subclient.id AND subProp.attrName like 'NAS streaming snap scan enabled' AND subProp.modified = 0

LEFT JOIN App_SubClientProp subProp2 ON subProp2.componentNameId = subclient.id AND subProp2.attrName like 'Enable Snap Backups' AND subProp2.modified = 0

		WHERE (subProp.attrVal = '1' OR subProp.attrVal IS NULL) AND (subProp2.attrVal = '0' OR subProp2.attrVal IS NULL)

		EXCEPT

SELECT componentNameId, 'Extent backup disabled', 2, 1, @curTime, 0, 0

FROM app_subclientprop where attrname like 'Extent backup disabled'
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@DisableExtentBackupFilersGUID, 'DisableExtentBackupFilersExec', 'Disables extent backup property for existing subclients (Filers).', @curTime, 16, 0, (16 + 2))

	END

END

-- Set use local archival rule = 1 for any subclient with FS server plan, etc. (coming from SP20-). 

DECLARE @correctLocalArchiveRules varchar(36) = '9DD3D4BB-FC28-4453-A509-D235C91DF4D2'

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @correctLocalArchiveRules)

BEGIN

	DECLARE @currentTimeStamp INT = dbo.getUnixTime(GETUTCDATE())

	-- jswaminathan: 06-23-2020: 

	-- 1. If subclient (not associated with any plan) has this property, remove it. 

		-- This is a safety measure. Though we honor on this property only when plan is associated, still this one present in DB 

		-- might cause issues in future when associating with archiver plan. 		

	-- 2. If subclient (associated with any plan <> archiver), set it to 1. 

		-- Till SP20, we did not have archiver plan. So any subclient associated with plan has to use archival rules locally. 

	UPDATE SCP1 

	SET modified = @currentTimeStamp 

	FROM APP_SubclientProp SCP1

		LEFT OUTER JOIN APP_SubclientProp SCP2

			ON SCP1.componentNameId = SCP2.componentNameId 

AND SCP2.attrName = 'Associated Plan'

AND SCP2.cs_attrName = CHECKSUM(N'Associated Plan')

			AND SCP2.attrVal <> '0'

			AND SCP2.modified = 0

	WHERE			

SCP1.attrName = 'Use Local Archival Rules'

AND SCP1.cs_attrName = CHECKSUM(N'Use Local Archival Rules')

		AND SCP1.modified = 0

		AND SCP2.componentNameId IS NULL

	IF OBJECT_ID('tempdb.dbo.#fixLocalArchiveRulesTbl') IS NOT NULL

		DROP TABLE #fixLocalArchiveRulesTbl

	CREATE TABLE #fixLocalArchiveRulesTbl

	(

		scId INT PRIMARY KEY

	)
	INSERT INTO #fixLocalArchiveRulesTbl


		SELECT DISTINCT SCP1.componentNameId 

		FROM APP_SubclientProp SCP1

			INNER JOIN APP_Plan P

ON SCP1.attrName = 'Associated Plan'

AND SCP1.cs_attrName = CHECKSUM(N'Associated Plan')

				AND SCP1.attrVal <> '0'

				AND SCP1.attrVal = CAST(P.id as VARCHAR(10))

				AND P.type <> 9				-- Archiver plan. 

			LEFT JOIN APP_SubclientProp SCP2

				ON SCP1.componentNameId = SCP2.componentNameId 

				AND SCP2.attrName = N'Turbo Mode Enable Stubbing'

				AND SCP2.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')

				AND SCP2.attrVal = '1'

				AND SCP2.modified = 0

			INNER JOIN APP_Application A

				ON A.id = SCP1.componentNameId 

			LEFT JOIN APP_BackupsetProp BP

				ON A.backupset = BP.componentNameID 

AND BP.attrName = 'Is Archiving Enabled'

				AND BP.attrVal = '1'

				AND BP.modified = 0

		WHERE

			SCP2.componentNameId IS NOT NULL OR BP.componentNameID IS NOT NULL		/* 1-pass or archiving set subclient */

	UPDATE SCP1

	SET modified = @currentTimeStamp

	FROM APP_SubclientProp SCP1

		INNER JOIN #fixLocalArchiveRulesTbl F

			ON SCP1.componentNameId = F.scId 		

AND SCP1.attrName = 'Use Local Archival Rules'

AND SCP1.cs_attrName = CHECKSUM(N'Use Local Archival Rules')

			AND SCP1.modified = 0
	INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified)


SELECT scId, 'Use Local Archival Rules', 2, '1', @currentTimeStamp, 0

		FROM #fixLocalArchiveRulesTbl F	
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@correctLocalArchiveRules, 'CorrectLocalArchiveRules', 'Sets local archive rules as 1 for subclients associated with FS server plans', @currentTimeStamp, 16, 0, (16 + 2))

END

-- Set VS Quiesce Simpana as false for all GCP clients

IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '79766012-CB78-4DE6-B510-07E882A2208C')

BEGIN

	UPDATE SCP

	SET SCP.attrval ='0' FROM App_SubClientProp SCP

	INNER JOIN APP_Application SC

	ON SCP.attrname ='VS QUIESCE SIMPANA' AND SCP.componentnameid = SC.id

	INNER JOIN APP_InstanceProp iprop

	ON iprop.attrname ='Virtual Server Instance Type' AND iprop.attrval =1301

	AND iprop.componentnameid = SC.instance and SCP.modified =0 and iprop.modified=0 
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('79766012-CB78-4DE6-B510-07E882A2208C', 'DisableVSQuiesceSimpana', 'VSA-GCP: Disable VS Quiesce Simpana for GCP Clients', @curTime, 16, 0, (16 + 2))

END

DECLARE @fixDuplicateDyPhasePercentages uniqueidentifier = '022308D6-CDD9-4322-9736-147EBFCC1582'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH (NOLOCK) WHERE SqlScriptGUID = @fixDuplicateDyPhasePercentages)

BEGIN

	DELETE SCP FROM APP_SubClientProp SCP INNER JOIN 

	(

		SELECT componentNameId, attrName FROM APP_SubClientProp 

		WHERE attrName LIKE 'Dynamic Phase%'

		GROUP BY componentNameId, attrName

		HAVING COUNT(0) > 1

	) DY

	ON DY.componentNameId = SCP.componentNameId AND DY.attrName = SCP.attrName			
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@fixDuplicateDyPhasePercentages, 'fixDuplicateDyPhasePercentages', 'Update script to fix duplicate dynamic phase percentage properties', DATEDIFF(second, '01/01/1970', GETUTCDATE()), 16, 0, (16 + 2))

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

