

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_SmartFolderCSLiveSync.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_SmartFolderCSLiveSync.script,v $ $Id: App_SmartFolderCSLiveSync.script,v 1.1.2.2 2019/12/12 22:39:22 vdevassy Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

IF EXISTS(SELECT 1 FROM dbo.simInstalledPackages WITH (NOLOCK) WHERE simPackageID = 24 )

BEGIN    

DECLARE @guid uniqueidentifier = '037B6E29-413E-4715-9092-4F778133B93E'

DECLARE @IsTranStarted INT = 0

DECLARE @curDateTime BIGINT = datediff(second, '01/01/1970', GetDate())

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCDate())

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN	

	BEGIN TRY

DECLARE @userId         INT = (SELECT TOP 1 id FROM UMUsers WITH (NOLOCK) WHERE flags & 0x040 <> 0)

		IF @@TRANCOUNT=0

		BEGIN			

			BEGIN TRAN

			SET @IsTranStarted = 1

		END

		DECLARE @sfName NVARCHAR(100) = 'CSLiveSync' -- need to edit folder/@smartFolderName in rawXMl below

		IF NOT EXISTS(SELECT 1 FROM APP_SmartFolder (NOLOCK) WHERE name=@sfName AND (flag & 2) != 2 ) -- 2 : FolderFlagType.CHILD_FOLDER

		BEGIN

			DECLARE @csLivesyncSmartFolderGuid uniqueidentifier = '87A3D1CA-A6C0-42D4-BB5F-5BB3CFEB05A7'

DECLARE @masterGroupId INTEGER = (Select ID from UMGroups where (groupFlags&0x0008)=0x0008)
			INSERT INTO APP_SmartFolder(name,description,folderType,flag,status,rawXml,ruleQuery,ownerId, created, modified,origCCId, GUID)


SELECT @sfName,'System created folder to contain client groups related to CS LiveSync', 28,1,0,

				'<App_SmartFolderEntityInfo description="" isAutomatic="1">

	  <folder smartFolderName="CSLiveSync" smartFolderId="0" folderType="28" />

	  <parentEntity subclientId="0" clientGroupId="0" applicationId="0" clientName="" backupsetId="0" instanceId="0" clientId="0" subclientName="" backupsetName="" instanceName="" clientGroupName="" _type_="27" appName="" />

	  <folderSecurity associationsOperationType="1">

		<associations>

		  <userOrGroup userGroupName="master" userGroupId="'+CONVERT(NVARCHAR(10),@masterGroupId)+'" _type_="15" />

		  <properties isCreatorAssociation="0">

			<categoryPermission>

			  <categoriesPermissionList permissionId="31" _type_="122" />

			</categoryPermission>

		  </properties>

		</associations>

		<ownerAssociations />

	  </folderSecurity>  

	  <folderRule op="0">

		<rules>

		  <rule op="1">

			<rules>

			  <rule filterID="10" propID="4" propType="2" value="failover" />

			</rules>

			<rules>

			  <rule filterID="10" propID="4" propType="2" value="CVLiveSync" />

			</rules>

		  </rule>

		</rules>

	  </folderRule>

	</App_SmartFolderEntityInfo>',

			'SELECT id, 28 from app_clientgroup where (id > 0) and ( ( (  (dbo.sfGetClientGroupName(id)  LIKE ''%failover%'' ESCAPE(''\''))  OR  (dbo.sfGetClientGroupName(id)  LIKE ''%CVLiveSync%'' ESCAPE(''\'')) ) )  )',

			@userId, @curDateTime, 0, 2, @csLivesyncSmartFolderGuid

			DECLARE @sfID INT = SCOPE_IDENTITY()

			-- Insert into assoc Table
			INSERT INTO APP_SmartFolderAssoc(folderId, componentType, componentId, status,created,modified)


SELECT @sfID, 28, id, 0,@curDateTime,0

			FROM App_Clientgroup (NOLOCK) WHERE (id > 0) and ( ( (  (dbo.sfGetClientGroupName(id)  LIKE '%failover%' ESCAPE('\'))  

			OR  (dbo.sfGetClientGroupName(id)  LIKE '%CVLiveSync%' ESCAPE('\')) ) )  )

			-- add CAT_USER_MANAGMENT_ASSOC_ON_ENTITY Permission and EV_VISIBILITY permissions FOR CREATOR and master group for security association
			INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, permissionId, entityType1, entityId1, authorId, isCreator)


SELECT @userId, 1, 31, 127, @sfID , @userId, 1

			UNION ALL

SELECT @userId, 1, 107, 127, @sfID , @userId, 1

			UNION ALL

SELECT @masterGroupId, 0,  31, 127, @sfID , @userId, 0

		END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'CSLivesyncCreateDefaultFolder', 'Create default folder for CS LiveSync', @curUtcDateTime, 16, 0 , (16 + 2))

		IF (@IsTranStarted=1)

		BEGIN

			COMMIT TRAN

		END

    END TRY

    BEGIN CATCH 

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

        IF (@IsTranStarted=1)

        BEGIN

            ROLLBACK TRAN

        END

    END CATCH;

END

END -- End block for first IF check for SimInstalledPackages. 

SET NOCOUNT OFF

GO

