

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_SCGRule.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                     

--           Copyright (c) 1998  CommVault Systems, Inc.               

--                  All rights reserved.                               

--                                                                     

--																		

--        This is unpublished proprietary source code of CommVault		

--        Systems, Inc. The copyright notice above does not evidence	

--        any actual or intended publication of such source code.		

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

GO

DECLARE @nowTimeInfra	int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

--===============================================================================================================

-- IMPORTANT: MR 281282

--	Note any new scripting added to this should be add to the end of the file.

--

--	The SCG V1 to SCG V2 retrofit script belows needs to execute before any other SCG scripting to convert

--	SCG V1 (scaler functions) to SCG V2 (table functions) and re-generate all Query Rules in the APP_SCGRule

--	table.

--===============================================================================================================

-- Readded this check since removed in SP3 time frame for old style SCG Rules still being inserted into the table.  Should all be converted now so only run one again starting with SP20.

-- Eliminates 7 seconds off of database upgrade

DECLARE @scgRuleGUID VARCHAR(40) = '6324E036-714F-488F-8C7A-EB4DFA65DB03'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @scgRuleGUID)

BEGIN

	--================================================================

	-- NOTE: This SQL source code is from APPSCGV2GenerateQuery.sp

	--================================================================

	DECLARE @exitCode		INT = 0

	DECLARE @exitMsg		VARCHAR(128) = 'Success'

	DECLARE @newLine		NVARCHAR(3) = NCHAR(13)	-- + CHAR(10)

	DECLARE @scgRuleCount	INT = 0

	DECLARE @tranStarted	INT = 0

	-- Backup current table to a temp table

	IF OBJECT_ID('tempdb.dbo.#APP_SCGRuleBackup') IS NOT NULL

		DROP TABLE #APP_SCGRuleBackup

	CREATE TABLE #APP_SCGRuleBackup (

		id				int primary key,

		scgId			int,

		ruleXml			xml,

		ruleQuery		nvarchar(max),

		ownerId			int,

		created			int,

		modified		int,

		flag			int

	)
	INSERT INTO #APP_SCGRuleBackup


		SELECT id, scgId, ruleXml, ruleQuery, ownerId, created, modified, flag FROM APP_SCGRule WHERE (flag & 1) = 0

	SET @scgRuleCount = @@ROWCOUNT

	IF (@scgRuleCount = 0)

	BEGIN

		-- nothing to convert

		GOTO END_OF_SCRIPT_SET

	END

	IF OBJECT_ID('tempdb.dbo.#RuleTree') IS NOT NULL

		 DROP TABLE #RuleTree

	CREATE TABLE #RuleTree (

		id			INT IDENTITY(1,1),

		masterOp	INT,

		[group]		INT,

		number		INT,

		filterID	INT,

		propID		INT,

		propType	INT,

		secValue	NVARCHAR(MAX),

		value		NVARCHAR(MAX),

		op			INT,

		flags		INT,

		funcName	NVARCHAR(256),

		ruleQuery	NVARCHAR(MAX),

		PRIMARY KEY ([group], number, id)

	)

	--IF OBJECT_ID('tempdb.dbo.#TestTable') IS NOT NULL

	--	DROP TABLE #TestTable

	--CREATE TABLE #TestTable (clientId	INT)

	DECLARE @scgRuleXML	XML

	DECLARE @wkgId		INT

	DECLARE @scgId		INT

	DECLARE @ruleQuery	NVARCHAR(MAX) = N''

	DECLARE @ruleCount	INT = 0

	DECLARE scgCursor CURSOR LOCAL FAST_FORWARD FOR

		SELECT

			r.id,

			r.scgId,

			r.ruleXml

		FROM #APP_SCGRuleBackup r

	OPEN scgCursor

	BEGIN TRAN SCGRuleTrans

	SET @tranStarted = 1

	FETCH NEXT FROM scgCursor INTO @wkgId, @scgId, @scgRuleXML

	WHILE @@FETCH_STATUS = 0

	BEGIN

		-- Has Group Rules been supplied?

		-- Note: First node name can be either App_SCGRuleGroup or scgRule

		IF (@scgRuleXML.exist('//rules') = 0)

		BEGIN

				-- No Group Rules supplied.  Create dummy query so that only Scope is applied.

				-- Do not need to do anything for this SCG Rule skipping it, since there will not be 

				-- any of these type rules before SP20 when it was supported so it does not need to

				-- be converted.

				FETCH NEXT FROM scgCursor INTO @wkgId, @scgId, @scgRuleXML

				CONTINUE

		END

		BEGIN TRY

			SET @ruleQuery = ''

			SET @ruleCount = 0

			-- flatten the XML SCG Rule out as a table

			TRUNCATE TABLE #RuleTree
			INSERT INTO #RuleTree(masterOp, [group], number, filterID, propID, propType, secValue, value, op, flags, funcName)


				SELECT

					r.value('../../../../@op', 'int') masterOp,

					gc.value('for $a in . return 1+count($a/../*[. << $a])','int') [group],

					rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,

					r.value('@filterID', 'int') filterID,

					r.value('@propID', 'int') propID,

					r.value('@propType', 'int') propType,

					r.value('@secValue', 'NVARCHAR(max)') secValue,

					CASE

						WHEN r.value('@propType', 'int') = 6 THEN 

							CASE

								WHEN CHARINDEX('UTF-8', r.value('@value', 'VARCHAR(max)'), 0) > 0 THEN CAST(CAST(r.value('@value', 'VARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove UTF-8 XML Header

								ELSE CAST(CAST(r.value('@value', 'NVARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove XML Header

							END

						ELSE r.value('@value', 'NVARCHAR(max)') 

					END value,

					r.value('../../@op', 'int') op,

					ISNULL(p.flags, up.flags) flags,

					ISNULL(p.funcName, up.funcName) funcName

				FROM

					@scgRuleXML.nodes('/scgRule/rules/rule/rules/rule') t(r)

					LEFT OUTER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function

						p.id = r.value('@propID', 'int')

					LEFT OUTER JOIN App_SCGUserProperty up WITH(READUNCOMMITTED) ON	-- propID >= 10000	User Defined SCG Function

						up.id = r.value('@propID', 'int')

					CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number

					CROSS APPLY r.nodes('../../..') gc(gc)		-- rule group count / number

			SET @ruleCount = @@ROWCOUNT

			IF (@ruleCount = 0)

			BEGIN

				-- Try to parse input where no grouping level nodes exist
				INSERT INTO #RuleTree(masterOp, [group], number, filterID, propID, propType, secValue, value, op, flags, funcName)


					SELECT

						r.value('../../@op', 'int') masterOp,

						1 [group],	-- only one grouping

						rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,

						r.value('@filterID', 'int') filterID,

						r.value('@propID', 'int') propID,

						r.value('@propType', 'int') propType,

						r.value('@secValue', 'NVARCHAR(max)') secValue,

						CASE

							WHEN r.value('@propType', 'int') = 6 THEN 

								CASE

									WHEN CHARINDEX('UTF-8', r.value('@value', 'VARCHAR(max)'), 0) > 0 THEN CAST(CAST(r.value('@value', 'VARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove UTF-8 XML Header

									ELSE CAST(CAST(r.value('@value', 'NVARCHAR(max)') AS XML) AS NVARCHAR(MAX))	-- remove XML Header

								END

							ELSE r.value('@value', 'NVARCHAR(max)') 

						END value,

						r.value('../../@op', 'int') op,		-- same as masterOp

						ISNULL(p.flags, up.flags) flags,

						ISNULL(p.funcName, up.funcName) funcName

					FROM

						@scgRuleXML.nodes('/scgRule/rules/rule') t(r)

						LEFT OUTER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function

							p.id = r.value('@propID', 'int')

						LEFT OUTER JOIN App_SCGUserProperty up WITH(READUNCOMMITTED) ON	-- propID >= 10000	User Defined SCG Function

							up.id = r.value('@propID', 'int')

						CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number

					WHERE

						r.exist('rules/rule') = 0		-- and no lower level nodes exist

				SET @ruleCount = @@ROWCOUNT

				IF (@ruleCount = 0)

				BEGIN

					SET @exitCode = 1

					SET @exitMsg = 'SCG XML Rule parsing error for SCGRule Id[' + CAST(@wkgId AS VARCHAR(12)) + ']'

					--THROW @exitCode, @exitMsg, @exitCode

					RAISERROR(@exitMsg, @exitCode, @exitCode);

				END

			END

			-- Make sure no mixed SCG Function Versions selected

			DECLARE @v2Count	INT = 0

			DECLARE @v1Count	INT = 0

			SELECT

				@v1Count += CASE WHEN rt.flags = 0 THEN 1 ELSE 0 END,

				@v2Count += CASE WHEN (rt.flags & 1) = 1 THEN 1 ELSE 0 END

			FROM #RuleTree rt

			IF (@v1Count <> @ruleCount AND @v2Count <> @ruleCount)

			BEGIN

				SET @exitCode = 2

				SET @exitMsg = 'Mixed SCG Function Versions Error for SCGRule Id[' + CAST(@wkgId AS VARCHAR(12)) + ']'

				--THROW @exitCode, @exitMsg, @exitCode

				RAISERROR(@exitMsg, @exitCode, @exitCode);

			END

			DECLARE @versionType INT

			SELECT @versionType = CASE WHEN @v1Count = @ruleCount THEN 1 ELSE 2 END

			DECLARE @selectV2	NVARCHAR(24) = N'SELECT clientId FROM '

			DECLARE @selectV1	NVARCHAR(24) = N'SELECT c.id FROM APP_Client c WITH(READUNCOMMITTED) WHERE '

			DECLARE @intersect	NVARCHAR(11) = N' INTERSECT '	-- and op for V2 no where clauses

			DECLARE @union		NVARCHAR(11) = N' UNION '		-- or op for V2 no where clauses

			DECLARE @except		NVARCHAR(11) = N' EXCEPT '		-- not op for V2 no where clauses

			DECLARE @ruleVars	NVARCHAR(512) = N'DECLARE @inClientId INT = 0/*GetAllClients*/; '		-- no not remove or change inline comment, it is keyword for replacing 0 with an actual clientId

			SET @ruleVars += @newLine + N'DECLARE @inSCGId INT = 0/*SCGProcessing*/; ' + @newLine;

			-- Generate SCG SQL Command

			IF (@versionType = 1)

			BEGIN

				SET @exitCode = 3

				SET @exitMsg = 'Generate SCG Function Version 1 Not Supported by procedure for SCGRule Id[' + CAST(@wkgId AS VARCHAR(12)) + ']'

				--THROW @exitCode, @exitMsg, @exitCode

				RAISERROR(@exitMsg, @exitCode, @exitCode);

			END

			ELSE

			BEGIN

				-- Generate individual SCG SQL Command for each rule

				UPDATE rt

					SET ruleQuery = CASE 

										WHEN rt.number > 1 AND rt.op = 0 THEN @intersect + N' '

										WHEN rt.number > 1 AND rt.op = 1 THEN @union + N' '

										WHEN rt.number > 1 AND rt.op = 2 THEN @except + N' '

										ELSE ''

									END

									+ @selectV2 

									+ rt.funcName 

									+ N'(' 

									-- + dbo.scgV2HelperGetParameters(rt.filterID, rt.propType, rt.value, rt.secValue)

									+ CASE rt.filterID

										WHEN 1 THEN N'''TRUE'',  1'

										WHEN 2 THEN N'''FALSE'',  0'

										WHEN 10 THEN N'''LIKE'', N''%' + REPLACE(rt.value, N'''', N'''''') + N'%'''

										WHEN 11 THEN N'''NOT LIKE'', N''%' + REPLACE(rt.value, N'''', N'''''') + N'%'''

										WHEN 12 THEN N'''='', N''' + REPLACE(rt.value, N'''', N'''''') + N''''

										WHEN 13 THEN N'''<>'', N''' + REPLACE(rt.value, N'''', N'''''') + N''''

										WHEN 14 THEN N'''LIKE'', N''' + REPLACE(rt.value, N'''', N'''''') + N'%'''

										WHEN 15 THEN N'''LIKE'', N''%' + REPLACE(rt.value, N'''', N'''''') + N''''

										WHEN 100 THEN N'''='', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 101 THEN N'''<>'', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 102 THEN N'''>'', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 103 THEN N'''<'', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 104 THEN N'''>='', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 105 THEN N'''<='', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 106 THEN N'''BETWEEN'', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.secValue ELSE N'''' + REPLACE(rt.secValue, N'''', N'''''') + N'''' END) + N' '

										WHEN 111 THEN N'''NOT BETWEEN'', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.secValue ELSE N'''' + REPLACE(rt.secValue, N'''', N'''''') + N'''' END) + N' '

										WHEN 107 THEN N'''NOT IN'', N''' + REPLACE(rt.value, N'''', N'''''') + N''''

										WHEN 110 THEN N'''IN'', N''' + REPLACE(rt.value, N'''', N'''''') + N''''

										WHEN 108 THEN N'''='', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										WHEN 109 THEN N'''<>'', ' + (CASE WHEN rt.propType = 3 OR rt.propType = 4 THEN rt.value ELSE N'''' + REPLACE(rt.value, N'''', N'''''') + N'''' END) + N' '

										ELSE N''

									END

									+ CASE	-- check if a 3rd argument is needed

										WHEN (rt.flags & 2) = 2 AND rt.filterID NOT IN (106, 111) THEN N', NULL '

										ELSE N''

									END

									+ N' , @inClientId, @inSCGId '

									+ N') '

				FROM #RuleTree rt

				--SELECT * FROM #RuleTree

				-- Generate the full SCG SQL Command

				SELECT

					@ruleQuery += CASE

										WHEN q.[group] > 1 AND q.masterOp = 0 THEN N') ' + @intersect + N' ('

										WHEN q.[group] > 1 AND q.masterOp = 1 THEN N') ' + @union + N' ('

										WHEN q.[group] > 1 AND q.masterOp = 2 THEN ') ' + @except + N' ('

										ELSE '('  

									END

									+ @newLine

									+ q.[rule]

				FROM (

					SELECT

						q.[group],

						q.masterOp,

						r.value('(ruleQuery)[1]', 'NVARCHAR(MAX)') [rule]

					FROM

						(SELECT --DISTINCT

							q.[group],

							q.masterOp,

							CAST((N'<ruleQuery> ' + q.[rule] + N'</ruleQuery>') AS XML) [rule]

						FROM

							(SELECT DISTINCT

								ort.[group],

								ort.masterOp,

								CAST(

									(SELECT

										irt.ruleQuery + @newLine

									FROM #RuleTree irt

									WHERE irt.[group] = ort.[group]

									ORDER BY irt.[group], irt.number

									FOR XML PATH(''), TYPE) 

								AS NVARCHAR(MAX)) AS [rule]

							FROM #RuleTree ort) q) q

						CROSS APPLY [rule].nodes('.') doc(r)) q

				SET @ruleQuery += N')' + @newLine

				SET @ruleQuery = @ruleVars + @ruleQuery

				--PRINT @ruleQuery

				-- cannot test generated scripts in a tblscript since the SQL Functions have not been installed yet!

				-- test the generated query for any syntax errors

				--INSERT INTO #TestTable

				--	EXEC(@ruleQuery)

				--SELECT clientId FROM #TestTable

				--TRUNCATE TABLE #TestTable

				--SELECT @exitCode o_exitCode, @exitMsg o_exitMessage, @ruleQuery o_ruleQuery

				-- Replace SCG V1 rule query with generated SCG V2 rule query

				UPDATE APP_SCGRule

					SET ruleQuery = @ruleQuery

				WHERE

					id =  @wkgId

			END

		END TRY

		BEGIN CATCH

			CLOSE scgCursor

			DEALLOCATE scgCursor

			IF (@tranStarted = 1)

			BEGIN

				ROLLBACK TRAN SCGRuleTrans

			END

			DECLARE @msg NVARCHAR(2047) = @newLine + @newLine

			SET @msg += 'INSIDE CATCH BLOCK WITH FOLLOWING ERROR: ' + @newLine

			SET @msg += '   ERROR CODE: ' + CAST(ERROR_NUMBER() AS NVARCHAR(12)) + @newLine

			SET @msg += '   SQL SCRIPT: APP_SCGRule' + @newLine

			SET @msg += '   ERROR LINE NO: ' + CAST(ERROR_LINE() AS NVARCHAR(12)) + @newLine

			SET @msg += '   ERROR MESSAGE: ' + ERROR_MESSAGE() + @newLine

			SET @msg += '   ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS NVARCHAR(12)) + @newLine

			SET @msg += '   ERROR STATE: ' + CAST(ERROR_STATE() AS NVARCHAR(12)) + @newLine + @newLine

			PRINT @msg

			IF (@exitCode = 0)

			BEGIN

				SET @exitCode = 5

				SET @exitMsg = 'Catch Block Error'

			END

			PRINT 'Exit Code: ' + CAST(@exitCode AS VARCHAR(12)) + '::' + @exitMsg

			--RAISERROR(@msg, 16, 1);

			GOTO END_OF_SCRIPT

		END CATCH

		FETCH NEXT FROM scgCursor INTO @wkgId, @scgId, @scgRuleXML

	END

	CLOSE scgCursor

	DEALLOCATE scgCursor

END_OF_SCRIPT_SET:
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@scgRuleGUID, 'SCGV2Rewrite', 'Update script to convert Smart Client Group functions to V2', @nowTimeInfra, 16, 0, 17)

	IF (@tranStarted = 1)

	BEGIN

		COMMIT TRAN SCGRuleTrans

	END

END_OF_SCRIPT:

	--PRINT 'Exit Code: ' + CAST(@exitCode AS VARCHAR(12)) + '::' + @exitMsg

END

-- This Table Scripting was at the top of this file and moved to the bottom after the SCG V1 to SCG V2 retrofit executes first 

-- before any changes are allowed so that database upgrades succeed for V10 and earlier V11 SP releases.

DECLARE @infrastructureGUID VARCHAR(40) = 'E6AE9DCA-29CB-4921-99F7-6676F15D6B05'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @infrastructureGUID)

BEGIN

       UPDATE scgRules

              SET scgRules.ruleXML = '<scgRule op="0"><rules><rule op="1"><rules><rule filterID="100" propID="2" propType="4" secValue="CS Client" value="11" /></rules><rules><rule filterID="100" propID="2" propType="4" secValue="MediaAgent" value="5" /></rules><rules><rule filterID="108" propID="9" propType="6" value="&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;&lt;App_AdvanceKeyInfo&gt;&lt;packages val=&quot;726&quot; /&gt;&lt;packages val=&quot;252&quot; /&gt;&lt;/App_AdvanceKeyInfo&gt;" /></rules><rules><rule filterID="1" propID="24" propType="1" /></rules></rule></rules></scgRule>'

       FROM APP_SCGRule scgRules

       INNER JOIN APP_ClientGroup scg ON scg.id = scgRules.scgId

       WHERE (scg.flag & 0x80000) != 0
       INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@infrastructureGUID, 'SCGInfrastructueRetrofit', 'Update script to Retrofit Infrastruction grouping', @nowTimeInfra, 16, 0, (16 + 2))

END

DECLARE @infrastructureIndexServerGUID VARCHAR(40) = '1AD8A671-51B6-4F0C-8295-F75D8914962F'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @infrastructureIndexServerGUID)

BEGIN

	DECLARE @inFilterID INT = 108	--ANY_IN_SELECTION: App.x

	DECLARE @inPropID INT = 9		--PACKAGE_INSTALLED: Table App_SCGProperty

	DECLARE @inPropTypeID INT = 6	--SCGP_SELECTION: App.x

	DECLARE @infraStructureRuleXML XML

	DECLARE @packageXML XML 

	DECLARE @infraScgId INT

	SELECT	@infraStructureRuleXML = scgRules.ruleXML,

			@infraScgId = scgRules.scgId

		FROM APP_SCGRule scgRules

		INNER JOIN APP_ClientGroup scg ON scg.id = scgRules.scgId

	WHERE (scg.flag & 0x80000) != 0

	IF @infraStructureRuleXML IS NOT NULL

	BEGIN

		-- MR 276453

		SET @packageXML = (	

							SELECT TOP 1 ISNULL(Tbl.Col.value('(./@value)', 'varchar(max)'),'')

							FROM @infraStructureRuleXML.nodes('/scgRule/rules/rule/rules/rule[@filterID=sql:variable("@inFilterID") and @propID=sql:variable("@inPropID") and @propType=sql:variable("@inPropTypeID")]') as Tbl(Col)

						)

	END

	IF @packageXML IS NOT NULL

	BEGIN

		--Add Index Gateway

		IF @packageXML.exist('/App_AdvanceKeyInfo/packages[./@val = "263"]') != 1

			SET @packageXML.modify('insert <packages val="263" /> into (/App_AdvanceKeyInfo)[1]') 

		--Add Index Store

		IF @packageXML.exist('/App_AdvanceKeyInfo/packages[./@val = "55"]') != 1

			SET @packageXML.modify('insert <packages val="55" /> into (/App_AdvanceKeyInfo)[1]') 

		DECLARE @strpackageXML VARCHAR(MAX) = CONVERT(VARCHAR(MAX), @packageXML)

		SET @infraStructureRuleXML.modify('replace value of (/scgRule/rules/rule/rules/rule[@filterID=sql:variable("@inFilterID") and @propID=sql:variable("@inPropID") and @propType=sql:variable("@inPropTypeID")]/@value)[1] with sql:variable("@strpackageXML")')

		DECLARE @inscgExitCode INT = 0

		DECLARE @inscgExitMsg VARCHAR(1024) = ''

		DECLARE @CSClientGroupRuleQuery NVARCHAR (MAX) = ''

		EXEC APPSCGV2GenerateQueryParams @infraStructureRuleXML, @inscgExitCode OUTPUT, @inscgExitMsg OUTPUT, @CSClientGroupRuleQuery OUTPUT

		UPDATE APP_SCGRule

		SET ruleXML = @infraStructureRuleXML,

			ruleQuery = @CSClientGroupRuleQuery

		WHERE scgId = @infraScgId

		UPDATE APP_ClientGroup

			SET description = 'Select CS, MA, WebConsole, WebServer, Index Gateway, Index Store, proxy clients.'

		WHERE id = @infraScgId

		EXEC AppSCGRefresh 1, @infraScgId

	END
   INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@infrastructureIndexServerGUID, 'InfrastructureIndexServerStore', 'Update script to add Index Gateway and Index Store to Infrastructure client group.', @nowTimeInfra, 16, 0, (16 + 2))

END

DECLARE @csFailoverInstallCGGUID VARCHAR(40) = 'C9AEA4C6-D4AE-4B60-9F49-94ADFCD94F14'

DECLARE @o_failoverCGId INT 

SELECT @o_failoverCGId = App_ClientGroup.id FROM App_ClientGroup (NOLOCK) INNER JOIN APP_componentProp (NOLOCK) ON App_ClientGroup.Id = APP_componentProp.componentId 

AND APP_componentProp.componentType = 8 AND APP_componentProp.propertyTypeId = 1302

AND APP_componentProp.dataType = 10 AND APP_componentProp.modified = 0

IF @o_failoverCGId>0 AND NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @csFailoverInstallCGGUID)

BEGIN

	DECLARE @inscgExitCodeFailoverCG INT = 0

	DECLARE @inscgExitMsgFailoverCG VARCHAR(1024) = ''

	DECLARE @failoverClientsQuery nvarchar (max) = ''

	DECLARE @FailoverClientsXML NVARCHAR(MAX) = '<scgRule op="0"><rules><rule op="1"><rules><rule filterID="108" propID="9" propType="6" value="&lt;?xml version=''1.0'' encoding=''UTF-8''?&gt;&lt;App_AdvanceKeyInfo&gt;&lt;packages val=&quot;24&quot; /&gt;&lt;/App_AdvanceKeyInfo&gt;" /></rules><rules><rule filterID="100" propID="2" propType="4" secValue="CS Client" value="11" /></rules></rule></rules></scgRule>'

	EXEC APPSCGV2GenerateQueryParams @FailoverClientsXML, @inscgExitCodeFailoverCG OUTPUT, 

		@inscgExitMsgFailoverCG OUTPUT, @failoverClientsQuery OUTPUT

	IF (@inscgExitCodeFailoverCG <> 0)

	BEGIN

            PRINT 'Error in generating query params for failover install smart client group. Error code: '+CAST(@inscgExitCodeFailoverCG AS NVARCHAR(100)) + '. Error: ' + @inscgExitMsgFailoverCG

            GOTO ERROR_EXIT

	END

	UPDATE APP_SCGRule

	SET ruleXML = @FailoverClientsXML,

		ruleQuery = @failoverClientsQuery

	WHERE scgId = @o_failoverCGId

	EXEC AppSCGRefresh 1, @o_failoverCGId
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@csFailoverInstallCGGUID, 'CVLiveSync CG update', 'Update CVLiveSync client group.', @nowTimeInfra, 16, 0, (16 + 2))

END

ERROR_EXIT:

GO

SET NOCOUNT OFF

