

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_SCGProperty.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                     

--           Copyright (c) 1998  CommVault Systems, Inc.               

--                  All rights reserved.                               

--                                                                     

--																		

--        This is unpublished proprietary source code of CommVault		

--        Systems, Inc. The copyright notice above does not evidence	

--        any actual or intended publication of such source code.		

-- ----------------------------------------------------------------------*/

-- SCG V2 - Macros to update based on Primary Key Name	- only update if it exist

-- SCG V2 - Update based on Primary Key Id

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @tranStarted INT = 0

DECLARE @nowTime	int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @newLine    VARCHAR(3) = CHAR(13)   -- + CHAR(10)

-- NOTE: Need to determine if SCG is a new install - the APP_SCGProperty Table is empty!  By pass the upgrade retrofit code altogether.

DECLARE @propCnt	INT = 0

SELECT

	@propCnt = COUNT(*)

FROM App_SCGProperty

IF (@propCnt = 0)

BEGIN

	PRINT 'App_SCGProperty table is a fresh install.'

	GOTO SCRIPT_INSERT_DATA

END

DECLARE @SCGGuid	VARCHAR(40) = 'CA2DB58B-E228-47D4-9676-D114128D16C5' 	--OLD: '35BC2AF2-E064-4A87-8FBB-894237D774F0' 'B07707B7-E2A2-4B07-8817-1505128CC688' 'B0B36A6C-0F51-420B-A154-CF9D4FAC7B7C' 'AF35DBA1-DE28-47C4-AC0E-A27DC138D80F'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @SCGGuid)

BEGIN

	PRINT 'App_SCGProperty and App_SCGRule going thru retrofit upgrade for dynamic to static ID conversion.'

	-- NOTE This is only executed once for database upgrade to V11 SP4 to convert from dynamic to static SCG Property Ids

	-- Update rows based on Primary Key Name then retrofit them to use static primary key ids

	-- check for hand installed SCG Function Rows

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_NAME')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_NAME',			
		    label = 'Client Name',		
			localeMsgId = (3981 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientName',			
			description = 'name of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_NAME'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_PROP')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_PROP',			
		    label = 'Client',		
			localeMsgId = (1886 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientProps',			
			description = 'checks some of the client properties',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_PROP'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_DESCRIPTION')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_DESCRIPTION',			
		    label = 'Client Description',		
			localeMsgId = (2981 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientDescription',			
			description = 'description of client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_DESCRIPTION'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='APP_TYPE')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'APP_TYPE',			
		    label = 'Agent(s) Installed',		
			localeMsgId = (1887 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 6,			
			funcName = 'dbo.scgV2CompareAppTypes',			
			description = 'check if values is in or not in the apptypes',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'APP_TYPE'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_GROUP')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_GROUP',			
		    label = 'Associated Client Group',		
			localeMsgId = (1888 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2CheckClientInGroup',			
			description = 'checks if a client belongs to a group',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_GROUP'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='TIMEZONE')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'TIMEZONE',			
		    label = 'Timezone',		
			localeMsgId = (1901 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientTimezoneId',			
			description = 'time zone for the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'TIMEZONE'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='HOST_NAME')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'HOST_NAME',			
		    label = 'Hostname',		
			localeMsgId = (1785 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientHostName',			
			description = 'hostname of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'HOST_NAME'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_VERSION')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_VERSION',			
		    label = 'Client Version',		
			localeMsgId = (1926 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientVersion',			
			description = 'Version of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_VERSION'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='OS_TYPE')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'OS_TYPE',			
		    label = 'OS Type',		
			localeMsgId = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientOSType',			
			description = 'os type of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'OS_TYPE'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='PACKAGE_INSTALLED')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'PACKAGE_INSTALLED',			
		    label = 'Package Installed',		
			localeMsgId = (2012 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 6,			
			funcName = 'dbo.scgV2CheckPackageInstalled',			
			description = 'packages installed on the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'PACKAGE_INSTALLED'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_OFFLINE')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_OFFLINE',			
            label = 'Client offline (days)',		
			localeMsgId = (2111 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2GetClientOfflineDays',			
			description = 'Client is offline for several days',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE name = 'CLIENT_OFFLINE'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='USER_CLIENT_OWNER')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USER_CLIENT_OWNER',			
		    label = 'User as client owner',		
			localeMsgId = (2258 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2IsUserClientOwner',			
			description = 'checks if user is the owner of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'USER_CLIENT_OWNER'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='LOCAL_GROUP_CLIENT_OWNER')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'LOCAL_GROUP_CLIENT_OWNER',			
		    label = 'Local user group as client owner',		
			localeMsgId = (2259 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2IsLocalUserGroupClientOwner',			
			description = 'checks if local group is the owner the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'LOCAL_GROUP_CLIENT_OWNER'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='EXTERNAL_GROUP_CLIENT_OWNER')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'EXTERNAL_GROUP_CLIENT_OWNER',			
		    label = 'External group as client owner',		
			localeMsgId = (2260 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2IsExternalUserGroupClientOwner',			
			description = 'checks if external group is the owner the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'EXTERNAL_GROUP_CLIENT_OWNER'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='USES_LIBRARY')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USES_LIBRARY',			
		    label = 'Associated library name',		
			localeMsgId = (2277 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2ClientHasLibrary',			
			description = 'Checks if the client uses this library',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'USES_LIBRARY'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='OS_VERSION')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'OS_VERSION',			
		    label = 'OS Version',		
			localeMsgId = (1889 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientOSVersion',			
			description = 'OS Version of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'OS_VERSION'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='PRODUCT_VERSION')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'PRODUCT_VERSION',			
		    label = 'Product Version',		
			localeMsgId = (847 | (CAST(POWER(2, 24) AS BIGINT) * 61)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientProductVersion',			
			description = 'Product Version of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'PRODUCT_VERSION'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='COMPARE_CLIENT_CS_VERSION')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'COMPARE_CLIENT_CS_VERSION',			
		    label = 'Client Version Same as CS Version',		
			localeMsgId = 0,	
			ptype = 1,			
			funcName = 'dbo.scgV2IsClientVersionSameAsCsVersion',			
			description = 'Client has same service pack as commserve',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'COMPARE_CLIENT_CS_VERSION'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='DAYS_SINCE_CLIENT_CREATED')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'DAYS_SINCE_CLIENT_CREATED',			
            label = 'Days since client created',		
			localeMsgId = (2551 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2DaysSinceClientCreated',			
			description = 'Number of days since client created',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE name = 'DAYS_SINCE_CLIENT_CREATED'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='DAYS_SINCE_LAST_CLIENT_BKP')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'DAYS_SINCE_LAST_CLIENT_BKP',			
            label = 'Days since last backup',		
			localeMsgId = (2550 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2DaysSinceLastBkpForClient',			
			description = 'Number of days since last successful backup for client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE name = 'DAYS_SINCE_LAST_CLIENT_BKP'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='SNAP_BACKUP_CLIENTS')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'SNAP_BACKUP_CLIENTS',			
		    label = 'SnapBackup clients',		
			localeMsgId = (2711 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2IntellisnapClients',			
			description = 'Clients that have Intellisnap enabled',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'SNAP_BACKUP_CLIENTS'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENTS_WITH_ATTACHED_STORAGE')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENTS_WITH_ATTACHED_STORAGE',			
		    label = 'Clients with attached storages',		
			localeMsgId = (2712 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithAttachedStorage',			
			description = 'Clients with attached storages',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENTS_WITH_ATTACHED_STORAGE'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CASE_MANAGER_CLIENTS')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CASE_MANAGER_CLIENTS',			
		    label = 'Case manager hold clients',		
			localeMsgId = (2713 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2CaseManagerHoldClients',			
			description = 'Client is part of a CaseManager hold',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CASE_MANAGER_CLIENTS'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='MAS_FOR_CLIENTS_IN_GROUP')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'MAS_FOR_CLIENTS_IN_GROUP',			
		    label = 'MediaAgents for clients in group',		
			localeMsgId = (2714 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2MediaAgentsInGroup',			
			description = 'MediaAgents for clients included in group',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'MAS_FOR_CLIENTS_IN_GROUP'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_ACTS_AS_PROXY')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ACTS_AS_PROXY',			
		    label = 'Client acts as proxy',		
			localeMsgId = (2552 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientActsAsProxy',			
			description = 'Client acts as network proxy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_ACTS_AS_PROXY'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='BACKUP_ACTIVITY_ENABLED_FOR_CLIENT')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'BACKUP_ACTIVITY_ENABLED_FOR_CLIENT',			
		    label = 'Backup activity enabled',		
			localeMsgId = (2553 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2BackupActivityForClient',			
			description = 'Backup activity enabled for client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'BACKUP_ACTIVITY_ENABLED_FOR_CLIENT'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='RESTORE_ACTIVITY_ENABLED_FOR_CLIENT')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'RESTORE_ACTIVITY_ENABLED_FOR_CLIENT',			
		    label = 'Restore activity enabled',		
			localeMsgId = (2554 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2RestoreActivityForClient',			
			description = 'Restore activity enabled for client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'RESTORE_ACTIVITY_ENABLED_FOR_CLIENT'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_ONLINE')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ONLINE',			
            label = 'Client online (days)',		
			localeMsgId = (2555 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2GetClientOnlineDays',			
			description = 'Days client online',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE name = 'CLIENT_ONLINE'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_OWNER_INACTIVE_ADUSER')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_OWNER_INACTIVE_ADUSER',			
		    label = 'Inactive AD user as client owner',		
			localeMsgId = (2556 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2InactiveADUsersAsClientOwner',			
			description = 'Inactive AD user as client owner',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_OWNER_INACTIVE_ADUSER'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_EXCLUDED_FROM_SLA')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_EXCLUDED_FROM_SLA',			
		    label = 'Client excluded from SLA report',		
			localeMsgId = (2557 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientExcludedFromSLAReport',			
			description = 'Client excluded from SLA report',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_EXCLUDED_FROM_SLA'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_USES_STORAGEPOLICY')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_USES_STORAGEPOLICY',			
		    label = 'Client uses storage policy',		
			localeMsgId = (2761 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2ClientUsesStoragePolicy',			
			description = 'Client uses storage policy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_USES_STORAGEPOLICY'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_HAS_CONNECTIVITY_ISSUES')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_HAS_CONNECTIVITY_ISSUES',			
		    label = 'Client is not ready',		
			localeMsgId = (2762 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientHasConnectivityIssue',			
			description = 'Client is not ready',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_HAS_CONNECTIVITY_ISSUES'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='STORAGE_POLICY')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'STORAGE_POLICY',			
		    label = 'Associated Storage Policy',		
			localeMsgId = (2857 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2CheckClientInStoragePolicy',			
			description = 'checks if a client belongs to the Storage Policy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'STORAGE_POLICY'				
END

	-- Form 8245

IF EXISTS (Select * from App_SCGProperty WHERE name='MEDIAAGENT_HAS_LUCENE_INDEX_ROLES')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'MEDIAAGENT_HAS_LUCENE_INDEX_ROLES',			
		    label = 'MediaAgent has Lucene Index Roles',		
			localeMsgId = (2858 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2MediaAgentHasLuceneIndexRoles',			
			description = 'Checks to see if MediaAgent has Lucene Index Roles',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'MEDIAAGENT_HAS_LUCENE_INDEX_ROLES'				
END

	-- Form 8913

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_ASSOCIATED_WITH_PLAN')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ASSOCIATED_WITH_PLAN',			
		    label = 'Client associated with plan',		
			localeMsgId = (2867 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2ClientAssociatedWithPlan',			
			description = 'Client associated with plan',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_ASSOCIATED_WITH_PLAN'				
END

	-- Form 9612

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_BY_SCHEDULE_INTERVAL')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_BY_SCHEDULE_INTERVAL',			
		    label = 'Client by Schedule Interval',		
			localeMsgId = (2950 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2ClientsByScheduleInterval',			
			description = 'Client by Schedule Interval',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_BY_SCHEDULE_INTERVAL'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='CLIENT_NEEDS_UPDATES')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_NEEDS_UPDATES',			
		    label = 'Client needs Updates',		
			localeMsgId = (2951 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientNeedsUpdates',			
			description = 'Client needs Updates',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'CLIENT_NEEDS_UPDATES'				
END

	-- SubClient Name added in V10 via Update but not added to CVS tree for future updating

IF EXISTS (Select * from App_SCGProperty WHERE name='SUBCLIENT_NAME')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'SUBCLIENT_NAME',			
		    label = 'Subclient Name',		
			localeMsgId = (2951 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetSubclientName',			
			description = 'name of subclient',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'SUBCLIENT_NAME'				
END

IF EXISTS (Select * from App_SCGProperty WHERE name='VSA_DISCOVER_CLIENT')	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'VSA_DISCOVER_CLIENT',			
		    label = 'Clients discovered using VSA Subclient',		
			localeMsgId = (3002 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 6,			
			funcName = 'dbo.scgV2VSADiscoveredClients',			
			description = 'Clients discovered using VSA Subclient',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE name = 'VSA_DISCOVER_CLIENT'				
END

	-- Check for invalid SCG Rule / Property Id mismatches and comment the ruleXML and ruleQuery out

	-- These will be ignored by the follow on upgrade scripting

	IF OBJECT_ID('tempdb.dbo.#InvalidRuleTree') IS NOT NULL

		DROP TABLE #InvalidRuleTree

	CREATE TABLE #InvalidRuleTree (

		id			INT IDENTITY(1,1),

		scgRuleId	INT,

		groupId		INT,

		groupName	NVARCHAR(255),

		masterOp	INT,

		[group]		INT,

		number		INT,

		filterID	INT,

		propID		INT,

		propType	INT,

		secValue	VARCHAR(MAX),

		value		VARCHAR(MAX),

		op			INT,

		funcName	VARCHAR(256),

		ruleXML		XML,

		newRuleXML	XML,

		level		INT,

		PRIMARY KEY (scgRuleId, [group], number, id)

	)
	INSERT INTO #InvalidRuleTree(scgRuleId, groupId, groupName, masterOp, [group], number, filterID, propID, propType, secValue, value, op, funcName, ruleXML, level)


		SELECT

			sr.id,

			sr.scgId,

			cg.name,

			r.value('../../../../@op', 'int') masterOp,

			gc.value('for $a in . return 1+count($a/../*[. << $a])','int') [group],

			rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,

			r.value('@filterID', 'int') filterID,

			r.value('@propID', 'int') propID,

			r.value('@propType', 'int') propType,

			r.value('@secValue', 'varchar(max)') secValue,

			CASE

				WHEN r.value('@propType', 'int') = 6 THEN CAST(CAST(r.value('@value', 'varchar(max)') AS XML) AS VARCHAR(MAX))	-- remove XML Header

				ELSE r.value('@value', 'varchar(max)') 

			END value,

			r.value('../../@op', 'int') op,

			p.funcName,

			CAST(sr.ruleXML AS NVARCHAR(MAX)),

			4

		FROM

			App_SCGRule sr

			CROSS APPLY sr.ruleXML.nodes('/scgRule/rules/rule/rules/rule') t(r)

			LEFT OUTER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function

				p.id = r.value('@propID', 'int')

			LEFT OUTER JOIN APP_ClientGroup cg ON

				cg.id = sr.scgId

			CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number

			CROSS APPLY r.nodes('../..') gc(gc)		-- rule group count / number

		WHERE

			p.id IS NULL

		UNION

		SELECT

			sr.id,

			sr.scgId,

			cg.name,

			r.value('../../@op', 'int') masterOp,

			1 [group],	-- only one grouping

			rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,

			r.value('@filterID', 'int') filterID,

			r.value('@propID', 'int') propID,

			r.value('@propType', 'int') propType,

			r.value('@secValue', 'varchar(max)') secValue,

			CASE

				WHEN r.value('@propType', 'int') = 6 THEN CAST(CAST(r.value('@value', 'varchar(max)') AS XML) AS VARCHAR(MAX))	-- remove XML Header

				ELSE r.value('@value', 'varchar(max)') 

			END value,

			r.value('../../@op', 'int') op,		-- same as masterOp

			p.funcName,

			CAST(sr.ruleXML AS NVARCHAR(MAX)),

			2

		FROM

			App_SCGRule sr

			CROSS APPLY sr.ruleXML.nodes('/scgRule/rules/rule') t(r)

			LEFT OUTER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function

				p.id = r.value('@propID', 'int')

			LEFT OUTER JOIN APP_ClientGroup cg ON

				cg.id = sr.scgId

			CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number

		WHERE

			r.exist('rules/rule') = 0

			AND p.id IS NULL

	-- Re-map SCG Property ids from dynamically asigned to statically assigned

	BEGIN TRY

		BEGIN TRAN SCGRuleTrans

		SET @tranStarted = 1

		UPDATE sr

			SET flag = 0	-- reset all

		FROM APP_SCGRule sr

		UPDATE sr

			SET flag = (flag | 1)	-- invalid SCG Rule bit turned on

		FROM APP_SCGRule sr

			INNER JOIN #InvalidRuleTree rt ON

				rt.scgRuleId = sr.id

		IF OBJECT_ID('tempdb.dbo.#App_SCGPropertyMap') IS NOT NULL 	

			DROP TABLE #App_SCGPropertyMap

		CREATE TABLE #App_SCGPropertyMap (

			id		INT PRIMARY KEY,

			name	NVARCHAR(256)

		)
		INSERT INTO #App_SCGPropertyMap (id, name) VALUES


(1,							'CLIENT_NAME'),

(2,							'CLIENT_PROP'),

(39,					'CLIENT_DESCRIPTION'),

(3,								'APP_TYPE'),

(4,							'CLIENT_GROUP'),

(5,								'TIMEZONE'),

(6,							'HOST_NAME'),

(7,						'CLIENT_VERSION'),

(8,								'OS_TYPE'),

(9,					'PACKAGE_INSTALLED'),

(10,						'CLIENT_OFFLINE'),

(11,					'USER_CLIENT_OWNER'),

(12,				'LOCAL_GROUP_CLIENT_OWNER'),

(13,			'EXTERNAL_GROUP_CLIENT_OWNER'),

(14,							'USES_LIBRARY'),

(15,							'OS_VERSION'),

(16,						'PRODUCT_VERSION'),

(17,			'COMPARE_CLIENT_CS_VERSION'),

(18,			'DAYS_SINCE_CLIENT_CREATED'),

(19,			'DAYS_SINCE_LAST_CLIENT_BKP'),

(20,					'SNAP_BACKUP_CLIENTS'),

(21,		'CLIENTS_WITH_ATTACHED_STORAGE'),

(22,					'CASE_MANAGER_CLIENTS'),

(23,				'MAS_FOR_CLIENTS_IN_GROUP'),

(24,					'CLIENT_ACTS_AS_PROXY'),

(25,	'BACKUP_ACTIVITY_ENABLED_FOR_CLIENT'),

(26,	'RESTORE_ACTIVITY_ENABLED_FOR_CLIENT'),

(27,						'CLIENT_ONLINE'),

(28,			'CLIENT_OWNER_INACTIVE_ADUSER'),

(29,				'CLIENT_EXCLUDED_FROM_SLA'),

(30,			'CLIENT_USES_STORAGEPOLICY'),

(31,		'CLIENT_HAS_CONNECTIVITY_ISSUES'),

(32,						'STORAGE_POLICY'),

(33,	'MEDIAAGENT_HAS_LUCENE_INDEX_ROLES'),

(34,			'CLIENT_ASSOCIATED_WITH_PLAN'),

(35,			'CLIENT_BY_SCHEDULE_INTERVAL'),

(36,					'CLIENT_NEEDS_UPDATES'),

(37,						'SUBCLIENT_NAME'),

			-- V11 SP4A

(38,					'IS_COMMCELL_CLIENT'),

(40,					'VSA_DISCOVER_CLIENT'),

(49,					    'CLIENTS_WITH_ONEPASS_ENABLED')

		IF OBJECT_ID('tempdb.dbo.#App_SCGPropertyRemapping') IS NOT NULL 	

			DROP TABLE #App_SCGPropertyRemapping

		-- Internal Test issue with unreleased SCG Function

		DELETE FROM App_SCGProperty

		WHERE

			funcName LIKE '%scgSnapBackupsOnlyMediaAgents%'

		SELECT pm.id staticId, p.* 

		INTO #App_SCGPropertyRemapping

		FROM App_SCGProperty p

			INNER JOIN #App_SCGPropertyMap pm ON

				pm.name = p.name

		-- Re-map SCG Rules to new static SCG Property Primary Key Ids 

		IF OBJECT_ID('tempdb.dbo.#RuleTree2') IS NOT NULL

			DROP TABLE #RuleTree2

		CREATE TABLE #RuleTree2 (

			id			INT IDENTITY(1,1),

			scgRuleId	INT,

			masterOp	INT,

			[group]		INT,

			number		INT,

			filterID	INT,

			propID		INT,

			newPropID	INT,

			propType	INT,

			secValue	VARCHAR(MAX),

			value		VARCHAR(MAX),

			op			INT,

			--flags		INT,

			funcName	VARCHAR(256),

			ruleXML		XML,

			newRuleXML	XML,

			level		INT,

			PRIMARY KEY (scgRuleId, [group], number, id)

		)

		-- Flatten SCG Rule XMLs into rows

		-- 4 levels - '--rules/rule/rules/rule'
		INSERT INTO #RuleTree2(scgRuleId, masterOp, [group], number, filterID, propID, newPropID, propType, secValue, value, op, /*flags,*/ funcName, ruleXML, level)


			SELECT

				sr.id,

				r.value('../../../../@op', 'int') masterOp,

				gc.value('for $a in . return 1+count($a/../*[. << $a])','int') [group],

				rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,

				r.value('@filterID', 'int') filterID,

				r.value('@propID', 'int') propID,

				pm.id newPropID,

				r.value('@propType', 'int') propType,

				r.value('@secValue', 'varchar(max)') secValue,

				CASE

					WHEN r.value('@propType', 'int') = 6 THEN CAST(CAST(r.value('@value', 'varchar(max)') AS XML) AS VARCHAR(MAX))	-- remove XML Header

					ELSE r.value('@value', 'varchar(max)') 

				END value,

				r.value('../../@op', 'int') op,

				--ISNULL(p.flags, up.flags) flags,

				p.funcName,

				sr.ruleXML,

				4

			FROM

				App_SCGRule sr

				CROSS APPLY sr.ruleXML.nodes('/scgRule/rules/rule/rules/rule') t(r)

				INNER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function

					p.id = r.value('@propID', 'int')

				INNER JOIN #App_SCGPropertyMap pm ON

					pm.name = p.name

				CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number

				CROSS APPLY r.nodes('../../..') gc(gc)		-- rule group count / number	NOTE if relate path --rules/rule/rules/rule -> '../..'

			WHERE

				(sr.flag & 1) = 0		-- check for invalid SCG Rule do not want to upgrade it

		-- 2 levels - '--rules/rule'
		INSERT INTO #RuleTree2(scgRuleId, masterOp, [group], number, filterID, propID, newPropID, propType, secValue, value, op, /*flags,*/ funcName, ruleXML, level)


			SELECT

				sr.id,

				r.value('../../@op', 'int') masterOp,

				1 [group],	-- only one grouping

				rc.value('for $a in . return 1+count($a/../*[. << $a])','int') number,

				r.value('@filterID', 'int') filterID,

				r.value('@propID', 'int') propID,

				pm.id newPropID,

				r.value('@propType', 'int') propType,

				r.value('@secValue', 'varchar(max)') secValue,

				CASE

					WHEN r.value('@propType', 'int') = 6 THEN CAST(CAST(r.value('@value', 'varchar(max)') AS XML) AS VARCHAR(MAX))	-- remove XML Header

					ELSE r.value('@value', 'varchar(max)') 

				END value,

				r.value('../../@op', 'int') op,		-- same as masterOp

				--ISNULL(p.flags, up.flags) flags,

				p.funcName,

				sr.ruleXML,

				2

			FROM

				App_SCGRule sr

				CROSS APPLY sr.ruleXML.nodes('/scgRule/rules/rule') t(r)

				INNER JOIN App_SCGProperty p WITH(READUNCOMMITTED) ON		-- propID < 10000	CS Supplied SCG Function

					p.id = r.value('@propID', 'int')

				INNER JOIN #App_SCGPropertyMap pm ON

					pm.name = p.name

				CROSS APPLY r.nodes('..') rc(rc)			-- rule count / number

			WHERE

				r.exist('rules/rule') = 0		-- and no lower level nodes exist

				AND sr.id NOT IN (SELECT scgRuleId FROM #RuleTree2)

				AND (sr.flag & 1) = 0		-- check for invalid SCG Rule do not want to upgrade it

		-- Re-generate Rule XMLs with replaced static ids

		IF OBJECT_ID('tempdb.dbo.#NewSCGRules') IS NOT NULL

			DROP TABLE #NewSCGRules

		CREATE TABLE #NewSCGRules (

			id			INT,

			oldRuleXML	XML,

			newRuleXML	XML

		)
		INSERT INTO #NewSCGRules


			SELECT

				sr.id,

				sr.ruleXML,

				CASE r.level

					WHEN 4 THEN

						(

							SELECT

								rt1.masterOp '@op',

								(

									SELECT

										(

											SELECT

												rt2.op '@op',

												(

													SELECT

														--rt3.number '@number',

														(

															SELECT

																rt4.filterID '@filterID',

																--rt4.propID '@oldPropId',

																rt4.newPropID '@propID',

																rt4.propType '@propType',

																rt4.secValue '@secValue',

																rt4.value '@value'

															FROM #RuleTree2 rt4

															WHERE 

																rt4.scgRuleId = rt3.scgRuleId

																AND rt4.[group] = rt3.[group]

																AND rt4.number = rt3.number

																AND rt4.masterOp = rt3.masterOp

															FOR XML PATH('rule'), TYPE

														)

													FROM  (SELECT DISTINCT scgRuleId, [group], masterOp, number, op FROM #RuleTree2) rt3

													WHERE rt3.scgRuleId = rt2.scgRuleId

														AND rt3.[group] = rt2.[group]

														AND rt3.masterOp = rt2.masterOp

														AND rt3.op = rt2.op

													FOR XML PATH('rules'), TYPE

												)

											FROM  (SELECT DISTINCT scgRuleId, [group], masterOp, op FROM #RuleTree2) rt2

											WHERE rt2.scgRuleId = rtGrp.scgRuleId

												AND rt2.masterOp = rtGrp.masterOp

												AND rt2.[group] = rtGrp.[group]

											FOR XML PATH('rule'), TYPE

										)

									FROM (SELECT DISTINCT scgRuleId, [group], masterOp FROM #RuleTree2) rtGrp

									WHERE rtGrp.scgRuleId = rt1.scgRuleId

											AND rtGrp.masterOp = rt1.masterOp

									FOR XML PATH('rules'), TYPE

								)

							FROM (SELECT DISTINCT scgRuleId, masterOp FROM #RuleTree2) rt1

							WHERE rt1.scgRuleId = sr.id

							FOR XML PATH('scgRule'), TYPE

						)

					WHEN 2 THEN (

							SELECT

								rt1.masterOp '@op',

								(

									SELECT

										(

											SELECT

												rt4.filterID '@filterID',

												--rt4.propID '@oldPropId',

												rt4.newPropID '@propID',

												rt4.propType '@propType',

												rt4.secValue '@secValue',

												rt4.value '@value'

											FROM #RuleTree2 rt4

											WHERE 

												rt4.scgRuleId = rt3.scgRuleId

												AND rt4.[group] = rt3.[group]

												AND rt4.number = rt3.number

											FOR XML PATH('rule'), TYPE

										)

									FROM  (SELECT scgRuleId, [group], number FROM #RuleTree2) rt3

									WHERE rt3.scgRuleId = rt1.scgRuleId

										AND rt3.[group] = rt1.[group]

									FOR XML PATH('rules'), TYPE

								)

							FROM (SELECT DISTINCT scgRuleId, [group], masterOp FROM #RuleTree2) rt1

							WHERE rt1.scgRuleId = sr.id

							FOR XML PATH('scgRule'), TYPE

						)

					ELSE NULL

				END

			FROM App_SCGRule sr

				INNER JOIN (

					SELECT DISTINCT

						rt.scgRuleId,

						rt.level

					FROM #RuleTree2 rt

				) r ON

					r.scgRuleId = sr.id

					AND (sr.flag & 1) = 0

		-- Change current identity ids to static ids

		UPDATE p

			SET id = pm.staticId

		FROM App_SCGProperty p

			INNER JOIN #App_SCGPropertyRemapping pm ON

				pm.name = p.name

		-- Now update the SCG Rules for the new static property ids

		UPDATE sr

			SET ruleXML = r.newRuleXML

		FROM APP_SCGRule sr

			INNER JOIN #NewSCGRules r ON

				r.id = sr.id

				AND (sr.flag & 1) = 0
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@SCGGuid, 'SCGV2StaticIdRetrofit', 'Update script to to assign static SCG Ids', @nowTime, 16, 0, (16 + 2))

		IF OBJECT_ID('tempdb.dbo.#App_SCGPropertyMap') IS NOT NULL 	

			DROP TABLE #App_SCGPropertyMap

		IF OBJECT_ID('tempdb.dbo.#App_SCGPropertyRemapping') IS NOT NULL 	

			DROP TABLE #App_SCGPropertyRemapping

		IF OBJECT_ID('tempdb.dbo.#RuleTree2') IS NOT NULL

			DROP TABLE #RuleTree2

		IF OBJECT_ID('tempdb.dbo.#NewSCGRules') IS NOT NULL

			DROP TABLE #NewSCGRules

	END TRY

	BEGIN CATCH

		IF (@tranStarted = 1)

		BEGIN

			ROLLBACK TRAN SCGRuleTrans

		END

		DECLARE @msg VARCHAR(2047) = @newLine + @newLine

		SET @msg += 'INSIDE CATCH BLOCK WITH FOLLOWING ERROR: ' + @newLine

		SET @msg += '   ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR(12)) + @newLine

		SET @msg += '   SQL SCRIPT: APP_SCGProperty' + @newLine

		SET @msg += '   ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR(12)) + @newLine

		SET @msg += '   ERROR MESSAGE: ' + ERROR_MESSAGE() + @newLine

		SET @msg += '   ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR(12)) + @newLine

		SET @msg += '   ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR(12)) + @newLine + @newLine

		PRINT @msg

		GOTO END_OF_SCRIPT

	END CATCH

	IF (@tranStarted = 1)

	BEGIN

		COMMIT TRAN SCGRuleTrans

	END

	-- Must fall thru for fresh installs

END

SCRIPT_INSERT_DATA:

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=1)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (1, 'CLIENT_NAME', 'Client Name', (3981 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2GetClientName', 'name of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_NAME',			
            label = 'Client Name',		
			localeMsgId = (3981 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientName',			
			description = 'name of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 1				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=2)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (2, 'CLIENT_PROP', 'Client', (1886 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2GetClientProps', 'checks some of the client properties', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_PROP',			
            label = 'Client',		
			localeMsgId = (1886 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientProps',			
			description = 'checks some of the client properties',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 2				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=39)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (39, 'CLIENT_DESCRIPTION', 'Client Description', (2981 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2GetClientDescription', 'description of client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_DESCRIPTION',			
            label = 'Client Description',		
			localeMsgId = (2981 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientDescription',			
			description = 'description of client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 39				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=3)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (3, 'APP_TYPE', 'Agent(s) Installed', (1887 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 6, 'dbo.scgV2CompareAppTypes', 'check if values is in or not in the apptypes', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'APP_TYPE',			
            label = 'Agent(s) Installed',		
			localeMsgId = (1887 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 6,			
			funcName = 'dbo.scgV2CompareAppTypes',			
			description = 'check if values is in or not in the apptypes',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 3				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=4)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (4, 'CLIENT_GROUP', 'Associated Client Group', (1888 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2CheckClientInGroup', 'checks if a client belongs to a group', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_GROUP',			
            label = 'Associated Client Group',		
			localeMsgId = (1888 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2CheckClientInGroup',			
			description = 'checks if a client belongs to a group',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 4				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=5)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (5, 'TIMEZONE', 'Timezone', (1901 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2GetClientTimezoneId', 'time zone for the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'TIMEZONE',			
            label = 'Timezone',		
			localeMsgId = (1901 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientTimezoneId',			
			description = 'time zone for the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 5				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=6)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (6, 'HOST_NAME', 'Hostname', (1785 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2GetClientHostName', 'hostname of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'HOST_NAME',			
            label = 'Hostname',		
			localeMsgId = (1785 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientHostName',			
			description = 'hostname of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 6				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=7)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (7, 'CLIENT_VERSION', 'Client Version', (1926 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2GetClientVersion', 'Version of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_VERSION',			
            label = 'Client Version',		
			localeMsgId = (1926 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientVersion',			
			description = 'Version of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 7				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=8)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (8, 'OS_TYPE', 'OS Type', (1957 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2GetClientOSType', 'os type of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'OS_TYPE',			
            label = 'OS Type',		
			localeMsgId = (1957 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientOSType',			
			description = 'os type of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 8				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=9)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (9, 'PACKAGE_INSTALLED', 'Package Installed', (2012 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 6, 'dbo.scgV2CheckPackageInstalled', 'packages installed on the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'PACKAGE_INSTALLED',			
            label = 'Package Installed',		
			localeMsgId = (2012 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 6,			
			funcName = 'dbo.scgV2CheckPackageInstalled',			
			description = 'packages installed on the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 9				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=10)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (10, 'CLIENT_OFFLINE', 'Client offline (days)', (2111 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2GetClientOfflineDays', 'Client is offline for several days', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_OFFLINE',			
            label = 'Client offline (days)',		
			localeMsgId = (2111 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2GetClientOfflineDays',			
			description = 'Client is offline for several days',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 10				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=11)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (11, 'USER_CLIENT_OWNER', 'User as client owner', (2258 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2IsUserClientOwner', 'checks if user is the owner of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USER_CLIENT_OWNER',			
            label = 'User as client owner',		
			localeMsgId = (2258 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2IsUserClientOwner',			
			description = 'checks if user is the owner of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 11				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=12)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (12, 'LOCAL_GROUP_CLIENT_OWNER', 'Local user group as client owner', (2259 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2IsLocalUserGroupClientOwner', 'checks if local group is the owner the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'LOCAL_GROUP_CLIENT_OWNER',			
            label = 'Local user group as client owner',		
			localeMsgId = (2259 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2IsLocalUserGroupClientOwner',			
			description = 'checks if local group is the owner the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 12				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=13)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (13, 'EXTERNAL_GROUP_CLIENT_OWNER', 'External group as client owner', (2260 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2IsExternalUserGroupClientOwner', 'checks if external group is the owner the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'EXTERNAL_GROUP_CLIENT_OWNER',			
            label = 'External group as client owner',		
			localeMsgId = (2260 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2IsExternalUserGroupClientOwner',			
			description = 'checks if external group is the owner the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 13				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=14)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (14, 'USES_LIBRARY', 'Associated library name', (2277 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2ClientHasLibrary', 'Checks if the client uses this library', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USES_LIBRARY',			
            label = 'Associated library name',		
			localeMsgId = (2277 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2ClientHasLibrary',			
			description = 'Checks if the client uses this library',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 14				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=15)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (15, 'OS_VERSION', 'OS Version', (1889 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2GetClientOSVersion', 'OS Version of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'OS_VERSION',			
            label = 'OS Version',		
			localeMsgId = (1889 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientOSVersion',			
			description = 'OS Version of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 15				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=16)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (16, 'PRODUCT_VERSION', 'Product Version', (847 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 2, 'dbo.scgV2GetClientProductVersion', 'Product Version of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'PRODUCT_VERSION',			
            label = 'Product Version',		
			localeMsgId = (847 | (CAST(POWER(2, 24) AS BIGINT) * 61)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientProductVersion',			
			description = 'Product Version of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 16				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=17)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (17, 'COMPARE_CLIENT_CS_VERSION', 'Client Version Same as CS Version', 0, 1, 'dbo.scgV2IsClientVersionSameAsCsVersion', 'Client has same service pack as commserve', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'COMPARE_CLIENT_CS_VERSION',			
            label = 'Client Version Same as CS Version',		
			localeMsgId = 0,	
			ptype = 1,			
			funcName = 'dbo.scgV2IsClientVersionSameAsCsVersion',			
			description = 'Client has same service pack as commserve',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 17				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=18)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (18, 'DAYS_SINCE_CLIENT_CREATED', 'Days since client created', (2551 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2DaysSinceClientCreated', 'Number of days since client created', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'DAYS_SINCE_CLIENT_CREATED',			
            label = 'Days since client created',		
			localeMsgId = (2551 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2DaysSinceClientCreated',			
			description = 'Number of days since client created',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 18				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=19)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (19, 'DAYS_SINCE_LAST_CLIENT_BKP', 'Days since last backup', (2550 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2DaysSinceLastBkpForClient', 'Number of days since last successful backup for client', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'DAYS_SINCE_LAST_CLIENT_BKP',			
            label = 'Days since last backup',		
			localeMsgId = (2550 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2DaysSinceLastBkpForClient',			
			description = 'Number of days since last successful backup for client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 19				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=20)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (20, 'SNAP_BACKUP_CLIENTS', 'SnapBackup clients', (2711 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2IntellisnapClients', 'Clients that have Intellisnap enabled', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'SNAP_BACKUP_CLIENTS',			
            label = 'SnapBackup clients',		
			localeMsgId = (2711 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2IntellisnapClients',			
			description = 'Clients that have Intellisnap enabled',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 20				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=21)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (21, 'CLIENTS_WITH_ATTACHED_STORAGE', 'Clients with attached storages', (2712 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientsWithAttachedStorage', 'Clients with attached storages', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENTS_WITH_ATTACHED_STORAGE',			
            label = 'Clients with attached storages',		
			localeMsgId = (2712 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithAttachedStorage',			
			description = 'Clients with attached storages',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 21				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=22)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (22, 'CASE_MANAGER_CLIENTS', 'Case manager hold clients', (2713 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2CaseManagerHoldClients', 'Client is part of a CaseManager hold', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CASE_MANAGER_CLIENTS',			
            label = 'Case manager hold clients',		
			localeMsgId = (2713 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2CaseManagerHoldClients',			
			description = 'Client is part of a CaseManager hold',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 22				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=23)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (23, 'MAS_FOR_CLIENTS_IN_GROUP', 'MediaAgents for clients in group', (2714 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2MediaAgentsInGroup', 'MediaAgents for clients included in group', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'MAS_FOR_CLIENTS_IN_GROUP',			
            label = 'MediaAgents for clients in group',		
			localeMsgId = (2714 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2MediaAgentsInGroup',			
			description = 'MediaAgents for clients included in group',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 23				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=24)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (24, 'CLIENT_ACTS_AS_PROXY', 'Client acts as proxy', (2552 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientActsAsProxy', 'Client acts as network proxy', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ACTS_AS_PROXY',			
            label = 'Client acts as proxy',		
			localeMsgId = (2552 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientActsAsProxy',			
			description = 'Client acts as network proxy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 24				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=25)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (25, 'BACKUP_ACTIVITY_ENABLED_FOR_CLIENT', 'Backup activity enabled', (2553 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2BackupActivityForClient', 'Backup activity enabled for client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'BACKUP_ACTIVITY_ENABLED_FOR_CLIENT',			
            label = 'Backup activity enabled',		
			localeMsgId = (2553 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2BackupActivityForClient',			
			description = 'Backup activity enabled for client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 25				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=26)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (26, 'RESTORE_ACTIVITY_ENABLED_FOR_CLIENT', 'Restore activity enabled', (2554 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2RestoreActivityForClient', 'Restore activity enabled for client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'RESTORE_ACTIVITY_ENABLED_FOR_CLIENT',			
            label = 'Restore activity enabled',		
			localeMsgId = (2554 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2RestoreActivityForClient',			
			description = 'Restore activity enabled for client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 26				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=27)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (27, 'CLIENT_ONLINE', 'Client online (days)', (2555 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2GetClientOnlineDays', 'Days client online', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ONLINE',			
            label = 'Client online (days)',		
			localeMsgId = (2555 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2GetClientOnlineDays',			
			description = 'Days client online',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 27				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=28)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (28, 'CLIENT_OWNER_INACTIVE_ADUSER', 'Inactive AD user as client owner', (2556 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2InactiveADUsersAsClientOwner', 'Inactive AD user as client owner', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_OWNER_INACTIVE_ADUSER',			
            label = 'Inactive AD user as client owner',		
			localeMsgId = (2556 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2InactiveADUsersAsClientOwner',			
			description = 'Inactive AD user as client owner',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 28				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=29)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (29, 'CLIENT_EXCLUDED_FROM_SLA', 'Client excluded from SLA report', (2557 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientExcludedFromSLAReport', 'Client excluded from SLA report', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_EXCLUDED_FROM_SLA',			
            label = 'Client excluded from SLA report',		
			localeMsgId = (2557 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientExcludedFromSLAReport',			
			description = 'Client excluded from SLA report',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 29				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=30)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (30, 'CLIENT_USES_STORAGEPOLICY', 'Client uses storage policy', (2761 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2ClientUsesStoragePolicy', 'Client uses storage policy', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_USES_STORAGEPOLICY',			
            label = 'Client uses storage policy',		
			localeMsgId = (2761 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2ClientUsesStoragePolicy',			
			description = 'Client uses storage policy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 30				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=31)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (31, 'CLIENT_HAS_CONNECTIVITY_ISSUES', 'Client is not ready', (2762 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientHasConnectivityIssue', 'Client is not ready', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_HAS_CONNECTIVITY_ISSUES',			
            label = 'Client is not ready',		
			localeMsgId = (2762 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientHasConnectivityIssue',			
			description = 'Client is not ready',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 31				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=32)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (32, 'STORAGE_POLICY', 'Associated Storage Policy', (2857 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2CheckClientInStoragePolicy', 'checks if a client belongs to the Storage Policy', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'STORAGE_POLICY',			
            label = 'Associated Storage Policy',		
			localeMsgId = (2857 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2CheckClientInStoragePolicy',			
			description = 'checks if a client belongs to the Storage Policy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 32				
END

-- Form 8245

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=33)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (33, 'MEDIAAGENT_HAS_LUCENE_INDEX_ROLES', 'MediaAgent has Lucene Index Roles', (2858 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2MediaAgentHasLuceneIndexRoles', 'Checks to see if MediaAgent has Lucene Index Roles', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'MEDIAAGENT_HAS_LUCENE_INDEX_ROLES',			
            label = 'MediaAgent has Lucene Index Roles',		
			localeMsgId = (2858 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2MediaAgentHasLuceneIndexRoles',			
			description = 'Checks to see if MediaAgent has Lucene Index Roles',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 33				
END

-- Form 8913

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=34)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (34, 'CLIENT_ASSOCIATED_WITH_PLAN', 'Client associated with plan', (2867 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2ClientAssociatedWithPlan', 'Client associated with plan', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ASSOCIATED_WITH_PLAN',			
            label = 'Client associated with plan',		
			localeMsgId = (2867 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2ClientAssociatedWithPlan',			
			description = 'Client associated with plan',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 34				
END

-- Form 9612

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=35)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (35, 'CLIENT_BY_SCHEDULE_INTERVAL', 'Client by Schedule Interval', (2950 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2ClientsByScheduleInterval', 'Client by Schedule Interval', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_BY_SCHEDULE_INTERVAL',			
            label = 'Client by Schedule Interval',		
			localeMsgId = (2950 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2ClientsByScheduleInterval',			
			description = 'Client by Schedule Interval',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 35				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=36)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (36, 'CLIENT_NEEDS_UPDATES', 'Client needs Updates', (2951 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientNeedsUpdates', 'Client needs Updates', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_NEEDS_UPDATES',			
            label = 'Client needs Updates',		
			localeMsgId = (2951 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientNeedsUpdates',			
			description = 'Client needs Updates',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 36				
END

-- SubClient Name added in V10 via Update but not added to CVS tree for future updating

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=37)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (37, 'SUBCLIENT_NAME', 'Subclient Name', (2952 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2GetSubclientName', 'name of subclient', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'SUBCLIENT_NAME',			
            label = 'Subclient Name',		
			localeMsgId = (2952 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetSubclientName',			
			description = 'name of subclient',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 37				
END

--V11 SP5

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=38)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (38, 'IS_COMMCELL_CLIENT', 'CommCell Pseudo Client', (3988 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2IsCommCellPseudoClient', 'Is CommCell Pseudo Client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'IS_COMMCELL_CLIENT',			
            label = 'CommCell Pseudo Client',		
			localeMsgId = (3988 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2IsCommCellPseudoClient',			
			description = 'Is CommCell Pseudo Client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 38				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=40)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (40, 'VSA_DISCOVER_CLIENT', 'Clients discovered using VSA Subclient', (3002 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 6, 'dbo.scgV2VSADiscoveredClients', 'Clients discovered using VSA Subclient', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'VSA_DISCOVER_CLIENT',			
            label = 'Clients discovered using VSA Subclient',		
			localeMsgId = (3002 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 6,			
			funcName = 'dbo.scgV2VSADiscoveredClients',			
			description = 'Clients discovered using VSA Subclient',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 40				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=41)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (41, 'CLIENT_WITH_NO_ARCHIVE_DATA', 'Clients with no Archive Data', (3028 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientsWithNoArchiveData', 'Clients with no Archive Data', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_WITH_NO_ARCHIVE_DATA',			
            label = 'Clients with no Archive Data',		
			localeMsgId = (3028 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithNoArchiveData',			
			description = 'Clients with no Archive Data',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 41				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=42)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (42, 'USER_CLIENT_ASSOCIATIONS', 'User Client Provider Associations', (3157 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2UserClientAssociations', 'User Client Provider Associations', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USER_CLIENT_ASSOCIATIONS',			
            label = 'User Client Provider Associations',		
			localeMsgId = (3157 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2UserClientAssociations',			
			description = 'User Client Provider Associations',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 42				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=43)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (43, 'USERGROUP_CLIENT_ASSOCIATIONS', 'User Group Client Provider Associations', (3158 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2UserGroupClientAssociations', 'User Group Client Provider Associations', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USERGROUP_CLIENT_ASSOCIATIONS',			
            label = 'User Group Client Provider Associations',		
			localeMsgId = (3158 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2UserGroupClientAssociations',			
			description = 'User Group Client Provider Associations',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 43				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=44)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (44, 'COMPANY_CLIENT_ASSOCIATIONS', 'Company Client Provider Associations', (3156 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2CompanyClientAssociations', 'Company Client Provider Associations', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'COMPANY_CLIENT_ASSOCIATIONS',			
            label = 'Company Client Provider Associations',		
			localeMsgId = (3156 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2CompanyClientAssociations',			
			description = 'Company Client Provider Associations',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 44				
END

--V11 SP6

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=45)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (45, 'CLIENT_MEETS_SLA', 'Clients Meet SLA', (3027 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2ClientMeetsSLA', 'Clients Meets SLA', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_MEETS_SLA',			
            label = 'Clients Meet SLA',		
			localeMsgId = (3027 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2ClientMeetsSLA',			
			description = 'Clients Meets SLA',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 45				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=46)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (46, 'SOLR_SERVERS_CLIENT', 'Index Servers', (3064 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2SolrServersClients', 'Client is part of a Index Servers', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'SOLR_SERVERS_CLIENT',			
            label = 'Index Servers',		
			localeMsgId = (3064 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2SolrServersClients',			
			description = 'Client is part of a Index Servers',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 46				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=49)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (49, 'CLIENTS_WITH_ONEPASS_ENABLED', 'Clients with OnePass enabled', (3101 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientWithOnePassEnabled', 'Clients with OnePass enabled', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENTS_WITH_ONEPASS_ENABLED',			
            label = 'Clients with OnePass enabled',		
			localeMsgId = (3101 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientWithOnePassEnabled',			
			description = 'Clients with OnePass enabled',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 49				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=52)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (52, 'USER_DESCRIPTION_CONTAINS', 'User description contains', (3113 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2UserDescriptionContains', 'User description contains', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USER_DESCRIPTION_CONTAINS',			
            label = 'User description contains',		
			localeMsgId = (3113 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2UserDescriptionContains',			
			description = 'User description contains',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 52				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=53)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (53, 'USERGROUP_DESCRIPTION_CONTAINS', 'User Group description contains', (3114 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2UserGroupDescriptionContains', 'User Group description contains', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USERGROUP_DESCRIPTION_CONTAINS',			
            label = 'User Group description contains',		
			localeMsgId = (3114 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2UserGroupDescriptionContains',			
			description = 'User Group description contains',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 53				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=50)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (50, 'CLIENT_BY_ROLE', 'Clients by Role', (3155 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2GetClientByRole', 'Clients by Role', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_BY_ROLE',			
            label = 'Clients by Role',		
			localeMsgId = (3155 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientByRole',			
			description = 'Clients by Role',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 50				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=51)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (51, 'CLIENT_BY_PERMISSION', 'Clients by Permission', (3154 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2GetClientByPermission', 'Clients by Permission', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_BY_PERMISSION',			
            label = 'Clients by Permission',		
			localeMsgId = (3154 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2GetClientByPermission',			
			description = 'Clients by Permission',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 51				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=54)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (54, 'ANALYZER_SERVERS_CLIENT', 'Content Analyzer Cloud', (3181 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2AnalyzerServersClients', 'Client is part of a Content Analyzer cloud', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'ANALYZER_SERVERS_CLIENT',			
            label = 'Content Analyzer Cloud',		
			localeMsgId = (3181 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2AnalyzerServersClients',			
			description = 'Client is part of a Content Analyzer cloud',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 54				
END

-- Added this additional delete due to mismatch of id refer 24233 & 26922

IF EXISTS (SELECT id FROM APP_SCGProperty WHERE Name='CLIENT_ONLINE_IN_LAST_30_DAYS' and id=55)

BEGIN 

	DELETE FROM APP_SCGProperty WHERE Id=55

END 

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=56)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (56, 'CLIENT_ONLINE_IN_LAST_30_DAYS', 'Client Online in Last 30 Days', (3189 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientOnlineInLast30Days', 'Client Online in Last 30 Days', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ONLINE_IN_LAST_30_DAYS',			
            label = 'Client Online in Last 30 Days',		
			localeMsgId = (3189 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientOnlineInLast30Days',			
			description = 'Client Online in Last 30 Days',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 56				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=55)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (55, 'COMPANY_INSTALLED_CLIENT_ASSOCIATIONS', 'Company Installed Client Associations', (3183 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2CompanyClientInstallAssociations', 'Company Installed Client Associations', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'COMPANY_INSTALLED_CLIENT_ASSOCIATIONS',			
            label = 'Company Installed Client Associations',		
			localeMsgId = (3183 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2CompanyClientInstallAssociations',			
			description = 'Company Installed Client Associations',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 55				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=60)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (60, 'CLIENT_WITH_ASSOCIATED_SP', 'Clients With Subclients Having Associated Storage Policy', (3225 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientsWithAssociatedSP', 'Client Has Subclients Having Associated Storage Policies', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_WITH_ASSOCIATED_SP',			
            label = 'Clients With Subclients Having Associated Storage Policy',		
			localeMsgId = (3225 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithAssociatedSP',			
			description = 'Client Has Subclients Having Associated Storage Policies',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 60				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=61)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (61, 'CLIENT_IMPROPER_DECONF_SUBCLIENT', 'Clients With Improperly Deconfigured Subclients', (3223 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientsWithImproperlyDeconfSubclients', 'Client Has Improperly Deconfigured Subclients', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_IMPROPER_DECONF_SUBCLIENT',			
            label = 'Clients With Improperly Deconfigured Subclients',		
			localeMsgId = (3223 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithImproperlyDeconfSubclients',			
			description = 'Client Has Improperly Deconfigured Subclients',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 61				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=63)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (63, 'CLIENT_WITH_BACKUP_SCHEDULE', 'Clients With Backup Schedule', (3226 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientsWithBackupSchedule', 'Clients With Backup Schedule', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_WITH_BACKUP_SCHEDULE',			
            label = 'Clients With Backup Schedule',		
			localeMsgId = (3226 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithBackupSchedule',			
			description = 'Clients With Backup Schedule',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 63				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=64)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (64, 'CLIENT_LONG_RUNNING_JOBS_N_DAYS', 'Clients With Long Running Jobs', (3224 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2ClientsWithLongRunningJobs', 'Clients With Long Running Jobs', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_LONG_RUNNING_JOBS_N_DAYS',			
            label = 'Clients With Long Running Jobs',		
			localeMsgId = (3224 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2ClientsWithLongRunningJobs',			
			description = 'Clients With Long Running Jobs',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 64				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=62)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (62, 'CLIENT_CONSECUTIVE_BACKUP_FAILURES', 'Strikes count', (3201 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2ClientsWithStrikes', 'Client has at least 1 subclient with consecutive backup job failures', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_CONSECUTIVE_BACKUP_FAILURES',			
            label = 'Strikes count',		
			localeMsgId = (3201 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2ClientsWithStrikes',			
			description = 'Client has at least 1 subclient with consecutive backup job failures',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 62				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=67)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (67, 'CLIENT_WITH_SYNTHETICFULL_BACKUP', 'Clients With Synthetic Full Backup N Days', (3232 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 3, 'dbo.scgV2GetdaysSinceLastFullSynthetic', 'Clients With Synthetic Full Backup N Days', 1, 0, 0, 3)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_WITH_SYNTHETICFULL_BACKUP',			
            label = 'Clients With Synthetic Full Backup N Days',		
			localeMsgId = (3232 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 3,			
			funcName = 'dbo.scgV2GetdaysSinceLastFullSynthetic',			
			description = 'Clients With Synthetic Full Backup N Days',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 3				
	WHERE id = 67				
END

-- Enumerated Selection List

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=70)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (70, 'MAS_FOR_CLIENTS_IN_GROUPLIST', 'MediaAgents for clients in group list', (3256 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2MediaAgentsInGroupList', 'MediaAgents for clients included in group list', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'MAS_FOR_CLIENTS_IN_GROUPLIST',			
            label = 'MediaAgents for clients in group list',		
			localeMsgId = (3256 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2MediaAgentsInGroupList',			
			description = 'MediaAgents for clients included in group list',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 70				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=71)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (71, 'CLIENT_GROUPLIST', 'Associated Client Group List', (3255 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2CheckClientInGroupList', 'checks if a client belongs to any group in list', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_GROUPLIST',			
            label = 'Associated Client Group List',		
			localeMsgId = (3255 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2CheckClientInGroupList',			
			description = 'checks if a client belongs to any group in list',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 71				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=72)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (72, 'TIMEZONELIST', 'Timezone List', (3259 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientTimezoneIdList', 'time zone list for clients', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'TIMEZONELIST',			
            label = 'Timezone List',		
			localeMsgId = (3259 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientTimezoneIdList',			
			description = 'time zone list for clients',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 72				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=73)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (73, 'MEDIAAGENT_HAS_LUCENE_INDEX_ROLELIST', 'MediaAgent has Lucene Index Role List', (3257 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2MediaAgentHasLuceneIndexRoleList', 'Checks to see if MediaAgent has Lucene Index Role List', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'MEDIAAGENT_HAS_LUCENE_INDEX_ROLELIST',			
            label = 'MediaAgent has Lucene Index Role List',		
			localeMsgId = (3257 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2MediaAgentHasLuceneIndexRoleList',			
			description = 'Checks to see if MediaAgent has Lucene Index Role List',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 73				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=74)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (74, 'STORAGE_POLICYLIST', 'Associated Storage Policy List', (3258 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2CheckClientInStoragePolicyList', 'checks if a client belongs to the Storage Policy List', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'STORAGE_POLICYLIST',			
            label = 'Associated Storage Policy List',		
			localeMsgId = (3258 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2CheckClientInStoragePolicyList',			
			description = 'checks if a client belongs to the Storage Policy List',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 74				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=75)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (75, 'TIMEZONE_REGIONLIST', 'Timezone Region List', (3296 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientTimezoneRegionList', 'time zone region list for clients', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'TIMEZONE_REGIONLIST',			
            label = 'Timezone Region List',		
			localeMsgId = (3296 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientTimezoneRegionList',			
			description = 'time zone region list for clients',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 75				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=80)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (80, 'CLIENT_ENCRYPTION_STATE', 'Clients With Encryption', (3446 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2CheckClientEncryptionState', 'Clients With Encryption', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ENCRYPTION_STATE',			
            label = 'Clients With Encryption',		
			localeMsgId = (3446 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2CheckClientEncryptionState',			
			description = 'Clients With Encryption',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 80				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=81)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (81, 'CLIENT_CIDR_RANGE', 'Client CIDR Address Range', (3444 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 10, 'dbo.scgV2GetClientListWithCIDRMask', 'Client CIDR Address Range', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_CIDR_RANGE',			
            label = 'Client CIDR Address Range',		
			localeMsgId = (3444 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 10,			
			funcName = 'dbo.scgV2GetClientListWithCIDRMask',			
			description = 'Client CIDR Address Range',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 81				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=85)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (85, 'HAC_CLUSTER_CLIENT', 'HAC Cluster', (3518 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2HacClusterClients', 'Client is part of a HAC cluster', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'HAC_CLUSTER_CLIENT',			
            label = 'HAC Cluster',		
			localeMsgId = (3518 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2HacClusterClients',			
			description = 'Client is part of a HAC cluster',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 85				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=90)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (90, 'CLIENT_INDEX_MAINFOLIST', 'Clients by Index MA', (3663 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientsbyIndexingMA', 'Clients by Index MA', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_INDEX_MAINFOLIST',			
            label = 'Clients by Index MA',		
			localeMsgId = (3663 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientsbyIndexingMA',			
			description = 'Clients by Index MA',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 90				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=91)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (91, 'CLIENT_OS_INFOLIST', 'Clients by OS Version', (3687 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientOSInfoList', 'OS Info List', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_OS_INFOLIST',			
            label = 'Clients by OS Version',		
			localeMsgId = (3687 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientOSInfoList',			
			description = 'OS Info List',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 91				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=105)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (105, 'USERGROUPLIST', 'Clients owned by users in usergroup list', (3863 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientOwnedbyUserGroupMembers', 'Clients owned by users in usergroup list', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'USERGROUPLIST',			
            label = 'Clients owned by users in usergroup list',		
			localeMsgId = (3863 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientOwnedbyUserGroupMembers',			
			description = 'Clients owned by users in usergroup list',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 105				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=110)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (110, 'CLIENT_CIDR_RANGE_IPV6', 'Client IPV6 CIDR Address Range', (3868 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 10, 'dbo.scgV2GetClientListWithCIDRMaskIPV6', 'Client IPV6 CIDR Address Range', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_CIDR_RANGE_IPV6',			
            label = 'Client IPV6 CIDR Address Range',		
			localeMsgId = (3868 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 10,			
			funcName = 'dbo.scgV2GetClientListWithCIDRMaskIPV6',			
			description = 'Client IPV6 CIDR Address Range',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 110				
END

-- SP17

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=115)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (115, 'PSEUDO_CLIENTS', 'Pseudo Clients', (3983 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2IsPseudoClients', 'Client is a psuedo client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'PSEUDO_CLIENTS',			
            label = 'Pseudo Clients',		
			localeMsgId = (3983 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2IsPseudoClients',			
			description = 'Client is a psuedo client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 115				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=116)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (116, 'CLIENT_DISPLAY_NAME', 'Client Display Name', (3982 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 2, 'dbo.scgV2GetClientDisplayName', 'Display name of the client', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_DISPLAY_NAME',			
            label = 'Client Display Name',		
			localeMsgId = (3982 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientDisplayName',			
			description = 'Display name of the client',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 116				
END

-- SP18

--

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=117)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (117, 'CLIENTS_RELEASE16PLUS_SP_LEVEL_CONSTRAINT', 'Client computers running version 11 and above and SP level constraint', (4397 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 9, 'dbo.scgV2ClientsWithRelease16PlusAndSPLevelConstraint', 'Client computers running version 11 and above and SP level constraint', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENTS_RELEASE16PLUS_SP_LEVEL_CONSTRAINT',			
            label = 'Client computers running version 11 and above and SP level constraint',		
			localeMsgId = (4397 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 9,			
			funcName = 'dbo.scgV2ClientsWithRelease16PlusAndSPLevelConstraint',			
			description = 'Client computers running version 11 and above and SP level constraint',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 117				
END

-- Nike request

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=118)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (118, 'CLIENT_ASSOCIATED_ADUSERGROUP', 'Clients associated to AD User Groups', (4408 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientsAssociatedToADUserGroupList', 'List clients associated to AD User Groups', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ASSOCIATED_ADUSERGROUP',			
            label = 'Clients associated to AD User Groups',		
			localeMsgId = (4408 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientsAssociatedToADUserGroupList',			
			description = 'List clients associated to AD User Groups',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 118				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=119)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (119, 'CLIENT_IDA_ASSOCIATED_ADUSERGROUP', 'Clients with Agents associated to AD User Groups', (4409 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2GetClientsWithIDAsAssociatedToADUserGroupList', 'List clients with Agents associated to AD User Groups', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_IDA_ASSOCIATED_ADUSERGROUP',			
            label = 'Clients with Agents associated to AD User Groups',		
			localeMsgId = (4409 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2GetClientsWithIDAsAssociatedToADUserGroupList',			
			description = 'List clients with Agents associated to AD User Groups',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 119				
END

-- SP19

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=125)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (125, 'CLIENT_ONLINE_IN_LAST_N_DAYS', 'Client Online in Last N Days', (4420 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 8, 'dbo.scgV2ClientOnlineInLastNDays', 'Client Online in Last N Days', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ONLINE_IN_LAST_N_DAYS',			
            label = 'Client Online in Last N Days',		
			localeMsgId = (4420 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 8,			
			funcName = 'dbo.scgV2ClientOnlineInLastNDays',			
			description = 'Client Online in Last N Days',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 125				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=124)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (124, 'CLIENT_ISDELETEDVM', 'Client is a Deleted VM', (4571 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2IsDeletedVMClients', 'List VM Clients Deleted', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ISDELETEDVM',			
            label = 'Client is a Deleted VM',		
			localeMsgId = (4571 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2IsDeletedVMClients',			
			description = 'List VM Clients Deleted',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 124				
END

-- SP20 - Metallic request

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=126)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (126, 'CLIENT_WITH_ASSOCIATED_REGION', 'Clients with associated regions', (4545 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2ClientsWithAssociatedRegions', 'Clients with associated regions', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_WITH_ASSOCIATED_REGION',			
            label = 'Clients with associated regions',		
			localeMsgId = (4545 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2ClientsWithAssociatedRegions',			
			description = 'Clients with associated regions',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 126				
END

-- SP20

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=131)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (131, 'CLIENT_INDEXINGV2', 'Clients with Indexing V2', (4551 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 7, 'dbo.scgV2ClientWithIndexingV2List', 'Clients with Indexing V2', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_INDEXINGV2',			
            label = 'Clients with Indexing V2',		
			localeMsgId = (4551 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 7,			
			funcName = 'dbo.scgV2ClientWithIndexingV2List',			
			description = 'Clients with Indexing V2',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 131				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=132)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (132, 'CLIENT_INDEXINGV1', 'Clients with Indexing V1', (4550 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2IsClientUsingIndexingV1', 'Clients with Indexing V1', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_INDEXINGV1',			
            label = 'Clients with Indexing V1',		
			localeMsgId = (4550 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2IsClientUsingIndexingV1',			
			description = 'Clients with Indexing V1',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 132				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=130)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (130, 'CLIENT_ASSOC_SCHDPOLICY', 'Clients associated to Schedule Policy', (4546 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 4, 'dbo.scgV2ClientsWithAssociatedSchdPolicy', 'List clients associated to Schedule Policy', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_ASSOC_SCHDPOLICY',			
            label = 'Clients associated to Schedule Policy',		
			localeMsgId = (4546 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 4,			
			funcName = 'dbo.scgV2ClientsWithAssociatedSchdPolicy',			
			description = 'List clients associated to Schedule Policy',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 130				
END

-- SP22

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=135)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (135, 'CLIENT_BACKUP_ACTIVITY_ENABLED', 'Client Backup Activity Enabled', (4657 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientBackupActivityEnabled', 'Client backup activity enabled', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_BACKUP_ACTIVITY_ENABLED',			
            label = 'Client Backup Activity Enabled',		
			localeMsgId = (4657 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientBackupActivityEnabled',			
			description = 'Client backup activity enabled',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 135				
END

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=136)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (136, 'CLIENT_WITH_ENABLED_BACKUP_SCHEDULE', 'Clients with Enabled Backup Schedule', (4658 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 1, 'dbo.scgV2ClientsWithEnabledBackupSchedule', 'Clients with Enabled Backup Schedule', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_WITH_ENABLED_BACKUP_SCHEDULE',			
            label = 'Clients with Enabled Backup Schedule',		
			localeMsgId = (4658 | (CAST(POWER(2, 24) AS BIGINT) * 35)),	
			ptype = 1,			
			funcName = 'dbo.scgV2ClientsWithEnabledBackupSchedule',			
			description = 'Clients with Enabled Backup Schedule',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 136				
END

--Metallic

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=134)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (134, 'CLIENTGROUP_NAME', 'Client Group Name', 0, 2, 'dbo.scgV2GetClientGroupName', 'Client Group Name', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENTGROUP_NAME',			
            label = 'Client Group Name',		
			localeMsgId = 0,	
			ptype = 2,			
			funcName = 'dbo.scgV2GetClientGroupName',			
			description = 'Client Group Name',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 134				
END

-- SP25

IF NOT EXISTS (Select * from App_SCGProperty WHERE id=140)	
BEGIN	
	INSERT INTO App_SCGProperty VALUES (140, 'CLIENT_LICENSELIST', 'Clients with License Consumed', 0, 7, 'dbo.scgV2ClientsWithLicenses', 'Is client using the selected licenses', 1, 0, 0, 1)	
END	
ELSE	
BEGIN	
	UPDATE App_SCGProperty			
        SET name = 'CLIENT_LICENSELIST',			
            label = 'Clients with License Consumed',		
			localeMsgId = 0,	
			ptype = 7,			
			funcName = 'dbo.scgV2ClientsWithLicenses',			
			description = 'Is client using the selected licenses',		
			complex = 1,		
			created = 0,				
			modified = 0,				
			flags = 1					
	WHERE id = 140				
END

END_OF_SCRIPT:

