

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_SCGClientGroupDependency.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                     

--           Copyright (c) 1998  CommVault Systems, Inc.               

--                  All rights reserved.                               

--                                                                     

--																		

--        This is unpublished proprietary source code of CommVault		

--        Systems, Inc. The copyright notice above does not evidence	

--        any actual or intended publication of such source code.		

-- ----------------------------------------------------------------------*/

SET NOCOUNT ON

SET QUOTED_IDENTIFIER ON

DECLARE @depSCGGUID	VARCHAR(40) = 'DC233097-9366-4908-8787-1BF5D3A28923'

DECLARE @nowTime	INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @newLine	NVARCHAR(3) = NCHAR(13) -- + CHAR(10)

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @depSCGGUID)

BEGIN

	-- This script adds missing Dependent SCG Grouping relationships for SCGProperty CLIENT_GROUPLIST.

	IF OBJECT_ID('tempdb.dbo.#DepSCGRuleCheck') IS NOT NULL

		DROP TABLE #DepSCGRuleCheck

	CREATE TABLE #DepSCGRuleCheck (

		scgId		INT,

		cgId		INT,

		depCGId		INT,

		PRIMARY KEY (cgId, depCGID, scgId)

	)
	INSERT INTO #DepSCGRuleCheck (scgId, cgId, depCGID)


		SELECT DISTINCT

			r.scgId,

			r.cgId,

			dg.value('@val', 'INT') depCGId

		FROM (

				SELECT

					gr.id scgId,

					gr.scgId cgId,

					CAST(r.value('@value', 'VARCHAR(MAX)') AS XML) depGroups

				FROM 

					APP_SCGRule gr WITH(NOLOCK)

					CROSS APPLY gr.ruleXml.nodes('//rules/rule') d(r)	-- find node at any level of tree

				WHERE

					r.value('@propID', 'int') IS NOT NULL

AND r.value('@propID', 'int') = 71	-- SCG_PKID_CLIENT_GROUPLIST Only want client group listing rule property since they were missed configured for group dependency when created

			) r

			CROSS APPLY r.depGroups.nodes('//id') d(dg)

	DECLARE @rcnt	INT = @@ROWCOUNT

	IF (@rcnt = 0)

	BEGIN

		-- nothing to do

		GOTO END_OF_GRPDEPBLK

	END

	--SELECT * FROM #DepSCGRuleCheck

	BEGIN TRY

		BEGIN TRAN

		--select * from App_SCGClientGroupDependency

		-- Now check to see if there are any dependency rows missing and insert them
		INSERT INTO App_SCGClientGroupDependency (associatedGrpId, ownerGrpId)


			SELECT

				g.depCGId,

				g.cgId

			FROM #DepSCGRuleCheck g

				LEFT OUTER JOIN App_SCGClientGroupDependency gd ON

					g.cgId = gd.ownerGrpId

					AND g.depCGId = gd.associatedGrpId

			WHERE

				gd.ownerGrpId IS NULL		-- not found insert it!

		--select * from App_SCGClientGroupDependency

		COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		DECLARE @msg NVARCHAR(2047) = @newLine + @newLine

		SET @msg += 'INSIDE CATCH BLOCK WITH FOLLOWING ERROR: ' + @newLine

		SET @msg += '   ERROR CODE: ' + CAST(ERROR_NUMBER() AS NVARCHAR(12)) + @newLine

		SET @msg += '   SQL SCRIPT: APP_SCGClientGroupDependency' + @newLine

		SET @msg += '   ERROR LINE NO: ' + CAST(ERROR_LINE() AS NVARCHAR(12)) + @newLine

		SET @msg += '   ERROR MESSAGE: ' + ERROR_MESSAGE() + @newLine

		SET @msg += '   ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS NVARCHAR(12)) + @newLine

		SET @msg += '   ERROR STATE: ' + CAST(ERROR_STATE() AS NVARCHAR(12)) + @newLine + @newLine

		PRINT @msg

		RAISERROR(@msg, 16, 1);		-- rethrow the exception

		GOTO END_OF_SCRIPT

	END CATCH

	END_OF_GRPDEPBLK:
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@depSCGGUID, 'SCGDependentGrpCheck', 'Update script to Retrofit CLIENT_GROUPLIST SCG Rules Dependencies', @nowTime, 16, 0, (16 + 2))

END

-- Now check for any circular loops in the grouping chains as a precaution.  If any found throw exception!

DECLARE @loopxml XML = NULL

;WITH SCGFindLoop AS

(

	SELECT 

		p.ownerGrpId parentId,

		p.associatedGrpId childId, 

		(

			SELECT

				p.ownerGrpId '@parentId',

				p.associatedGrpId 'Node/@id'

			FOR XML PATH('Path'), TYPE

		) path,

		1 distance,

		0 loop

	FROM App_SCGClientGroupDependency p WITH(NOLOCK)

	UNION ALL

	SELECT 

		p.ownerGrpId parentId, 

		c.childId,

		CASE CAST(c.path.exist('//Node[@id = sql:column("p.associatedGrpId")]') AS INT)

			WHEN 1 THEN

				(

					SELECT

						c.path.value('(/Path/@parentId)[1]', 'INT') '@parentId',

						c.path.query('/Path/Node'),

						p.associatedGrpId 'NodeLoop/@id'

					FOR XML PATH('Path'), TYPE

				)

			ELSE

				(

					SELECT

						c.path.value('(/Path/@parentId)[1]', 'INT') '@parentId',

						c.path.query('/Path/Node'),

						p.associatedGrpId 'Node/@id'

					FOR XML PATH('Path'), TYPE

				)

		END path,

		c.distance + 1,

		CAST(c.path.exist('//Node[@id = sql:column("p.associatedGrpId")]') AS INT) loop

	FROM App_SCGClientGroupDependency p 

		INNER JOIN SCGFindLoop c ON 

			c.parentId = p.associatedGrpId 

			AND p.ownerGrpId <> p.associatedGrpId 

	WHERE

		c.loop = 0

 )

	SELECT @loopxml = (

		SELECT

			l.parentId '@parentId',

			l.childId '@childId',

			l.loop '@loop',

			l.distance '@distance',

			l.path.query('.')

		FROM SCGFindLoop l

		WHERE

			l.loop <> 0

		FOR XML PATH('SCGLoopDetected'), ROOT('GroupPath'), TYPE

	)

IF (@loopxml IS NOT NULL)

BEGIN

	-- EXCEPTION THROWN

	-- Circular Dependence found in Group Chaining, need to upload customer database and investigate and fix

	DECLARE @cirMsg NVARCHAR(MAX) = N'Cirular Dependency detected in the App_SCGClientGroupDependency Table, please contact Tech Support to help resolve before upgrading.'  + @newLine

	SET @cirMsg += N'XML Listing: ' +  @newLine + CAST(@loopxml AS NVARCHAR(MAX)) + @newLine

	PRINT @cirMsg

END

ELSE

BEGIN

	PRINT 'No Cirular Dependency detected in the App_SCGClientGroupDependency Table'

END

END_OF_SCRIPT:

