

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_ReplicationGroupProp.script] ---------- 


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME App_ReplicationGroupProp

print '... inserting Table: App_ReplicationGroupProp'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME App_ReplicationGroupProp

DECLARE @nowTime    int =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @populateTableGuid    VARCHAR(40) = 'BAF21B8A-B6F6-4E4A-825A-3A8669F51A18'

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @populateTableGuid)

BEGIN

    --For all periodic replication groups (type = 1) insert associated plan prop
	INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)


SELECT REPASSOC.componentNameId, 'Associated Plan', 7, SUB.attrVal, '',@nowTime, 0

		FROM App_ReplicationGroupAssociation REPASSOC WITH(NOLOCK) JOIN TM_AssocEntity TMASSOC WITH(NOLOCK) ON TMASSOC.taskId = REPASSOC.taskId

		JOIN APP_SubClientProp SUB WITH(NOLOCK) ON SUB.componentNameId = TMASSOC.subclientId

WHERE SUB.attrName = 'Associated Plan' AND SUB.cs_attrName = CheckSum(N'Associated Plan')

	--For all continuous replication groups (type = 2) insert both associated plan as well as blr pair xml template.

	--Using a cursor here since a single replication group can have several pairs and xml encoding tags need to be removed for each continuous group before inserting into app_replicationgrouprop

	DECLARE @repGroupId INT = 0

	DECLARE @taskInfo nvarchar(max)

	DECLARE @taskInfoXML XML

	DECLARE @planId INT = 0

	DECLARE ContinuousRepGroupPropCursor CURSOR FOR 

    SELECT id FROM App_ReplicationGroup WITH(NOLOCK) WHERE type = 2

	OPEN ContinuousRepGroupPropCursor

		FETCH NEXT FROM ContinuousRepGroupPropCursor INTO @repGroupId

	WHILE @@FETCH_STATUS = 0

	BEGIN

		SET @taskInfo = ''

		SET @taskInfoXML  = ''

		SELECT TOP 1 @taskInfo = SUB.attrVal FROM App_SubclientProp SUB WITH(NOLOCK) JOIN BlrPair BLR WITH(NOLOCK) ON SUB.componentNameId = BLR.subClientId

			JOIN App_ReplicationGroupAssociation REPASSOC ON REPASSOC.blrpairId = BLR.id  

WHERE REPASSOC.componentNameId = @repGroupId AND SUB.attrName = 'Virtual Server Block Level Replication Restore XML' AND SUB.cs_attrName = CheckSum(N'Virtual Server Block Level Replication Restore XML') AND SUB.modified = 0

		SELECT TOP 1 @planId = CONVERT(INT,SUB.attrVal) FROM App_SubclientProp SUB WITH(NOLOCK) JOIN BlrPair BLR WITH(NOLOCK) ON SUB.componentNameId = BLR.subClientId

		    JOIN App_ReplicationGroupAssociation REPASSOC ON REPASSOC.blrpairId = BLR.id

WHERE REPASSOC.componentNameId = @repGroupId AND SUB.attrName = 'Associated Plan' AND SUB.cs_attrName = CheckSum(N'Associated Plan') AND SUB.modified = 0

		DECLARE @startTag INT = CHARINDEX( '<',@taskInfo,1)

		DECLARE @startEncodeTag INT = CHARINDEX( '?xml',@taskInfo,1)

		IF (@startEncodeTag = (@startTag)+1)

		BEGIN

			SET @taskInfoXML  =(SELECT CONVERT(XML,SUBSTRING(@taskInfo,CHARINDEX('?>',@taskInfo,1)+2,LEN(@taskInfo)),2))

		END

		ELSE

		BEGIN

			SET @taskInfoXML  = (SELECT CONVERT(XML,@taskInfo))

		END

		--Update replication group properties table.
		INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)


VALUES(@repGroupId, 'Virtual Server Block Level Replication Restore XML', 1 , '', @taskInfoXML, @nowTime, 0),

(@repGroupId, 'Associated Plan', 7, @planId, '',@nowTime, 0 )

	FETCH NEXT FROM ContinuousRepGroupPropCursor INTO @repGroupId

	END --END ContinuousRepGroupPropCursor fetch loop

	CLOSE ContinuousRepGroupPropCursor

    DEALLOCATE ContinuousRepGroupPropCursor
    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@populateTableGuid, 'PopulateTable', 'Populate records in App_ReplicationGroupProp', @nowTime,  16, 0, (16 + 2))

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '6DAED6CE-9A63-4DF3-B591-4E73CE989C01')

BEGIN

	-- Replication type = 2 (continuous replication groups)
	INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)


SELECT REP.id, 'BLR recovery options', 1, '', REPPROP.attrXML.query('/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/defaultRestoreSettings/blrRecoveryOpts'),

		@nowTime,0

		FROM App_ReplicationGroup REP WITH(NOLOCK) JOIN App_ReplicationGroupProp REPPROP WITH(NOLOCK) ON REPPROP.componentNameId = REP.id

WHERE REP.type = 2 AND REPPROP.attrName = 'Virtual Server Block Level Replication Restore XML'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('6DAED6CE-9A63-4DF3-B591-4E73CE989C01', 'PopulateTable', 'Populate BLR recovery options in App_ReplicationGroupProp', @nowTime,  16, 0, (16 + 2))

END
