

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_PlanSchedulePoliciesUpgrade.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_PlanSchedulePoliciesUpgrade.script,v $ $Id: App_PlanSchedulePoliciesUpgrade.script,v 1.1.2.1.4.1 2021/02/17 06:23:07 rengu Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))

    DECLARE @planSchedulePolicyAssociationsUpgrade uniqueidentifier = 'A9154551-8BF1-4951-BD1F-25425469F49F'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @planSchedulePolicyAssociationsUpgrade)

    BEGIN

        IF OBJECT_ID('tempdb.dbo.#PlanScheduleIds') IS NOT NULL 

        DROP TABLE #PlanScheduleIds

		CREATE TABLE #PlanScheduleIds (

			planId                  INT,

			taskId					INT

		)

		IF OBJECT_ID('tempdb.dbo.#TasksToClone') IS NOT NULL 

        DROP TABLE #TasksToClone

		CREATE TABLE #TasksToClone (

			taskId					INT,

			taskName				NVARCHAR(256)

		)

		IF OBJECT_ID('tempdb.dbo.#SubclientPlanAssoc') IS NOT NULL 

        DROP TABLE #SubclientPlanAssoc

		CREATE TABLE #SubclientPlanAssoc (

			appId INT,

			planId INT

		)

		IF OBJECT_ID('tempdb.dbo.#SubclientTaskAssoc') IS NOT NULL 

        DROP TABLE #SubclientTaskAssoc

		CREATE TABLE #SubclientTaskAssoc (

			appId INT,

			taskId INT

		)

		-- Get all server plans and schedules
		INSERT INTO #PlanScheduleIds(planId,taskId)


SELECT P.id, dbo.AppPlanGetEntityValueV2(P.id,'Schedule policy',default) FROM App_Plan P WHERE P.subType = 33554437

		UNION

SELECT P.id, dbo.AppPlanGetEntityValueV2(P.id,'Log schedule policy',default) FROM App_Plan P WHERE P.subType = 33554437

		-- Get plan associated subclients.
		INSERT INTO #SubclientPlanAssoc(appId,planId)


		SELECT APP.id, CAST(SCP.attrVal AS INT) FROM APP_Application APP WITH(NOLOCK)

INNER JOIN APP_SubclientProp SCP WITH(NOLOCK) ON SCP.componentnameId = APP.id AND SCP.attrName = 'Associated Plan'

		WHERE APP.subclientStatus & (2|4) = 0 AND SCP.modified = 0

		-- Remove existing schedule associations that are part of plan assoc

		DELETE AE

		FROM TM_AssocEntity AE WITH(NOLOCK)

		INNER JOIN #SubclientPlanAssoc SC ON SC.appId = AE.subclientId

		INNER JOIN #PlanScheduleIds P ON P.planId = SC.planId AND P.taskId = AE.taskId

		INNER JOIN TM_Task T WITH(NOLOCK) ON P.taskId = T.taskId

		-- Let us get all tasks that have some extra non-plan association
		INSERT INTO #TasksToClone


		SELECT DISTINCT P.taskId, T.taskName

		FROM #PlanScheduleIds P

		INNER JOIN TM_Task T WITH(NOLOCK) ON P.taskId = T.taskId

		INNER JOIN TM_AssocEntity AE WITH(NOLOCK) ON AE.taskId = T.taskId

		-- Check if custom non-plan association is still found, let us clone them.

		IF EXISTS(	SELECT 1 

					FROM #TasksToClone

				 )

		BEGIN

			DECLARE @loopTaskId INT = 0

			DECLARE @looptaskName NVARCHAR(256) = ''

			DECLARE @adminUserId INT = 0

			DECLARE @errorCode INT = 0

			DECLARE @errorString NVARCHAR(MAX) = ''

			SELECT	TOP 1 @adminUserId = id

			FROM  UMUsers WITH(NOLOCK)

			WHERE ((flags & 0x40) <> 0) -- USERS_ADMIN

			DECLARE GetTasksToClone CURSOR

			FOR SELECT taskId, taskName FROM #TasksToClone

			OPEN GetTasksToClone

			FETCH GetTasksToClone INTO @loopTaskId, @looptaskName

			WHILE @@FETCH_STATUS = 0

			BEGIN

				EXEC TM_cloneTask @adminUserId, 0, 1, @loopTaskId, 'Automatically cloned by system', @errorCode OUTPUT, @errorString OUTPUT

				IF @errorCode > 0

				BEGIN

					-- Just log and continue upgrade

					PRINT('Failed to Clone task [' + @looptaskName + '] with error [' + CAST(@errorCode AS NVARCHAR(32)) + ' - ' + @errorString + '].')

					SET @errorCode = 0

					SET @errorString = ''

				END

				FETCH NEXT FROM GetTasksToClone INTO @loopTaskId, @looptaskName

			END

			CLOSE GetTasksToClone

			DEALLOCATE GetTasksToClone

			-- Drop all custom associations also on the original plan tasks

			DELETE AE

			FROM TM_AssocEntity AE WITH(NOLOCK)

			INNER JOIN #TasksToClone P ON P.taskId = AE.taskId

		END

		-- Finally add plan associations to the tasks
		INSERT INTO TM_AssocEntity  (assocType,         taskId,         flags,      created,        exclude,


                             clientGroupId,     clientId,       apptypeId,  instanceId,     backupsetId,

                             subclientId,       policyId,       copyId,     srmReportSet,   srmReportType,

                             trackingPolicyId,  MediaAgentId,   agentlessPolicyId, workflowId, sidbStoreId,

                             libraryId, logMonitoringPolicyId,entityId

                             )

SELECT	158, P.taskId, 0, @currentTime, 0,

				0, 0, 0, 0, 0,

				0, 0, 0, 0, 0,

				0, 0, 0, 0, 0,

				0, 0, P.planId

		FROM #PlanScheduleIds P

		JOIN TM_Task T WITH(NOLOCK) ON P.taskId = T.taskId

LEFT JOIN TM_AssocEntity AE WITH(NOLOCK) ON AE.assocType = 158 AND AE.entityId = P.planId AND AE.taskId = P.taskId

		WHERE AE.assocId IS NULL

        -- Get All user groups for which we don't have direct association present but there reference does exist in App_PlanProp Table.
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@planSchedulePolicyAssociationsUpgrade, 'Scalable Plan schedules', 'Script to scale subclient associations to plan to planId.', @currentTime,  16, 0, (16 + 2))

    END

GO

SET QUOTED_IDENTIFIER OFF

GO

