

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_PlanProp.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_PlanProp.script,v $ $Id: App_PlanProp.script,v 1.1.2.32 2020/11/19 05:48:18 sthakkar Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @pid INT = 0

	DECLARE @pType INT = 0

	DECLARE @atType INT = 0

	DECLARE @taskid INT = 0

	DECLARE @subTaskId INT = 0

    DECLARE @guidForPlanAttrTypeUpdate uniqueidentifier = '5B0ACAF7-D683-45CB-9BBF-848E05A4FEC0'

    DECLARE @planAttrTypeAlreadyUpdated BIT = CASE WHEN EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guidForPlanAttrTypeUpdate) THEN 1 ELSE 0 END

DECLARE @constAttType_RpoInMinutes	        INT             = IIF(@planAttrTypeAlreadyUpdated=1, 7, 283)

DECLARE @constAttName_RpoInMinutes	        NVARCHAR(32)    = IIF(@planAttrTypeAlreadyUpdated=1, 'RPO In Minutes', 'SLA In Minutes')

DECLARE @constAttType_LogRpoInMinutes	    INT             = IIF(@planAttrTypeAlreadyUpdated=1, 7, 285)

DECLARE @constAttName_LogRpoInMinutes	    NVARCHAR(32)    = IIF(@planAttrTypeAlreadyUpdated=1, 'Log RPO In Minutes', 'Log SLA In Minutes')

DECLARE @constAttrType_Policy_Schedule	    INT             = IIF(@planAttrTypeAlreadyUpdated=1, 7, 265)

DECLARE @constAttrName_Policy_Schedule	    NVARCHAR(32)    = 'Schedule policy'

DECLARE @constAttrType_Policy_ScheduleLog   INT             = IIF(@planAttrTypeAlreadyUpdated=1, 7, 281)

DECLARE @constAttrName_Policy_ScheduleLog   NVARCHAR(32)    = 'Log schedule policy'

	DECLARE @rpoMinutes INT = 0

	DECLARE @planId INT = 0

	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))

	DECLARE @unixTime INTEGER = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))

	DECLARE @autoIncrPattXML XML = NULL

	DECLARE @slaTimeFromPattern INT = 0

	DECLARE @guidForPlanUpdation uniqueidentifier = '1B38B702-A95E-4720-A5A9-49D2B5C65734'	 

	DECLARE @PlanPropUpdateExec INT = 0

	SELECT @PlanPropUpdateExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @guidForPlanUpdation

	IF (@PlanPropUpdateExec = 0)        -- not done, update the plan details below

	BEGIN

		DECLARE @tblIds AS TABLE (

			SubDayInterval INT,

			TaskId INT, 

			SubTaskId INT,

			schedType INT,

			planId INT

		)

		DECLARE details_cursor CURSOR FOR   

		SELECT PP.attrVal, P.subType, PP.attrType, P.id

			FROM App_PlanProp PP

			INNER JOIN App_Plan P ON P.id = PP.componentNameId

		WHERE PP.attrType = @constAttrType_Policy_Schedule  AND P.ownerId IS NOT NULL

		UNION 

		SELECT PP.attrVal, P.subType, PP.attrType, P.id

			FROM App_PlanProp PP

			INNER JOIN App_Plan P ON P.id = PP.componentNameId

		WHERE PP.attrType = @constAttrType_Policy_ScheduleLog AND P.ownerId IS NOT NULL

		OPEN details_cursor  

		FETCH NEXT FROM details_cursor   

		INTO @taskid, @pType, @atType,@planId

		WHILE @@FETCH_STATUS = 0  

		BEGIN 

			IF @atType = @constAttrType_Policy_Schedule

			BEGIN

				IF @pType in (33554437 /*Server*/, 33579013 /*Database*/ , 50331655 /*FSServer*/ , 67108869 /*Snap*/, 83886085 /*VSAServer*/, 83918853 /*VSAReplication*/ )

				BEGIN
					INSERT INTO @tblIds(SubDayInterval,TaskId,SubTaskId,schedType,planId)


					SELECT MIN(CASE WHEN P.freq_subday_interval = 0 THEN 86400 ELSE p.freq_subday_interval END),ST.taskId, 0, @atType, @planId FROM TM_SubTask ST

						INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

							ON PA.subTaskId = ST.subTaskId

						INNER JOIN TM_SubTaskOptions O WITH(NOLOCK)

							ON ST.subTaskId = O.subTaskId

						INNER JOIN TM_Pattern P WITH(NOLOCK)

							ON P.patternId = PA.patternId

WHERE NOT EXISTS (	SELECT 1 FROM TM_SubTask WHERE taskId = @taskid AND flags & 0x10000 > 0 ) AND

							ST.taskId = @taskid	AND

O.optionId = 458405394 AND

							O.value = 2 AND --2 for Incremental

							P.freq_type = 4		

						GROUP BY ST.taskId

					UPDATE @tblIds SET SubTaskId = ( SELECT TOP 1 ST.subtaskId FROM TM_SubTask ST

														INNER JOIN TM_SubTaskOptions O WITH(NOLOCK)

															ON ST.subTaskId = O.subTaskId

														INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

															ON PA.subTaskId = ST.subTaskId

														INNER JOIN TM_Pattern P WITH(NOLOCK)

															ON P.patternId = PA.patternId

WHERE O.optionId = 458405394 AND

															ST.taskId = @taskid AND

															O.value = 2 AND --2 for Incremental

															P.freq_subday_interval = SubDayInterval AND

															P.freq_type = 4)

									WHERE TaskId = @taskid

				END

				IF @pType in (33554439/*Laptop*/, 16777223/*DLO*/)

				BEGIN
					INSERT INTO @tblIds(SubDayInterval,TaskId,SubTaskId,schedType,planId)


					SELECT 0, ST.taskId, 0,@atType, @planId FROM TM_SubTask ST

						INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

							ON PA.subTaskId = ST.subTaskId

						INNER JOIN TM_SubTaskOptions STO WITH(NOLOCK)

							ON ST.subTaskId = STO.subTaskId

						INNER JOIN TM_Pattern P WITH(NOLOCK)

							ON P.patternId = PA.patternId

WHERE NOT EXISTS (	SELECT 1 FROM TM_SubTask WHERE taskId = @taskid AND flags & 0x10000 > 0 ) AND

							ST.taskId = @taskid

							AND STO.value = 1

AND STO.optionId = 312510015

							AND P.freq_type = 1024/*Automatic*/

						GROUP BY ST.taskId

					UPDATE @tblIds SET SubTaskId = ( SELECT TOP 1 ST.subTaskId FROM TM_SubTask ST

														INNER JOIN TM_SubTaskOptions STO WITH(NOLOCK)

															ON ST.subTaskId = STO.subTaskId

														INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

															ON PA.subTaskId = ST.subTaskId

														INNER JOIN TM_Pattern P WITH(NOLOCK)

															ON P.patternId = PA.patternId

														WHERE ST.taskId = @taskid

															AND STO.value = 1

AND STO.optionId = 312510015

															AND P.freq_type = 1024 /*Automatic*/)

									WHERE TaskId = @taskid

					UPDATE @tblIds SET SubDayInterval = (SELECT CAST((SELECT ref.value('@maxBackupInterval','nvarchar(32)') 

									FROM STXO.xmlValue.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT ) * 60

								+  CAST((SELECT ref.value('@maxBackupIntervalMinutes','nvarchar(32)') 

									FROM STXO.xmlValue.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT ) FROM TM_SubTaskXMLOptions STXO

									INNER JOIN @tblIds Ids ON STXO.subTaskId = Ids.SubTaskId

									WHERE Ids.TaskId = @taskid)

								WHERE TaskId = @taskid

				END

			END

			IF @atType = @constAttrType_Policy_ScheduleLog

			BEGIN

				IF @pType = 33579013 /*Database*/

				BEGIN
					INSERT INTO @tblIds(SubDayInterval,TaskId,SubTaskId,schedType,planId)


					SELECT 0, ST.taskId, 0,@atType, @planId FROM TM_SubTask ST

						INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

							ON PA.subTaskId = ST.subTaskId

						INNER JOIN TM_SubTaskOptions STO WITH(NOLOCK)

							ON ST.subTaskId = STO.subTaskId

						INNER JOIN TM_Pattern P WITH(NOLOCK)

							ON P.patternId = PA.patternId

WHERE NOT EXISTS (	SELECT 1 FROM TM_SubTask WHERE taskId = @taskid AND flags & 0x10000 > 0 ) AND

							ST.taskId = @taskid

							AND STO.value = 1

AND STO.optionId = 312510015

							AND P.freq_type = 1024/*Automatic*/

						GROUP BY ST.taskId

					UPDATE @tblIds SET SubTaskId = ( SELECT TOP 1 ST.subTaskId FROM TM_SubTask ST

														INNER JOIN TM_SubTaskOptions STO WITH(NOLOCK)

															ON ST.subTaskId = STO.subTaskId

														INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

															ON PA.subTaskId = ST.subTaskId

														INNER JOIN TM_Pattern P WITH(NOLOCK)

															ON P.patternId = PA.patternId

														WHERE ST.taskId = @taskid

															AND STO.value = 1

AND STO.optionId = 312510015

															AND P.freq_type = 1024 /*Automatic*/)

									WHERE TaskId = @taskid

					UPDATE @tblIds SET SubDayInterval = (SELECT CAST((SELECT ref.value('@maxBackupInterval','nvarchar(32)') 

									FROM STXO.xmlValue.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT ) * 60

								+  CAST((SELECT ref.value('@maxBackupIntervalMinutes','nvarchar(32)') 

									FROM STXO.xmlValue.nodes('TMMsg_JobOption/commonOpts/automaticSchedulePattern') R (ref)) AS INT ) FROM TM_SubTaskXMLOptions STXO

									INNER JOIN @tblIds Ids ON STXO.subTaskId = Ids.SubTaskId

									WHERE Ids.TaskId = @taskid)

								WHERE TaskId = @taskid

				END

			END

			FETCH NEXT FROM details_cursor   

			INTO @taskid, @pType, @atType,@planId

		END   

		CLOSE details_cursor;  

		DEALLOCATE details_cursor;

		BEGIN TRY

		BEGIN TRAN

			DECLARE updation_cursor CURSOR FOR

				SELECT * FROM @tblIds

			OPEN updation_cursor    

			FETCH NEXT FROM updation_cursor   

			INTO @rpoMinutes,@taskid,@subTaskId,@atType,@planId

			WHILE @@FETCH_STATUS = 0  

			BEGIN 

UPDATE TM_SubTask SET flags = flags|0x10000 WHERE subTaskId = @subTaskId

				IF @atType = @constAttrType_Policy_Schedule

				BEGIN

					IF NOT EXISTS ( SELECT 1 FROM App_PlanProp WHERE attrName = @constAttName_RpoInMinutes AND componentNameId = @planId )
						INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)


							VALUES (@planId, @constAttName_RpoInMinutes, @constAttType_RpoInMinutes	, @rpoMinutes/60 , @currentTime, 0)

				END

				ELSE

				BEGIN

					IF NOT EXISTS ( SELECT 1 FROM App_PlanProp WHERE attrName = @constAttName_LogRpoInMinutes AND componentNameId = @planId )
						INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)


							VALUES (@planId, @constAttName_LogRpoInMinutes, @constAttType_LogRpoInMinutes, @rpoMinutes , @currentTime, 0)

				END

				FETCH NEXT FROM updation_cursor   

				INTO @rpoMinutes,@taskId,@subTaskId,@atType,@planId

			END

			CLOSE updation_cursor;  

			DEALLOCATE updation_cursor;	

		COMMIT TRAN

		END TRY

		BEGIN CATCH

			DECLARE @o_errorCode INT

			DECLARE @tmpErrorString NVARCHAR

			-- Call procedure to print error information.

			-- Call procedure to get error information.

			EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT

			PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

			--Close cursor

			IF ( CURSOR_STATUS('global', 'updation_cursor') >= 0  /* cursor is open */ 

				OR CURSOR_STATUS('local', 'updation_cursor') >= 0 ) 

			CLOSE updation_cursor 

			IF ( CURSOR_STATUS('global','updation_cursor') = -1  /* cursor is closed */ 

				OR CURSOR_STATUS('local','updation_cursor') = -1 ) 

			DEALLOCATE updation_cursor 

			-- Rollback any active or uncommittable transactions before

			-- inserting information in the ErrorLog

			IF XACT_STATE() <> 0

			BEGIN

			PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction'

				ROLLBACK TRANSACTION;

			END

		END CATCH;
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guidForPlanUpdation, 'PlanSLAPropertyValues', 'Creating plan property rows: SLA for existing plans', @unixTime, 16, 0 , (16 + 1))

    END

    IF @planAttrTypeAlreadyUpdated = 0 BEGIN

UPDATE App_PlanProp SET attrtype = CASE attrType WHEN 260 THEN 7

WHEN 261 THEN 7

WHEN 262 THEN 1

WHEN 263 THEN 7

WHEN 264 THEN 7

WHEN 265 THEN 7

WHEN 266 THEN 7

WHEN 267 THEN 1

WHEN 268 THEN 7

WHEN 269 THEN 7

WHEN 270 THEN 7

WHEN 271 THEN 7

WHEN 272 THEN 7

WHEN 273 THEN 7

WHEN 274 THEN 2

WHEN 275 THEN 7

WHEN 276 THEN 7

WHEN 277 THEN 7

WHEN 278 THEN 7

WHEN 279 THEN 7

WHEN 280 THEN 7

WHEN 281 THEN 7

WHEN 282 THEN 7

WHEN 283 THEN 7

WHEN 285 THEN 7

WHEN 284 THEN 1

                                                         ELSE 1 END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guidForPlanAttrTypeUpdate, 'PlanAttributeTypes', 'Changing plan attribute types', @unixTime, 16, 0 , (16 + 1))

    END

    -- for old plans make sure that plan property table contains correct entry for possible and required values for each plan

    -- possible

    MERGE   APP_PlanProp AS TGT

    USING   (SELECT id, subtype, created FROM APP_Plan) AS SRC(planId, subtype, created)

ON      TGT.componentNameId = SRC.planId AND TGT.attrName = 'Defintion entities : possible'

WHEN    NOT MATCHED THEN INSERT VALUES (SRC.planId, 'Defintion entities : possible', 1, '1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768,65536,65537,65538,65539', SRC.created, 0);

    -- required

    MERGE   APP_PlanProp AS TGT

    USING   (SELECT id, subtype, created FROM APP_Plan) AS SRC(planId, subtype, created)

ON      TGT.componentNameId = SRC.planId AND TGT.attrName = 'Defintion entities : required'

WHEN    NOT MATCHED THEN INSERT VALUES (SRC.planId, 'Defintion entities : required', 1,

IIF(SRC.subtype = 16777223,             '1,4,256,512,1024',

IIF(SRC.subtype = 33554437,          '1,4',

IIF(SRC.subtype = 67108869,            '1,4',

IIF(SRC.subtype = 50331655,        '1,4,256,512,1024',

IIF(SRC.subtype = 33579013,        '1,4,8192,16384',

IIF(SRC.subtype = 33554439,          '1,4,256,512,1024,16,2048',

IIF(SRC.subtype = 83886085,       '1,4',

IIF(SRC.subtype = 83918853,  '1,4,32768',

IIF(SRC.subtype = 100859907,   '65536,65537,65538',

IIF(SRC.subtype = 100794372,'65537,65539', '')))))))))), SRC.created, 0);

    -- make sure that all entites associated with plans have flag that prevent its deletion

UPDATE UMGroups                 SET groupFlags = (groupFlags | 536870912) WHERE id       IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE attrName IN ('Assigned user group'))

UPDATE APP_ClientGroup          SET flag =       (flag       | 536870912) WHERE id       IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE attrName IN ('Assigned client group'))

UPDATE archGroup                SET flags =      (flags      | 536870912) WHERE id       IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE attrName IN ('Storage policy',           'Log storage policy'))

UPDATE TM_Task                  SET flags =      (flags      | 536870912) WHERE taskId   IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE attrName IN ('Schedule policy',          'Log schedule policy'))

UPDATE UMRoles                  SET flags =      (flags      | 536870912) WHERE id       IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE attrName IN ('Feature',          'Access policy'))

UPDATE APP_ConfigurationPolicy  SET flags =      (flags      | 536870912) WHERE policyId IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE attrName IN ('Exchange mailbox archiving policy', 'Exchange mailbox retention policy',  'Exchange mailbox cleanup policy', 'Exchange mailbox journal policy'))

SET @pid = (SELECT MIN(id) FROM APP_PlanProp WHERE attrName IN ('Replication schedule policy', 'Assgined Edge Drive', 'Subclient policy 2', 'Subclient policy 3', 'Subclient policy 4'))

    DECLARE @propertyName VARCHAR(510)

    DECLARE @propertyValue VARCHAR(510)

    WHILE ISNULL(@pid, 0) != 0 BEGIN

        SELECT @planId = componentNameId, @propertyName = attrName, @propertyValue = attrVal FROM APP_PlanProp WHERE id = @pid

IF @propertyName = 'Assgined Edge Drive' BEGIN

DECLARE @cprId INT = (SELECT id FROM APP_ClientProp WHERE componentNameId = CAST(@propertyValue AS INT) AND attrName = 'Associated Plan')

            IF @cprId IS NULL BEGIN

                IF EXISTS (SELECT 1 FROM APP_Client WHERE id = CAST(@propertyValue AS INT))
                    INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


VALUES(CAST(@propertyValue AS INT), 'Associated Plan', 2, CAST(@planId AS VARCHAR(32)), @currentTime, 0, 0)

            END ELSE BEGIN

                UPDATE APP_ClientProp SET attrVal = CAST(@planId AS VARCHAR(32)) WHERE id = @cprId

            END

END ELSE IF @propertyName = 'Replication schedule policy' BEGIN

UPDATE TM_Task SET flags = (flags | 536870912) WHERE taskId IN (SELECT _ID FROM dbo.SplitIDString(@propertyValue))

        END ELSE BEGIN

DECLARE @bsprId INT = (SELECT id FROM APP_BackupSetProp WHERE componentNameId = CAST(@propertyValue AS INT) AND attrName = 'Associated Plan')

            IF @bsprId IS NULL BEGIN

                IF EXISTS (SELECT 1 FROM APP_BackupSetName WHERE id = CAST(@propertyValue AS INT))
                    INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


VALUES(CAST(@propertyValue AS INT), 'Associated Plan', 2, CAST(@planId AS VARCHAR(32)), @currentTime, 0, 0)

            END ELSE BEGIN 

                UPDATE APP_BackupSetProp SET attrVal = CAST(@planId AS VARCHAR(32)) WHERE id = @bsprId

            END

        END

SET @pid = (SELECT MIN(id) FROM APP_PlanProp WHERE (id > @pid) AND (attrName IN ('Replication schedule policy', 'Assgined Edge Drive', 'Subclient policy 2', 'Subclient policy 3', 'Subclient policy 4')))

    END 

	-- Rename SLA In Minutes/Log SLA In Minutes attribute to RPO in minutes/Log RPO In Minutes. 

	DECLARE @guidForPlanRPOAttrNameUpdate uniqueidentifier = '3D1BF85E-6C55-4765-A4D9-232841488C17'

    DECLARE @PlanRPOAttrNameAlreadyUpdated BIT = CASE WHEN EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guidForPlanRPOAttrNameUpdate) THEN 1 ELSE 0 END

	IF @PlanRPOAttrNameAlreadyUpdated = 0

	BEGIN

		BEGIN TRY

		BEGIN TRAN

UPDATE App_PlanProp SET attrName = 'RPO In Minutes' WHERE attrName =  'SLA In Minutes'

UPDATE App_PlanProp SET attrName = 'Log RPO In Minutes' WHERE attrName =  'Log SLA In Minutes'
			INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guidForPlanRPOAttrNameUpdate, 'PlanSLAAttributeReName', 'Changing plan SLA attribute names to RPO', @unixTime, 16, 0 , (16 + 2))

			COMMIT TRAN

		END TRY

		BEGIN CATCH

			-- Call procedure to print error information.

			-- Call procedure to get error information.

			EXECUTE dbo.GetError @tmpErrorString OUTPUT , @o_errorCode OUTPUT

			PRINT 'Error: [ ' + @tmpErrorString + ' ]. Rolling back transaction for updating plan SLA attribute names'

			ROLLBACK TRAN

		END CATCH

	END

    SET NOCOUNT OFF

    DECLARE @PlanUserOrUserGroupUpdate    VARCHAR(40) = '69D85982-F029-47DC-88AC-855E189A9813'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanUserOrUserGroupUpdate)

    BEGIN

        DECLARE @groupsTbl TABLE (groupId INT, planId INT)

        DECLARE @usersTbl TABLE  (userId INT, planGroupId INT, planId INT)

        -- First Lets Process User Groups

        -- Get All user group which have some mapping via app_planprop
        INSERT INTO @groupsTbl


        SELECT attrVal,componentNameId FROM App_PlanProp

WHERE attrName IN ('Associated internal user group', 'Associated external user group') and modified=0 AND ISNUMERIC(attrVal)=1

        -- Remove user groups which are correctly mapped to plan. Means remove those for which plan also have entry and group prop also have entry

        DELETE GT

        FROM @groupsTbl GT

        INNER JOIN UMGroupsProp UG

ON UG.componentNameId=GT.groupId AND UG.attrName='Associated Plan' AND UG.modified=0 AND UG.attrVal=CAST(GT.planId AS NVARCHAR(64))

        -- We are left with unwanted entries. Remove there references from App_planprop

        DELETE APP

        FROM App_PlanProp APP

        INNER JOIN @groupsTbl GTL

ON APP.componentNameId=GTL.planId AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.attrVal=CAST(GTL.groupId AS NVARCHAR(64))

        -- Secondly Let's Process Users

        -- Get All users which have some explicit mapping to Plan via Plan User Group
        INSERT INTO @usersTbl


        SELECT UUG.userId, UUG.groupId,APP.componentNameId FROM App_PlanProp APP

        INNER JOIN UMUserGroup UUG

ON  APP.attrName='Assigned user group' AND APP.modified=0 AND CAST(UUG.groupId AS NVARCHAR(64))=APP.attrVal

        -- Remove all users form temp table for which mapping is correct.

        DELETE UT

        FROM @usersTbl UT

        INNER JOIN UMUsersProp UUP

ON UUP.componentNameId=UT.userId AND UUP.attrName='Associated Plan' AND UUP.modified=0 AND UUP.attrVal=CAST(UT.planId AS nvarchar(64))

        -- We are left with duplicated mappings which doesn't hold well. Lets remove there association from Plan User Group

        DELETE UUG

        FROM UMUserGroup UUG

        INNER JOIN @usersTbl UTL

        ON UTL.userId=UUG.userId AND UTL.planGroupId=UUG.groupId

        -- Get All user groups for which we don't have direct association present but there reference does exist in App_PlanProp Table.
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlanUserOrUserGroupUpdate, 'PlanUserOrUserGroupUpdate', 'Script to remove unwanted multiple references of user or user group associations.', @currentTime,  16, 0, (16 + 2))

    END

	DECLARE @PlanUserGroupHideUpdate    VARCHAR(40) = '175a5688-3d8a-4eeb-9172-357f69769331'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanUserGroupHideUpdate)

    BEGIN

        -- Set hidden Flag for all the found out user groups

		UPDATE UG

SET UG.groupFlags = UG.groupFlags | 0x0010

		FROM UmGroups UG

		INNER JOIN App_PlanProp APP

ON (APP.attrName = 'Assigned user group') AND CAST(UG.id AS NVARCHAR(64))=APP.attrVal AND APP.modified=0 AND ISNUMERIC(APP.attrVal)=1

WHERE UG.groupFlags & 536870912 <> 0

        -- Get All user groups for which we don't have direct association present but there reference does exist in App_PlanProp Table.
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlanUserGroupHideUpdate, 'PlanUserGroupHideUpdate', 'Script to hide plan user groups from all possible UI points.', @currentTime,  16, 0, (16 + 2))

    END

	-- Upgrade of Daily Incremental schedules to Continuous Incremental schedules for below plans

	-- Server, FS Server, Snap, VSA Server, VSA Replication

	DECLARE @PlanContinuousRPOUpgrade    VARCHAR(40) = '4F74BD6A-8D2C-4588-8BE6-849D2524343D'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanContinuousRPOUpgrade)

    BEGIN

		DECLARE @plans AS TABLE (

			planId INT,

			planType INT,

			planRPO INT,

			taskId INT, 

			subTaskId INT,

			subTaskXMLOptions XML,

			jobXMLOptions XML

		)
        INSERT INTO @plans (planId, planType, planRPO, taskId, subTaskId)


		SELECT DISTINCT P.id, P.subType, CONVERT(INT,pp.attrVal), CONVERT(INT,pp1.attrVal), 0

			FROM App_Plan P WITH(NOLOCK)

			INNER JOIN App_PlanProp pp

ON P.id = pp.componentnameId AND pp.attrName = 'RPO In Minutes'

			INNER JOIN App_PlanProp pp1

ON P.id = pp1.componentNameId AND pp1.attrName = 'Schedule policy'

WHERE P.subType IN (33554437, 50331655, 67108869, 83886085, 83918853)  AND P.ownerId IS NOT NULL

UPDATE P SET P.subTaskId = ( SELECT ST.subTaskId FROM TM_SubTask ST WITH (READUNCOMMITTED) WHERE ST.taskId = P.taskId AND ST.flags & 0x10000 > 0 ) FROM @plans P

		UPDATE P SET P.subTaskXMLOptions = (SELECT STXO.xmlValue FROM TM_SubTaskXMLOptions STXO WITH(READUNCOMMITTED) WHERE STXO.subTaskId = P.subTaskId ) FROM @plans P

		UPDATE P SET P.jobXMLOptions = (SELECT JXO.xmlValue FROM TM_JobXMLOptions JXO WHERE JXO.subTaskId = P.subTaskId and JXO.jobId = 0 AND JXO.modified = 0) FROM @plans P

		-- updating the Pattern of the subtasks 

		UPDATE TP

SET TP.freq_interval = IIF((P.planRPO/60) <= 1, 60, ((P.planRPO/60)-1) * 60), TP.freq_subday_interval = 0, TP.freq_type = 4096

		FROM TM_Pattern TP

		INNER JOIN TM_PatternAssoc PA 

			ON PA.patternId = TP.patternId

		INNER JOIN @plans P 

			ON P.subTaskId = PA.subTaskId

WHERE TP.freq_type = 4

		DECLARE @sXmlOptions XML 

		DECLARE @jXmlOptions XML 

		DECLARE @value INT = 1

		--upgrading existing subtask options to have continuous incremental flag "useJobStartTimeForContinuousSchedule""

		DECLARE xmlOptions_cursor CURSOR FOR   

		SELECT P.taskId, P.subTaskId, P.subTaskXMLOptions, P.jobXMLOptions

			FROM @plans P WHERE P.taskId IS NOT NULL AND P.subTaskId IS NOT NULL AND P.planRPO IS NOT NULL --For derived plans we do not need to upgrade

		OPEN xmlOptions_cursor

		FETCH NEXT FROM xmlOptions_cursor

		INTO @taskid, @subTaskId, @sXmlOptions, @jXmlOptions

		WHILE @@FETCH_STATUS = 0  

		BEGIN 

			IF @taskid IS NOT NULL AND @subTaskId IS NOT NULL

			BEGIN

				UPDATE TM_SubTaskOptions SET value = N'1' WHERE subTaskId = @subTaskId AND optionId = 414240771 -- COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE

				IF @@ROWCOUNT = 0

				BEGIN
					INSERT INTO TM_SubTaskOptions(subTaskID, optionID, type, value) VALUES


(@subTaskId, 414240771/*COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE*/, 2, N'1')

				END

				IF @sXmlOptions IS NOT NULL BEGIN

					IF (@sXmlOptions.exist('//TMMsg_JobOption/commonOpts/@useJobStartTimeForContinuousSchedule')) = 0

					BEGIN

						SET @sXmlOptions.modify('insert attribute useJobStartTimeForContinuousSchedule {sql:variable("@value")} as first into (/TMMsg_JobOption/commonOpts)[1]') 

						UPDATE STXO SET STXO.xmlValue = @sXmlOptions FROM TM_SubTaskXMLOptions STXO WHERE STXO.subTaskId = @subTaskId

					END

				END

				UPDATE TM_JobOptions SET value = N'1' WHERE taskId = @taskId AND subTaskId = @subTaskId AND optionId = 414240771/*COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE*/ AND jobId = 0 AND modified = 0

				IF @@ROWCOUNT = 0

				BEGIN
					INSERT INTO TM_JobOptions (jobId, optionId, type, value, taskId, subTaskId,	lastJobId, created,	modified) VALUES 


( 0, 414240771/*COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE*/, 2, N'1', @taskId, @subTaskId, 0, @currentTime, 0)

				END

				IF @jXmlOptions IS NOT NULL BEGIN

					IF (@jXmlOptions.exist('//TMMsg_JobOption/commonOpts/@useJobStartTimeForContinuousSchedule')) = 0

					BEGIN

						--aging job xml options

						UPDATE TM_JobXMLOptions 

						SET modified = @currentTime 

						WHERE subTaskId = @subTaskId AND taskId = @taskid AND modified = 0 
						INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


						SELECT 0, @jXmlOptions, @taskid, @subTaskId, 0, @currentTime, 0

						UPDATE TM_JobXMLOptions

						SET xmlValue.modify('insert attribute useJobStartTimeForContinuousSchedule {sql:variable("@value")} as first into (/TMMsg_JobOption/commonOpts)[1]')

						WHERE subTaskId = @subTaskId AND taskId = @taskid AND modified = 0 

					END

				END

			END

		FETCH NEXT FROM xmlOptions_cursor

		INTO @taskid, @subTaskId, @sXmlOptions, @jXmlOptions

		END   

		CLOSE xmlOptions_cursor;  

		DEALLOCATE xmlOptions_cursor;

        -- Get All user groups for which we don't have direct association present but there reference does exist in App_PlanProp Table.
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlanContinuousRPOUpgrade, 'PlanContinuousRPOUpgrade', 'Plan upgrade from Daily Incremental to Continuous', @currentTime,  16, 0, (16 + 2))

    END

	-- updating snap addon property for plans prior to SP13 which have snap addon support (cases like AWS or Azure subclient for Schuberg philis)

	DECLARE @PlanSnapAddonUpgrade   VARCHAR(40) = '92AE77D5-72BB-4E49-A64C-FD592E158BBF'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanSnapAddonUpgrade)

    BEGIN

        DECLARE @snapServerPlans AS TABLE (

			planId INT,

			storagePolicyId INT

		)
		INSERT INTO @snapServerPlans


		SELECT P.id, CAST(PP2.attrVal AS INT) FROM App_Plan P WITH(NOLOCK)

INNER JOIN App_PlanProp PP1 WITH(NOLOCK) ON P.id = PP1.componentNameId AND PP1.attrName = 'Snap Addon' AND CHARINDEX(',',PP1.attrVal) > 0

INNER JOIN App_PlanProp PP2 WITH(NOLOCK) ON PP1.componentNameId = PP2.componentNameId AND PP2.attrName = 'Storage policy'

WHERE P.subType = 33554437

		UPDATE PP

SET PP.attrType= 7, PP.attrVal = '1', PP.created = @currentTime

		FROM App_PlanProp PP

		INNER JOIN @snapServerPlans SP ON SP.planId = PP.componentNameId

		INNER JOIN archGroup AG ON SP.storagePolicyId = AG.id

		INNER JOIN archGroupCopy AGC ON AG.id = AGC.archGroupId AND AG.defaultSnapCopy = AGC.id AND AGC.isSnapCopy = 1

		INNER JOIN ArchMaterializeSnapshotProp AMS  ON AMS.archGroupId = AG.id AND AMS.enabled = 1

WHERE PP.componentNameId = SP.planId AND PP.attrName = 'Snap Addon'

		--For plans which still have this snap addon property with comma seperated value then delete it irrespective of the actual status

		DELETE PP1

			FROM App_PlanProp PP1

INNER JOIN App_Plan P ON P.id = PP1.componentNameId AND PP1.attrName = 'Snap Addon' AND CHARINDEX(',',PP1.attrVal) > 0

WHERE P.subType = 33554437
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlanSnapAddonUpgrade, 'PlanSnapAddonUpgrade', 'Script to upgrade existing smart snap addon created plans.', @currentTime,  16, 0, (16 + 2))

    END

	DECLARE @PlanDefinitionEntitesUpdate    VARCHAR(40) = '14DC9E5B-CA9E-4219-AD93-3F890B4EB50A'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanDefinitionEntitesUpdate)

    BEGIN

		DECLARE @PossibleEntitiesList TABLE (planId INT, possibleEntities NVARCHAR(MAX))
		INSERT INTO @PossibleEntitiesList


SELECT componentNameId, attrVal FROM App_PlanProp WHERE attrName='Defintion entities : possible'

		DECLARE @planIdPossible INT = 0

		DECLARE @possibleEntities NVARCHAR(MAX)

		IF ( CURSOR_STATUS('global', 'PlanCursor') >= 0   OR CURSOR_STATUS('local', 'PlanCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

				  CLOSE PlanCursor

		IF ( CURSOR_STATUS('global','PlanCursor') = -1     OR CURSOR_STATUS('local','PlanCursor') = -1 )

			DEALLOCATE PlanCursor

		DECLARE PlanCursor CURSOR

		FOR

			SELECT planId, possibleEntities FROM @PossibleEntitiesList

		OPEN PlanCursor

		FETCH FROM PlanCursor INTO @planIdPossible, @possibleEntities

		WHILE @@FETCH_STATUS = 0 

		BEGIN

			DECLARE @newPossibleEntities NVARCHAR(MAX) = NULL

DECLARE @possibleEntitiesOld NVARCHAR(MAX) = (SELECT attrVal FROM App_PlanProp WITH(NOLOCK) WHERE componentNameId=@planIdPossible AND attrName='Defintion entities : possible')

IF NOT EXISTS (	SELECT 1 FROM dbo.SplitIDString(@possibleEntitiesOld) PR WHERE PR._Id = 65545 )

			BEGIN

				SELECT  @newPossibleEntities = COALESCE(@newPossibleEntities + ',', '') + CAST(T._ID AS VARCHAR(32))

											FROM

											(SELECT _ID FROM dbo.SplitIDs(@possibleEntitiesOld)

											UNION

SELECT 65545 ) T

UPDATE App_PlanProp SET attrVal=@newPossibleEntities WHERE componentNameId=@planIdPossible AND attrName='Defintion entities : possible'

			END

			FETCH FROM PlanCursor INTO @planIdPossible, @possibleEntities

		END

		CLOSE PlanCursor

		DEALLOCATE PlanCursor
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlanDefinitionEntitesUpdate, 'PlanPossibleEntitesUpdate', 'Script to update possible entities for plan with entity for index copy schedule policy entity.', @currentTime,  16, 0, (16 + 2))

    END

	DECLARE @PlanRestrictedEntitesUpdate    VARCHAR(40) = '2cc431ae-1fd1-4119-a416-f624b2919a8f'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanRestrictedEntitesUpdate)

    BEGIN

DECLARE @globalRestrictedEntitiesList NVARCHAR(1024) = ISNULL((SELECT TOP 1 value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Plan entites derivation restricted' AND modified=0 ),'')

		DECLARE @restrictionList TABLE (planId INT, restrictions NVARCHAR(MAX))
		INSERT INTO @restrictionList


		SELECT componentNameId, attrVal FROM App_PlanProp WHERE attrName='Descendants enforced entities'

		DECLARE @planIdRes INT = 0

		DECLARE @restrictions NVARCHAR(MAX)

		DECLARE PlanCursor CURSOR

		FOR

			SELECT planId, restrictions FROM @restrictionList

		OPEN PlanCursor

		FETCH FROM PlanCursor INTO @planIdRes, @restrictions

		WHILE @@FETCH_STATUS = 0 

		BEGIN

			DECLARE @newRestrictions NVARCHAR(MAX) = NULL

DECLARE @privateEntities NVARCHAR(MAX) = (SELECT attrVal FROM App_PlanProp WITH(NOLOCK) WHERE componentNameId=@planIdRes AND attrName='Private entities')

			-- If any entity is already private , then don't add it to restriction list

			IF NOT EXISTS (	SELECT 1 FROM dbo.SplitIDString(@privateEntities) PR

							INNER JOIN dbo.SplitIDString(@globalRestrictedEntitiesList) TB

								ON TB._ID=PR._ID)

			BEGIN

				SELECT  @newRestrictions = COALESCE(@newRestrictions + ',', '') + CAST(T._ID AS VARCHAR(32))

											FROM

											(SELECT _ID FROM dbo.SplitIDs(@restrictions)

											UNION

											SELECT _ID FROM dbo.SplitIDs(@globalRestrictedEntitiesList)) T

UPDATE App_PlanProp SET attrVal=@newRestrictions WHERE componentNameId=@planIdRes AND attrName='Descendants enforced entities'

			END

			FETCH FROM PlanCursor INTO @planIdRes, @restrictions

		END

		CLOSE PlanCursor

		DEALLOCATE PlanCursor
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlanRestrictedEntitesUpdate, 'PlanRestrictedEntitesUpdate', 'Script to update restricted entities for plan.', @currentTime,  16, 0, (16 + 2))

    END

	DECLARE @ExchangePlansRPOCleanup   VARCHAR(40) = 'EAB9F80C-118E-47CE-B840-BC2AE869DBB7'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @ExchangePlansRPOCleanup)

    BEGIN

		DELETE PP

		FROM App_PlanProp PP

			 INNER JOIN APP_Plan P ON PP.componentnameId = P.id

WHERE PP.attrName = 'RPO In Minutes'

AND P.subType IN (100859907,100794372);
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@ExchangePlansRPOCleanup, 'ExchangePlansRPOCleanup', 'Script to delete RPO property for Exchange plans.', @currentTime,  16, 0, (16 + 2))

    END

    DECLARE @SubclientPolicyPropDecouping   VARCHAR(40) = 'A8F8BA3A-5B7E-499F-902C-29BB523C0302'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @SubclientPolicyPropDecouping)

    BEGIN
        INSERT INTO App_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)


            SELECT componentNameId, 'Subclient content 2', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 2' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient content 2')

            UNION

            SELECT componentNameId, 'Subclient content 3', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 3' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient content 3')

            UNION

            SELECT componentNameId, 'Subclient content 4', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 4' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient content 4')

            UNION

            SELECT componentNameId, 'Subclient retentions 2', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 2' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient retentions 2')

            UNION

            SELECT componentNameId, 'Subclient retentions 3', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 3' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient retentions 3')

            UNION

            SELECT componentNameId, 'Subclient retentions 4', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 4' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient retentions 4')

            UNION

            SELECT componentNameId, 'Subclient archival rules 2', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 3' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient archival rules 2')

            UNION

            SELECT componentNameId, 'Subclient archival rules 3', 7, attrVal, created, 0

            FROM App_PlanProp PP1 WHERE attrName = 'Subclient policy 3' AND NOT EXISTS (SELECT 1 FROM App_PlanProp PP2 WHERE PP1.componentNameId = PP2.componentNameId AND attrName = 'Subclient archival rules 3')
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@SubclientPolicyPropDecouping, 'LaptopPlanSubclientPropDecopling', 'Support for subclient policies content and retention inheritance', @currentTime,  16, 0, (16 + 2))

    END

   DECLARE @PlanAutoRetireDevices VARCHAR(40) = '7B0F0F05-62B7-4505-816B-8D92CEA2F3F5'

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlanAutoRetireDevices)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#laptopPlanIds') IS NOT NULL 

        DROP TABLE #laptopPlanIds

		CREATE TABLE #laptopPlanIds (

			planId                    INT PRIMARY KEY

		)

		-- Get edge clients
		INSERT INTO #laptopPlanIds


		SELECT P.id

		FROM APP_Plan P WITH(NOLOCK)

WHERE P.subType = 33554439

		MERGE App_PlanProp t 

		USING #laptopPlanIds s

ON (s.planId = t.componentNameId AND t.attrName = 'Retire devices after days')

		WHEN MATCHED

		THEN UPDATE SET

			t.attrVal = -1

		WHEN NOT MATCHED 

		THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)

VALUES (s.planId, 'Retire devices after days', 7 , -1 , @currentTime, 0);

		MERGE App_PlanProp t 

		USING #laptopPlanIds s

ON (s.planId = t.componentNameId AND t.attrName = 'Force delete devices after days')

		WHEN MATCHED

		THEN UPDATE SET

			t.attrVal = -1

		WHEN NOT MATCHED 

		THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)

VALUES (s.planId, 'Force delete devices after days', 7 , -1 , @currentTime, 0);
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ( @PlanAutoRetireDevices, 'PlanAutoRetireDevices', 'Set auto retire devices properties', @currentTime,  16, 0, (16 + 2))

		IF OBJECT_ID('tempdb.dbo.#laptopPlanIds') IS NOT NULL 

        DROP TABLE #laptopPlanIds

	END

	DECLARE @autoRetireDevicesAttrType VARCHAR(40) = '3E6C0EA3-1282-4522-89BD-F041F2263552'

	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @autoRetireDevicesAttrType)

	BEGIN

		UPDATE APP_PlanProp 

SET attrType = 7 where attrName in ('Force delete devices after days','Retire devices after days')
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ( @autoRetireDevicesAttrType, 'PlanAutoRetireDevicesPropertyAttrType', 'Change attrType to integer for properties related to autoretireDevices', @currentTime,  16, 0, (16 + 2))

	END

    DECLARE @PlansMissingEntitesList   VARCHAR(40) = '880F7206-D73D-4D12-82CE-F1969E04599D'

    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @PlansMissingEntitesList)

    BEGIN

        -- iterate through the list of incomplete plans

        DECLARE @incompletePlanId INT

        DECLARE IncompletePlansCursor CURSOR FOR

            SELECT Id FROM APP_Plan WHERE (flag & 2) = 2

        OPEN IncompletePlansCursor

        FETCH FROM IncompletePlansCursor INTO @incompletePlanId

        WHILE @@FETCH_STATUS = 0  BEGIN

            -- fetch list of the entities necessary for plan to be in 'complete' state

DECLARE @requiredEntites VARCHAR(510) = (SELECT attrVal FROM APP_PlanProp WHERE componentNameId = @incompletePlanId AND attrName = 'Defintion entities : required' )

            -- recalculating plan status will insert PLAN_ATTRNAME__PLANPROP_MISSING attribute value into App_PlanProp table

            EXEC AppPlanCalcUpdateStatusV2 @incompletePlanId, @requiredEntites

            -- next incomplete plan

            FETCH FROM IncompletePlansCursor INTO @incompletePlanId

        END

        -- close cursor

        CLOSE IncompletePlansCursor

        DEALLOCATE IncompletePlansCursor
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@PlansMissingEntitesList, 'PlansMissingEntitesList', 'Store list of missing entities for plans in incomplete state', @currentTime,  16, 0, (16 + 2))

    END

GO

SET QUOTED_IDENTIFIER ON

GO

