

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_PlanDailyRPOSchedule.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2016  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_PlanDailyRPOSchedule.script,v $ $Id: App_PlanDailyRPOSchedule.script,v 1.1.4.2.16.1 2021/03/28 07:23:05 rengu Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

	DECLARE @errCode INTEGER

	DECLARE @errStr varchar(1024)

	DECLARE @pid INT = 0

	DECLARE @pType INT = 0

	DECLARE @atType INT = 0

	DECLARE @taskid INT = 0

	DECLARE @subTaskId INT = 0

	DECLARE @currentTime INT = DATEDIFF(second, '01/01/1970', GETDATE())

DECLARE @defaultCCId int = 2

    DECLARE @guidForRPOScheduleDailyUpdate uniqueidentifier = '78B565A5-5F76-4E17-83F0-8CF64BB24B56'

    DECLARE @guidForRPOIncrWithLogs uniqueidentifier = '3C07C6F5-92EB-48AC-9DB8-42124AE26AF7'

	DECLARE @globalParamPlanUpdateExec INT = 0

	SELECT @globalParamPlanUpdateExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = @guidForRPOScheduleDailyUpdate

	IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

	BEGIN

	BEGIN TRY

		BEGIN TRAN

		DECLARE @sp17InstallTime INT = 0 -- Its in unixtime of utc. We compare it against createTime of task which is in CS.

IF EXISTS(SELECT * FROM APP_ComponentProp WHERE propertyTypeId =  3624 AND componentId = @defaultCCId)

		BEGIN

			SELECT TOP 1 @sp17InstallTime = InstallHistory.C.value('@installTime', 'int') 

				FROM 

				(

					SELECT componentId, CAST(stringVal AS XML) AS historyXml

					FROM APP_ComponentProp (NOLOCK)

WHERE propertyTypeId =  3624 AND componentId = @defaultCCId

				) AS results

				CROSS APPLY results.historyXml.nodes('/PatchInstallHistory/SPVer') AS InstallHistory(C)

				WHERE C.value('@sp', 'int')>=17

				ORDER BY InstallHistory.C.value('@installTime','int') ASC				

		END

		-- Its in unixtime of utc. We compare it against createTime of task which is in dbo.getunixtime(getdate()). So converting install time 

		SET @sp17InstallTime = @sp17InstallTime + DATEDIFF(s, GETUTCDATE(), GETDATE())

		IF object_id('tempdb.dbo.#PlanRPOSchedules') is not null 

			DROP TABLE #PlanRPOSchedules

		CREATE TABLE #PlanRPOSchedules

		(

			taskID INT, 

			subtaskID INT			

		)

		CREATE CLUSTERED INDEX PlanRPOSchedules_subTaskId_Idx ON #PlanRPOSchedules(subTaskId)

		-- Take all plan RPO schedules where autoConvertbackuplevel option isnt set. 
		INSERT INTO #PlanRPOSchedules(taskId, subTaskId)


		SELECT DISTINCT CONVERT(INT,pp.attrVal), ST.subTaskId

			FROM App_Plan P WITH(NOLOCK)

			INNER JOIN App_PlanProp pp (NOLOCK)

				ON P.id = pp.componentNameId 

			INNER JOIN TM_Subtask ST (NOLOCK)

				ON ST.taskId = CONVERT(INT,pp.attrVal)

AND (ST.flags & 0x10000 )>0 -- RPO schedule flag

				 AND ST.operationType = 2 --Backup

			     AND ST.subTaskType = 2   --Backup

			INNER JOIN TM_task (NOLOCK) ON TM_task.taskId = ST.taskId

			INNER JOIN TM_PatternAssoc PA WITH(NOLOCK)

				ON PA.subTaskId = ST.subTaskId

			INNER JOIN TM_Pattern TP WITH(NOLOCK)

				ON TP.patternId = PA.patternId

			INNER JOIN TM_SubTaskOptions (NOLOCK) ON TM_SubTaskOptions.subTaskId = ST.subTaskId 

AND TM_SubTaskOptions.optionId = 458405394 AND TM_SubTaskOptions.Value = '2' -- incremental

			LEFT JOIN TM_SubtaskOptions (NOLOCK) AutoConvertOption ON AutoConvertOption.subTaskId = ST.subTaskId 

AND AutoConvertOption.optionId = 413934094

			LEFT JOIN TM_JobOptions (NOLOCK) AutoConvertJobOption ON AutoConvertJobOption.subTaskId = ST.subTaskId 

AND AutoConvertJobOption.optionId = 413934094

			WHERE ST.taskId = CONVERT(INT,pp.attrVal)

				AND (TP.freq_type = 4 OR TP.freq_type = 4096 OR TP.freq_type = 8) -- Daily , continous incremental or weekly

				AND P.subType IN (33554437, 150994951)  -- Server          =  33554437 , Archiver		= 150994951				

AND pp.attrName = 'Schedule policy'

				AND AutoConvertOption.optionID IS NULL

				AND AutoConvertJobOption.optionID IS NULL

				AND TM_Task.created >= @sp17InstallTime

		IF EXISTS (SELECT * FROM #PlanRPOSchedules)

		BEGIN

			UPDATE TM_SubTaskXMLOptions

			SET xmlValue.modify('insert (attribute autoConvertBackupLevel {1}) into (/TMMsg_JobOption/backupOpts)[1]')

			FROM TM_SubTaskXMLOptions

			INNER JOIN #PlanRPOSchedules ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

			AND xmlValue.exist('//TMMsg_JobOption/backupOpts/@autoConvertBackupLevel') = 0

			 -- Age of job XML options

			UPDATE TM_JobXMLOptions 

			SET modified = @currentTime 

			 FROM TM_JobXMLOptions

			 INNER JOIN #PlanRPOSchedules ST ON 

			 ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0 AND jobID = 0
			INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


			SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

			  FROM #PlanRPOSchedules ST

			  INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

			--Insert into Subtask Options
			INSERT INTO TM_SubtaskOptions(subTaskId, optionId, type, value)


SELECT ST.subTaskId,413934094/*BACKUPOPTION_AUTO_CONVERT_BACKUP_LEVEL*/, 0, '1'

			FROM #PlanRPOSchedules ST    

			INNER JOIN TM_Subtask T ON ST.subTaskId = T.subTaskId

			-- Dont age off job options. Insert only since we ocme here only if option not present. 
			INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


SELECT 0,413934094/*BACKUPOPTION_AUTO_CONVERT_BACKUP_LEVEL*/, 0, '1', ST.taskId, ST.subTaskId,0,@currentTime,0

			FROM #PlanRPOSchedules ST

		END
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guidForRPOScheduleDailyUpdate, 'RPOScheduleDailyFix', 'Fix auto convert backup level option for RPO schedules', @currentTime,  16, 0, (16 + 2))

		COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	END CATCH

	IF object_id('tempdb.dbo.#PlanRPOSchedules') is not null 

			DROP TABLE #PlanRPOSchedules

	END

	IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = @guidForRPOIncrWithLogs)        

	BEGIN

	BEGIN TRY

		BEGIN TRAN

		IF object_id('tempdb.dbo.#IncrRPOSchedules') is not null 

			DROP TABLE #IncrRPOSchedules

		CREATE TABLE #IncrRPOSchedules

		(

			taskID INT, 

			subtaskID INT			

		)

		CREATE CLUSTERED INDEX IncrRPOSchedules_subTaskId_Idx ON #IncrRPOSchedules(subTaskId)

		-- Take all plan incr RPO schedules where incrementaldatawithLogs option isnt set. 
		INSERT INTO #IncrRPOSchedules(taskId, subTaskId)


		SELECT DISTINCT CONVERT(INT,pp.attrVal), ST.subTaskId

			FROM App_Plan P WITH(NOLOCK)

			INNER JOIN App_PlanProp pp (NOLOCK)

				ON P.id = pp.componentNameId 

			INNER JOIN TM_Subtask ST (NOLOCK)

				ON CONVERT(NVARCHAR(10), ST.taskId) = pp.attrVal

AND (ST.flags & 0x10000 )>0 -- RPO schedule flag

				 AND ST.operationType = 2 --Backup

			     AND ST.subTaskType = 2   --Backup

			INNER JOIN TM_task (NOLOCK) ON TM_task.taskId = ST.taskId

			INNER JOIN TM_SubTaskOptions (NOLOCK) ON TM_SubTaskOptions.subTaskId = ST.subTaskId 

AND TM_SubTaskOptions.optionId = 458405394 AND TM_SubTaskOptions.Value = '2' -- incremental

			LEFT JOIN TM_SubtaskOptions (NOLOCK) IncrDataWithLogs ON IncrDataWithLogs.subTaskId = ST.subTaskId 

AND IncrDataWithLogs.optionId = 1505355145

			LEFT JOIN TM_JobOptions (NOLOCK) IncrDataWithLogsJobOption ON IncrDataWithLogsJobOption.subTaskId = ST.subTaskId 

AND IncrDataWithLogsJobOption.optionId = 1505355145

			WHERE CONVERT(NVARCHAR(10), ST.taskId) = pp.attrVal

AND pp.attrName = 'Schedule policy'

				AND IncrDataWithLogs.optionID IS NULL

				AND IncrDataWithLogsJobOption.optionID IS NULL

		IF EXISTS (SELECT * FROM #IncrRPOSchedules)

		BEGIN

			UPDATE TM_SubTaskXMLOptions

			SET xmlValue.modify('insert (attribute incrementalDataWithLogs {1}) into (/TMMsg_JobOption/backupOpts)[1]')

			FROM TM_SubTaskXMLOptions

			INNER JOIN #IncrRPOSchedules ST ON ST.subTaskId = TM_SubTaskXMLOptions.subTaskId

			AND xmlValue.exist('//TMMsg_JobOption/backupOpts/@incrementalDataWithLogs') = 0

			 -- Age of job XML options

			UPDATE TM_JobXMLOptions 

			SET modified = @currentTime 

			 FROM TM_JobXMLOptions

			 INNER JOIN #IncrRPOSchedules ST ON 

			 ST.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0 AND jobID = 0
			INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)        


			SELECT 0,STXO.xmlValue,ST.taskId,ST.subTaskId,0,@currentTime, 0

			  FROM #IncrRPOSchedules ST

			  INNER JOIN TM_SubTaskXMLOptions STXO ON ST.subTaskId = STXO.subTaskId

			--Insert into Subtask Options
			INSERT INTO TM_SubtaskOptions(subTaskId, optionId, type, value)


SELECT ST.subTaskId,1505355145/*BACKUPOPTION_INCREMENTAL_DATA_WITH_LOGS*/, 0, '1'

			FROM #IncrRPOSchedules ST    

			INNER JOIN TM_Subtask T ON ST.subTaskId = T.subTaskId

			-- Dont age off job options. Insert only since we ocme here only if option not present. 
			INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


SELECT 0,1505355145/*BACKUPOPTION_INCREMENTAL_DATA_WITH_LOGS*/, 0, '1', ST.taskId, ST.subTaskId,0,@currentTime,0

			FROM #IncrRPOSchedules ST

		END
	    INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@guidForRPOIncrWithLogs, 'RPOIncrDataWithLogs', 'Upgrade RPO data schedules to have incremental data with Logs Option', @currentTime,  16, 0, (16 + 2))

		COMMIT TRAN

	END TRY

	BEGIN CATCH

		ROLLBACK TRAN

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		;THROW;

	END CATCH

	IF object_id('tempdb.dbo.#IncrRPOSchedules') is not null 

			DROP TABLE #IncrRPOSchedules

	END	

GO

