

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_MessageHandler.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/App_MessageHandler.script,v $ $Id: App_MessageHandler.script,v 1.1.2.1 2018/03/27 09:22:30 anarde Exp $";

GO

DECLARE @curTime INT 

SET @curTime  = datediff(second, '01/01/1970', GETUTCDATE())

DECLARE @workflowIdGUID VARCHAR(50) = '9C3F54DB-A5EE-4C21-B827-C67B714AA403'

DECLARE @workflowIdUpgrade INT = 0

SELECT

    @workflowIdUpgrade = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID =  @workflowIdGUID        

IF (@workflowIdUpgrade = 0)        -- not done, do the db upgrade

BEGIN

    MERGE INTO App_MessageHandler AS target

		USING (SELECT WorkflowId, Name FROM WF_Definition) AS source

		ON (target.workflowname = source.Name)

		WHEN MATCHED 

			THEN UPDATE SET target.workflowId = source.WorkflowId;		
    INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES( @workflowIdGUID, 'UpdateWorkflowId', 'Foreign key column workflowId is created, populate this column.', @curTime, 16, 0 , (16 + 1))

END

SET NOCOUNT OFF

GO

