

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_LMCreateAuditEventDashboard.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------

SET NOCOUNT ON

DECLARE @curUtcDateTime BIGINT

DECLARE @errorCode int = 0

DECLARE @errorString NVARCHAR(1024) = ''

DECLARE @AuditandEventDashboardScriptExec INT = 0

DECLARE @dashboardId INT

DECLARE @DashBoardName NVARCHAR(30) = 'Audit and Event Dashboard'

DECLARE @searchId INT 

DECLARE @searchUrl NVARCHAR(MAX)

DECLARE @searchUrlXml XML 

BEGIN TRY

	BEGIN TRANSACTION LMCrtAdtEvntDashbrdTran

	SELECT

		@AuditandEventDashboardScriptExec = 1

	FROM

		GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

	WHERE

		gp.SqlScriptGUID = 'B9F08FBA-6519-432A-837F-7ABDC28D13B1'

	IF (@AuditandEventDashboardScriptExec = 0)		-- not done, create the Audit and Event dashboard

	BEGIN

		SET @curUtcDateTime = datediff(second, '01/01/1970', GetUTCdate())

		--creating dashboard

		IF exists(SELECT 1 FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName)

		BEGIN

			SET @dashboardId = (SELECT TOP 1 dashBoardId FROM LMDashBoard WITH (NOLOCK) WHERE dashBoardName = @DashBoardName)

		END

		ELSE

		BEGIN

			-- status = 4 indicates the default dasboard
			INSERT INTO LMDashBoard (dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType) 


				VALUES(@DashBoardName,1,1,4,@curUtcDateTime,0,1)

			SET @dashboardId = @@IDENTITY

		END

		--creating searches

SET @searchUrl = '<LogMonitoring_SearchURLInfo orderId="' + '2' + '" searchType="0" browserURL="' + '?viewId=1&amp;MonitoringPolicyName=%22Gui%20Audit%20Trail%20Policy%22%2C%22Gui%20Event%20Viewer%20Policy%22%2C%22WebConsole%20Audit%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=linear" trendBrowserURL="?viewId=1&amp;MonitoringPolicyName=%22Gui%20Audit%20Trail%20Policy%22%2C%22Gui%20Event%20Viewer%20Policy%22%2C%22WebConsole%20Audit%20Policy%22&amp;fieldList=MonitoringPolicyName&amp;keyWord=graphtype%20compare&amp;startTime=NOW-30DAYS&amp;endTime=NOW&amp;estimatedTimeDiff=2592000000&amp;gap=1DAYS&amp;isAllTime=false&amp;dataView=rawView&amp;graphScale=linear' + '" solrQuery="' + 'df=LogLine&amp;q.op=AND&amp;rows=100&amp;start=0&amp;hl=true&amp;hl.fl=LogLine&amp;hl.fragsize=0&amp;hl.simple.pre=%3CFONT+style%3D%22BACKGROUND-COLOR%3Ayellow%22%3E&amp;hl.simple.post=%3C%2FFONT%3E&amp;fq=%28isLMDoc%3A1%29&amp;fq=%28MonitoringPolicyName%3A%22Gui+Audit+Trail+Policy%22+OR+MonitoringPolicyName%3A%22Gui+Event+Viewer+Policy%22+OR+MonitoringPolicyName%3A%22WebConsole+Audit+Policy%22%29&amp;fq=%28eventTime:[NOW-30DAYS+TO+NOW}%29&amp;q=*%3A*&amp;sort=eventTime+desc' + '" searchLabel="' + 'Search Info&lt;br&gt;&lt;b&gt;MonitoringPolicyName:&lt;/b&gt;Gui Audit Trail Policy,Gui Event Viewer Policy,WebConsole Audit Policy&lt;br&gt;&lt;b&gt;Start Time:&lt;/b&gt;NOW-30DAYS&lt;br&gt;&lt;b&gt;End Time:&lt;/b&gt;NOW&lt;br&gt;' + '" isImplicitSearch="0" />' 
	SET @searchUrlXml = CONVERT(XML,@searchUrl) 
	IF NOT EXISTS (SELECT 1 FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Event Viewer and Webconsole Audit events') 
	BEGIN 
		INSERT INTO LMUserSearch (searchName,isPrivate,creatorUserId,status,searchInfo,created,modified,monitoringAppType) 
		VALUES('Event Viewer and Webconsole Audit events',1,1,6,@searchUrlXml,@curUtcDateTime,@curUtcDateTime,1)	
		SET @searchId = @@IDENTITY 
		INSERT INTO lmdashsearchAssoc(dashBoardId,searchId) 
			VALUES(@dashboardId,@searchId) 
	END 
	ELSE 
	BEGIN 
		SET @searchId = (SELECT searchId FROM LMUserSearch WITH (NOLOCK) WHERE searchName = 'Event Viewer and Webconsole Audit events')  
		IF not exists(SELECT 1 FROM LMDashSearchAssoc WITH (NOLOCK) WHERE dashBoardId = @dashboardId AND searchId = @searchId) 
		BEGIN 
			INSERT INTO lmdashsearchAssoc(dashBoardId,searchId) 
			VALUES(@dashboardId,@searchId) 
			UPDATE LMUserSearch 
			SET status =  status | 4 
			WHERE searchId = @searchId 
		END 
	END
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('B9F08FBA-6519-432A-837F-7ABDC28D13B1', 'AuditandEventDashboardScriptExec', 'Create audit and event dashboard and searches', @curUtcDateTime, 16, 0 , (16 + 1))

	END

	COMMIT TRANSACTION LMCrtAdtEvntDashbrdTran

END TRY

BEGIN CATCH

	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()

	PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR) + N') ErrorMsg(' + @errorString + N').'

	PRINT N'So Rolling back Transactions.'

	ROLLBACK TRANSACTION LMCrtAdtEvntDashbrdTran

END CATCH

