

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/App_IdaPropInsertAzureConnections.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/* ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 2017  CommVault Systems, Inc.                

--                  All rights reserved.                                

-- 

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

--			Upgrade script to convert individual Azure props of Exchange mailbox agent into Azure App list XML string.

--		  Author : Nagaraju Uppu

-- ----------------------------------------------------------------------*/

Set Nocount ON

SET QUOTED_IDENTIFIER ON

DECLARE @createdTime INT = dbo.getUnixtime(GETUTCDATE())

DECLARE @sqlScriptGUID varchar(48) = '8C3C5B59-C850-4D21-B4C2-9DC6EEAFCEDA'

IF EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking (NOLOCK) WHERE SqlScriptGUID = @sqlScriptGUID)

GOTO ERROR_EXIST

IF OBJECT_ID('tempdb.dbo.#azureOldClients') IS NOT NULL	DROP TABLE #azureOldClients

CREATE TABLE   #azureOldClients  (id INT, idaId INT,  prop NVARCHAR(MAX))

BEGIN TRANSACTION InsertAzureConnectionsTran

BEGIN TRY
INSERT INTO #azureOldClients


SELECT I.clientId , I.id, ''  FROM  APP_IdaName I (NOLOCK) 

JOIN  App_IDAProp P (NOLOCK) ON I.id = P.componentNameId

WHERE I.appTypeId = 137 AND P.attrName='Exchange Environment Type' and P.modified = 0 AND P.attrval IN (2,3, 4)

Delete FROM #azureOldClients

WHERE id in (SELECT componentNameId FROM app_Clientprop (NOLOCK) WHERE attrname = 'Office 365 Pseudo Client' and modified = 0)

UPDATE #azureOldClients

SET prop =  CONVERT(NVARCHAR(MAX), ISNULL(T.xmlProp, ''))

FROM  (select id as clientId,  

			(SELECT 

			(SELECT 

				(SELECT 

CASE WHEN P.attrName = 'Azure App Id' THEN P.attrVal  END as 'azureAppKeyID' ,

CASE WHEN P.attrName = 'Azure App Secret Key' THEN P.attrVal  END as 'azureAppKeyValue' ,

CASE WHEN P.attrName = 'Azure Tenant URL' THEN P.attrVal END as 'azureDirectoryId'

			FROM app_idaprop P	(NOLOCK) 								

WHERE P.attrName IN ('Azure App Id', 'Azure App Secret Key' , 'Azure Tenant URL') and P.modified = 0 AND C.idaId = P.componentNameId

		FOR XML PATH(''),TYPE)

		FOR XML PATH ('azureDetails'), TYPE)

		FOR XML PATH ('App_Office365AzureConnections'), TYPE)  as xmlProp

FROM #azureOldClients C) T WHERE id = T.clientId

	---- Insert into IdaProp table where there is valid Azure prop 

	IF EXISTS (SELECT TOP 1 1 FROM #azureOldClients)

	BEGIN
INSERT INTO APP_IDAProp SELECT idaId,'Exchange Azure Connections',1,prop,@createdTime,0,0


		FROM #azureOldClients

		WHERE CONVERT(XML,prop).exist('/App_Office365AzureConnections/azureDetails/azureAppKeyID') = 1	
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@sqlScriptGUID, 'App_IdaProp_InsertAzureConnectionsXml', 'Inserted Exchange Azure Connections as XML', @createdTime, 16, 0 , (16+ 1))

	END

	IF OBJECT_ID('tempdb.dbo.#azureOldClients') IS NOT NULL	DROP TABLE #azureOldClients

	COMMIT TRANSACTION InsertAzureConnectionsTran 

END TRY

BEGIN CATCH

    PRINT N'Error occured. At Line(' + CAST(ERROR_LINE() AS NVARCHAR) + N') ErrorNo(' + CAST(ERROR_NUMBER() AS NVARCHAR) + N') ErrorMsg(' + ERROR_MESSAGE() + N').'

    PRINT N'So Rolling back Transaction.'

    ROLLBACK TRANSACTION InsertAzureConnectionsTran

END CATCH

ERROR_EXIST:

SET NOCOUNT OFF

